/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import org.eclipse.persistence.testing.framework.DriverWrapper;

public class ConnectionWrapper
implements Connection {
    Connection conn;
    boolean broken;
    String exceptionString;
    public static String defaultExceptionString = "ConnectionWrapper: broken";

    public ConnectionWrapper(Connection conn) {
        this.conn = conn;
        this.broken = DriverWrapper.newConnectionsBroken;
        this.exceptionString = DriverWrapper.newConnectionsBrokenExceptionString;
    }

    public void breakConnection() {
        this.breakConnection(defaultExceptionString);
    }

    public void breakConnection(String newExceptionString) {
        this.broken = true;
        this.exceptionString = newExceptionString;
    }

    public void repairConnection() {
        this.broken = false;
        this.exceptionString = null;
    }

    public boolean broken() {
        return this.broken;
    }

    public String getExceptionString() {
        return this.exceptionString;
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        return this.conn.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        return this.conn.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        return this.conn.prepareCall(sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        return this.conn.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        this.conn.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        return this.conn.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        this.conn.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.conn.rollback();
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
    }

    @Override
    public void close() throws SQLException {
        this.conn.close();
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        return this.conn.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.conn.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        this.conn.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        return this.conn.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        this.conn.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        return this.conn.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        this.conn.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        return this.conn.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        return this.conn.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        this.conn.clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        return this.conn.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        return this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        return this.conn.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        return this.conn.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        this.conn.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        this.conn.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        return this.conn.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        return this.conn.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        return this.conn.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        this.conn.rollback();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        this.conn.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        return this.conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        return this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        return this.conn.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        return this.conn.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        return this.conn.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (this.broken) {
            throw new SQLException(this.getExceptionString());
        }
        return this.conn.prepareStatement(sql, columnNames);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        return null;
    }

    @Override
    public Clob createClob() throws SQLException {
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return false;
    }

    @Override
    public void setClientInfo(String name, String value) {
    }

    @Override
    public void setClientInfo(Properties properties) {
    }

    @Override
    public boolean isWrapperFor(Class<?> iFace) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iFace) throws SQLException {
        return iFace.cast(this);
    }
}

