/*******************************************************************************
 * Copyright (c) 1998, 2011 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the 
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0 
 * which accompanies this distribution. 
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at 
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
 ******************************************************************************/  
package org.eclipse.persistence.testing.tests.remote;

import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.internal.sessions.remote.Transporter;

public class TransporterGenerator {
    public static int RETURN_NULL = 0;
    public static int THROW_REMOTE_EXCEPTION = 1;
    public static int SET_EXCEPTION_INTO_TRANSPORTER = 2;
    
    protected String message;
    protected int mode;
    
    public TransporterGenerator(int mode) {
        this.mode = mode;
        this.message =  "Generated by TransporterGenerator";
    }
    public TransporterGenerator(int mode, String message) {
        this(mode);
        this.message = message;
    }
    public int getMode() {
        return mode;
    }
    public String getMessage() {
        return message;
    }
    public Transporter generate() {
        if(mode == RETURN_NULL) {
            return null;
        } else if(mode == THROW_REMOTE_EXCEPTION) {
            throw new Error(message);
        } else if (mode == SET_EXCEPTION_INTO_TRANSPORTER) {
            Transporter transporter = new Transporter();
            transporter.setException(new TestException (message));
            return transporter;
        } else {
            throw new TestException("TransporterGenerator: Invalid mode");
        }
    }
}
