/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.platform.database.oracle.publisher.PublisherException;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.AttributeField;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlTypeWithMethods;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.TypeClass;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllTypes;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.FieldInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.MethodInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ParamInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ResultInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ViewRow;
import org.eclipse.persistence.platform.database.oracle.publisher.visit.PublisherVisitor;

public class SqlObjectType
extends SqlTypeWithMethods {
    protected SqlType m_supertype = null;
    protected boolean m_supertypeKnown = false;
    protected boolean m_isFinal = true;
    protected int m_modifiers = 0;

    public SqlObjectType(SqlName sqlName, boolean generateMe, SqlType parentType, SqlReflector reflector) throws SQLException {
        this(sqlName, 2002, generateMe, parentType, reflector);
    }

    public SqlObjectType(SqlName sqlName, int typecode, boolean generateMe, SqlType parentType, SqlReflector reflector) throws SQLException {
        super(sqlName, typecode, generateMe, parentType, null, reflector);
    }

    public SqlObjectType(SqlName sqlName, List<AttributeField> fields, SqlReflector reflector) throws SQLException {
        super(sqlName, 2002, true, null, null, reflector);
        this.m_modifiers = 1;
        this.m_fields = fields;
        this.m_fieldsPublishedOnly = fields;
        this.m_methods = new ArrayList();
    }

    @Override
    public boolean isObject() {
        return !"BOOLEAN".equals(this.m_name.getSimpleName());
    }

    public void setFields(List<AttributeField> fields) {
        this.m_fields = fields;
        this.m_fieldsPublishedOnly = fields;
    }

    @Override
    public TypeClass getSupertype() throws SQLException, PublisherException {
        if (this.m_supertypeKnown) {
            return this.m_supertype;
        }
        this.m_supertypeKnown = true;
        SqlName name = (SqlName)this.getNameObject();
        String schemaName = name.getSchemaName();
        String typeName = name.getTypeName();
        Iterator<ViewRow> iter = this.m_viewCache.getRows("ALL_TYPES", new String[0], new String[]{"OWNER", "TYPE_NAME"}, new Object[]{schemaName, typeName}, new String[0]);
        if (iter.hasNext()) {
            AllTypes row = (AllTypes)iter.next();
            String supertypeName = row.supertypeName;
            String supertypeOwner = row.supertypeOwner;
            if (supertypeName != null) {
                this.m_supertype = this.m_reflector.addSqlDBType(supertypeOwner, supertypeName, null, "", false, this);
            }
        }
        return this.m_supertype;
    }

    @Override
    public int getModifiers() throws SQLException {
        if (this.m_modifiers == 0) {
            this.m_modifiers = 1;
            SqlName name = (SqlName)this.getNameObject();
            String schemaName = name.getSchemaName();
            String typeName = name.getTypeName();
            Iterator<ViewRow> iter = this.m_viewCache.getRows("ALL_TYPES", new String[0], new String[]{"OWNER", "TYPE_NAME"}, new Object[]{schemaName, typeName}, new String[0]);
            if (iter.hasNext()) {
                String isIncomplete;
                String isInstantiable;
                AllTypes fi = (AllTypes)iter.next();
                String isFinal = fi.finalProp;
                if (isFinal.equals("YES")) {
                    this.m_modifiers += 16;
                }
                if ((isInstantiable = fi.instantiable).equals("NO")) {
                    this.m_modifiers += 1024;
                }
                if ((isIncomplete = fi.incomplete).equals("YES")) {
                    this.m_modifiers += 0x20000000;
                }
            }
        }
        return this.m_modifiers;
    }

    @Override
    public List<AttributeField> getFields(boolean publishedOnly) throws SecurityException, SQLException, PublisherException {
        return this.getFields(0, publishedOnly);
    }

    protected List<AttributeField> getFields(int subtypeFieldCount, boolean publishedOnly) throws SecurityException, SQLException, PublisherException {
        List<AttributeField> declaredFields = this.getDeclaredFields(publishedOnly);
        SqlObjectType supertype = (SqlObjectType)this.getSupertype();
        if (supertype == null && subtypeFieldCount == 0) {
            return declaredFields;
        }
        int declaredFieldCount = declaredFields.size();
        int nonSuperFieldCount = declaredFieldCount + subtypeFieldCount;
        List<Object> fields = supertype == null ? new ArrayList(nonSuperFieldCount) : supertype.getFields(nonSuperFieldCount, publishedOnly);
        int fieldsX = fields.size() - nonSuperFieldCount;
        for (int i = 0; i < declaredFieldCount; ++i) {
            fields.set(fieldsX++, declaredFields.get(i));
        }
        return fields;
    }

    @Override
    protected List<FieldInfo> getFieldInfo() throws SQLException {
        SqlName sqlName = this.getSqlName();
        String schema = sqlName.getSchemaName();
        String type = sqlName.getTypeName();
        Iterator<ViewRow> iter = this.m_viewCache.getRows("ALL_TYPE_ATTRS", new String[0], new String[]{"OWNER", "TYPE_NAME", "INHERITED"}, new Object[]{schema, type, "NO"}, new String[]{"ATTR_NO"});
        return FieldInfo.getFieldInfo(iter);
    }

    @Override
    protected MethodInfo[] getMethodInfo(String schema, String name) throws SQLException {
        Iterator<ViewRow> iter = null;
        iter = this.m_reflector.geqOracle9() ? this.m_viewCache.getRows("ALL_TYPE_METHODS", new String[0], new String[]{"OWNER", "TYPE_NAME", "INSTANTIABLE"}, new String[]{schema, name, "YES"}, new String[]{"METHOD_NAME", "METHOD_NO"}) : this.m_viewCache.getRows("ALL_TYPE_METHODS", new String[0], new String[]{"OWNER", "TYPE_NAME"}, new String[]{schema, name}, new String[]{"METHOD_NAME"});
        return MethodInfo.getMethodInfo(iter);
    }

    @Override
    protected ResultInfo getResultInfo(String schema, String name, String method, String methodNo) throws SQLException {
        Iterator<ViewRow> iter = this.m_viewCache.getRows("ALL_METHOD_RESULTS", new String[0], new String[]{"OWNER", "TYPE_NAME", "METHOD_NO"}, new Object[]{schema, name, methodNo}, new String[0]);
        return ResultInfo.getResultInfo(iter);
    }

    @Override
    protected ParamInfo[] getParamInfo(String schema, String name, String method, String methodNo) throws SQLException {
        Iterator<ViewRow> iter = this.m_viewCache.getRows("ALL_METHOD_PARAMS", new String[0], new String[]{"OWNER", "TYPE_NAME", "METHOD_NO"}, new Object[]{schema, name, methodNo}, new String[]{"PARAM_NO"});
        return ParamInfo.getParamInfo(iter);
    }

    @Override
    public void accept(PublisherVisitor v) {
        v.visit(this);
    }
}

