/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLUnionField;
import org.eclipse.persistence.oxm.record.MarshalRecord;

public abstract class MappingNodeValue
extends NodeValue {
    public abstract DatabaseMapping getMapping();

    public boolean isMappingNodeValue() {
        return true;
    }

    protected QName getSchemaType(XMLField xmlField, Object value, AbstractSession session) {
        QName schemaType = null;
        if (xmlField.getLeafElementType() != null) {
            schemaType = xmlField.getLeafElementType();
        } else if (xmlField.isTypedTextField()) {
            schemaType = xmlField.getXMLType(value.getClass());
        } else {
            if (xmlField.isUnionField()) {
                return this.getSingleValueToWriteForUnion((XMLUnionField)xmlField, value, session);
            }
            if (xmlField.getSchemaType() != null) {
                schemaType = xmlField.getSchemaType();
            }
        }
        return schemaType;
    }

    protected QName getSingleValueToWriteForUnion(XMLUnionField xmlField, Object value, AbstractSession session) {
        ArrayList schemaTypes = xmlField.getSchemaTypes();
        QName schemaType = null;
        int schemaTypesSize = schemaTypes.size();
        for (int i = 0; i < schemaTypesSize; ++i) {
            QName nextQName = (QName)xmlField.getSchemaTypes().get(i);
            try {
                if (nextQName == null) continue;
                Class javaClass = xmlField.getJavaClass(nextQName);
                value = ((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(value, javaClass, nextQName);
                schemaType = nextQName;
                break;
            }
            catch (ConversionException ce) {
                if (i != schemaTypes.size() - 1) continue;
                schemaType = nextQName;
            }
        }
        return schemaType;
    }

    protected void updateNamespaces(QName qname, MarshalRecord marshalRecord, XMLField xmlField) {
        if (qname != null) {
            String prefix;
            if (xmlField != null) {
                if (xmlField.isTypedTextField()) {
                    if (xmlField.getSchemaType() == null ? qname.equals(XMLConstants.STRING_QNAME) : xmlField.isSchemaType(qname)) {
                        return;
                    }
                } else {
                    return;
                }
            }
            if ((prefix = marshalRecord.getNamespaceResolver().resolveNamespaceURI(qname.getNamespaceURI())) == null || prefix.length() == 0) {
                prefix = "http://www.w3.org/2001/XMLSchema".equals(qname.getNamespaceURI()) ? marshalRecord.getNamespaceResolver().generatePrefix("xsd") : marshalRecord.getNamespaceResolver().generatePrefix();
                marshalRecord.attribute("http://www.w3.org/2000/xmlns/", prefix, "xmlns:" + prefix, qname.getNamespaceURI());
            }
            String typeValue = prefix + ':' + qname.getLocalPart();
            this.addTypeAttribute(marshalRecord, typeValue);
        }
    }

    protected void addTypeAttribute(MarshalRecord marshalRecord, String typeValue) {
        String xsiPrefix = null;
        if (marshalRecord.getNamespaceResolver() != null) {
            xsiPrefix = marshalRecord.getNamespaceResolver().resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        } else {
            xsiPrefix = "xsi";
            marshalRecord.attribute("http://www.w3.org/2000/xmlns/", xsiPrefix, "xmlns:" + xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
        }
        if (xsiPrefix == null) {
            xsiPrefix = marshalRecord.getNamespaceResolver().generatePrefix("xsi");
            marshalRecord.attribute("http://www.w3.org/2000/xmlns/", xsiPrefix, "xmlns:" + xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
        }
        marshalRecord.attribute("http://www.w3.org/2001/XMLSchema-instance", "type", xsiPrefix + ':' + "type", typeValue);
    }
}

