/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.IOException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.XMLFragmentReader;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.record.JSONWriterRecord;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class JSONFormattedWriterRecord
extends JSONWriterRecord {
    private static final char[] TAB = "   ".toCharArray();
    private int numberOfTabs = 0;
    private boolean complexType = true;
    private boolean isLastEventText = false;

    public void endDocument() {
        try {
            super.endDocument();
            this.writer.write(Helper.cr());
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        try {
            JSONWriterRecord.Level position = null;
            if (this.levels.isEmpty()) {
                this.levels.push(new JSONWriterRecord.Level(true));
            } else {
                position = (JSONWriterRecord.Level)this.levels.peek();
                this.levels.push(new JSONWriterRecord.Level(true));
                if (position.isFirst()) {
                    position.setFirst(false);
                } else {
                    this.writer.write(44);
                }
            }
            this.addPositionalNodes(xPathFragment, namespaceResolver);
            if (!this.isLastEventText) {
                if (this.numberOfTabs > 0) {
                    this.writer.write(Helper.cr());
                }
                for (int x = 0; x < this.numberOfTabs; ++x) {
                    this.writer.write(TAB);
                }
            }
            if (position == null || !position.isCollection() || position.isEmptyCollection()) {
                this.isStartElementOpen = true;
                this.writer.write(34);
                this.writer.write(xPathFragment.getLocalName());
                this.writer.write("\" : ");
                if (position != null && position.isCollection()) {
                    this.writer.write(91);
                }
                if (position != null && position.isEmptyCollection()) {
                    position.setEmptyCollection(false);
                }
            }
            XPathFragment next = xPathFragment.getNextFragment();
            if (!(xPathFragment.isAttribute() || xPathFragment.nameIsText() || next != null && next.nameIsText())) {
                this.writer.write(123);
            }
            ++this.numberOfTabs;
            this.isLastEventText = false;
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void element(XPathFragment frag) {
        try {
            this.isLastEventText = false;
            if (this.isStartElementOpen) {
                this.writer.write(62);
                this.isStartElementOpen = false;
            }
            this.writer.write(Helper.cr());
            for (int x = 0; x < this.numberOfTabs; ++x) {
                this.writer.write(TAB);
            }
            super.element(frag);
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.isLastEventText = false;
        --this.numberOfTabs;
        super.endElement(xPathFragment, namespaceResolver);
    }

    public void characters(String value) {
        super.characters(value);
        this.isLastEventText = true;
        this.complexType = false;
    }

    public void cdata(String value) {
        try {
            if (this.isStartElementOpen) {
                this.writer.write(62);
                this.isStartElementOpen = false;
            }
            super.cdata(value);
            this.complexType = false;
        }
        catch (IOException ex) {
            throw XMLMarshalException.marshalException(ex);
        }
    }

    public void node(Node node, NamespaceResolver namespaceResolver) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String resolverPfx = null;
            if (this.getNamespaceResolver() != null) {
                resolverPfx = this.getNamespaceResolver().resolveNamespaceURI(attr.getNamespaceURI());
            }
            if (resolverPfx != null) {
                this.attribute(attr.getNamespaceURI(), "", resolverPfx + ':' + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(attr.getNamespaceURI(), "", attr.getName(), attr.getNodeValue());
                if (attr.getNamespaceURI() != null) {
                    this.attribute("http://www.w3.org/2000/xmlns/", "", "xmlns:" + attr.getPrefix(), attr.getNamespaceURI());
                    this.getNamespaceResolver().put(attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else if (node.getNodeType() == 3) {
            this.characters(node.getNodeValue());
        } else {
            try {
                FormattedWriterRecordContentHandler wrcHandler = new FormattedWriterRecordContentHandler();
                XMLFragmentReader xfragReader = new XMLFragmentReader(namespaceResolver);
                xfragReader.setContentHandler(wrcHandler);
                xfragReader.setProperty("http://xml.org/sax/properties/lexical-handler", wrcHandler);
                xfragReader.parse(node);
            }
            catch (SAXException sex) {
                throw XMLMarshalException.marshalException(sex);
            }
        }
    }

    private class FormattedWriterRecordContentHandler
    extends JSONWriterRecord.WriterRecordContentHandler {
        private FormattedWriterRecordContentHandler() {
            super(JSONFormattedWriterRecord.this);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            try {
                if (JSONFormattedWriterRecord.this.isStartElementOpen) {
                    JSONFormattedWriterRecord.this.writer.write(62);
                }
                if (!JSONFormattedWriterRecord.this.isLastEventText) {
                    JSONFormattedWriterRecord.this.writer.write(Helper.cr());
                    for (int x = 0; x < JSONFormattedWriterRecord.this.numberOfTabs; ++x) {
                        JSONFormattedWriterRecord.this.writer.write(TAB);
                    }
                }
                JSONFormattedWriterRecord.this.writer.write(60);
                JSONFormattedWriterRecord.this.writer.write(qName);
                JSONFormattedWriterRecord.this.numberOfTabs++;
                JSONFormattedWriterRecord.this.isStartElementOpen = true;
                JSONFormattedWriterRecord.this.isLastEventText = false;
                this.handleAttributes(atts);
                this.writePrefixMappings();
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            try {
                JSONFormattedWriterRecord.this.isLastEventText = false;
                JSONFormattedWriterRecord.this.numberOfTabs--;
                if (JSONFormattedWriterRecord.this.isStartElementOpen) {
                    JSONFormattedWriterRecord.this.writer.write(47);
                    JSONFormattedWriterRecord.this.writer.write(62);
                    JSONFormattedWriterRecord.this.isStartElementOpen = false;
                    JSONFormattedWriterRecord.this.complexType = true;
                    return;
                }
                if (JSONFormattedWriterRecord.this.complexType) {
                    JSONFormattedWriterRecord.this.writer.write(Helper.cr());
                    for (int x = 0; x < JSONFormattedWriterRecord.this.numberOfTabs; ++x) {
                        JSONFormattedWriterRecord.this.writer.write(TAB);
                    }
                } else {
                    JSONFormattedWriterRecord.this.complexType = true;
                }
                super.endElement(namespaceURI, localName, qName);
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (JSONFormattedWriterRecord.this.isProcessingCData) {
                JSONFormattedWriterRecord.this.cdata(new String(ch, start, length));
                return;
            }
            if (new String(ch).trim().length() == 0) {
                return;
            }
            super.characters(ch, start, length);
            JSONFormattedWriterRecord.this.isLastEventText = true;
            JSONFormattedWriterRecord.this.complexType = false;
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            try {
                if (JSONFormattedWriterRecord.this.isStartElementOpen) {
                    JSONFormattedWriterRecord.this.writer.write(62);
                    JSONFormattedWriterRecord.this.writer.write(Helper.cr());
                    JSONFormattedWriterRecord.this.isStartElementOpen = false;
                }
                this.writeComment(ch, start, length);
                JSONFormattedWriterRecord.this.complexType = false;
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }
    }
}

