/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.handles;

import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWDescriptorHandle
extends MWHandle {
    private volatile MWDescriptor descriptor;
    private volatile String descriptorName;

    private MWDescriptorHandle() {
    }

    public MWDescriptorHandle(MWModel parent, MWHandle.NodeReferenceScrubber scrubber) {
        super(parent, scrubber);
    }

    public MWDescriptorHandle(MWModel parent, MWDescriptor descriptor, MWHandle.NodeReferenceScrubber scrubber) {
        super(parent, scrubber);
        this.descriptor = descriptor;
    }

    public MWDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(MWDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    protected Node node() {
        return this.getDescriptor();
    }

    public MWDescriptorHandle setScrubber(MWHandle.NodeReferenceScrubber scrubber) {
        this.setScrubberInternal(scrubber);
        return this;
    }

    public void resolveDescriptorHandles() {
        super.resolveDescriptorHandles();
        if (this.descriptorName != null) {
            this.descriptor = this.getProject().descriptorNamed(this.descriptorName);
        }
        this.descriptorName = null;
    }

    public int compareTo(Object o) {
        return this.descriptor.compareTo(((MWDescriptorHandle)o).descriptor);
    }

    public void toString(StringBuffer sb) {
        sb.append(this.descriptor == null ? "null" : this.descriptor.getName());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWDescriptorHandle.class);
        descriptor.addDirectMapping("descriptorName", "getDescriptorNameForToplink", "setDescriptorNameForToplink", "descriptor-name/text()");
        return descriptor;
    }

    private String getDescriptorNameForToplink() {
        return this.descriptor == null ? null : this.descriptor.getName();
    }

    private void setDescriptorNameForToplink(String descriptorName) {
        this.descriptorName = descriptorName;
    }
}

