/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheIndex
implements Cloneable,
Serializable {
    protected List<DatabaseField> fields;
    protected int cacheSize;
    protected Class cacheType;

    public CacheIndex() {
        this.fields = new ArrayList<DatabaseField>();
        this.cacheType = ClassConstants.WeakIdentityMap_Class;
    }

    public CacheIndex(DatabaseField[] fields) {
        this.fields = new ArrayList<DatabaseField>(fields.length);
        for (DatabaseField field : fields) {
            this.fields.add(field);
        }
        this.cacheType = ClassConstants.WeakIdentityMap_Class;
    }

    public CacheIndex(String ... fields) {
        this.fields = new ArrayList<DatabaseField>(fields.length);
        for (String field : fields) {
            this.fields.add(new DatabaseField(field));
        }
        this.cacheType = ClassConstants.WeakIdentityMap_Class;
    }

    public Class getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(Class cacheType) {
        this.cacheType = cacheType;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public void addField(DatabaseField field) {
        this.fields.add(field);
    }

    public void addFieldName(String field) {
        this.addField(new DatabaseField(field));
    }

    public List<DatabaseField> getFields() {
        return this.fields;
    }

    public void setFields(List<DatabaseField> fields) {
        this.fields = fields;
    }
}

