/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record.json;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.persistence.internal.libraries.antlr.runtime.ANTLRInputStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.ANTLRReaderStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.CharStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.RecognitionException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.TokenRewriteStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.TokenSource;
import org.eclipse.persistence.internal.libraries.antlr.runtime.TokenStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.CommonTree;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.Tree;
import org.eclipse.persistence.internal.oxm.record.XMLReaderAdapter;
import org.eclipse.persistence.internal.oxm.record.json.JSONLexer;
import org.eclipse.persistence.internal.oxm.record.json.JSONParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JSONReader
extends XMLReaderAdapter {
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private JSONAttributes attributes = new JSONAttributes();

    public void parse(InputSource input) throws IOException, SAXException {
        try {
            ANTLRInputStream charStream;
            InputStream inputStream = null;
            if (null != input.getByteStream()) {
                charStream = new ANTLRInputStream(input.getByteStream());
            } else if (null != input.getCharacterStream()) {
                charStream = new ANTLRReaderStream(input.getCharacterStream());
            } else {
                URL url = new URL(input.getSystemId());
                inputStream = url.openStream();
                charStream = new ANTLRInputStream(inputStream);
            }
            JSONLexer lexer = new JSONLexer((CharStream)charStream);
            TokenRewriteStream tokens = new TokenRewriteStream((TokenSource)lexer);
            JSONParser parser = new JSONParser((TokenStream)tokens);
            CommonTree commonTree = (CommonTree)parser.object().getTree();
            this.contentHandler.startDocument();
            this.parseRoot((Tree)commonTree);
            this.contentHandler.endDocument();
            if (null != inputStream) {
                inputStream.close();
            }
        }
        catch (RecognitionException e) {
            throw new SAXParseException(e.getLocalizedMessage(), input.getPublicId(), input.getSystemId(), e.line, e.index, (Exception)((Object)e));
        }
    }

    private void parseRoot(Tree tree) throws SAXException {
        if (tree.getType() == 4) {
            int children = tree.getChildCount();
            if (children == 1) {
                this.parse((Tree)((CommonTree)tree.getChild(0)));
            } else {
                this.contentHandler.startElement("", "", null, this.attributes.setTree(tree));
                int size = tree.getChildCount();
                for (int x = 0; x < size; ++x) {
                    this.parse((Tree)((CommonTree)tree.getChild(x)));
                }
                this.contentHandler.endElement("", "", null);
            }
        }
    }

    private void parse(Tree tree) throws SAXException {
        switch (tree.getType()) {
            case 5: {
                Tree valueTree = tree.getChild(1);
                if (valueTree.getType() == 8) {
                    this.parse(valueTree);
                    break;
                }
                Tree stringTree = tree.getChild(0);
                String localName = stringTree.getText().substring(1, stringTree.getText().length() - 1);
                this.contentHandler.startElement("", localName, localName, this.attributes.setTree(valueTree));
                this.parse(valueTree);
                this.contentHandler.endElement("", localName, localName);
                break;
            }
            case 6: {
                String string = this.string(tree.getChild(0).getText());
                this.contentHandler.characters(string);
                break;
            }
            case 7: {
                this.contentHandler.characters(tree.getChild(0).getText());
                break;
            }
            case 9: {
                this.contentHandler.characters(TRUE);
                break;
            }
            case 10: {
                this.contentHandler.characters(FALSE);
                break;
            }
            case 11: {
                break;
            }
            case 8: {
                Tree parentStringTree = tree.getParent().getChild(0);
                String parentLocalName = parentStringTree.getText().substring(1, parentStringTree.getText().length() - 1);
                int size = tree.getChildCount();
                for (int x = 0; x < size; ++x) {
                    CommonTree nextChildTree = (CommonTree)tree.getChild(x);
                    this.contentHandler.startElement("", parentLocalName, parentLocalName, this.attributes.setTree((Tree)nextChildTree));
                    this.parse((Tree)nextChildTree);
                    this.contentHandler.endElement("", parentLocalName, parentLocalName);
                }
                break;
            }
            default: {
                int size = tree.getChildCount();
                for (int x = 0; x < size; ++x) {
                    this.parse((Tree)((CommonTree)tree.getChild(x)));
                }
            }
        }
    }

    private String string(String string) {
        string = string.substring(1, string.length() - 1);
        string = string.replace("\\\"", "\"");
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JSONAttributes
    extends XMLReaderAdapter.IndexedAttributeList {
        private Tree tree;

        private JSONAttributes() {
        }

        public JSONAttributes setTree(Tree tree) {
            this.reset();
            this.tree = tree;
            return this;
        }

        @Override
        protected List<XMLReaderAdapter.Attribute> attributes() {
            if (null == this.attributes) {
                if (this.tree.getType() == 11) {
                    this.attributes = new ArrayList(1);
                    this.attributes.add(new XMLReaderAdapter.Attribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "nil", JSONReader.TRUE));
                    return this.attributes;
                }
                if (this.tree.getType() == 4) {
                    this.attributes = new ArrayList(this.tree.getChildCount());
                    block7: for (int x = 0; x < this.tree.getChildCount(); ++x) {
                        Tree childTree = this.tree.getChild(x);
                        String attributeLocalName = childTree.getChild(0).getText().substring(1, childTree.getChild(0).getText().length() - 1);
                        Tree childValueTree = childTree.getChild(1);
                        switch (childValueTree.getType()) {
                            case 6: {
                                String stringValue = childValueTree.getChild(0).getText();
                                this.attributes.add(new XMLReaderAdapter.Attribute("", attributeLocalName, attributeLocalName, stringValue.substring(1, stringValue.length() - 1)));
                                continue block7;
                            }
                            case 7: {
                                this.attributes.add(new XMLReaderAdapter.Attribute("", attributeLocalName, attributeLocalName, childValueTree.getChild(0).getText()));
                                continue block7;
                            }
                            case 9: {
                                this.attributes.add(new XMLReaderAdapter.Attribute("", attributeLocalName, attributeLocalName, JSONReader.TRUE));
                                continue block7;
                            }
                            case 10: {
                                this.attributes.add(new XMLReaderAdapter.Attribute("", attributeLocalName, attributeLocalName, JSONReader.FALSE));
                                continue block7;
                            }
                            case 11: {
                                this.attributes.add(new XMLReaderAdapter.Attribute("", attributeLocalName, attributeLocalName, ""));
                            }
                        }
                    }
                } else {
                    this.attributes = Collections.EMPTY_LIST;
                }
            }
            return this.attributes;
        }
    }
}

