/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.meta;

import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import org.eclipse.persistence.internal.codegen.AccessLevel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWModifiable;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWModifier
extends MWModel {
    private volatile int code;
    public static final String CODE_PROPERTY = "code";
    public static final String ACCESS_LEVEL_PROPERTY = "accessLevel";
    public static final String PUBLIC = "public";
    public static final String PACKAGE = "package";
    public static final String PROTECTED = "protected";
    public static final String PRIVATE = "private";

    private MWModifier() {
    }

    MWModifier(MWModifiable parent) {
        super((MWModel)((Object)parent));
    }

    MWModifier(MWModifiable parent, int code) {
        this(parent);
        this.setCode(code);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.code = MWModifier.defaultCode();
    }

    void initializeFrom(MWModifier oldModifier) {
        this.setCode(oldModifier.getCode());
    }

    void clear() {
        this.setCode(MWModifier.defaultCode());
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        int old = this.code;
        this.setCodeInternal(code);
        this.firePropertyChanged(CODE_PROPERTY, old, this.code);
        if (old != this.code) {
            this.modifiableParent().modifierChanged(old, this.code);
        }
    }

    private void setCodeInternal(int code) {
        this.code = code &= 0xFFFFFDFF;
    }

    void setCodeForTopLink(int code) {
        this.setCodeInternal(code);
    }

    private void setBit(boolean value, int mask) {
        int temp = this.code;
        temp = value ? (temp |= mask) : (temp &= ~mask);
        this.setCode(temp);
    }

    public boolean supportsAbstract() {
        return this.modifiableParent().supportsAbstract();
    }

    public boolean canBeSetAbstract() {
        return this.modifiableParent().canBeSetAbstract();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.code);
    }

    public void setAbstract(boolean value) {
        this.setBit(value, 1024);
    }

    public boolean canBeSetFinal() {
        return this.modifiableParent().canBeSetFinal();
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.code);
    }

    public void setFinal(boolean value) {
        this.setBit(value, 16);
    }

    private boolean supportsInterface() {
        return this.modifiableParent().supportsInterface();
    }

    private boolean canBeSetInterface() {
        return this.modifiableParent().canBeSetInterface();
    }

    private boolean isInterface() {
        return Modifier.isInterface(this.code);
    }

    private void setInterface(boolean value) {
        this.setBit(value, 512);
    }

    public boolean supportsNative() {
        return this.modifiableParent().supportsNative();
    }

    public boolean canBeSetNative() {
        return this.modifiableParent().canBeSetNative();
    }

    public boolean isNative() {
        return Modifier.isNative(this.code);
    }

    public void setNative(boolean value) {
        this.setBit(value, 256);
    }

    public String getAccessLevel() {
        if (this.isPublic()) {
            return PUBLIC;
        }
        if (this.isProtected()) {
            return PROTECTED;
        }
        if (this.isPackage()) {
            return PACKAGE;
        }
        if (this.isPrivate()) {
            return PRIVATE;
        }
        throw new IllegalStateException(this.toString());
    }

    public void setAccessLevel(String accessLevel) {
        String old = this.getAccessLevel();
        if (accessLevel == PUBLIC) {
            this.setPublic(true);
        } else if (accessLevel == PROTECTED) {
            this.setProtected(true);
        } else if (accessLevel == PRIVATE) {
            this.setPrivate(true);
        } else if (accessLevel == PACKAGE) {
            this.setPackage(true);
        } else {
            throw new IllegalArgumentException("Allowable values: MWModifier.PUBLIC, MWModifier.PROTECTED, MWModifier.PRIVATE, MWModifier.PACKAGE");
        }
        this.firePropertyChanged(ACCESS_LEVEL_PROPERTY, old, accessLevel);
        if (this.attributeValueHasChanged(old, accessLevel)) {
            this.modifiableParent().accessLevelChanged(old, accessLevel);
        }
    }

    public boolean canBeSetPackage() {
        return this.modifiableParent().canBeSetPackage();
    }

    public boolean isPackage() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public void setPackage(boolean value) {
        int temp = this.code;
        temp = value ? (temp &= 0xFFFFFFFE) : (temp |= 1);
        temp &= 0xFFFFFFFD;
        this.setCode(temp &= 0xFFFFFFFB);
    }

    public boolean canBeSetPrivate() {
        return this.modifiableParent().canBeSetPrivate();
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.code);
    }

    public void setPrivate(boolean value) {
        int temp = this.code;
        if (value) {
            temp |= 2;
            temp &= 0xFFFFFFFB;
            temp &= 0xFFFFFFFE;
        } else {
            temp &= 0xFFFFFFFD;
        }
        this.setCode(temp);
    }

    public boolean canBeSetProtected() {
        return this.modifiableParent().canBeSetProtected();
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.code);
    }

    public void setProtected(boolean value) {
        int temp = this.code;
        if (value) {
            temp |= 4;
            temp &= 0xFFFFFFFD;
            temp &= 0xFFFFFFFE;
        } else {
            temp &= 0xFFFFFFFB;
        }
        this.setCode(temp);
    }

    public boolean canBeSetPublic() {
        return this.modifiableParent().canBeSetPublic();
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.code);
    }

    public void setPublic(boolean value) {
        int temp = this.code;
        if (value) {
            temp |= 1;
            temp &= 0xFFFFFFFD;
            temp &= 0xFFFFFFFB;
        } else {
            temp &= 0xFFFFFFFE;
        }
        this.setCode(temp);
    }

    public boolean canBeSetStatic() {
        return this.modifiableParent().canBeSetStatic();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.code);
    }

    public void setStatic(boolean value) {
        this.setBit(value, 8);
    }

    public boolean supportsStrict() {
        return this.modifiableParent().supportsStrict();
    }

    public boolean canBeSetStrict() {
        return this.modifiableParent().canBeSetStrict();
    }

    public boolean isStrict() {
        return Modifier.isStrict(this.code);
    }

    public void setStrict(boolean value) {
        this.setBit(value, 2048);
    }

    public boolean supportsSynchronized() {
        return this.modifiableParent().supportsSynchronized();
    }

    public boolean canBeSetSynchronized() {
        return this.modifiableParent().canBeSetSynchronized();
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.code);
    }

    public void setSynchronized(boolean value) {
        this.setBit(value, 32);
    }

    public boolean supportsTransient() {
        return this.modifiableParent().supportsTransient();
    }

    public boolean canBeSetTransient() {
        return this.modifiableParent().canBeSetTransient();
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.code);
    }

    public void setTransient(boolean value) {
        this.setBit(value, 128);
    }

    public boolean supportsVolatile() {
        return this.modifiableParent().supportsVolatile();
    }

    public boolean canBeSetVolatile() {
        return this.modifiableParent().canBeSetVolatile();
    }

    public boolean isVolatile() {
        return Modifier.isVolatile(this.code);
    }

    public void setVolatile(boolean value) {
        this.setBit(value, 64);
    }

    private MWModifiable modifiableParent() {
        return (MWModifiable)((Object)this.getMWParent());
    }

    public static int defaultCode() {
        return 1;
    }

    public boolean isDefaultValue() {
        return this.code == MWModifier.defaultCode();
    }

    AccessLevel accessLevel() {
        AccessLevel accessLevel = new AccessLevel();
        if (this.isPublic()) {
            accessLevel.setLevel(AccessLevel.PUBLIC);
        } else if (this.isProtected()) {
            accessLevel.setLevel(AccessLevel.PROTECTED);
        } else if (this.isPackage()) {
            accessLevel.setLevel(AccessLevel.PACKAGE);
        } else {
            accessLevel.setLevel(AccessLevel.PRIVATE);
        }
        accessLevel.setIsAbstract(this.isAbstract());
        accessLevel.setIsFinal(this.isFinal());
        accessLevel.setIsNative(this.isNative());
        accessLevel.setIsStatic(this.isStatic());
        accessLevel.setIsSynchronized(this.isSynchronized());
        accessLevel.setIsTransient(this.isTransient());
        accessLevel.setIsVolatile(this.isVolatile());
        return accessLevel;
    }

    void refresh(int javaModifiers) {
        this.setCode(javaModifiers);
    }

    void allowedModifiersChanged() {
        this.fireStateChanged();
    }

    private void checkCode() {
        if (this.isPublic() && !this.canBeSetPublic() || this.isProtected() && !this.canBeSetProtected() || this.isPackage() && !this.canBeSetPackage() || this.isPrivate() && !this.canBeSetPrivate() || this.isInterface() && !this.canBeSetInterface() || this.isFinal() && !this.canBeSetFinal() || this.isStatic() && !this.canBeSetStatic() || this.isAbstract() && !this.canBeSetAbstract() || this.isNative() && !this.canBeSetNative() || this.isStrict() && !this.canBeSetStrict() || this.isSynchronized() && !this.canBeSetSynchronized() || this.isTransient() && !this.canBeSetTransient() || this.isVolatile() && !this.canBeSetVolatile()) {
            throw new IllegalStateException(this.toString());
        }
    }

    @Override
    public String displayString() {
        return Modifier.toString(this.code);
    }

    @Override
    public void toString(StringBuffer sb) {
        sb.append(this.displayString());
    }

    boolean writeSource(PrintWriter pw) {
        String source = Modifier.toString(this.code);
        if (source.length() == 0) {
            return false;
        }
        pw.print(source);
        return true;
    }

    static boolean flagsAreSame(int flags, int code1, int code2) {
        return (code1 & flags) == (code2 & flags);
    }

    static boolean anyFlagsAreDifferent(int flags, int code1, int code2) {
        return !MWModifier.flagsAreSame(flags, code1, code2);
    }
}

