/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangePolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.queries.AttributeItem;
import org.eclipse.persistence.internal.queries.EntityFetchGroup;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchGroupManager
implements Cloneable {
    private Map<String, FetchGroup> fetchGroups = null;
    private Map<Set<String>, EntityFetchGroup> entityFetchGroups = new ConcurrentHashMap<Set<String>, EntityFetchGroup>();
    private FetchGroup defaultFetchGroup;
    private EntityFetchGroup defaultEntityFetchGroup;
    private FetchGroup fullFetchGroup;
    private FetchGroup minimalFetchGroup;
    private EntityFetchGroup idEntityFetchGroup;
    private EntityFetchGroup nonReferenceEntityFetchGroup;
    private ClassDescriptor descriptor;
    private boolean shouldUseInheritedDefaultFetchGroup = true;

    public void addFetchGroup(FetchGroup group) {
        this.getFetchGroups().put(group.getName(), group);
    }

    public Map<String, FetchGroup> getFetchGroups() {
        if (this.fetchGroups == null) {
            this.fetchGroups = new HashMap<String, FetchGroup>(2);
        }
        return this.fetchGroups;
    }

    public FetchGroup getDefaultFetchGroup() {
        return this.defaultFetchGroup;
    }

    public EntityFetchGroup getDefaultEntityFetchGroup() {
        return this.defaultEntityFetchGroup;
    }

    public FetchGroup createMinimalFetchGroup() {
        return this.minimalFetchGroup.clone();
    }

    public boolean isMinimalFetchGroup(FetchGroup fetchGroup) {
        return this.minimalFetchGroup.equals(fetchGroup);
    }

    public EntityFetchGroup getIdEntityFetchGroup() {
        return this.idEntityFetchGroup;
    }

    public EntityFetchGroup getNonReferenceEntityFetchGroup() {
        return this.nonReferenceEntityFetchGroup;
    }

    public EntityFetchGroup getNonReferenceEntityFetchGroup(boolean addPk, boolean addVersion) {
        String lockAttribute;
        String name;
        if (addPk && addVersion) {
            return this.getNonReferenceEntityFetchGroup();
        }
        FetchGroup nonReferenceFetchGroup = new FetchGroup();
        for (DatabaseMapping mapping : this.getDescriptor().getMappings()) {
            if (mapping.isForeignReferenceMapping()) continue;
            name = mapping.getAttributeName();
            if (this.defaultEntityFetchGroup != null && !this.defaultEntityFetchGroup.containsAttribute(name)) continue;
            nonReferenceFetchGroup.addAttribute(name);
        }
        if (addPk) {
            for (DatabaseMapping mapping : this.descriptor.getObjectBuilder().getPrimaryKeyMappings()) {
                name = mapping.getAttributeName();
                if (nonReferenceFetchGroup.containsAttribute(name)) continue;
                nonReferenceFetchGroup.addAttribute(name);
            }
        } else {
            for (DatabaseMapping mapping : this.descriptor.getObjectBuilder().getPrimaryKeyMappings()) {
                if (!mapping.isForeignReferenceMapping() || nonReferenceFetchGroup.containsAttribute(name = mapping.getAttributeName())) continue;
                nonReferenceFetchGroup.addAttribute(name);
            }
        }
        if (addVersion && (lockAttribute = this.descriptor.getObjectBuilder().getLockAttribute()) != null && !nonReferenceFetchGroup.containsAttribute(lockAttribute)) {
            nonReferenceFetchGroup.addAttribute(lockAttribute);
        }
        return this.getEntityFetchGroup(nonReferenceFetchGroup);
    }

    public void addMinimalFetchGroup(FetchGroup fetchGroup) {
        if (this.minimalFetchGroup == null) {
            return;
        }
        for (String name : this.minimalFetchGroup.getAttributeNames()) {
            if (fetchGroup.containsAttribute(name)) continue;
            fetchGroup.addAttribute(name);
        }
    }

    public void prepareAndVerify(FetchGroup fetchGroup) {
        this.prepareAndVerifyInternal(fetchGroup, "");
    }

    protected void prepareAndVerifyInternal(FetchGroup fetchGroup, String attributePrefix) {
        this.addMinimalFetchGroup(fetchGroup);
        ObjectBuilder builder = this.descriptor.getObjectBuilder();
        for (Map.Entry<String, AttributeItem> entry : fetchGroup.getItems().entrySet()) {
            String name = entry.getKey();
            DatabaseMapping mapping = builder.getMappingForAttributeName(name);
            if (mapping != null) {
                FetchGroup nestedFetchGroup = (FetchGroup)entry.getValue().getGroup();
                if (nestedFetchGroup == null) continue;
                if (mapping.isForeignReferenceMapping()) {
                    ClassDescriptor referenceDescriptor = ((ForeignReferenceMapping)mapping).getReferenceDescriptor();
                    if (referenceDescriptor != null) {
                        FetchGroupManager nestedFetchGroupManager = referenceDescriptor.getFetchGroupManager();
                        if (nestedFetchGroupManager != null) {
                            nestedFetchGroupManager.prepareAndVerifyInternal(nestedFetchGroup, String.valueOf(attributePrefix) + name + '.');
                            continue;
                        }
                        throw ValidationException.fetchGroupHasWrongReferenceClass(fetchGroup, name);
                    }
                    throw ValidationException.fetchGroupHasWrongReferenceAttribute(fetchGroup, name);
                }
                throw ValidationException.fetchGroupHasWrongReferenceAttribute(fetchGroup, name);
            }
            throw ValidationException.fetchGroupHasUnmappedAttribute(fetchGroup, name);
        }
    }

    public FetchGroup createDefaultFetchGroup() {
        return this.defaultFetchGroup.clone();
    }

    public FetchGroup createFullFetchGroup() {
        return this.fullFetchGroup.clone();
    }

    public boolean isFullFetchGroup(FetchGroup fetchGroup) {
        return this.fullFetchGroup.equals(fetchGroup);
    }

    public EntityFetchGroup getEntityFetchGroup(Set<String> attributeNames) {
        if (attributeNames == null || attributeNames.isEmpty()) {
            return null;
        }
        EntityFetchGroup entityFetchGroup = this.entityFetchGroups.get(attributeNames);
        if (entityFetchGroup == null) {
            entityFetchGroup = new EntityFetchGroup(attributeNames);
            if (entityFetchGroup.equals(this.fullFetchGroup)) {
                return null;
            }
            this.entityFetchGroups.put(entityFetchGroup.getAttributeNames(), entityFetchGroup);
        }
        return entityFetchGroup;
    }

    public EntityFetchGroup getEntityFetchGroup(FetchGroup fetchGroup) {
        if (fetchGroup == null) {
            return null;
        }
        return this.getEntityFetchGroup(fetchGroup.getAttributeNames());
    }

    public FetchGroup getFetchGroup(String groupName) {
        FetchGroup fg = this.fetchGroups.get(groupName);
        if (fg == null && this.getDescriptor().isChildDescriptor()) {
            ClassDescriptor current = this.descriptor;
            while (fg == null && current.isChildDescriptor()) {
                ClassDescriptor parent = current.getInheritancePolicy().getParentDescriptor();
                if (parent.hasFetchGroupManager()) {
                    fg = parent.getFetchGroupManager().getFetchGroup(groupName);
                }
                current = parent;
            }
        }
        return fg;
    }

    public FetchGroup getFetchGroup(String groupName, boolean useDefault) {
        FetchGroup fg = null;
        if (groupName != null) {
            fg = this.getFetchGroup(groupName);
        }
        if (fg == null && useDefault) {
            fg = this.getDefaultFetchGroup();
        }
        return fg;
    }

    public void setDefaultFetchGroup(FetchGroup newDefaultFetchGroup) {
        if (this.defaultFetchGroup != newDefaultFetchGroup) {
            if (this.descriptor.isFullyInitialized()) {
                if (newDefaultFetchGroup != null) {
                    this.prepareAndVerify(newDefaultFetchGroup);
                    this.defaultEntityFetchGroup = this.getEntityFetchGroup(newDefaultFetchGroup);
                } else {
                    this.defaultEntityFetchGroup = null;
                }
            }
            this.defaultFetchGroup = newDefaultFetchGroup;
            if (this.descriptor.isFullyInitialized()) {
                this.initNonReferenceEntityFetchGroup();
            }
        }
    }

    public boolean isPartialObject(Object domainObject) {
        if (domainObject != null) {
            FetchGroup fetchGroupInCache = ((FetchGroupTracker)domainObject)._persistence_getFetchGroup();
            return fetchGroupInCache != null;
        }
        return false;
    }

    public boolean isObjectValidForFetchGroup(Object object, FetchGroup fetchGroup) {
        FetchGroup groupInObject = ((FetchGroupTracker)object)._persistence_getFetchGroup();
        return groupInObject == null || groupInObject.isSupersetOf(fetchGroup);
    }

    public boolean shouldWriteInto(Object cachedObject, Object clone) {
        FetchGroup fetchGroupInTarg = ((FetchGroupTracker)clone)._persistence_getFetchGroup();
        if (fetchGroupInTarg != null) {
            FetchGroup fetchGroupInSrc = ((FetchGroupTracker)cachedObject)._persistence_getFetchGroup();
            return !fetchGroupInTarg.isSupersetOf(fetchGroupInSrc) || ((FetchGroupTracker)cachedObject)._persistence_shouldRefreshFetchGroup();
        }
        return false;
    }

    public void writePartialIntoClones(Object partialObject, Object workingClone, UnitOfWorkImpl uow) {
        FetchGroup fetchGroupInClone = ((FetchGroupTracker)workingClone)._persistence_getFetchGroup();
        FetchGroup fetchGroupInObject = ((FetchGroupTracker)partialObject)._persistence_getFetchGroup();
        Object backupClone = uow.getBackupClone(workingClone, this.descriptor);
        EntityFetchGroup union = this.flatUnionFetchGroups(fetchGroupInObject, fetchGroupInClone);
        this.setObjectFetchGroup(workingClone, union, uow);
        if (workingClone != backupClone) {
            this.setObjectFetchGroup(backupClone, union, uow);
        }
        ObjectChangePolicy policy = this.descriptor.getObjectChangePolicy();
        policy.dissableEventProcessing(workingClone);
        try {
            if (((FetchGroupTracker)partialObject)._persistence_shouldRefreshFetchGroup()) {
                this.refreshFetchGroupIntoClones(partialObject, workingClone, backupClone, fetchGroupInObject, fetchGroupInClone, uow);
            } else {
                this.revertDataIntoUnfetchedAttributesOfClones(partialObject, workingClone, backupClone, fetchGroupInObject, fetchGroupInClone, uow);
            }
        }
        finally {
            policy.enableEventProcessing(workingClone);
        }
    }

    private void refreshFetchGroupIntoClones(Object cachedObject, Object workingClone, Object backupClone, FetchGroup fetchGroupInObject, FetchGroup fetchGroupInClone, UnitOfWorkImpl uow) {
        Vector<DatabaseMapping> mappings = this.descriptor.getMappings();
        boolean isObjectPartial = fetchGroupInObject != null;
        Set<String> fetchedAttributes = isObjectPartial ? fetchGroupInObject.getAttributeNames() : null;
        int size = mappings.size();
        int index = 0;
        while (index < size) {
            DatabaseMapping mapping = mappings.get(index);
            if (!isObjectPartial || fetchedAttributes != null && fetchedAttributes.contains(mapping.getAttributeName())) {
                mapping.buildClone(cachedObject, null, workingClone, null, uow);
                if (workingClone != backupClone) {
                    mapping.buildClone(workingClone, null, backupClone, null, uow);
                }
            }
            ++index;
        }
    }

    private void revertDataIntoUnfetchedAttributesOfClones(Object cachedObject, Object workingClone, Object backupClone, FetchGroup fetchGroupInObject, FetchGroup fetchGroupInClone, UnitOfWorkImpl uow) {
        Set<String> fetchedAttributesClone = fetchGroupInClone.getAttributeNames();
        Set<String> fetchedAttributesCached = null;
        if (fetchGroupInObject != null) {
            fetchedAttributesCached = fetchGroupInObject.getAttributeNames();
        }
        for (DatabaseMapping mapping : this.descriptor.getMappings()) {
            String attributeName = mapping.getAttributeName();
            if (fetchedAttributesCached != null && !fetchedAttributesCached.contains(attributeName) || fetchedAttributesClone.contains(attributeName)) continue;
            mapping.buildClone(cachedObject, null, workingClone, null, uow);
            if (workingClone == backupClone) continue;
            mapping.buildClone(workingClone, null, backupClone, null, uow);
        }
    }

    public void copyFetchGroupInto(Object source, Object target, AbstractSession session) {
        if (this.isPartialObject(source)) {
            this.setObjectFetchGroup(target, ((FetchGroupTracker)source)._persistence_getFetchGroup(), session);
        }
    }

    public void unionEntityFetchGroupIntoObject(Object source, EntityFetchGroup newEntityFetchGroup, AbstractSession session) {
        this.setObjectFetchGroup(source, this.flatUnionFetchGroups(((FetchGroupTracker)source)._persistence_getFetchGroup(), newEntityFetchGroup), session);
    }

    public FetchGroup unionFetchGroups(FetchGroup first, FetchGroup second) {
        if (first == null || second == null) {
            return null;
        }
        if (first == second || first.isSupersetOf(second)) {
            return first;
        }
        if (second.isSupersetOf(first)) {
            return second;
        }
        HashSet<String> unionAttributeNames = new HashSet<String>();
        unionAttributeNames.addAll(first.getAttributeNames());
        unionAttributeNames.addAll(second.getAttributeNames());
        return this.getEntityFetchGroup(unionAttributeNames);
    }

    public EntityFetchGroup flatUnionFetchGroups(FetchGroup first, FetchGroup second) {
        if (first == null || second == null) {
            return null;
        }
        if (first == second) {
            return this.getEntityFetchGroup(first);
        }
        HashSet<String> unionAttributeNames = new HashSet<String>();
        unionAttributeNames.addAll(first.getAttributeNames());
        unionAttributeNames.addAll(second.getAttributeNames());
        return this.getEntityFetchGroup(unionAttributeNames);
    }

    public void reset(Object source) {
        ((FetchGroupTracker)source)._persistence_resetFetchGroup();
    }

    public FetchGroup getObjectFetchGroup(Object domainObject) {
        if (domainObject != null) {
            return ((FetchGroupTracker)domainObject)._persistence_getFetchGroup();
        }
        return null;
    }

    public EntityFetchGroup getObjectEntityFetchGroup(Object domainObject) {
        FetchGroup fetchGroup;
        if (domainObject != null && (fetchGroup = ((FetchGroupTracker)domainObject)._persistence_getFetchGroup()) != null) {
            if (fetchGroup.isEntityFetchGroup()) {
                return (EntityFetchGroup)fetchGroup;
            }
            return this.getEntityFetchGroup(fetchGroup);
        }
        return null;
    }

    public void setObjectFetchGroup(Object source, FetchGroup fetchGroup, AbstractSession session) {
        FetchGroupTracker tracker = (FetchGroupTracker)source;
        if (fetchGroup == null) {
            tracker._persistence_setFetchGroup(null);
            tracker._persistence_setSession(null);
        } else if (fetchGroup.isEntityFetchGroup()) {
            tracker._persistence_setFetchGroup(fetchGroup);
            tracker._persistence_setSession(session);
        } else {
            EntityFetchGroup entityFetchGroup = this.getEntityFetchGroup(fetchGroup);
            if (entityFetchGroup != null) {
                tracker._persistence_setFetchGroup(entityFetchGroup);
                tracker._persistence_setSession(session);
            } else {
                tracker._persistence_setFetchGroup(null);
                tracker._persistence_setSession(null);
            }
        }
    }

    public void setRefreshOnFetchGroupToObject(Object source, boolean shouldRefreshOnFetchgroup) {
        ((FetchGroupTracker)source)._persistence_setShouldRefreshFetchGroup(shouldRefreshOnFetchgroup);
    }

    public boolean isAttributeFetched(Object entity, String attributeName) {
        FetchGroup fetchGroup = ((FetchGroupTracker)entity)._persistence_getFetchGroup();
        if (fetchGroup == null) {
            return true;
        }
        return fetchGroup.containsAttributeInternal(attributeName);
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public boolean hasFetchGroup(String groupName) {
        return this.getFetchGroups().containsKey(groupName);
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        DatabaseMapping lockMapping;
        DatabaseField lockField;
        if (!Helper.classImplementsInterface(this.getDescriptor().getJavaClass(), ClassConstants.FetchGroupTracker_class)) {
            session.getIntegrityChecker().handleError(DescriptorException.needToImplementFetchGroupTracker(this.getDescriptor().getJavaClass(), this.getDescriptor()));
        }
        this.minimalFetchGroup = new FetchGroup();
        this.fullFetchGroup = new FetchGroup();
        for (DatabaseMapping mapping : this.getDescriptor().getMappings()) {
            String name = mapping.getAttributeName();
            if (mapping.isPrimaryKeyMapping()) {
                this.minimalFetchGroup.addAttribute(name);
            }
            this.fullFetchGroup.addAttribute(name);
        }
        this.idEntityFetchGroup = this.getEntityFetchGroup(this.minimalFetchGroup);
        if (this.descriptor.usesOptimisticLocking() && (lockField = this.descriptor.getOptimisticLockingPolicy().getWriteLockField()) != null && (lockMapping = this.getDescriptor().getObjectBuilder().getMappingForField(lockField)) != null) {
            String attributeName = lockMapping.getAttributeName();
            this.minimalFetchGroup.addAttribute(attributeName);
        }
        this.getEntityFetchGroup(this.minimalFetchGroup);
    }

    public void postInitialize(AbstractSession session) throws DescriptorException {
        if (!Helper.classImplementsInterface(this.getDescriptor().getJavaClass(), ClassConstants.FetchGroupTracker_class)) {
            return;
        }
        if (this.fetchGroups != null) {
            for (FetchGroup fetchGroup : this.fetchGroups.values()) {
                this.prepareAndVerify(fetchGroup);
                this.getEntityFetchGroup(fetchGroup);
            }
        }
        if (this.defaultFetchGroup == null) {
            if (this.descriptor.isChildDescriptor() && this.shouldUseInheritedDefaultFetchGroup) {
                ClassDescriptor current = this.descriptor;
                while (current.isChildDescriptor()) {
                    ClassDescriptor parent = current.getInheritancePolicy().getParentDescriptor();
                    if (parent.hasFetchGroupManager()) {
                        this.defaultFetchGroup = parent.getFetchGroupManager().getDefaultFetchGroup();
                        if (this.defaultFetchGroup != null) {
                            return;
                        }
                    }
                    current = parent;
                }
            }
            FetchGroup defaultCandidate = new FetchGroup();
            boolean hasLazy = false;
            for (DatabaseMapping mapping : this.getDescriptor().getMappings()) {
                if (mapping.isForeignReferenceMapping() || !mapping.isLazy()) {
                    defaultCandidate.addAttribute(mapping.getAttributeName());
                    continue;
                }
                hasLazy = true;
            }
            if (hasLazy) {
                this.defaultFetchGroup = defaultCandidate;
            }
        }
        if (this.defaultFetchGroup != null) {
            this.prepareAndVerify(this.defaultFetchGroup);
            this.defaultEntityFetchGroup = this.getEntityFetchGroup(this.defaultFetchGroup);
        }
        this.initNonReferenceEntityFetchGroup();
    }

    protected void initNonReferenceEntityFetchGroup() {
        FetchGroup nonReferenceFetchGroup = new FetchGroup();
        for (DatabaseMapping mapping : this.getDescriptor().getMappings()) {
            if (mapping.isForeignReferenceMapping()) continue;
            String name = mapping.getAttributeName();
            if (this.defaultEntityFetchGroup != null && !this.defaultEntityFetchGroup.containsAttribute(name)) continue;
            nonReferenceFetchGroup.addAttribute(name);
        }
        this.addMinimalFetchGroup(nonReferenceFetchGroup);
        this.nonReferenceEntityFetchGroup = this.getEntityFetchGroup(nonReferenceFetchGroup);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
    }

    public void setShouldUseInheritedDefaultFetchGroup(boolean shouldUseInheritedDefaultFetchGroup) {
        this.shouldUseInheritedDefaultFetchGroup = shouldUseInheritedDefaultFetchGroup;
    }

    public boolean shouldUseInheritedDefaultFetchGroup() {
        return this.shouldUseInheritedDefaultFetchGroup;
    }
}

