/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import org.eclipse.persistence.internal.jpa.jpql.AbstractReadAllQueryVisitor;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.internal.jpa.jpql.ReportItemBuilder;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.EclipseLinkAnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.GroupByClause;
import org.eclipse.persistence.jpa.jpql.parser.HavingClause;
import org.eclipse.persistence.queries.ReportQuery;

final class ReportQueryVisitor
extends AbstractReadAllQueryVisitor {
    Class<?> type;

    ReportQueryVisitor(JPQLQueryContext queryContext, ReportQuery query) {
        super(queryContext, query);
    }

    public void visit(HavingClause expression) {
        ((ReportQuery)this.query).setHavingExpression(this.queryContext.buildExpression(expression));
    }

    public void visit(GroupByClause expression) {
        GroupByVisitor visitor = new GroupByVisitor();
        expression.accept(visitor);
    }

    void visitAbstractSelectClause(AbstractSelectClause expression) {
        super.visitAbstractSelectClause(expression);
        ReportItemBuilder builder = new ReportItemBuilder(this.queryContext, (ReportQuery)this.query);
        expression.accept(builder);
        this.type = builder.type[0];
    }

    void visitAbstractSelectStatement(AbstractSelectStatement expression) {
        super.visitAbstractSelectStatement(expression);
        if (expression.hasHavingClause()) {
            expression.getHavingClause().accept(this);
        }
        if (expression.hasGroupByClause()) {
            expression.getGroupByClause().accept(this);
        }
    }

    private class GroupByVisitor
    extends EclipseLinkAnonymousExpressionVisitor {
        private GroupByVisitor() {
        }

        public void visit(CollectionExpression expression) {
            expression.acceptChildren(this);
        }

        public void visit(GroupByClause expression) {
            expression.getGroupByItems().accept(this);
        }

        protected void visit(Expression expression) {
            ((ReportQuery)ReportQueryVisitor.this.query).addGrouping(ReportQueryVisitor.this.queryContext.buildExpression(expression));
        }
    }
}

