/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;

public class IdAccessor
extends BasicAccessor {
    public IdAccessor() {
        super("<id>");
    }

    public IdAccessor(MetadataAnnotation id, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(id, accessibleObject, classAccessor);
    }

    public boolean equals(Object objectToCompare) {
        return super.equals(objectToCompare) && objectToCompare instanceof IdAccessor;
    }

    public boolean isId() {
        return true;
    }

    public void process() {
        super.process();
        String attributeName = this.getAttributeName();
        for (MetadataDescriptor owningDescriptor : this.getOwningDescriptors()) {
            if (owningDescriptor.hasEmbeddedId()) {
                throw ValidationException.embeddedIdAndIdAnnotationFound(this.getJavaClass(), owningDescriptor.getEmbeddedIdAttributeName(), attributeName);
            }
            owningDescriptor.validatePKClassId(attributeName, this.getBoxedType(this.getReferenceClassName()));
            owningDescriptor.addIdAttributeName(attributeName);
            owningDescriptor.addPrimaryKeyField(this.getDatabaseField(), this);
        }
        this.getMapping().setIsJPAId();
    }
}

