/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.converters.MetadataConverter;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;

public class TemporalMetadata
extends MetadataConverter {
    private String m_temporalType;

    public TemporalMetadata() {
        super("<temporal>");
    }

    public TemporalMetadata(MetadataAnnotation temporal, MetadataAccessor accessor) {
        super(temporal, accessor);
        this.m_temporalType = (String)temporal.getAttribute("value");
    }

    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof TemporalMetadata) {
            TemporalMetadata enumerated = (TemporalMetadata)objectToCompare;
            return this.valuesMatch(this.m_temporalType, enumerated.getTemporalType());
        }
        return false;
    }

    public String getTemporalType() {
        return this.m_temporalType;
    }

    public static boolean isValidTemporalType(MetadataClass cls) {
        return cls.equals(Date.class) || cls.equals(Calendar.class) || cls.equals(GregorianCalendar.class);
    }

    public void process(DatabaseMapping mapping, MappingAccessor accessor, MetadataClass referenceClass, boolean isForMapKey) {
        if (TemporalMetadata.isValidTemporalType(referenceClass)) {
            if (this.m_temporalType.equals("DATE")) {
                this.setFieldClassification(mapping, java.sql.Date.class, isForMapKey);
            } else if (this.m_temporalType.equals("TIME")) {
                this.setFieldClassification(mapping, Time.class, isForMapKey);
            } else {
                this.setFieldClassification(mapping, Timestamp.class, isForMapKey);
            }
        } else {
            throw ValidationException.invalidTypeForTemporalAttribute(accessor.getAttributeName(), referenceClass, accessor.getJavaClass());
        }
        this.setConverter(mapping, new TypeConversionConverter(mapping), isForMapKey);
    }

    public void setTemporalType(String temporalType) {
        this.m_temporalType = temporalType;
    }
}

