/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.mappings;

import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;

public class OrderByMetadata
extends ORMetadata {
    private static final String ASCENDING = "ASC";
    private static final String DESCENDING = "DESC";
    private String m_value;

    public OrderByMetadata() {
        super("<order-by>");
    }

    public OrderByMetadata(MetadataAnnotation orderBy, MetadataAccessor accessor) {
        super(orderBy, accessor);
        this.m_value = (String)orderBy.getAttributeString("value");
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof OrderByMetadata) {
            OrderByMetadata orderBy = (OrderByMetadata)objectToCompare;
            return this.valuesMatch(this.m_value, orderBy.getValue());
        }
        return false;
    }

    public String getValue() {
        return this.m_value;
    }

    public void process(CollectionMapping mapping, MetadataDescriptor referenceDescriptor, MetadataClass javaClass) {
        if (this.m_value != null && !this.m_value.equals("")) {
            StringTokenizer commaTokenizer = new StringTokenizer(this.m_value, ",");
            while (commaTokenizer.hasMoreTokens()) {
                String ordering;
                StringTokenizer spaceTokenizer = new StringTokenizer(commaTokenizer.nextToken());
                String propertyOrFieldName = spaceTokenizer.nextToken();
                if (propertyOrFieldName.equals(ASCENDING) || propertyOrFieldName.equals(DESCENDING)) {
                    ordering = propertyOrFieldName;
                    propertyOrFieldName = referenceDescriptor.getIdAttributeName();
                } else {
                    String string = ordering = spaceTokenizer.hasMoreTokens() ? spaceTokenizer.nextToken() : ASCENDING;
                }
                if (mapping.isDirectCollectionMapping()) {
                    if (ordering.equals(DESCENDING)) {
                        ((DirectCollectionMapping)mapping).addDescendingOrdering();
                        continue;
                    }
                    ((DirectCollectionMapping)mapping).addAscendingOrdering();
                    continue;
                }
                MappingAccessor referenceAccessor = referenceDescriptor.getMappingAccessor(propertyOrFieldName);
                if (referenceAccessor == null) {
                    throw ValidationException.invalidOrderByValue(propertyOrFieldName, referenceDescriptor.getJavaClass(), this.getAccessibleObjectName(), javaClass);
                }
                String attributeName = referenceAccessor.getAttributeName();
                if (referenceAccessor.isEmbedded()) {
                    for (String orderByAttributeName : referenceDescriptor.getOrderByAttributeNames()) {
                        mapping.addAggregateOrderBy(propertyOrFieldName, orderByAttributeName, ordering.equals(DESCENDING));
                    }
                    continue;
                }
                if (referenceAccessor.getClassAccessor().isEmbeddableAccessor()) {
                    String embeddableChain = "";
                    if (propertyOrFieldName.contains(".")) {
                        embeddableChain = propertyOrFieldName.substring(0, propertyOrFieldName.lastIndexOf("."));
                    }
                    mapping.addAggregateOrderBy(embeddableChain, attributeName, ordering.equals(DESCENDING));
                    continue;
                }
                mapping.addOrderBy(attributeName, ordering.equals(DESCENDING));
            }
        } else if (mapping.isDirectCollectionMapping()) {
            ((DirectCollectionMapping)mapping).addAscendingOrdering();
        } else {
            List<String> orderByAttributes = referenceDescriptor.getIdOrderByAttributeNames();
            if (referenceDescriptor.hasEmbeddedId()) {
                String embeddedIdAttributeName = referenceDescriptor.getEmbeddedIdAttributeName();
                for (String orderByAttribute : orderByAttributes) {
                    mapping.addAggregateOrderBy(embeddedIdAttributeName, orderByAttribute, false);
                }
            } else {
                for (String orderByAttribute : orderByAttributes) {
                    mapping.addOrderBy(orderByAttribute, false);
                }
            }
        }
    }

    public void setValue(String value) {
        this.m_value = value;
    }
}

