/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.util.Map;
import org.eclipse.persistence.internal.jpa.StoredProcedureQueryImpl;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.queries.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedStoredProcedureQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.StoredProcedureParameterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.StoredFunctionCall;
import org.eclipse.persistence.queries.StoredProcedureCall;

public class NamedStoredFunctionQueryMetadata
extends NamedStoredProcedureQueryMetadata {
    private StoredProcedureParameterMetadata returnParameter;

    public NamedStoredFunctionQueryMetadata() {
        super("<named-stored-function-query>");
    }

    public NamedStoredFunctionQueryMetadata(MetadataAnnotation namedStoredProcedureQuery, MetadataAccessor accessor) {
        super(namedStoredProcedureQuery, accessor);
        this.returnParameter = new StoredProcedureParameterMetadata((MetadataAnnotation)namedStoredProcedureQuery.getAttribute("returnParameter"), accessor);
        this.setProcedureName((String)namedStoredProcedureQuery.getAttribute("functionName"));
    }

    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof NamedStoredFunctionQueryMetadata) {
            NamedStoredFunctionQueryMetadata query = (NamedStoredFunctionQueryMetadata)objectToCompare;
            return this.valuesMatch(this.returnParameter, query.getReturnParameter());
        }
        return false;
    }

    public StoredProcedureParameterMetadata getReturnParameter() {
        return this.returnParameter;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.returnParameter, accessibleObject);
    }

    public void process(AbstractSession session, ClassLoader loader) {
        StoredFunctionCall call = new StoredFunctionCall();
        boolean callByIndex = this.callByIndex();
        for (StoredProcedureParameterMetadata parameter : this.getParameters()) {
            parameter.processArgument(call, callByIndex, -1);
        }
        if (this.getReturnParameter() != null) {
            this.getReturnParameter().processResult(call, -1);
        }
        call.setProcedureName(this.getProcedureName());
        Map<String, Object> hints = this.processQueryHints(session);
        if (this.getResultClass().isVoid()) {
            if (this.hasResultSetMapping(session)) {
                session.addQuery(this.getName(), StoredProcedureQueryImpl.buildStoredProcedureQuery(this.getResultSetMapping(), (StoredProcedureCall)call, hints, loader, session));
            } else {
                session.addQuery(this.getName(), StoredProcedureQueryImpl.buildStoredProcedureQuery(call, hints, loader, session));
            }
        } else {
            session.addQuery(this.getName(), StoredProcedureQueryImpl.buildStoredProcedureQuery(MetadataHelper.getClassForName(this.getResultClass().getName(), loader), (StoredProcedureCall)call, hints, loader, session));
        }
    }

    public void setReturnParameter(StoredProcedureParameterMetadata returnParameter) {
        this.returnParameter = returnParameter;
    }
}

