/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.SAXFragmentBuilder;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLRelationshipMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.oxm.record.deferred.CompositeCollectionMappingContentHandler;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLInverseReferenceMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLCompositeCollectionMappingNodeValue
extends XMLRelationshipMappingNodeValue
implements ContainerValue {
    private XMLCompositeCollectionMapping xmlCompositeCollectionMapping;
    private int index = -1;

    public XMLCompositeCollectionMappingNodeValue(XMLCompositeCollectionMapping xmlCompositeCollectionMapping) {
        this.xmlCompositeCollectionMapping = xmlCompositeCollectionMapping;
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
        if (this.xmlCompositeCollectionMapping.isReadOnly()) {
            return false;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object collection = this.xmlCompositeCollectionMapping.getAttributeAccessor().getAttributeValueFromObject(object);
        if (collection == null) {
            AbstractNullPolicy wrapperNP = this.xmlCompositeCollectionMapping.getWrapperNullPolicy();
            if (wrapperNP != null && wrapperNP.getMarshalNullRepresentation().equals((Object)XMLNullRepresentationType.XSI_NIL)) {
                marshalRecord.nilSimple(namespaceResolver);
                return true;
            }
            return false;
        }
        Object iterator = cp.iteratorFor(collection);
        if (iterator == null || !cp.hasNext(iterator)) {
            return marshalRecord.emptyCollection(xPathFragment, namespaceResolver, this.xmlCompositeCollectionMapping.getWrapperNullPolicy() != null);
        }
        XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        marshalRecord.closeStartGroupingElements(groupingFragment);
        marshalRecord.startCollection();
        while (cp.hasNext(iterator)) {
            Object objectValue = cp.next(iterator, session);
            this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
        }
        marshalRecord.endCollection();
        return true;
    }

    public boolean startElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts) {
        XMLDescriptor xmlDescriptor;
        block15: {
            block16: {
                try {
                    QName leafType;
                    xmlDescriptor = (XMLDescriptor)this.xmlCompositeCollectionMapping.getReferenceDescriptor();
                    if (xmlDescriptor != null) break block15;
                    xmlDescriptor = this.findReferenceDescriptor(xPathFragment, unmarshalRecord, atts, this.xmlCompositeCollectionMapping, this.xmlCompositeCollectionMapping.getKeepAsElementPolicy());
                    if (xmlDescriptor == null && this.xmlCompositeCollectionMapping.getField() != null && (leafType = ((XMLField)this.xmlCompositeCollectionMapping.getField()).getLastXPathFragment().getLeafElementType()) != null) {
                        XPathFragment frag = new XPathFragment();
                        frag.setNamespaceAware(unmarshalRecord.isNamespaceAware());
                        String xpath = leafType.getLocalPart();
                        String uri = leafType.getNamespaceURI();
                        if (uri != null && uri.length() > 0) {
                            frag.setNamespaceURI(uri);
                            String prefix = ((XMLDescriptor)this.xmlCompositeCollectionMapping.getDescriptor()).getNonNullNamespaceResolver().resolveNamespaceURI(uri);
                            if (prefix != null && prefix.length() > 0) {
                                xpath = String.valueOf(prefix) + ':' + xpath;
                            }
                        }
                        frag.setXPath(xpath);
                        XMLContext xmlContext = unmarshalRecord.getUnmarshaller().getXMLContext();
                        xmlDescriptor = xmlContext.getDescriptorByGlobalType(frag);
                    }
                    UnmarshalKeepAsElementPolicy policy = this.xmlCompositeCollectionMapping.getKeepAsElementPolicy();
                    if ((xmlDescriptor != null || policy != UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT) && policy != UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) break block15;
                    if (unmarshalRecord.getTypeQName() == null) break block16;
                    XMLConversionManager cfr_ignored_0 = (XMLConversionManager)unmarshalRecord.getSession().getDatasourcePlatform().getConversionManager();
                    Class theClass = (Class)XMLConversionManager.getDefaultXMLTypes().get(unmarshalRecord.getTypeQName());
                    if (theClass == null) {
                        this.setupHandlerForKeepAsElementPolicy(unmarshalRecord, xPathFragment, atts);
                        return true;
                    }
                    break block15;
                }
                catch (SAXException e) {
                    throw XMLMarshalException.unmarshalException(e);
                }
            }
            this.setupHandlerForKeepAsElementPolicy(unmarshalRecord, xPathFragment, atts);
            return true;
        }
        if (this.xmlCompositeCollectionMapping.getNullPolicy().isNullRepresentedByEmptyNode()) {
            String qnameString = xPathFragment.getLocalName();
            if (xPathFragment.getPrefix() != null) {
                qnameString = String.valueOf(xPathFragment.getPrefix()) + ':' + qnameString;
            }
            if (xmlDescriptor != null) {
                CompositeCollectionMappingContentHandler aHandler = new CompositeCollectionMappingContentHandler(unmarshalRecord, this, this.xmlCompositeCollectionMapping, atts, xPathFragment, xmlDescriptor);
                aHandler.startElement(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), qnameString, atts);
                XMLReader xmlReader = unmarshalRecord.getXMLReader();
                xmlReader.setContentHandler(aHandler);
                xmlReader.setLexicalHandler(aHandler);
            }
        } else if (this.xmlCompositeCollectionMapping.getNullPolicy().valueIsNull(atts)) {
            this.getContainerPolicy().addInto(null, unmarshalRecord.getContainerInstance(this), unmarshalRecord.getSession());
        } else {
            XMLField xmlFld = (XMLField)this.xmlCompositeCollectionMapping.getField();
            if (xmlFld.hasLastXPathFragment()) {
                unmarshalRecord.setLeafElementType(xmlFld.getLastXPathFragment().getLeafElementType());
            }
            this.processChild(xPathFragment, unmarshalRecord, atts, xmlDescriptor, this.xmlCompositeCollectionMapping);
        }
        return true;
    }

    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        Object collection = unmarshalRecord.getContainerInstance(this);
        this.endElement(xPathFragment, unmarshalRecord, collection);
    }

    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Object collection) {
        if (unmarshalRecord.getChildRecord() == null) {
            SAXFragmentBuilder builder = unmarshalRecord.getFragmentBuilder();
            UnmarshalKeepAsElementPolicy keepAsElementPolicy = this.xmlCompositeCollectionMapping.getKeepAsElementPolicy();
            if ((keepAsElementPolicy == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT || keepAsElementPolicy == UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) && builder.getNodes().size() != 0) {
                if (unmarshalRecord.getTypeQName() != null) {
                    XMLConversionManager cfr_ignored_0 = (XMLConversionManager)unmarshalRecord.getSession().getDatasourcePlatform().getConversionManager();
                    Class theClass = (Class)XMLConversionManager.getDefaultXMLTypes().get(unmarshalRecord.getTypeQName());
                    if (theClass != null) {
                        this.endElementProcessText(unmarshalRecord, this.xmlCompositeCollectionMapping.getConverter(), xPathFragment, collection);
                        return;
                    }
                }
                if (builder.getDocument() != null) {
                    this.setOrAddAttributeValueForKeepAsElement(builder, this.xmlCompositeCollectionMapping, (XMLConverter)this.xmlCompositeCollectionMapping.getConverter(), unmarshalRecord, true, collection);
                    return;
                }
            } else {
                this.endElementProcessText(unmarshalRecord, this.xmlCompositeCollectionMapping.getConverter(), xPathFragment, collection);
                return;
            }
            return;
        }
        Object objectValue = unmarshalRecord.getChildRecord().getCurrentObject();
        if (this.xmlCompositeCollectionMapping.hasConverter()) {
            Converter converter = this.xmlCompositeCollectionMapping.getConverter();
            objectValue = converter instanceof XMLConverter ? ((XMLConverter)converter).convertDataValueToObjectValue(objectValue, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller()) : converter.convertObjectValueToDataValue(objectValue, unmarshalRecord.getSession());
        }
        unmarshalRecord.addAttributeValue(this, objectValue, collection);
        XMLInverseReferenceMapping inverseReferenceMapping = this.xmlCompositeCollectionMapping.getInverseReferenceMapping();
        if (inverseReferenceMapping != null) {
            if (inverseReferenceMapping.getContainerPolicy() == null) {
                inverseReferenceMapping.getAttributeAccessor().setAttributeValueInObject(objectValue, unmarshalRecord.getCurrentObject());
            } else {
                Object backpointerContainer = inverseReferenceMapping.getAttributeAccessor().getAttributeValueFromObject(objectValue);
                if (backpointerContainer == null) {
                    backpointerContainer = inverseReferenceMapping.getContainerPolicy().containerInstance();
                    inverseReferenceMapping.getAttributeAccessor().setAttributeValueInObject(objectValue, backpointerContainer);
                }
                inverseReferenceMapping.getContainerPolicy().addInto(unmarshalRecord.getCurrentObject(), backpointerContainer, unmarshalRecord.getSession());
            }
        }
        unmarshalRecord.setChildRecord(null);
    }

    public Object getContainerInstance() {
        return this.getContainerPolicy().containerInstance();
    }

    public void setContainerInstance(Object object, Object containerInstance) {
        this.xmlCompositeCollectionMapping.setAttributeValueInObject(object, containerInstance);
    }

    public ContainerPolicy getContainerPolicy() {
        return this.xmlCompositeCollectionMapping.getContainerPolicy();
    }

    public boolean isContainerValue() {
        return true;
    }

    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        UnmarshalKeepAsElementPolicy keepAsElementPolicy;
        if (xPathFragment.hasLeafElementType()) {
            marshalRecord.setLeafElementType(xPathFragment.getLeafElementType());
        }
        XMLMarshaller marshaller = marshalRecord.getMarshaller();
        if (this.xmlCompositeCollectionMapping.hasConverter()) {
            Converter converter = this.xmlCompositeCollectionMapping.getConverter();
            value = converter instanceof XMLConverter ? ((XMLConverter)converter).convertObjectValueToDataValue(value, session, marshaller) : converter.convertObjectValueToDataValue(value, session);
        }
        if (value == null) {
            return this.xmlCompositeCollectionMapping.getNullPolicy().compositeObjectMarshal(xPathFragment, marshalRecord, object, session, namespaceResolver);
        }
        XMLDescriptor descriptor = (XMLDescriptor)this.xmlCompositeCollectionMapping.getReferenceDescriptor();
        if (descriptor == null || descriptor.hasInheritance() && descriptor.getJavaClass() != value.getClass()) {
            descriptor = (XMLDescriptor)session.getDescriptor(value.getClass());
        }
        if (((keepAsElementPolicy = this.xmlCompositeCollectionMapping.getKeepAsElementPolicy()) == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT || keepAsElementPolicy == UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) && value instanceof Node) {
            marshalRecord.node((Node)value, marshalRecord.getNamespaceResolver());
            return true;
        }
        if (descriptor != null) {
            marshalRecord.beforeContainmentMarshal(value);
            TreeObjectBuilder objectBuilder = (TreeObjectBuilder)descriptor.getObjectBuilder();
            this.getXPathNode().startElement(marshalRecord, xPathFragment, object, session, namespaceResolver, objectBuilder, value);
            List extraNamespaces = objectBuilder.addExtraNamespacesToNamespaceResolver(descriptor, marshalRecord, session);
            this.writeExtraNamespaces(extraNamespaces, marshalRecord, session);
            objectBuilder.addXsiTypeAndClassIndicatorIfRequired(marshalRecord, descriptor, (XMLDescriptor)this.xmlCompositeCollectionMapping.getReferenceDescriptor(), (XMLField)this.xmlCompositeCollectionMapping.getField(), false);
            objectBuilder.buildRow(marshalRecord, value, session, marshaller, xPathFragment, DatabaseMapping.WriteType.UNDEFINED);
            marshalRecord.afterContainmentMarshal(object, value);
            marshalRecord.endElement(xPathFragment, namespaceResolver);
            objectBuilder.removeExtraNamespacesFromNamespaceResolver(marshalRecord, extraNamespaces, session);
        } else {
            this.getXPathNode().startElement(marshalRecord, xPathFragment, object, session, namespaceResolver, null, value);
            QName schemaType = this.getSchemaType((XMLField)this.xmlCompositeCollectionMapping.getField(), value, session);
            this.updateNamespaces(schemaType, marshalRecord, (XMLField)this.xmlCompositeCollectionMapping.getField());
            marshalRecord.characters(schemaType, value, null, false);
            marshalRecord.endElement(xPathFragment, namespaceResolver);
        }
        return true;
    }

    public XMLCompositeCollectionMapping getMapping() {
        return this.xmlCompositeCollectionMapping;
    }

    protected void setOrAddAttributeValue(UnmarshalRecord unmarshalRecord, Object value, XPathFragment xPathFragment, Object collection) {
        unmarshalRecord.addAttributeValue(this, value, collection);
    }

    public boolean getReuseContainer() {
        return this.getMapping().getReuseContainer();
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isDefaultEmptyContainer() {
        return this.getMapping().isDefaultEmptyContainer();
    }
}

