/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.annotations.CacheKeyType;
import org.eclipse.persistence.config.ReferenceMode;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.changetracking.AttributeChangeTrackingPolicy;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangePolicy;
import org.eclipse.persistence.exceptions.CommunicationException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatasourceAccessor;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.descriptors.CascadeLockingPolicy;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.IdentityHashSet;
import org.eclipse.persistence.internal.helper.IdentityWeakHashMap;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMapManager;
import org.eclipse.persistence.internal.identitymaps.UnitOfWorkCacheKey;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkQueryValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkTransformerValueHolder;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.localization.LoggingLocalization;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CommitManager;
import org.eclipse.persistence.internal.sessions.IsolatedClientSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkIdentityMapAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.DoesExistQuery;
import org.eclipse.persistence.queries.ModifyAllQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.coordination.MergeChangeSetCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitOfWorkImpl
extends AbstractSession
implements UnitOfWork {
    protected transient Map<Object, Object> cloneToOriginals;
    protected transient AbstractSession parent;
    protected Map<Object, Object> cloneMapping;
    protected Map<Object, Object> newObjectsCloneToOriginal;
    protected Map<Object, Object> newObjectsOriginalToClone;
    protected Map<Object, Object> deletedObjects;
    protected Map<Object, Object> allClones;
    protected Map<Object, Object> objectsDeletedDuringCommit;
    protected Map<Object, Object> removedObjects;
    protected Map<Object, Object> unregisteredNewObjects;
    protected Map<Object, Object> unregisteredNewObjectsInParent;
    protected Map<Object, Object> unregisteredExistingObjects;
    protected Map<Object, Object> newObjectsInParentOriginalToClone;
    protected Map<DatabaseMapping, Set> privateOwnedObjects;
    protected Map<Object, Object> newObjectsInParent;
    protected Map<Object, Object> newAggregates;
    protected UnitOfWorkChangeSet unitOfWorkChangeSet;
    protected UnitOfWorkImpl containerUnitOfWork;
    protected Map<Object, Object> containerBeans;
    protected Map<Object, Object> pessimisticLockedObjects;
    protected MergeManager lastUsedMergeManager;
    protected Map<ReadQuery, ReadQuery> batchQueries;
    protected Set<Class> readOnlyClasses;
    protected boolean wasTransactionBegunPrematurely;
    protected boolean shouldNewObjectsBeCached;
    protected boolean shouldPerformDeletesFirst;
    protected int shouldThrowConformExceptions;
    protected int validationLevel;
    public static final int None = 0;
    public static final int Partial = 1;
    public static final int Full = 2;
    protected int lifecycle;
    public static final int Birth = 0;
    public static final int CommitPending = 1;
    public static final int CommitTransactionPending = 2;
    public static final int WriteChangesFailed = 3;
    public static final int MergePending = 4;
    public static final int Death = 5;
    public static final int AfterExternalTransactionRolledBack = 6;
    public static final int DO_NOT_THROW_CONFORM_EXCEPTIONS = 0;
    public static final int THROW_ALL_CONFORM_EXCEPTIONS = 1;
    public static final String LOCK_QUERIES_PROPERTY = "LockQueriesProperties";
    protected static boolean SmartMerge = false;
    protected Map<Object, Object> optimisticReadLockObjects;
    public static final String ReadLockOnly = "no update";
    public static final String ReadLockUpdateVersion = "update version";
    protected List<ModifyAllQuery> modifyAllQueries;
    protected List<Object[]> deferredModifyAllQueries;
    protected int cloneDepth;
    protected Object transaction;
    protected boolean resumeOnTransactionCompletion;
    protected boolean shouldDiscoverNewObjects;
    protected boolean wasNonObjectLevelModifyQueryExecuted;
    protected boolean shouldCascadeCloneToJoinedRelationship;
    protected boolean isNestedUnitOfWork;
    protected boolean shouldValidateExistence;
    protected boolean shouldOrderUpdates;
    protected ReferenceMode referenceMode;
    protected Set<Object> changeTrackedHardList;
    protected Map<Object, Object> unregisteredDeletedObjectsCloneToBackupAndOriginal;
    protected boolean preDeleteComplete = false;
    protected Map<DatabaseMapping, List<Object>> deletedPrivateOwnedObjects;
    protected MergeManager mergeManagerForActiveMerge = null;
    protected Set<Object> cascadeDeleteObjects;
    protected Map<Object, Set<Object>> deletionDependencies;

    public UnitOfWorkImpl(AbstractSession parent, ReferenceMode referenceMode) {
        this.isLoggingOff = parent.isLoggingOff;
        this.referenceMode = referenceMode;
        this.shouldDiscoverNewObjects = true;
        this.name = parent.name;
        this.parent = parent;
        this.project = parent.project;
        this.profiler = parent.profiler;
        this.isInProfile = parent.isInProfile;
        this.sessionLog = parent.sessionLog;
        if (parent.hasEventManager()) {
            this.eventManager = parent.getEventManager().clone(this);
        }
        this.exceptionHandler = parent.exceptionHandler;
        this.pessimisticLockTimeoutDefault = parent.pessimisticLockTimeoutDefault;
        this.queryTimeoutDefault = parent.queryTimeoutDefault;
        this.setReadOnlyClasses(parent.copyReadOnlyClasses());
        this.validationLevel = 1;
        this.shouldThrowConformExceptions = 0;
        this.lifecycle = 0;
        this.isNestedUnitOfWork = parent.isUnitOfWork();
        if (this.eventManager != null) {
            this.eventManager.postAcquireUnitOfWork();
        }
        this.descriptors = parent.getDescriptors();
        this.incrementProfile("Counter:UnitOfWorkCreates");
        this.shouldCheckWriteLock = this.getParent().getDatasourceLogin().shouldSynchronizedReadOnWrite() || this.getParent().getDatasourceLogin().shouldSynchronizeWrites();
        this.shouldOrderUpdates = true;
        this.tablePerTenantDescriptors = parent.tablePerTenantDescriptors;
    }

    @Override
    public Session acquireHistoricalSession(AsOfClause clause) throws ValidationException {
        throw ValidationException.cannotAcquireHistoricalSession();
    }

    @Override
    public UnitOfWorkImpl acquireUnitOfWork() {
        UnitOfWorkImpl uow = super.acquireUnitOfWork();
        uow.discoverAllUnregisteredNewObjectsInParent();
        return uow;
    }

    public void addDeletedPrivateOwnedObjects(DatabaseMapping mapping, Object object) {
        List<Object> list;
        if (this.deletedPrivateOwnedObjects == null) {
            this.deletedPrivateOwnedObjects = new IdentityHashMap<DatabaseMapping, List<Object>>();
        }
        if ((list = this.deletedPrivateOwnedObjects.get(mapping)) == null) {
            list = new ArrayList<Object>();
            this.deletedPrivateOwnedObjects.put(mapping, list);
        }
        list.add(object);
    }

    public void addNewAggregate(Object originalObject) {
        this.getNewAggregates().put(originalObject, originalObject);
    }

    public void addObjectDeletedDuringCommit(Object object, ClassDescriptor descriptor) {
        this.getObjectsDeletedDuringCommit().put(object, this.keyFromObject(object, descriptor));
        ((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).addDeletedObject(object, this);
    }

    @Override
    public void addReadOnlyClass(Class theClass) throws ValidationException {
        if (!this.canChangeReadOnlySet()) {
            throw ValidationException.cannotModifyReadOnlyClassesSetAfterUsingUnitOfWork();
        }
        this.getReadOnlyClasses().add(theClass);
        ClassDescriptor descriptor = this.getDescriptor(theClass);
        if (descriptor.hasInheritance()) {
            for (ClassDescriptor childDescriptor : descriptor.getInheritancePolicy().getChildDescriptors()) {
                this.addReadOnlyClass(childDescriptor.getJavaClass());
            }
        }
    }

    @Override
    public void addReadOnlyClasses(Collection classes) {
        for (Class theClass : classes) {
            this.addReadOnlyClass(theClass);
        }
    }

    public void addRemovedObject(Object orignal) {
        this.getRemovedObjects().put(orignal, orignal);
    }

    @Override
    public void assignSequenceNumber(Object object) throws DatabaseException {
        ClassDescriptor descriptor = this.getDescriptor(object);
        Object implementation = descriptor.getObjectBuilder().unwrapObject(object, this);
        this.assignSequenceNumber(implementation, descriptor);
    }

    public Object assignSequenceNumber(Object object, ClassDescriptor descriptor) throws DatabaseException {
        Object value = null;
        if (descriptor.usesSequenceNumbers() && !descriptor.getSequence().shouldAcquireValueAfterInsert()) {
            this.startOperationProfile("Timer:Sequencing");
            ObjectBuilder builder = descriptor.getObjectBuilder();
            try {
                try {
                    value = builder.assignSequenceNumber(object, this);
                }
                catch (RuntimeException exception) {
                    this.handleException(exception);
                    this.endOperationProfile("Timer:Sequencing");
                }
            }
            finally {
                this.endOperationProfile("Timer:Sequencing");
            }
        }
        return value;
    }

    @Override
    public void assignSequenceNumbers() throws DatabaseException {
        this.discoverAllUnregisteredNewObjects();
        if (this.hasUnregisteredNewObjects()) {
            this.assignSequenceNumbers(this.getUnregisteredNewObjects());
        }
        if (this.hasNewObjects()) {
            this.assignSequenceNumbers(this.getNewObjectsCloneToOriginal());
        }
    }

    protected void assignSequenceNumbers(Map objects) throws DatabaseException {
        if (objects.isEmpty()) {
            return;
        }
        Sequencing sequencing = this.getSequencing();
        if (sequencing == null) {
            return;
        }
        int whenShouldAcquireValueForAll = sequencing.whenShouldAcquireValueForAll();
        if (whenShouldAcquireValueForAll == 1) {
            return;
        }
        boolean shouldAcquireValueBeforeInsertForAll = whenShouldAcquireValueForAll == -1;
        this.startOperationProfile("Timer:Sequencing");
        for (Object object : objects.keySet()) {
            ClassDescriptor descriptor = this.getDescriptor(object);
            if (!descriptor.usesSequenceNumbers() || !shouldAcquireValueBeforeInsertForAll && descriptor.getSequence().shouldAcquireValueAfterInsert()) continue;
            descriptor.getObjectBuilder().assignSequenceNumber(object, this);
        }
        this.endOperationProfile("Timer:Sequencing");
    }

    @Override
    public void beginEarlyTransaction() throws DatabaseException {
        this.beginTransaction();
        this.setWasTransactionBegunPrematurely(true);
    }

    @Override
    public void beginTransaction() throws DatabaseException {
        this.parent.beginTransaction();
    }

    public Object buildOriginal(Object workingClone) {
        ClassDescriptor descriptor = this.getDescriptor(workingClone);
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object original = builder.instantiateClone(workingClone, this);
        if (this.checkIfAlreadyRegistered(workingClone, descriptor) != null) {
            this.getCloneToOriginals().put(workingClone, original);
            return original;
        }
        Object backup = builder.instantiateClone(workingClone, this);
        this.getCloneMapping().put(workingClone, backup);
        this.getNewObjectsCloneToOriginal().put(workingClone, original);
        this.getNewObjectsOriginalToClone().put(original, workingClone);
        return original;
    }

    /*
     * WARNING - void declaration
     */
    public UnitOfWorkChangeSet calculateChanges(Map registeredObjects, UnitOfWorkChangeSet changeSet, boolean assignSequences, boolean shouldCloneMap) {
        Map allObjects;
        if (this.eventManager != null) {
            this.eventManager.preCalculateUnitOfWorkChangeSet();
        }
        Map map = allObjects = shouldCloneMap ? this.cloneMap(registeredObjects) : registeredObjects;
        if (assignSequences && this.hasNewObjects()) {
            this.assignSequenceNumbers(this.newObjectsCloneToOriginal);
        }
        Iterator objects = allObjects.keySet().iterator();
        IdentityHashMap changedObjects = new IdentityHashMap();
        IdentityHashMap visitedNodes = new IdentityHashMap();
        while (objects.hasNext()) {
            Object object = objects.next();
            Iterator<Map.Entry<DatabaseMapping, List<Object>>> descriptor = this.getDescriptor(object);
            this.updateDerivedIds(object, (ClassDescriptor)((Object)descriptor));
            boolean isNew = this.isCloneNewObject(object);
            if (isNew || ((ClassDescriptor)((Object)descriptor)).getObjectChangePolicy().shouldCompareExistingObjectForChange(object, this, (ClassDescriptor)((Object)descriptor))) {
                ObjectChangeSet changes = null;
                changes = isNew ? ((ClassDescriptor)((Object)descriptor)).getObjectChangePolicy().calculateChangesForNewObject(object, changeSet, this, (ClassDescriptor)((Object)descriptor), true) : ((ClassDescriptor)((Object)descriptor)).getObjectChangePolicy().calculateChangesForExistingObject(object, changeSet, this, (ClassDescriptor)((Object)descriptor), true);
                if (changes != null) {
                    changeSet.addObjectChangeSet(changes, this, true);
                    changedObjects.put(object, object);
                    if (!changes.hasChanges() || changes.hasForcedChangesFromCascadeLocking()) continue;
                    if (((ClassDescriptor)((Object)descriptor)).hasCascadeLockingPolicies()) {
                        for (CascadeLockingPolicy cascadeLockingPolicy : ((ClassDescriptor)((Object)descriptor)).getCascadeLockingPolicies()) {
                            cascadeLockingPolicy.lockNotifyParent(object, changeSet, this);
                        }
                        continue;
                    }
                    if (!((ClassDescriptor)((Object)descriptor)).usesOptimisticLocking() || !((ClassDescriptor)((Object)descriptor)).getOptimisticLockingPolicy().isCascaded()) continue;
                    changes.setHasForcedChangesFromCascadeLocking(true);
                    continue;
                }
                visitedNodes.put(object, object);
                continue;
            }
            visitedNodes.put(object, object);
        }
        if (this.hasDeletedObjects() && !this.isNestedUnitOfWork()) {
            for (Map.Entry<DatabaseMapping, List<Object>> deletedObject : ((IdentityHashMap)((IdentityHashMap)this.deletedObjects).clone()).keySet()) {
                this.getDescriptor(deletedObject).getObjectBuilder().recordPrivateOwnedRemovals(deletedObject, this, true);
            }
        }
        if (this.deletedPrivateOwnedObjects != null && !this.isNestedUnitOfWork) {
            for (Map.Entry<DatabaseMapping, List<Object>> entry : this.deletedPrivateOwnedObjects.entrySet()) {
                DatabaseMapping databasemapping = entry.getKey();
                for (Object deletedObject : entry.getValue()) {
                    databasemapping.getReferenceDescriptor().getObjectBuilder().recordPrivateOwnedRemovals(deletedObject, this, false);
                }
            }
            this.deletedPrivateOwnedObjects.clear();
        }
        if (this.project.hasMappingsPostCalculateChangesOnDeleted() && this.hasDeletedObjects()) {
            for (Object deletedObject : this.getDeletedObjects().keySet()) {
                void var13_25;
                ClassDescriptor descriptor = this.getDescriptor(deletedObject);
                if (!descriptor.hasMappingsPostCalculateChangesOnDeleted()) continue;
                int size = descriptor.getMappingsPostCalculateChangesOnDeleted().size();
                boolean bl = false;
                while (var13_25 < size) {
                    DatabaseMapping mapping = descriptor.getMappingsPostCalculateChangesOnDeleted().get((int)var13_25);
                    mapping.postCalculateChangesOnDeleted(deletedObject, changeSet, this);
                    ++var13_25;
                }
            }
        }
        if (this.shouldDiscoverNewObjects && !changedObjects.isEmpty()) {
            IdentityHashMap newObjects = new IdentityHashMap();
            this.discoverUnregisteredNewObjects(changedObjects, newObjects, this.getUnregisteredExistingObjects(), visitedNodes);
            this.setUnregisteredNewObjects(newObjects);
            if (assignSequences) {
                this.assignSequenceNumbers(newObjects);
            }
            for (Object object : newObjects.values()) {
                ClassDescriptor descriptor = this.getDescriptor(object);
                ObjectChangeSet objectChangeSet = descriptor.getObjectChangePolicy().calculateChangesForNewObject(object, changeSet, this, descriptor, true);
                changeSet.addObjectChangeSet(objectChangeSet, this, true);
            }
        }
        if (this.hasPrivateOwnedObjects()) {
            IdentityHashMap visitedObjects = new IdentityHashMap();
            for (Set privateOwnedObjects : this.getPrivateOwnedObjects().values()) {
                for (Object objectToRemove : privateOwnedObjects) {
                    this.performRemovePrivateOwnedObjectFromChangeSet(objectToRemove, visitedObjects);
                }
            }
            this.privateOwnedObjects.clear();
        }
        if (this.eventManager != null) {
            this.eventManager.postCalculateUnitOfWorkChangeSet(changeSet);
        }
        return changeSet;
    }

    protected boolean canChangeReadOnlySet() {
        return !this.hasCloneMapping() && !this.hasDeletedObjects();
    }

    public boolean checkForUnregisteredExistingObject(Object object) {
        ClassDescriptor descriptor = this.getDescriptor(object.getClass());
        Object primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this, true);
        if (primaryKey == null) {
            return false;
        }
        DoesExistQuery existQuery = descriptor.getQueryManager().getDoesExistQuery();
        existQuery = (DoesExistQuery)existQuery.clone();
        existQuery.setObject(object);
        existQuery.setPrimaryKey(primaryKey);
        existQuery.setDescriptor(descriptor);
        existQuery.setIsExecutionClone(true);
        return (Boolean)this.executeQuery(existQuery);
    }

    public Object checkExistence(Object object) {
        ClassDescriptor descriptor = this.getDescriptor(object.getClass());
        Object primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this, true);
        if (primaryKey == null) {
            return null;
        }
        DoesExistQuery existQuery = descriptor.getQueryManager().getDoesExistQuery();
        Boolean exists = (Boolean)existQuery.checkEarlyReturn(object, primaryKey, this, null);
        if (exists == null) {
            existQuery = (DoesExistQuery)existQuery.clone();
            existQuery.setObject(object);
            existQuery.setPrimaryKey(primaryKey);
            existQuery.setDescriptor(descriptor);
            existQuery.setIsExecutionClone(true);
            exists = (boolean)((Boolean)this.executeQuery(existQuery));
        }
        if (exists.booleanValue()) {
            Object objectFromCache = this.getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, object.getClass(), descriptor);
            if (objectFromCache != null) {
                if (this.shouldPerformFullValidation() && objectFromCache != object && this.parent.getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, object.getClass(), descriptor) != object) {
                    throw ValidationException.wrongObjectRegistered(object, objectFromCache);
                }
                if (!this.isObjectDeleted(objectFromCache)) {
                    return objectFromCache;
                }
            }
            CacheKey cacheKey = new CacheKey(primaryKey);
            cacheKey.setReadTime(System.currentTimeMillis());
            cacheKey.setIsolated(true);
            return this.cloneAndRegisterObject(object, cacheKey, descriptor);
        }
        return null;
    }

    public Object checkIfAlreadyRegistered(Object object, ClassDescriptor descriptor) {
        if (this.isClassReadOnly(object.getClass(), descriptor)) {
            return null;
        }
        Object registeredObject = this.getCloneMapping().get(object);
        if (registeredObject != null) {
            return object;
        }
        if (this.hasNewObjects() && (registeredObject = this.getNewObjectsOriginalToClone().get(object)) != null) {
            return registeredObject;
        }
        if (this.isNestedUnitOfWork) {
            if (this.hasNewObjectsInParentOriginalToClone()) {
                registeredObject = this.getNewObjectsInParentOriginalToClone().get(object);
            }
            if (registeredObject != null) {
                return registeredObject;
            }
        }
        return null;
    }

    @Override
    public boolean isConsideredInvalid(Object object, CacheKey cacheKey, ClassDescriptor descriptor) {
        if (!this.isNestedUnitOfWork) {
            return this.getParent().isConsideredInvalid(object, cacheKey, descriptor);
        }
        return false;
    }

    protected Object cloneAndRegisterNewObject(Object original) {
        ClassDescriptor descriptor = this.getDescriptor(original);
        if (this.isNestedUnitOfWork && descriptor.getObjectChangePolicy() instanceof AttributeChangeTrackingPolicy) {
            throw ValidationException.nestedUOWNotSupportedForAttributeTracking();
        }
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object clone = builder.instantiateWorkingCopyClone(original, this);
        this.getNewObjectsOriginalToClone().put(original, clone);
        this.getNewObjectsCloneToOriginal().put(clone, original);
        this.getCloneMapping().put(clone, clone);
        builder.populateAttributesForClone(original, null, clone, null, this);
        this.registerNewObjectClone(clone, original, descriptor);
        Object backupClone = descriptor.getObjectChangePolicy().buildBackupClone(clone, builder, this);
        this.getCloneMapping().put(clone, backupClone);
        this.executeDeferredEvents();
        return clone;
    }

    public Object cloneAndRegisterObject(Object original, CacheKey parentCacheKey, ClassDescriptor descriptor) {
        CacheKey unitOfWorkCacheKey = null;
        if (parentCacheKey.getKey() == null) {
            unitOfWorkCacheKey = new UnitOfWorkCacheKey(null);
            unitOfWorkCacheKey.acquire();
        } else {
            unitOfWorkCacheKey = this.getIdentityMapAccessorInstance().acquireLock(parentCacheKey.getKey(), original.getClass(), descriptor);
        }
        try {
            Object object = this.cloneAndRegisterObject(original, parentCacheKey, unitOfWorkCacheKey, descriptor);
            return object;
        }
        finally {
            unitOfWorkCacheKey.release();
        }
    }

    /*
     * Unable to fully structure code
     */
    public Object cloneAndRegisterObject(Object original, CacheKey parentCacheKey, CacheKey unitOfWorkCacheKey, ClassDescriptor descriptor) {
        block16: {
            block17: {
                concreteDescriptor = descriptor;
                if (original.getClass() != descriptor.getJavaClass()) {
                    concreteDescriptor = this.getDescriptor(original);
                }
                if (this.isNestedUnitOfWork && concreteDescriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
                    throw ValidationException.nestedUOWNotSupportedForAttributeTracking();
                }
                builder = concreteDescriptor.getObjectBuilder();
                workingClone = null;
                identityMapLocked = this.parent.shouldCheckWriteLock != false && this.parent.getIdentityMapAccessorInstance().acquireWriteLock() != false;
                rootOfCloneRecursion = false;
                if (identityMapLocked) {
                    this.checkAndRefreshInvalidObject(original, parentCacheKey, descriptor);
                } else if (this.objectsLockedForClone == null) {
                    if (concreteDescriptor.shouldAcquireCascadedLocks()) {
                        this.objectsLockedForClone = this.parent.getIdentityMapAccessorInstance().getWriteLockManager().acquireLocksForClone(original, concreteDescriptor, parentCacheKey, this.parent);
                    } else {
                        this.checkAndRefreshInvalidObject(original, parentCacheKey, descriptor);
                        parentCacheKey.acquireReadLock();
                    }
                    rootOfCloneRecursion = true;
                }
                try {
                    workingClone = builder.instantiateWorkingCopyClone(original, this);
                    if (workingClone instanceof PersistenceEntity) {
                        ((PersistenceEntity)workingClone)._persistence_setId(parentCacheKey.getKey());
                    }
                    this.getCloneMapping().put(workingClone, workingClone);
                    if (this.isNestedUnitOfWork && this.isCloneNewObjectFromParent(original)) {
                        this.getNewObjectsInParentOriginalToClone().put(original, workingClone);
                    }
                    this.getCloneToOriginals().put(workingClone, original);
                    this.populateAndRegisterObject(original, workingClone, unitOfWorkCacheKey, parentCacheKey, concreteDescriptor);
                    if (concreteDescriptor.hasFetchGroupManager()) {
                        concreteDescriptor.getFetchGroupManager().copyFetchGroupInto(original, workingClone, this);
                    }
                }
                finally {
                    if (identityMapLocked) {
                        this.parent.getIdentityMapAccessorInstance().releaseWriteLock();
                        break block16;
                    }
                    if (!rootOfCloneRecursion) break block16;
                    if (this.objectsLockedForClone == null) {
                        parentCacheKey.releaseReadLock();
                        break block17;
                    }
                    iterator = this.objectsLockedForClone.values().iterator();
                    if (true) ** GOTO lbl50
                }
                {
                }
                do {
                    ((CacheKey)iterator.next()).releaseReadLock();
lbl50:
                    // 2 sources

                } while (iterator.hasNext());
                this.objectsLockedForClone = null;
            }
            this.executeDeferredEvents();
        }
        concreteDescriptor.getObjectBuilder().instantiateEagerMappings(workingClone, this);
        return workingClone;
    }

    public Map collectAndPrepareObjectsForNestedMerge() {
        this.discoverAllUnregisteredNewObjectsInParent();
        return new IdentityHashMap(this.getCloneMapping());
    }

    @Override
    public void commit() throws DatabaseException, OptimisticLockException {
        if (!this.isActive()) {
            throw ValidationException.cannotCommitUOWAgain();
        }
        if (this.isAfterWriteChangesFailed()) {
            throw ValidationException.unitOfWorkAfterWriteChangesFailed("commit");
        }
        if (!this.isNestedUnitOfWork && this.isSynchronized()) {
            if (this.parent.wasJTSTransactionInternallyStarted()) {
                this.commitInternallyStartedExternalTransaction();
            }
            return;
        }
        this.log(2, "transaction", "begin_unit_of_work_commit");
        if (this.lifecycle == 2) {
            this.commitAfterWriteChanges();
            return;
        }
        if (this.eventManager != null) {
            this.eventManager.preCommitUnitOfWork();
        }
        this.setLifecycle(1);
        if (this.isNestedUnitOfWork) {
            this.commitNestedUnitOfWork();
        } else {
            this.commitRootUnitOfWork();
        }
        if (this.eventManager != null) {
            this.eventManager.postCommitUnitOfWork();
        }
        this.log(2, "transaction", "end_unit_of_work_commit");
        this.release();
    }

    @Override
    public void commitAndResume() throws DatabaseException, OptimisticLockException {
        if (!this.isActive()) {
            throw ValidationException.cannotCommitUOWAgain();
        }
        if (this.isAfterWriteChangesFailed()) {
            throw ValidationException.unitOfWorkAfterWriteChangesFailed("commit");
        }
        if (!this.isNestedUnitOfWork && this.isSynchronized()) {
            throw ValidationException.cannotCommitAndResumeSynchronizedUOW(this);
        }
        if (this.lifecycle == 2) {
            this.commitAndResumeAfterWriteChanges();
            return;
        }
        this.log(2, "transaction", "begin_unit_of_work_commit");
        if (this.eventManager != null) {
            this.eventManager.preCommitUnitOfWork();
        }
        this.setLifecycle(1);
        if (this.parent.isUnitOfWork()) {
            this.commitNestedUnitOfWork();
        } else {
            this.commitRootUnitOfWork();
        }
        if (this.eventManager != null) {
            this.eventManager.postCommitUnitOfWork();
        }
        this.log(2, "transaction", "end_unit_of_work_commit");
        this.log(2, "transaction", "resume_unit_of_work");
        this.synchronizeAndResume();
        if (this.eventManager != null) {
            this.eventManager.postResumeUnitOfWork();
        }
    }

    public void commitAndResumeWithPreBuiltChangeSet(UnitOfWorkChangeSet uowChangeSet) throws DatabaseException, OptimisticLockException {
        if (!this.isNestedUnitOfWork && this.isSynchronized()) {
            if (this.parent.wasJTSTransactionInternallyStarted()) {
                this.commitInternallyStartedExternalTransaction();
            }
            return;
        }
        this.log(2, "transaction", "begin_unit_of_work_commit");
        if (this.eventManager != null) {
            this.eventManager.preCommitUnitOfWork();
        }
        this.setLifecycle(1);
        if (this.parent.isUnitOfWork()) {
            this.commitNestedUnitOfWork();
        } else {
            this.commitRootUnitOfWorkWithPreBuiltChangeSet(uowChangeSet);
        }
        if (this.eventManager != null) {
            this.eventManager.postCommitUnitOfWork();
        }
        this.log(2, "transaction", "end_unit_of_work_commit");
        this.log(2, "transaction", "resume_unit_of_work");
        this.synchronizeAndResume();
        if (this.eventManager != null) {
            this.eventManager.postResumeUnitOfWork();
        }
    }

    @Override
    public void commitAndResumeOnFailure() throws DatabaseException, OptimisticLockException {
        IdentityMapManager failureManager = (IdentityMapManager)this.getIdentityMapAccessorInstance().getIdentityMapManager().clone();
        try {
            this.commitAndResume();
        }
        catch (RuntimeException exception) {
            this.setUnitOfWorkChangeSet(null);
            this.getIdentityMapAccessorInstance().setIdentityMapManager(failureManager);
            this.log(2, "transaction", "resuming_unit_of_work_from_failure");
            throw exception;
        }
    }

    protected void commitAfterWriteChanges() {
        this.commitTransactionAfterWriteChanges();
        this.mergeClonesAfterCompletion();
        this.setDead();
        this.release();
    }

    protected void commitAndResumeAfterWriteChanges() {
        this.commitTransactionAfterWriteChanges();
        this.mergeClonesAfterCompletion();
        this.log(2, "transaction", "resume_unit_of_work");
        this.synchronizeAndResume();
        if (this.eventManager != null) {
            this.eventManager.postResumeUnitOfWork();
        }
    }

    protected boolean commitInternallyStartedExternalTransaction() {
        boolean committed = false;
        if (!this.parent.isInTransaction() || this.wasTransactionBegunPrematurely() && this.parent.getTransactionMutex().getDepth() == 1) {
            committed = this.parent.commitExternalTransaction();
        }
        return committed;
    }

    protected void commitNestedUnitOfWork() {
        this.parent.getIdentityMapAccessorInstance().acquireWriteLock();
        try {
            if (this.getUnitOfWorkChangeSet() == null) {
                this.setUnitOfWorkChangeSet(new UnitOfWorkChangeSet(this));
            }
            this.unitOfWorkChangeSet = this.calculateChanges(this.collectAndPrepareObjectsForNestedMerge(), (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet(), false, false);
            this.allClones = null;
            this.mergeChangesIntoParent();
            if (this.hasDeletedObjects()) {
                for (Object deletedObject : this.getDeletedObjects().keySet()) {
                    Object originalObject = this.getOriginalVersionOfObject(deletedObject);
                    if (originalObject != null && ((UnitOfWorkImpl)this.parent).getNewObjectsCloneToOriginal().containsKey(originalObject)) {
                        ((UnitOfWorkImpl)this.parent).unregisterObject(originalObject);
                        continue;
                    }
                    ((UnitOfWorkImpl)this.parent).getDeletedObjects().put(originalObject, this.getId(originalObject));
                }
            }
            if (this.hasRemovedObjects()) {
                Iterator removedObjects = this.getRemovedObjects().values().iterator();
                while (removedObjects.hasNext()) {
                    ((UnitOfWorkImpl)this.parent).getCloneMapping().remove(removedObjects.next());
                }
            }
        }
        finally {
            this.parent.getIdentityMapAccessorInstance().releaseWriteLock();
        }
    }

    public void commitRootUnitOfWork() throws DatabaseException, OptimisticLockException {
        this.commitToDatabaseWithChangeSet(true);
        this.mergeChangesIntoParent();
        this.changeTrackedHardList = null;
    }

    public void commitRootUnitOfWorkWithPreBuiltChangeSet(UnitOfWorkChangeSet uowChangeSet) throws DatabaseException, OptimisticLockException {
        this.commitToDatabaseWithPreBuiltChangeSet(uowChangeSet, true, true);
        this.mergeChangesIntoParent();
    }

    protected void commitToDatabase(boolean commitTransaction) {
        block24: {
            try {
                if (this.wasTransactionBegunPrematurely()) {
                    this.setWasTransactionBegunPrematurely(false);
                } else {
                    this.beginTransaction();
                }
                if (commitTransaction) {
                    this.setWasNonObjectLevelModifyQueryExecuted(false);
                }
                this.preDeleteComplete = false;
                ArrayList<Object> deletedObjects = null;
                if (this.hasDeletedObjects()) {
                    deletedObjects = new ArrayList<Object>(this.deletedObjects.size());
                    for (Object objectToDelete : this.deletedObjects.keySet()) {
                        ClassDescriptor descriptor = this.getDescriptor(objectToDelete);
                        if (descriptor.hasPreDeleteMappings()) {
                            for (DatabaseMapping mapping : descriptor.getPreDeleteMappings()) {
                                DeleteObjectQuery deleteQuery = descriptor.getQueryManager().getDeleteQuery();
                                if (deleteQuery == null) {
                                    deleteQuery = new DeleteObjectQuery();
                                    deleteQuery.setDescriptor(descriptor);
                                } else {
                                    deleteQuery.checkPrepare(this, deleteQuery.getTranslationRow());
                                    deleteQuery = (DeleteObjectQuery)deleteQuery.clone();
                                }
                                deleteQuery.setIsExecutionClone(true);
                                deleteQuery.setTranslationRow(new DatabaseRecord());
                                deleteQuery.setObject(objectToDelete);
                                deleteQuery.setSession(this);
                                mapping.earlyPreDelete(deleteQuery, objectToDelete);
                            }
                        }
                        deletedObjects.add(objectToDelete);
                    }
                    this.preDeleteComplete = true;
                }
                if (this.shouldPerformDeletesFirst) {
                    if (deletedObjects != null) {
                        this.getCommitManager().deleteAllObjects(deletedObjects);
                        Iterator objects = this.getObjectsDeletedDuringCommit().keySet().iterator();
                        while (objects.hasNext()) {
                            ObjectChangeSet objectChangeSet = (ObjectChangeSet)this.unitOfWorkChangeSet.getObjectChangeSetForClone(objects.next());
                            if (objectChangeSet == null) continue;
                            objectChangeSet.clear(true);
                        }
                    }
                    super.writeAllObjectsWithChangeSet(this.unitOfWorkChangeSet);
                    this.issueModifyAllQueryList();
                } else {
                    super.writeAllObjectsWithChangeSet(this.unitOfWorkChangeSet);
                    if (deletedObjects != null) {
                        this.getCommitManager().deleteAllObjects(deletedObjects);
                    }
                    this.issueModifyAllQueryList();
                }
                if (this.eventManager != null) {
                    this.eventManager.prepareUnitOfWork();
                }
                if (commitTransaction) {
                    try {
                        this.acquireWriteLocks();
                        this.commitTransaction();
                        break block24;
                    }
                    catch (RuntimeException throwable) {
                        this.releaseWriteLocks();
                        throw throwable;
                    }
                    catch (Error throwable) {
                        this.releaseWriteLocks();
                        throw throwable;
                    }
                }
                this.setWasTransactionBegunPrematurely(true);
            }
            catch (RuntimeException exception) {
                this.copyStatementsCountIntoProperties();
                try {
                    this.rollbackTransaction(commitTransaction);
                }
                catch (RuntimeException runtimeException) {}
                if (this.hasExceptionHandler()) {
                    this.getExceptionHandler().handleException(exception);
                }
                throw exception;
            }
        }
    }

    protected void commitToDatabaseWithChangeSet(boolean commitTransaction) throws DatabaseException, OptimisticLockException {
        block19: {
            try {
                try {
                    boolean hasChanges;
                    this.incrementProfile("Counter:UnitOfWorkCommits");
                    this.startOperationProfile("Timer:UnitOfWorkCommit");
                    boolean bl = hasChanges = this.unitOfWorkChangeSet != null || this.hasCloneMapping() || this.hasDeletedObjects() || this.hasModifyAllQueries() || this.hasDeferredModifyAllQueries();
                    if (hasChanges) {
                        try {
                            if (this.unitOfWorkChangeSet == null) {
                                this.unitOfWorkChangeSet = new UnitOfWorkChangeSet(this);
                            }
                            this.calculateChanges(this.getCloneMapping(), this.unitOfWorkChangeSet, true, true);
                        }
                        catch (RuntimeException exception) {
                            this.copyStatementsCountIntoProperties();
                            throw exception;
                        }
                        hasChanges = this.hasModifications();
                    }
                    if (hasChanges) {
                        this.getCommitManager().setIsActive(true);
                        this.commitToDatabase(commitTransaction);
                        break block19;
                    }
                    try {
                        if (!this.wasTransactionBegunPrematurely() || !commitTransaction) break block19;
                        this.setWasTransactionBegunPrematurely(false);
                        this.setWasNonObjectLevelModifyQueryExecuted(false);
                        try {
                            this.commitTransaction();
                        }
                        catch (RuntimeException commitFailed) {
                            try {
                                this.rollbackTransaction();
                            }
                            catch (RuntimeException runtimeException) {}
                            throw commitFailed;
                        }
                        catch (Error error) {
                            try {
                                this.rollbackTransaction();
                            }
                            catch (RuntimeException runtimeException) {}
                            throw error;
                        }
                    }
                    catch (RuntimeException exception) {
                        this.copyStatementsCountIntoProperties();
                        throw exception;
                    }
                }
                catch (RuntimeException exception) {
                    this.handleException(exception);
                    this.endOperationProfile("Timer:UnitOfWorkCommit");
                }
            }
            finally {
                this.endOperationProfile("Timer:UnitOfWorkCommit");
            }
        }
    }

    protected void commitToDatabaseWithPreBuiltChangeSet(UnitOfWorkChangeSet uowChangeSet, boolean commitTransaction, boolean isChangeSetFromOutsideUOW) throws DatabaseException, OptimisticLockException {
        try {
            uowChangeSet.setIsChangeSetFromOutsideUOW(isChangeSetFromOutsideUOW);
            this.getCommitManager().setIsActive(true);
            this.setUnitOfWorkChangeSet(uowChangeSet);
            this.commitToDatabase(commitTransaction);
            uowChangeSet.setIsChangeSetFromOutsideUOW(false);
        }
        catch (RuntimeException exception) {
            this.handleException(exception);
        }
    }

    @Override
    public void commitTransaction() throws DatabaseException {
        this.parent.commitTransaction();
    }

    public void commitTransactionAfterWriteChanges() {
        this.setWasNonObjectLevelModifyQueryExecuted(false);
        if (this.hasModifications() || this.wasTransactionBegunPrematurely()) {
            try {
                this.setWasTransactionBegunPrematurely(false);
                this.acquireWriteLocks();
                this.commitTransaction();
            }
            catch (RuntimeException exception) {
                this.releaseWriteLocks();
                try {
                    this.rollbackTransaction(false);
                }
                catch (RuntimeException runtimeException) {}
                this.setLifecycle(3);
                this.handleException(exception);
            }
            catch (Error throwable) {
                this.releaseWriteLocks();
                try {
                    this.rollbackTransaction();
                }
                catch (RuntimeException runtimeException) {}
                throw throwable;
            }
        }
    }

    protected void acquireWriteLocks() {
        if ((this.project.hasNonIsolatedUOWClasses() || this.modifyAllQueries != null) && this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWriteDatabase() && this.unitOfWorkChangeSet != null) {
            this.writesCompleted();
            this.lastUsedMergeManager = new MergeManager(this);
            this.parent.getIdentityMapAccessorInstance().getWriteLockManager().acquireRequiredLocks(this.lastUsedMergeManager, this.unitOfWorkChangeSet);
        }
    }

    public void releaseWriteLocks() {
        if (this.lastUsedMergeManager != null) {
            this.verifyMutexThreadIntegrityBeforeRelease();
            this.parent.getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this.lastUsedMergeManager);
            this.lastUsedMergeManager = null;
        }
    }

    @Override
    public Vector copyReadOnlyClasses() {
        return new Vector(this.getReadOnlyClasses());
    }

    @Override
    public Object deepMergeClone(Object rmiClone) {
        return this.mergeClone(rmiClone, 3, false);
    }

    @Override
    public Object deepRevertObject(Object clone) {
        return this.revertObject(clone, 3);
    }

    @Override
    public void deepUnregisterObject(Object clone) {
        this.unregisterObject(clone, 3);
    }

    @Override
    public void deleteAllObjects(Vector domainObjects) {
        Enumeration objectsEnum = domainObjects.elements();
        while (objectsEnum.hasMoreElements()) {
            this.deleteObject(objectsEnum.nextElement());
        }
    }

    protected void discoverAllUnregisteredNewObjects() {
        IdentityHashMap visitedNodes = new IdentityHashMap();
        IdentityHashMap newObjects = new IdentityHashMap();
        this.discoverUnregisteredNewObjects(new IdentityHashMap(this.getCloneMapping()), newObjects, this.getUnregisteredExistingObjects(), visitedNodes);
        this.setUnregisteredNewObjects(newObjects);
    }

    protected void discoverAllUnregisteredNewObjectsInParent() {
        if (this.isNestedUnitOfWork) {
            IdentityHashMap visitedNodes = new IdentityHashMap();
            IdentityHashMap newObjects = new IdentityHashMap();
            UnitOfWorkImpl parent = (UnitOfWorkImpl)this.parent;
            parent.discoverUnregisteredNewObjects(((UnitOfWorkImpl)this.parent).getCloneMapping(), newObjects, new IdentityHashMap(), visitedNodes);
            this.setUnregisteredNewObjectsInParent(newObjects);
        }
    }

    public void discoverUnregisteredNewObjects(Map clones, final Map knownNewObjects, final Map unregisteredExistingObjects, Map visitedObjects) {
        DescriptorIterator iterator = new DescriptorIterator(){

            public void iterate(Object object) {
                if (UnitOfWorkImpl.this.isClassReadOnly(object.getClass(), this.getCurrentDescriptor())) {
                    this.setShouldBreak(true);
                    return;
                }
                if (UnitOfWorkImpl.isSmartMerge() && UnitOfWorkImpl.this.isOriginalNewObject(object)) {
                    return;
                }
                if (!UnitOfWorkImpl.this.isObjectRegistered(object)) {
                    if (UnitOfWorkImpl.this.shouldPerformNoValidation()) {
                        if (UnitOfWorkImpl.this.checkForUnregisteredExistingObject(object)) {
                            unregisteredExistingObjects.put(object, object);
                            this.setShouldBreak(true);
                            return;
                        }
                    } else {
                        UnitOfWorkImpl.this.getBackupClone(object, this.getCurrentDescriptor());
                    }
                    knownNewObjects.put(object, object);
                }
            }

            public void iterateReferenceObjectForMapping(Object referenceObject, DatabaseMapping mapping) {
                super.iterateReferenceObjectForMapping(referenceObject, mapping);
                if (mapping.isCandidateForPrivateOwnedRemoval()) {
                    UnitOfWorkImpl.this.removePrivateOwnedObject(mapping, referenceObject);
                }
            }
        };
        iterator.setVisitedObjects(visitedObjects);
        iterator.setResult(knownNewObjects);
        iterator.setSession(this);
        iterator.setShouldIterateOverWrappedObjects(false);
        Iterator clonesEnum = clones.keySet().iterator();
        while (clonesEnum.hasNext()) {
            iterator.startIterationOn(clonesEnum.next());
        }
    }

    @Override
    public void dontPerformValidation() {
        this.setValidationLevel(0);
    }

    @Override
    public Object executeCall(Call call, AbstractRecord translationRow, DatabaseQuery query) throws DatabaseException {
        Collection<Accessor> accessors = query.getSession().getAccessors(call, translationRow, query);
        query.setAccessors(accessors);
        try {
            Object object = this.basicExecuteCall(call, translationRow, query);
            return object;
        }
        finally {
            if (call.isFinished()) {
                query.setAccessor(null);
            }
        }
    }

    @Override
    public void forceUpdateToVersionField(Object lockObject, boolean shouldModifyVersionField) {
        ClassDescriptor descriptor = this.getDescriptor(lockObject);
        if (descriptor == null) {
            throw DescriptorException.missingDescriptor(lockObject.getClass().toString());
        }
        this.getOptimisticReadLockObjects().put(descriptor.getObjectBuilder().unwrapObject(lockObject, this), shouldModifyVersionField);
    }

    @Override
    public Accessor getAccessor() {
        return this.parent.getAccessor();
    }

    @Override
    public Collection<Accessor> getAccessors() {
        return this.parent.getAccessors();
    }

    @Override
    public CommitManager getCommitManager() {
        if (this.commitManager == null) {
            this.commitManager = new CommitManager(this);
            this.commitManager.setCommitOrder(this.parent.getCommitManager().getCommitOrder());
        }
        return this.commitManager;
    }

    @Override
    public Collection<Accessor> getAccessors(Call call, AbstractRecord translationRow, DatabaseQuery query) {
        return this.parent.getAccessors(call, translationRow, query);
    }

    @Override
    public UnitOfWork getActiveUnitOfWork() {
        return this.parent.getActiveUnitOfWork();
    }

    public Vector getAllFromNewObjects(Expression selectionCriteria, Class theClass, AbstractRecord translationRow, int valueHolderPolicy) {
        if (!this.hasNewObjects()) {
            return new Vector(1);
        }
        ClassDescriptor descriptor = this.getDescriptor(theClass);
        boolean readSubclassesOrNoInheritance = !descriptor.hasInheritance() || descriptor.getInheritancePolicy().shouldReadSubclasses();
        Vector objects = new Vector();
        for (Object object : this.getNewObjectsCloneToOriginal().keySet()) {
            if (object.getClass() != theClass && (!readSubclassesOrNoInheritance || !theClass.isInstance(object))) continue;
            if (selectionCriteria == null) {
                objects.addElement(object);
                continue;
            }
            if (!selectionCriteria.doesConform(object, this, translationRow, valueHolderPolicy)) continue;
            objects.addElement(object);
        }
        return objects;
    }

    public Object getBackupClone(Object clone) throws QueryException {
        return this.getBackupClone(clone, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getBackupClone(Object clone, ClassDescriptor descriptor) throws QueryException {
        void var3_6;
        Object v = this.getCloneMapping().get(clone);
        if (v != null) {
            return v;
        }
        if (this.isObjectRegistered(clone)) {
            return this.getCloneMapping().get(clone);
        }
        if (descriptor == null) {
            descriptor = this.getDescriptor(clone);
        }
        Object primaryKey = this.keyFromObject(clone, descriptor);
        if (this.getParentIdentityMapSession(descriptor, false, true).getIdentityMapAccessorInstance().containsObjectInIdentityMap(primaryKey, clone.getClass(), descriptor)) {
            if (this.getUnregisteredNewObjects().get(clone) != null && this.isMergePending()) {
                return descriptor.getObjectBuilder().buildNewInstance();
            }
            if (!this.hasObjectsDeletedDuringCommit() || !this.getObjectsDeletedDuringCommit().containsKey(clone)) throw QueryException.backupCloneIsOriginalFromParent(clone);
            throw QueryException.backupCloneIsDeleted(clone);
        }
        if (this.hasNewObjects() && this.getNewObjectsOriginalToClone().containsKey(clone)) {
            if (!UnitOfWorkImpl.isSmartMerge()) throw QueryException.backupCloneIsOriginalFromSelf(clone);
            Object v2 = this.getCloneMapping().get(this.getNewObjectsOriginalToClone().get(clone));
            return var3_6;
        } else {
            Object object = descriptor.getObjectBuilder().buildNewInstance();
        }
        return var3_6;
    }

    public Object getBackupCloneForCommit(Object clone, ClassDescriptor descriptor) {
        Object backupClone = this.getBackupClone(clone, descriptor);
        if (this.isCloneNewObject(clone)) {
            if (descriptor != null) {
                return descriptor.getObjectBuilder().buildNewInstance();
            }
            return this.getDescriptor(clone).getObjectBuilder().buildNewInstance();
        }
        return backupClone;
    }

    public Object getBackupCloneForCommit(Object clone) {
        Object backupClone = this.getBackupClone(clone);
        if (this.isCloneNewObject(clone)) {
            return this.getDescriptor(clone).getObjectBuilder().buildNewInstance();
        }
        return backupClone;
    }

    @Override
    public org.eclipse.persistence.sessions.changesets.UnitOfWorkChangeSet getCurrentChanges() {
        Map allObjects = this.collectAndPrepareObjectsForNestedMerge();
        return this.calculateChanges(allObjects, new UnitOfWorkChangeSet(this), false, false);
    }

    @Override
    public AbstractSession getParentIdentityMapSession(ClassDescriptor descriptor, boolean canReturnSelf, boolean terminalOnly) {
        if (canReturnSelf && !terminalOnly) {
            return this;
        }
        return this.parent.getParentIdentityMapSession(descriptor, true, terminalOnly);
    }

    @Override
    public AbstractSession getExecutionSession(DatabaseQuery query) {
        return this.parent.getExecutionSession(query);
    }

    public Map getCloneMapping() {
        if (this.cloneMapping == null) {
            this.cloneMapping = this.createMap();
        }
        return this.cloneMapping;
    }

    public boolean hasCloneMapping() {
        return this.cloneMapping != null && !this.cloneMapping.isEmpty();
    }

    public Map getCloneToOriginals() {
        if (this.cloneToOriginals == null) {
            this.cloneToOriginals = this.createMap();
        }
        return this.cloneToOriginals;
    }

    protected boolean hasCloneToOriginals() {
        return this.cloneToOriginals != null && !this.cloneToOriginals.isEmpty();
    }

    public Map getContainerBeans() {
        if (this.containerBeans == null) {
            this.containerBeans = new IdentityHashMap<Object, Object>();
        }
        return this.containerBeans;
    }

    public boolean hasContainerBeans() {
        return this.containerBeans != null && !this.containerBeans.isEmpty();
    }

    public Set<Object> getCascadeDeleteObjects() {
        if (this.cascadeDeleteObjects == null) {
            this.cascadeDeleteObjects = new IdentityHashSet();
        }
        return this.cascadeDeleteObjects;
    }

    protected void setCascadeDeleteObjects(Set<Object> cascadeDeleteObjects) {
        this.cascadeDeleteObjects = cascadeDeleteObjects;
    }

    public boolean hasCascadeDeleteObjects() {
        return this.cascadeDeleteObjects != null && !this.cascadeDeleteObjects.isEmpty();
    }

    public boolean hasUnregisteredNewObjects() {
        return this.unregisteredNewObjects != null && !this.unregisteredNewObjects.isEmpty();
    }

    public boolean hasNewObjects() {
        return this.newObjectsCloneToOriginal != null && !this.newObjectsCloneToOriginal.isEmpty();
    }

    public UnitOfWorkImpl getContainerUnitOfWork() {
        if (this.containerUnitOfWork == null) {
            this.containerUnitOfWork = this.parent.acquireNonSynchronizedUnitOfWork(ReferenceMode.WEAK);
        }
        return this.containerUnitOfWork;
    }

    @Override
    public Vector getDefaultReadOnlyClasses() {
        return this.parent.getDefaultReadOnlyClasses();
    }

    public Map getDeletedObjects() {
        if (this.deletedObjects == null) {
            this.deletedObjects = new IdentityHashMap<Object, Object>();
        }
        return this.deletedObjects;
    }

    public boolean hasDeletedObjects() {
        return this.deletedObjects != null && !this.deletedObjects.isEmpty();
    }

    public int getLifecycle() {
        return this.lifecycle;
    }

    public MergeManager getMergeManager() {
        return this.lastUsedMergeManager;
    }

    public Map getNewAggregates() {
        if (this.newAggregates == null) {
            this.newAggregates = new IdentityHashMap<Object, Object>();
        }
        return this.newAggregates;
    }

    public synchronized Map getNewObjectsCloneToOriginal() {
        if (this.newObjectsCloneToOriginal == null) {
            this.newObjectsCloneToOriginal = new IdentityHashMap<Object, Object>();
        }
        return this.newObjectsCloneToOriginal;
    }

    public Map getNewObjectsInParentOriginalToClone() {
        if (this.newObjectsInParentOriginalToClone == null) {
            this.newObjectsInParentOriginalToClone = new IdentityHashMap<Object, Object>();
        }
        return this.newObjectsInParentOriginalToClone;
    }

    protected boolean hasNewObjectsInParentOriginalToClone() {
        return this.newObjectsInParentOriginalToClone != null && !this.newObjectsInParentOriginalToClone.isEmpty();
    }

    private Map<DatabaseMapping, Set> getPrivateOwnedObjects() {
        if (this.privateOwnedObjects == null) {
            this.privateOwnedObjects = new IdentityHashMap<DatabaseMapping, Set>();
        }
        return this.privateOwnedObjects;
    }

    public boolean hasPrivateOwnedObjects() {
        return this.privateOwnedObjects != null && !this.privateOwnedObjects.isEmpty();
    }

    public boolean hasOptimisticReadLockObjects() {
        return this.optimisticReadLockObjects != null && !this.optimisticReadLockObjects.isEmpty();
    }

    public synchronized Map getNewObjectsOriginalToClone() {
        if (this.newObjectsOriginalToClone == null) {
            this.newObjectsOriginalToClone = new IdentityHashMap<Object, Object>();
        }
        return this.newObjectsOriginalToClone;
    }

    @Override
    public Sequencing getSequencing() {
        return this.parent.getSequencing();
    }

    @Override
    public ServerPlatform getServerPlatform() {
        return this.parent.getServerPlatform();
    }

    @Override
    public String getSessionTypeString() {
        return "UnitOfWork";
    }

    public void afterExternalTransactionRollback() {
        this.parent.setWasJTSTransactionInternallyStarted(false);
        this.setLifecycle(6);
        if (this.getMergeManager() != null && this.getMergeManager().getAcquiredLocks() != null && !this.getMergeManager().getAcquiredLocks().isEmpty()) {
            this.verifyMutexThreadIntegrityBeforeRelease();
            this.parent.getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this.getMergeManager());
            this.setMergeManager(null);
        }
    }

    @Override
    public void releaseJTSConnection() {
        this.parent.releaseJTSConnection();
    }

    public Object getObjectFromNewObjects(Class theClass, Object selectionKey) {
        if (!this.hasNewObjects()) {
            return null;
        }
        ClassDescriptor descriptor = this.getDescriptor(theClass);
        boolean readSubclassesOrNoInheritance = !descriptor.hasInheritance() || descriptor.getInheritancePolicy().shouldReadSubclasses();
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        for (Object object : this.getNewObjectsCloneToOriginal().keySet()) {
            Object primaryKey;
            if (object.getClass() != theClass && (!readSubclassesOrNoInheritance || !theClass.isInstance(object)) || (primaryKey = objectBuilder.extractPrimaryKeyFromObject(object, this, true)) == null || !primaryKey.equals(selectionKey)) continue;
            return object;
        }
        return null;
    }

    public Object getObjectFromNewObjects(Expression selectionCriteria, Class theClass, AbstractRecord translationRow, int valueHolderPolicy) {
        if (!this.hasNewObjects()) {
            return null;
        }
        ClassDescriptor descriptor = this.getDescriptor(theClass);
        boolean readSubclassesOrNoInheritance = !descriptor.hasInheritance() || descriptor.getInheritancePolicy().shouldReadSubclasses();
        for (Object object : this.getNewObjectsCloneToOriginal().keySet()) {
            if (object.getClass() != theClass && (!readSubclassesOrNoInheritance || !theClass.isInstance(object))) continue;
            if (selectionCriteria == null) {
                return object;
            }
            if (!selectionCriteria.doesConform(object, this, translationRow, valueHolderPolicy)) continue;
            return object;
        }
        return null;
    }

    public Map getObjectsDeletedDuringCommit() {
        if (this.objectsDeletedDuringCommit == null) {
            this.objectsDeletedDuringCommit = new IdentityHashMap<Object, Object>();
        }
        return this.objectsDeletedDuringCommit;
    }

    protected boolean hasObjectsDeletedDuringCommit() {
        return this.objectsDeletedDuringCommit != null && !this.objectsDeletedDuringCommit.isEmpty();
    }

    public Map getOptimisticReadLockObjects() {
        if (this.optimisticReadLockObjects == null) {
            this.optimisticReadLockObjects = new HashMap<Object, Object>(2);
        }
        return this.optimisticReadLockObjects;
    }

    public Object getOriginalVersionOfNewObject(Object workingClone) {
        if (!this.hasNewObjects()) {
            return null;
        }
        return this.getNewObjectsCloneToOriginal().get(workingClone);
    }

    @Override
    public Object getOriginalVersionOfObject(Object workingClone) {
        if (workingClone == null) {
            return null;
        }
        Object original = null;
        ClassDescriptor descriptor = this.getDescriptor(workingClone);
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(workingClone, this);
        CacheKey cacheKey = this.getParentIdentityMapSession(descriptor, false, false).getCacheKeyFromTargetSessionForMerge(implementation, builder, descriptor, this.lastUsedMergeManager);
        if (cacheKey != null) {
            original = cacheKey.getObject();
        }
        if (original == null) {
            original = this.getOriginalVersionOfNewObject(implementation);
        }
        if (original == null) {
            if (this.isClassReadOnly(implementation.getClass(), descriptor)) {
                return implementation;
            }
            if (this.hasCloneToOriginals()) {
                original = this.getCloneToOriginals().get(workingClone);
            }
        }
        if (original == null) {
            original = this.buildOriginal(implementation);
        }
        return original;
    }

    public Object getOriginalVersionOfObjectOrNull(Object workingClone, ObjectChangeSet changeSet, ClassDescriptor descriptor, AbstractSession targetSession) {
        if (workingClone == null) {
            return null;
        }
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(workingClone, this);
        Object original = this.getOriginalVersionOfNewObject(implementation);
        if (original == null) {
            if (this.isClassReadOnly(implementation.getClass(), descriptor)) {
                return implementation;
            }
            if (this.hasCloneToOriginals()) {
                original = this.getCloneToOriginals().get(workingClone);
            }
        }
        return original;
    }

    public Object getOriginalVersionOfObjectOrNull(Object workingClone, ClassDescriptor descriptor) {
        if (workingClone == null) {
            return null;
        }
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(workingClone, this);
        Object primaryKey = builder.extractPrimaryKeyFromObject(implementation, this);
        Object original = this.parent.getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, implementation.getClass(), descriptor);
        if (original == null) {
            original = this.getOriginalVersionOfNewObject(implementation);
        }
        if (original == null) {
            if (this.isClassReadOnly(implementation.getClass(), descriptor)) {
                return implementation;
            }
            if (this.hasCloneToOriginals()) {
                original = this.getCloneToOriginals().get(workingClone);
            }
        }
        return original;
    }

    @Override
    public AbstractSession getParent() {
        return this.parent;
    }

    @Override
    public Object getProperty(String name) {
        Object propertyValue = super.getProperties().get(name);
        if (propertyValue == null) {
            propertyValue = this.parent.getProperty(name);
        }
        return propertyValue;
    }

    @Override
    public Platform getPlatform(Class domainClass) {
        return this.parent.getPlatform(domainClass);
    }

    public int getShouldThrowConformExceptions() {
        return this.shouldThrowConformExceptions;
    }

    @Override
    public DatabaseQuery getQuery(String name, Vector arguments) {
        DatabaseQuery query = super.getQuery(name, arguments);
        if (query == null) {
            query = this.parent.getQuery(name, arguments);
        }
        return query;
    }

    @Override
    public DatabaseQuery getQuery(String name) {
        DatabaseQuery query = super.getQuery(name);
        if (query == null) {
            query = this.parent.getQuery(name);
        }
        return query;
    }

    @Override
    public Set getReadOnlyClasses() {
        if (this.readOnlyClasses == null) {
            this.readOnlyClasses = new HashSet<Class>();
        }
        return this.readOnlyClasses;
    }

    protected Map getRemovedObjects() {
        if (this.removedObjects == null) {
            this.removedObjects = new IdentityHashMap<Object, Object>();
        }
        return this.removedObjects;
    }

    protected boolean hasRemovedObjects() {
        return this.removedObjects != null && !this.removedObjects.isEmpty();
    }

    protected boolean hasModifyAllQueries() {
        return this.modifyAllQueries != null && !this.modifyAllQueries.isEmpty();
    }

    protected boolean hasDeferredModifyAllQueries() {
        return this.deferredModifyAllQueries != null && !this.deferredModifyAllQueries.isEmpty();
    }

    public int getState() {
        return this.lifecycle;
    }

    public Object getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Object transaction) {
        this.transaction = transaction;
    }

    @Override
    public org.eclipse.persistence.sessions.changesets.UnitOfWorkChangeSet getUnitOfWorkChangeSet() {
        return this.unitOfWorkChangeSet;
    }

    public Map getUnregisteredExistingObjects() {
        if (this.unregisteredExistingObjects == null) {
            this.unregisteredExistingObjects = new IdentityHashMap<Object, Object>();
        }
        return this.unregisteredExistingObjects;
    }

    protected Map getUnregisteredNewObjects() {
        if (this.unregisteredNewObjects == null) {
            this.unregisteredNewObjects = new IdentityHashMap<Object, Object>();
        }
        return this.unregisteredNewObjects;
    }

    protected Map getUnregisteredNewObjectsInParent() {
        if (this.unregisteredNewObjectsInParent == null) {
            this.unregisteredNewObjectsInParent = new IdentityHashMap<Object, Object>();
        }
        return this.unregisteredNewObjectsInParent;
    }

    @Override
    public int getValidationLevel() {
        return this.validationLevel;
    }

    @Override
    public boolean hasChanges() {
        if (this.hasNewObjects()) {
            return true;
        }
        if (this.hasDeletedObjects()) {
            return true;
        }
        IdentityHashMap allObjects = new IdentityHashMap(this.getCloneMapping());
        UnitOfWorkChangeSet changeSet = this.calculateChanges(allObjects, new UnitOfWorkChangeSet(this), false, false);
        return changeSet.hasChanges();
    }

    protected boolean hasModifications() {
        return this.unitOfWorkChangeSet != null && (this.unitOfWorkChangeSet.hasChanges() || ((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).hasForcedChanges()) || this.hasDeletedObjects() || this.hasModifyAllQueries() || this.hasDeferredModifyAllQueries();
    }

    @Override
    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new UnitOfWorkIdentityMapAccessor(this, new IdentityMapManager(this));
    }

    @Override
    public Object internalExecuteQuery(DatabaseQuery query, AbstractRecord databaseRow) throws DatabaseException, QueryException {
        Object result = query.executeInUnitOfWork(this, databaseRow);
        this.executeDeferredEvents();
        return result;
    }

    public Object internalRegisterObject(Object object, ClassDescriptor descriptor) {
        if (object == null) {
            return null;
        }
        if (descriptor.isDescriptorTypeAggregate()) {
            throw ValidationException.cannotRegisterAggregateObjectInUnitOfWork(object.getClass());
        }
        Object registeredObject = this.checkIfAlreadyRegistered(object, descriptor);
        if (registeredObject == null) {
            UnitOfWorkImpl parentUnitOfWork;
            if (this.isNestedUnitOfWork && ((parentUnitOfWork = (UnitOfWorkImpl)this.parent).isObjectRegistered(object) || this.isUnregisteredNewObjectInParent(object))) {
                Object primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this);
                registeredObject = this.isCloneNewObjectFromParent(object) || this.isUnregisteredNewObjectInParent(object) ? this.cloneAndRegisterObject(object, new CacheKey(primaryKey), new CacheKey(primaryKey), descriptor) : this.getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, descriptor.getJavaClass(), descriptor);
                return registeredObject;
            }
            registeredObject = this.checkExistence(object);
            if (registeredObject == null) {
                registeredObject = this.cloneAndRegisterNewObject(object);
                if (this.mergeManagerForActiveMerge != null) {
                    this.mergeManagerForActiveMerge.getMergedNewObjects().put(registeredObject, registeredObject);
                }
            }
        }
        return registeredObject;
    }

    @Override
    public boolean isActive() {
        return this.lifecycle != 5;
    }

    @Override
    public boolean isClassReadOnly(Class theClass, ClassDescriptor descriptor) {
        if (descriptor != null && descriptor.shouldBeReadOnly()) {
            return true;
        }
        return theClass != null && this.readOnlyClasses != null && this.readOnlyClasses.contains(theClass);
    }

    public boolean isCloneNewObjectFromParent(Object clone) {
        if (this.parent.isUnitOfWork()) {
            if (((UnitOfWorkImpl)this.parent).isCloneNewObject(clone)) {
                return true;
            }
            if (((UnitOfWorkImpl)this.parent).isObjectRegistered(clone)) {
                clone = ((UnitOfWorkImpl)this.parent).getCloneToOriginals().get(clone);
            }
            return ((UnitOfWorkImpl)this.parent).isCloneNewObjectFromParent(clone);
        }
        return false;
    }

    public boolean isCloneNewObject(Object clone) {
        return this.newObjectsCloneToOriginal != null && this.newObjectsCloneToOriginal.containsKey(clone);
    }

    public boolean isCommitPending() {
        return this.lifecycle == 1;
    }

    public boolean isDead() {
        return this.lifecycle == 5;
    }

    @Override
    public boolean isInTransaction() {
        return this.parent.isInTransaction();
    }

    public boolean isMergePending() {
        return this.lifecycle == 4;
    }

    public boolean isAfterWriteChangesButBeforeCommit() {
        return this.lifecycle == 2 || this.lifecycle == 3;
    }

    protected boolean isAfterWriteChangesFailed() {
        return this.lifecycle == 3;
    }

    @Override
    public boolean isNestedUnitOfWork() {
        return this.isNestedUnitOfWork;
    }

    public boolean isNewObjectInParent(Object clone) {
        Object original = null;
        if (this.hasCloneToOriginals()) {
            original = this.getCloneToOriginals().get(clone);
        }
        if (original != null) {
            return ((UnitOfWorkImpl)this.parent).getNewObjectsCloneToOriginal().containsKey(original);
        }
        return false;
    }

    public boolean isObjectDeleted(Object object) {
        boolean isDeleted;
        boolean bl = isDeleted = this.deletedObjects != null && this.deletedObjects.containsKey(object);
        if (this.parent.isUnitOfWork()) {
            return isDeleted || ((UnitOfWorkImpl)this.parent).isObjectDeleted(object);
        }
        return isDeleted;
    }

    public boolean isObjectNew(Object clone) {
        return this.isCloneNewObject(clone) || !this.isObjectRegistered(clone) && !this.isClassReadOnly(clone.getClass()) && !this.isUnregisteredExistingObject(clone);
    }

    public boolean isUnregisteredExistingObject(Object object) {
        return this.unregisteredExistingObjects != null && this.unregisteredExistingObjects.containsKey(object);
    }

    @Override
    public boolean isObjectRegistered(Object clone) {
        if (this.getCloneMapping().containsKey(clone)) {
            return true;
        }
        if (UnitOfWorkImpl.isSmartMerge()) {
            ClassDescriptor descriptor = this.getDescriptor(clone);
            if (this.parent.getIdentityMapAccessorInstance().containsObjectInIdentityMap(this.keyFromObject(clone, descriptor), clone.getClass(), descriptor)) {
                this.mergeCloneWithReferences(clone);
                return true;
            }
        }
        return false;
    }

    public boolean isOriginalNewObject(Object original) {
        return this.newObjectsOriginalToClone != null && this.newObjectsOriginalToClone.containsKey(original) || this.newAggregates != null && this.newAggregates.containsKey(original);
    }

    public static boolean isSmartMerge() {
        return SmartMerge;
    }

    public void issueSQLbeforeCompletion() {
        this.issueSQLbeforeCompletion(true);
    }

    public void issueSQLbeforeCompletion(boolean commitTransaction) {
        if (this.lifecycle == 2) {
            this.commitTransactionAfterWriteChanges();
            return;
        }
        this.log(2, "transaction", "begin_unit_of_work_commit");
        this.mergeBmpAndWsEntities();
        if (this.eventManager != null) {
            this.eventManager.preCommitUnitOfWork();
        }
        this.lifecycle = 1;
        this.commitToDatabaseWithChangeSet(commitTransaction);
    }

    protected void issueModifyAllQueryList() {
        if (this.deferredModifyAllQueries != null) {
            int size = this.deferredModifyAllQueries.size();
            int index = 0;
            while (index < size) {
                Object[] queries = this.deferredModifyAllQueries.get(index);
                ModifyAllQuery query = (ModifyAllQuery)queries[0];
                AbstractRecord translationRow = (AbstractRecord)queries[1];
                this.parent.executeQuery((DatabaseQuery)query, translationRow);
                ++index;
            }
        }
    }

    @Override
    public boolean isUnitOfWork() {
        return true;
    }

    public boolean isUnregisteredNewObjectInParent(Object originalObject) {
        return this.getUnregisteredNewObjectsInParent().containsKey(originalObject);
    }

    protected void mergeBmpAndWsEntities() {
        if (this.hasContainerBeans()) {
            Iterator containerBeansEnum = this.getContainerBeans().keySet().iterator();
            while (containerBeansEnum.hasNext()) {
                this.mergeCloneWithReferences(containerBeansEnum.next());
            }
        }
    }

    protected void mergeChangesIntoParent() {
        MergeManager manager;
        UnitOfWorkChangeSet uowChangeSet;
        block28: {
            uowChangeSet = (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet();
            if (uowChangeSet == null) {
                return;
            }
            if (!this.hasModifications()) {
                return;
            }
            boolean isNestedUnitOfWork = this.isNestedUnitOfWork;
            if (!isNestedUnitOfWork && !this.project.hasNonIsolatedUOWClasses() && this.modifyAllQueries == null) {
                return;
            }
            this.setPendingMerge();
            this.startOperationProfile("Timer:Merge");
            this.parent.getIdentityMapAccessorInstance().acquireWriteLock();
            manager = this.getMergeManager();
            if (manager == null) {
                manager = new MergeManager(this);
            }
            try {
                Object objectToWrite;
                if (!isNestedUnitOfWork) {
                    this.preMergeChanges();
                }
                if (this.parent.hasEventManager()) {
                    this.parent.getEventManager().preMergeUnitOfWorkChangeSet(uowChangeSet);
                }
                if (!isNestedUnitOfWork && this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWrite()) {
                    this.setMergeManager(manager);
                    this.parent.getIdentityMapAccessorInstance().getWriteLockManager().acquireRequiredLocks(this.getMergeManager(), (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet());
                }
                if (!this.shouldStoreBypassCache()) {
                    block8: for (Map<ObjectChangeSet, ObjectChangeSet> objectChangesList : ((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).getObjectChanges().values()) {
                        for (ObjectChangeSet changeSetToWrite : objectChangesList.values()) {
                            if (!changeSetToWrite.hasChanges()) continue;
                            objectToWrite = changeSetToWrite.getUnitOfWorkClone();
                            ClassDescriptor descriptor = this.getDescriptor(objectToWrite);
                            if (!isNestedUnitOfWork && descriptor.getCachePolicy().shouldIsolateObjectsInUnitOfWork()) continue block8;
                            manager.mergeChanges(objectToWrite, changeSetToWrite, this.getParentIdentityMapSession(descriptor, false, false));
                        }
                    }
                }
                if (this.modifyAllQueries != null) {
                    int size = this.modifyAllQueries.size();
                    int index = 0;
                    while (index < size) {
                        ModifyAllQuery query = this.modifyAllQueries.get(index);
                        query.setSession(this.parent);
                        query.mergeChangesIntoSharedCache();
                        ++index;
                    }
                }
                if (isNestedUnitOfWork) {
                    for (Map<ObjectChangeSet, ObjectChangeSet> objectChangesList : ((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).getNewObjectChangeSets().values()) {
                        for (ObjectChangeSet changeSetToWrite : objectChangesList.values()) {
                            if (!changeSetToWrite.hasChanges()) continue;
                            objectToWrite = changeSetToWrite.getUnitOfWorkClone();
                            manager.mergeChanges(objectToWrite, changeSetToWrite, this.parent);
                        }
                    }
                }
                if (isNestedUnitOfWork) break block28;
                this.parent.getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(manager);
                this.setMergeManager(null);
                this.postMergeChanges();
                if (!this.parent.shouldPropagateChanges() || this.parent.getCommandManager() == null) break block28;
                if (this.hasDeletedObjects()) {
                    uowChangeSet.addDeletedObjects(this.getDeletedObjects(), this);
                }
                if (this.hasObjectsDeletedDuringCommit()) {
                    uowChangeSet.addDeletedObjects(this.getObjectsDeletedDuringCommit(), this);
                }
                boolean hasData = false;
                if (!uowChangeSet.hasChanges()) break block28;
                MergeChangeSetCommand command = new MergeChangeSetCommand();
                command.setChangeSet(uowChangeSet);
                try {
                    hasData = command.convertChangeSetToByteArray(this);
                }
                catch (IOException exception) {
                    throw CommunicationException.unableToPropagateChanges("", exception);
                }
                if (hasData) {
                    this.parent.getCommandManager().propagateCommand(command);
                }
            }
            catch (Throwable throwable) {
                if (!this.isNestedUnitOfWork && !manager.getAcquiredLocks().isEmpty()) {
                    try {
                        this.verifyMutexThreadIntegrityBeforeRelease();
                        this.parent.getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(manager);
                    }
                    catch (Exception exception) {}
                    this.setMergeManager(null);
                }
                this.parent.getIdentityMapAccessorInstance().releaseWriteLock();
                this.parent.getEventManager().postMergeUnitOfWorkChangeSet(uowChangeSet);
                this.endOperationProfile("Timer:Merge");
                throw throwable;
            }
        }
        if (!this.isNestedUnitOfWork && !manager.getAcquiredLocks().isEmpty()) {
            try {
                this.verifyMutexThreadIntegrityBeforeRelease();
                this.parent.getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(manager);
            }
            catch (Exception exception) {}
            this.setMergeManager(null);
        }
        this.parent.getIdentityMapAccessorInstance().releaseWriteLock();
        this.parent.getEventManager().postMergeUnitOfWorkChangeSet(uowChangeSet);
        this.endOperationProfile("Timer:Merge");
    }

    @Override
    public Object mergeClone(Object rmiClone) {
        return this.mergeClone(rmiClone, 2, false);
    }

    public Object mergeClone(Object rmiClone, int cascadeDepth, boolean forRefresh) {
        if (rmiClone == null) {
            return null;
        }
        this.logDebugMessage(rmiClone, "merge_clone");
        this.startOperationProfile("Timer:Merge");
        ObjectBuilder builder = this.getDescriptor(rmiClone).getObjectBuilder();
        Object implementation = builder.unwrapObject(rmiClone, this);
        MergeManager manager = new MergeManager(this);
        manager.mergeCloneIntoWorkingCopy();
        manager.setCascadePolicy(cascadeDepth);
        manager.setForRefresh(forRefresh);
        Object merged = null;
        try {
            merged = manager.mergeChanges(implementation, null, this);
        }
        catch (RuntimeException exception) {
            merged = this.handleException(exception);
        }
        this.endOperationProfile("Timer:Merge");
        return merged;
    }

    public void mergeClonesAfterCompletion() {
        this.verifyMutexThreadIntegrityBeforeRelease();
        this.mergeChangesIntoParent();
        if (this.eventManager != null) {
            this.eventManager.postCommitUnitOfWork();
        }
        this.log(2, "transaction", "end_unit_of_work_commit");
    }

    @Override
    public Object mergeCloneWithReferences(Object rmiClone) {
        return this.mergeCloneWithReferences(rmiClone, 2);
    }

    public Object mergeCloneWithReferences(Object rmiClone, int cascadePolicy) {
        return this.mergeCloneWithReferences(rmiClone, cascadePolicy, false);
    }

    public Object mergeCloneWithReferences(Object rmiClone, int cascadePolicy, boolean forceCascade) {
        Object returnValue = null;
        try {
            MergeManager manager = new MergeManager(this);
            manager.mergeCloneWithReferencesIntoWorkingCopy();
            manager.setCascadePolicy(cascadePolicy);
            manager.setForceCascade(forceCascade);
            this.mergeManagerForActiveMerge = manager;
            returnValue = this.mergeCloneWithReferences(rmiClone, manager);
        }
        finally {
            this.mergeManagerForActiveMerge = null;
        }
        return returnValue;
    }

    public Object mergeCloneWithReferences(Object rmiClone, MergeManager manager) {
        if (rmiClone == null) {
            return null;
        }
        ClassDescriptor descriptor = this.getDescriptor(rmiClone);
        if (descriptor == null || descriptor.isDescriptorTypeAggregate()) {
            if (manager.getCascadePolicy() == 4) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{rmiClone}));
            }
            return rmiClone;
        }
        this.logDebugMessage(rmiClone, "merge_clone_with_references");
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(rmiClone, this);
        Object mergedObject = manager.mergeChanges(implementation, null, this);
        if (UnitOfWorkImpl.isSmartMerge()) {
            return builder.wrapObject(mergedObject, this);
        }
        return mergedObject;
    }

    @Override
    public Object newInstance(Class theClass) {
        this.logDebugMessage(theClass, "new_instance");
        ClassDescriptor descriptor = this.getDescriptor(theClass);
        Object newObject = descriptor.getObjectBuilder().buildNewInstance();
        return this.registerObject(newObject);
    }

    public void performRemove(Object toBeDeleted, Map visitedObjects) {
        if (toBeDeleted == null) {
            return;
        }
        ClassDescriptor descriptor = this.getDescriptor(toBeDeleted);
        if (descriptor == null || descriptor.isDescriptorTypeAggregate()) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{toBeDeleted}));
        }
        this.logDebugMessage(toBeDeleted, "deleting_object");
        if (this.getDeletedObjects().containsKey(toBeDeleted)) {
            return;
        }
        visitedObjects.put(toBeDeleted, toBeDeleted);
        Object registeredObject = this.checkIfAlreadyRegistered(toBeDeleted, descriptor);
        if (registeredObject == null) {
            Object primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(toBeDeleted, this);
            DoesExistQuery existQuery = descriptor.getQueryManager().getDoesExistQuery();
            existQuery = (DoesExistQuery)existQuery.clone();
            existQuery.setObject(toBeDeleted);
            existQuery.setPrimaryKey(primaryKey);
            existQuery.setDescriptor(descriptor);
            existQuery.setIsExecutionClone(true);
            existQuery.setCheckCacheFirst(true);
            if (((Boolean)this.executeQuery(existQuery)).booleanValue()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("cannot_remove_detatched_entity", new Object[]{toBeDeleted}));
            }
        } else {
            if (descriptor.getEventManager().hasAnyEventListeners()) {
                DescriptorEvent event = new DescriptorEvent(toBeDeleted);
                event.setEventCode(16);
                event.setSession(this);
                descriptor.getEventManager().executeEvent(event);
            }
            if (this.hasNewObjects() && this.getNewObjectsCloneToOriginal().containsKey(registeredObject)) {
                this.unregisterObject(registeredObject, 1);
            } else {
                this.getDeletedObjects().put(toBeDeleted, toBeDeleted);
            }
        }
        descriptor.getObjectBuilder().cascadePerformRemove(toBeDeleted, this, visitedObjects);
    }

    public void performRemovePrivateOwnedObjectFromChangeSet(Object toBeRemoved, Map visitedObjects) {
        ObjectChangeSet ocs;
        if (toBeRemoved == null) {
            return;
        }
        visitedObjects.put(toBeRemoved, toBeRemoved);
        ClassDescriptor descriptor = this.getDescriptor(toBeRemoved);
        UnitOfWorkChangeSet uowChanges = (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet();
        if (uowChanges != null && (ocs = (ObjectChangeSet)uowChanges.getObjectChangeSetForClone(toBeRemoved)) != null) {
            uowChanges.removeObjectChangeSet(ocs);
            uowChanges.removeObjectChangeSetFromNewList(ocs, this);
        }
        this.unregisterObject(toBeRemoved, 1);
        descriptor.getObjectBuilder().cascadePerformRemovePrivateOwnedObjectFromChangeSet(toBeRemoved, this, visitedObjects);
    }

    @Override
    public void performFullValidation() {
        this.setValidationLevel(2);
    }

    @Override
    public void performPartialValidation() {
        this.setValidationLevel(1);
    }

    protected void populateAndRegisterObject(Object original, Object workingClone, CacheKey unitOfWorkCacheKey, CacheKey parentCacheKey, ClassDescriptor descriptor) {
        unitOfWorkCacheKey.setObject(workingClone);
        unitOfWorkCacheKey.setReadTime(parentCacheKey.getReadTime());
        unitOfWorkCacheKey.setWriteLockValue(parentCacheKey.getWriteLockValue());
        ObjectChangePolicy changePolicy = descriptor.getObjectChangePolicy();
        changePolicy.setChangeListener(workingClone, this, descriptor);
        changePolicy.dissableEventProcessing(workingClone);
        ObjectBuilder builder = descriptor.getObjectBuilder();
        builder.populateAttributesForClone(original, parentCacheKey, workingClone, null, this);
        Object backupClone = changePolicy.buildBackupClone(workingClone, builder, this);
        if (workingClone != backupClone) {
            this.getCloneMapping().put(workingClone, backupClone);
        }
        changePolicy.enableEventProcessing(workingClone);
    }

    protected void postMergeChanges() {
        if (this.unitOfWorkChangeSet.hasDeletedObjects()) {
            Map<ObjectChangeSet, ObjectChangeSet> deletedObjects = this.unitOfWorkChangeSet.getDeletedObjects();
            for (ObjectChangeSet removedObjectChangeSet : deletedObjects.keySet()) {
                Object primaryKey = removedObjectChangeSet.getId();
                ClassDescriptor descriptor = removedObjectChangeSet.getDescriptor();
                if (descriptor.getCachePolicy().shouldIsolateObjectsInUnitOfWork()) continue;
                this.parent.getIdentityMapAccessorInstance().removeFromIdentityMap(primaryKey, descriptor.getJavaClass(), descriptor, removedObjectChangeSet.getUnitOfWorkClone());
            }
        }
    }

    protected void preMergeChanges() {
        if (this.hasObjectsDeletedDuringCommit()) {
            for (Object removedObject : this.getObjectsDeletedDuringCommit().keySet()) {
                Object referenceObjectToRemove;
                this.getCloneMapping().remove(removedObject);
                if (!this.hasNewObjects() || (referenceObjectToRemove = this.getNewObjectsCloneToOriginal().get(removedObject)) == null) continue;
                this.getNewObjectsCloneToOriginal().remove(removedObject);
                this.getNewObjectsOriginalToClone().remove(referenceObjectToRemove);
            }
        }
    }

    @Override
    public void printRegisteredObjects() {
        if (this.shouldLog(7, "cache")) {
            this.basicPrintRegisteredObjects();
        }
    }

    public Object processDeleteObjectQuery(DeleteObjectQuery deleteQuery) {
        ObjectBuilder builder;
        Object implementation;
        if (deleteQuery.getObject() == null) {
            throw QueryException.objectToModifyNotSpecified(deleteQuery);
        }
        ClassDescriptor descriptor = deleteQuery.getDescriptor();
        if (descriptor == null) {
            descriptor = this.getDescriptor(deleteQuery.getObject());
        }
        if (this.isClassReadOnly((implementation = (builder = descriptor.getObjectBuilder()).unwrapObject(deleteQuery.getObject(), this)).getClass(), descriptor)) {
            throw QueryException.cannotDeleteReadOnlyObject(implementation);
        }
        if (this.isCloneNewObject(implementation)) {
            this.unregisterObject(implementation);
            return implementation;
        }
        Object primaryKey = builder.extractPrimaryKeyFromObject(implementation, this);
        Object clone = this.getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, implementation.getClass(), descriptor);
        if (clone == null) {
            clone = implementation;
        }
        clone = builder.unwrapObject(clone, this);
        deleteQuery.setObject(clone);
        if (!this.getCommitManager().isActive()) {
            this.getDeletedObjects().put(clone, primaryKey);
            return clone;
        }
        if (this.hasObjectsDeletedDuringCommit() && this.getObjectsDeletedDuringCommit().containsKey(clone)) {
            return clone;
        }
        return null;
    }

    protected void basicPrintRegisteredObjects() {
        String cr = Helper.cr();
        StringWriter writer = new StringWriter();
        writer.write(LoggingLocalization.buildMessage("unitofwork_identity_hashcode", new Object[]{cr, String.valueOf(System.identityHashCode(this))}));
        if (this.hasDeletedObjects()) {
            writer.write(String.valueOf(cr) + LoggingLocalization.buildMessage("deleted_objects"));
            for (Object object : this.getDeletedObjects().keySet()) {
                writer.write(LoggingLocalization.buildMessage("key_identity_hash_code_object", new Object[]{cr, this.getDescriptor(object).getObjectBuilder().extractPrimaryKeyFromObject(object, this), "\t", String.valueOf(System.identityHashCode(object)), object}));
            }
        }
        writer.write(String.valueOf(cr) + LoggingLocalization.buildMessage("all_registered_clones"));
        for (Object object : this.getCloneMapping().keySet()) {
            writer.write(LoggingLocalization.buildMessage("key_identity_hash_code_object", new Object[]{cr, this.getDescriptor(object).getObjectBuilder().extractPrimaryKeyFromObject(object, this), "\t", String.valueOf(System.identityHashCode(object)), object}));
        }
        if (this.hasNewObjectsInParentOriginalToClone()) {
            writer.write(String.valueOf(cr) + LoggingLocalization.buildMessage("new_objects"));
            for (Object object : this.getNewObjectsCloneToOriginal().keySet()) {
                writer.write(LoggingLocalization.buildMessage("key_identity_hash_code_object", new Object[]{cr, this.getDescriptor(object).getObjectBuilder().extractPrimaryKeyFromObject(object, this), "\t", String.valueOf(System.identityHashCode(object)), object}));
            }
        }
        this.log(7, "transaction", writer.toString(), null, null, false);
    }

    @Override
    public Vector registerAllObjects(Collection domainObjects) {
        Vector<Object> clones = new Vector<Object>(domainObjects.size());
        Iterator objectsEnum = domainObjects.iterator();
        while (objectsEnum.hasNext()) {
            clones.addElement(this.registerObject(objectsEnum.next()));
        }
        return clones;
    }

    public Vector registerAllObjects(Vector domainObjects) throws DatabaseException, OptimisticLockException {
        Vector<Object> clones = new Vector<Object>(domainObjects.size());
        Enumeration objectsEnum = domainObjects.elements();
        while (objectsEnum.hasMoreElements()) {
            clones.addElement(this.registerObject(objectsEnum.nextElement()));
        }
        return clones;
    }

    @Override
    public Object registerExistingObject(Object existingObject) {
        if (existingObject == null) {
            return null;
        }
        ClassDescriptor descriptor = this.getDescriptor(existingObject);
        if (descriptor == null) {
            throw DescriptorException.missingDescriptor(existingObject.getClass().toString());
        }
        if (this.isClassReadOnly(descriptor.getJavaClass(), descriptor)) {
            return existingObject;
        }
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(existingObject, this);
        Object registeredObject = this.registerExistingObject(implementation, descriptor, null);
        if (implementation != existingObject) {
            return builder.wrapObject(registeredObject, this);
        }
        return registeredObject;
    }

    public Object registerExistingObject(Object objectToRegister, ClassDescriptor descriptor, Object queryPrimaryKey) {
        Object registeredObject;
        if (this.isClassReadOnly(descriptor.getJavaClass(), descriptor)) {
            return objectToRegister;
        }
        if (this.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(this.lifecycle, "registerExistingObject");
        }
        if (descriptor.isDescriptorTypeAggregate()) {
            throw ValidationException.cannotRegisterAggregateObjectInUnitOfWork(objectToRegister.getClass());
        }
        this.logDebugMessage(objectToRegister, "register_existing");
        try {
            this.startOperationProfile("Timer:Register");
            registeredObject = this.checkIfAlreadyRegistered(objectToRegister, descriptor);
            if (registeredObject == null) {
                Object primaryKey = queryPrimaryKey;
                if (primaryKey == null) {
                    primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(objectToRegister, this, true);
                }
                if (primaryKey != null) {
                    registeredObject = this.getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, objectToRegister, objectToRegister.getClass(), true, descriptor);
                }
                if (registeredObject == null) {
                    CacheKey cacheKey = new CacheKey(primaryKey);
                    cacheKey.setReadTime(System.currentTimeMillis());
                    cacheKey.setIsolated(true);
                    registeredObject = this.cloneAndRegisterObject(objectToRegister, cacheKey, descriptor);
                }
            }
            if (descriptor.hasFetchGroupManager() && descriptor.getFetchGroupManager().shouldWriteInto(objectToRegister, registeredObject)) {
                descriptor.getFetchGroupManager().writePartialIntoClones(objectToRegister, registeredObject, this);
            }
        }
        finally {
            this.endOperationProfile("Timer:Register");
        }
        return registeredObject;
    }

    public synchronized Object registerNewContainerBean(Object newObject) {
        if (newObject == null) {
            return null;
        }
        this.logDebugMessage(newObject, "register_new");
        this.startOperationProfile("Timer:Register");
        this.setShouldNewObjectsBeCached(true);
        ClassDescriptor descriptor = this.getDescriptor(newObject);
        if (descriptor == null) {
            throw DescriptorException.missingDescriptor(newObject.getClass().toString());
        }
        ObjectBuilder builder = descriptor.getObjectBuilder();
        if (this.shouldPerformFullValidation()) {
            Object primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(newObject, this);
            Object objectFromCache = this.parent.getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, descriptor.getJavaClass(), descriptor);
            if (objectFromCache != null) {
                throw ValidationException.wrongObjectRegistered(newObject, objectFromCache);
            }
        }
        Object original = builder.buildNewInstance();
        builder.copyInto(newObject, original);
        Object clone = this.registerObject(original);
        this.getContainerBeans().put(newObject, clone);
        this.endOperationProfile("Timer:Register");
        return newObject;
    }

    public synchronized Object registerNewContainerBeanForCMP(Object newObject) {
        if (newObject == null) {
            return null;
        }
        this.logDebugMessage(newObject, "register_new_bean");
        this.startOperationProfile("Timer:Register");
        Object clone = this.cloneAndRegisterNewObject(newObject);
        this.endOperationProfile("Timer:Register");
        return clone;
    }

    @Override
    public Object registerNewObject(Object newObject) {
        if (newObject == null) {
            return null;
        }
        ClassDescriptor descriptor = this.getDescriptor(newObject);
        if (descriptor == null) {
            throw DescriptorException.missingDescriptor(newObject.getClass().toString());
        }
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(newObject, this);
        this.registerNewObject(implementation, descriptor);
        if (implementation == newObject) {
            return newObject;
        }
        return builder.wrapObject(implementation, this);
    }

    protected Object registerNewObject(Object implementation, ClassDescriptor descriptor) {
        if (this.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(this.lifecycle, "registerNewObject");
        }
        if (descriptor.isDescriptorTypeAggregate()) {
            throw ValidationException.cannotRegisterAggregateObjectInUnitOfWork(implementation.getClass());
        }
        try {
            this.logDebugMessage(implementation, "register_new");
            this.startOperationProfile("Timer:Register");
            Object registeredObject = this.checkIfAlreadyRegistered(implementation, descriptor);
            if (registeredObject == null) {
                if (this.shouldPerformFullValidation()) {
                    Object primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(implementation, this);
                    Object objectFromCache = this.parent.getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, implementation.getClass(), descriptor);
                    if (objectFromCache != null) {
                        throw ValidationException.wrongObjectRegistered(implementation, objectFromCache);
                    }
                }
                ObjectBuilder builder = descriptor.getObjectBuilder();
                Object original = null;
                Object backupClone = implementation;
                if (!descriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
                    backupClone = builder.buildNewInstance();
                }
                this.getCloneMapping().put(implementation, backupClone);
                this.registerNewObjectClone(implementation, original, descriptor);
            }
        }
        finally {
            this.endOperationProfile("Timer:Register");
        }
        return implementation;
    }

    public void discoverAndPersistUnregisteredNewObjects(Object object, boolean cascadePersist, Map newObjects, Map unregisteredExistingObjects, Map visitedObjects, Set cascadeErrors) {
        if (object == null) {
            return;
        }
        if (cascadePersist && this.isObjectDeleted(object)) {
            this.undeleteObject(object);
        }
        if (visitedObjects.containsKey(object) && !cascadeErrors.contains(object)) {
            return;
        }
        visitedObjects.put(object, object);
        if (this.isObjectDeleted(object)) {
            return;
        }
        ClassDescriptor descriptor = this.getDescriptor(object);
        if (this.isClassReadOnly(object.getClass(), descriptor)) {
            return;
        }
        if (!this.isObjectRegistered(object)) {
            if (cascadePersist) {
                this.registerNotRegisteredNewObjectForPersist(object, descriptor);
                newObjects.put(object, object);
                if (cascadeErrors.contains(object)) {
                    cascadeErrors.remove(object);
                }
            } else {
                if (this.checkForUnregisteredExistingObject(object)) {
                    unregisteredExistingObjects.put(object, object);
                    return;
                }
                cascadeErrors.add(object);
                return;
            }
        }
        descriptor.getObjectBuilder().cascadeDiscoverAndPersistUnregisteredNewObjects(object, newObjects, unregisteredExistingObjects, visitedObjects, this, cascadeErrors);
    }

    public void registerNewObjectForPersist(Object newObject, Map visitedObjects) {
        if (newObject == null) {
            return;
        }
        if (visitedObjects.containsKey(newObject)) {
            return;
        }
        visitedObjects.put(newObject, newObject);
        ClassDescriptor descriptor = this.getDescriptor(newObject);
        if (descriptor == null || descriptor.isDescriptorTypeAggregate()) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{newObject}));
        }
        this.startOperationProfile("Timer:Register");
        try {
            Object registeredObject = this.checkIfAlreadyRegistered(newObject, descriptor);
            if (registeredObject == null) {
                this.registerNotRegisteredNewObjectForPersist(newObject, descriptor);
            } else if (this.isObjectDeleted(newObject)) {
                this.undeleteObject(newObject);
            }
            descriptor.getObjectBuilder().cascadeRegisterNewForCreate(newObject, this, visitedObjects);
            this.updateDerivedIds(newObject, descriptor);
        }
        finally {
            this.endOperationProfile("Timer:Register");
        }
    }

    public boolean wasDeleted(Object original) {
        return false;
    }

    protected void registerNotRegisteredNewObjectForPersist(Object newObject, ClassDescriptor descriptor) {
        if (this.shouldValidateExistence()) {
            DoesExistQuery existQuery = descriptor.getQueryManager().getDoesExistQuery();
            existQuery = (DoesExistQuery)existQuery.clone();
            existQuery.setObject(newObject);
            existQuery.setDescriptor(descriptor);
            existQuery.setIsExecutionClone(true);
            if (((Boolean)this.executeQuery(existQuery)).booleanValue()) {
                throw ValidationException.cannotPersistExistingObject(newObject, this);
            }
        }
        this.logDebugMessage(newObject, "register_new_for_persist");
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object original = null;
        Object backupClone = newObject;
        if (!descriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
            backupClone = builder.buildNewInstance();
        }
        this.getCloneMapping().put(newObject, backupClone);
        this.assignSequenceNumber(newObject, descriptor);
        this.registerNewObjectClone(newObject, original, descriptor);
    }

    protected void registerNewObjectClone(Object clone, Object original, ClassDescriptor descriptor) {
        this.registerNewObjectInIdentityMap(clone, original, descriptor);
        this.getNewObjectsCloneToOriginal().put(clone, original);
        if (original != null) {
            this.getNewObjectsOriginalToClone().put(original, clone);
        }
        if (descriptor.getEventManager().hasAnyEventListeners()) {
            DescriptorEvent event = new DescriptorEvent(clone);
            event.setEventCode(15);
            event.setSession(this);
            descriptor.getEventManager().executeEvent(event);
        }
    }

    protected void registerNewObjectInIdentityMap(Object clone, Object original, ClassDescriptor descriptor) {
        Object key;
        if (this.shouldNewObjectsBeCached() && (key = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(clone, this, true)) != null) {
            this.getIdentityMapAccessorInstance().putInIdentityMap(clone, key, null, 0L, descriptor);
        }
    }

    @Override
    public Object registerObject(Object object) {
        if (object == null) {
            return null;
        }
        ClassDescriptor descriptor = this.getDescriptor(object);
        if (descriptor == null) {
            throw DescriptorException.missingDescriptor(object.getClass().toString());
        }
        if (this.isClassReadOnly(descriptor.getJavaClass(), descriptor)) {
            return object;
        }
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(object, this);
        boolean wasWrapped = implementation != object;
        Object registeredObject = this.registerObject(implementation, descriptor);
        if (wasWrapped) {
            return builder.wrapObject(registeredObject, this);
        }
        return registeredObject;
    }

    protected Object registerObject(Object object, ClassDescriptor descriptor) {
        Object registeredObject;
        if (this.isClassReadOnly(descriptor.getJavaClass(), descriptor)) {
            return object;
        }
        if (this.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(this.lifecycle, "registerObject");
        }
        this.logDebugMessage(object, "register");
        try {
            this.startOperationProfile("Timer:Register");
            registeredObject = this.internalRegisterObject(object, descriptor);
        }
        finally {
            this.endOperationProfile("Timer:Register");
        }
        return registeredObject;
    }

    public void registerOriginalNewObjectFromNestedUnitOfWork(Object originalObject, Object backupClone, Object newInstance, ClassDescriptor descriptor) {
        this.getCloneMapping().put(originalObject, backupClone);
        this.registerNewObjectClone(originalObject, newInstance, descriptor);
    }

    public void registerWithTransactionIfRequired() {
        if (this.parent.hasExternalTransactionController() && !this.isSynchronized()) {
            boolean hasAlreadyStarted = this.parent.wasJTSTransactionInternallyStarted();
            this.parent.getExternalTransactionController().registerSynchronizationListener(this, this.parent);
            if (!hasAlreadyStarted && this.parent.wasJTSTransactionInternallyStarted()) {
                this.setWasTransactionBegunPrematurely(true);
            }
        }
    }

    @Override
    public void release() {
        this.log(2, "transaction", "release_unit_of_work");
        if (this.eventManager != null) {
            this.eventManager.preReleaseUnitOfWork();
        }
        RuntimeException exception = null;
        if (this.lifecycle == 2) {
            if (this.hasModifications() || this.wasTransactionBegunPrematurely()) {
                try {
                    this.rollbackTransaction(false);
                }
                catch (RuntimeException ex) {
                    exception = ex;
                }
                this.setWasTransactionBegunPrematurely(false);
            }
        } else if (this.wasTransactionBegunPrematurely() && !this.isNestedUnitOfWork) {
            this.rollbackTransaction();
            this.setWasTransactionBegunPrematurely(false);
        }
        this.releaseWriteLocks();
        this.setDead();
        if (this.shouldClearForCloseOnRelease()) {
            this.clearForClose(false);
        }
        this.batchQueries = null;
        this.parent.releaseUnitOfWork(this);
        if (this.eventManager != null) {
            this.eventManager.postReleaseUnitOfWork();
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public void removeAllReadOnlyClasses() throws ValidationException {
        if (this.isNestedUnitOfWork) {
            throw ValidationException.cannotRemoveFromReadOnlyClassesInNestedUnitOfWork();
        }
        this.getReadOnlyClasses().clear();
    }

    @Override
    public void removeForceUpdateToVersionField(Object lockObject) {
        this.getOptimisticReadLockObjects().remove(lockObject);
    }

    public void removePrivateOwnedObject(DatabaseMapping mapping, Object privateOwnedObject) {
        Set objectsForMapping;
        if (this.privateOwnedObjects != null && (objectsForMapping = this.privateOwnedObjects.get(mapping)) != null) {
            objectsForMapping.remove(privateOwnedObject);
            if (objectsForMapping.isEmpty()) {
                this.privateOwnedObjects.remove(mapping);
            }
        }
    }

    @Override
    public void removeReadOnlyClass(Class theClass) throws ValidationException {
        if (!this.canChangeReadOnlySet()) {
            throw ValidationException.cannotModifyReadOnlyClassesSetAfterUsingUnitOfWork();
        }
        if (this.isNestedUnitOfWork) {
            throw ValidationException.cannotRemoveFromReadOnlyClassesInNestedUnitOfWork();
        }
        this.getReadOnlyClasses().remove(theClass);
    }

    @Override
    public void revertAndResume() {
        if (this.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(this.lifecycle, "revertAndResume");
        }
        this.log(2, "transaction", "revert_unit_of_work");
        MergeManager manager = new MergeManager(this);
        manager.mergeOriginalIntoWorkingCopy();
        manager.setForRefresh(true);
        manager.cascadeAllParts();
        for (Object clone : new IdentityHashMap(this.getCloneMapping()).keySet()) {
            manager.mergeChanges(clone, null, this);
            ClassDescriptor descriptor = this.getDescriptor(clone);
            descriptor.getObjectChangePolicy().revertChanges(clone, descriptor, this, this.getCloneMapping(), true);
        }
        if (this.hasNewObjects()) {
            for (Object clone : this.getNewObjectsCloneToOriginal().keySet()) {
                this.getCloneMapping().remove(clone);
            }
            if (this.getUnitOfWorkChangeSet() != null) {
                ((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).getNewObjectChangeSets().clear();
            }
        }
        this.setNewObjectsCloneToOriginal(null);
        this.setNewObjectsOriginalToClone(null);
        this.allClones = null;
        this.setObjectsDeletedDuringCommit(new IdentityHashMap());
        this.setDeletedObjects(new IdentityHashMap());
        this.setRemovedObjects(new IdentityHashMap());
        this.setUnregisteredNewObjects(new IdentityHashMap());
        if (this.isNestedUnitOfWork) {
            this.discoverAllUnregisteredNewObjectsInParent();
        }
        this.log(2, "transaction", "resume_unit_of_work");
    }

    @Override
    public Object revertObject(Object clone) {
        return this.revertObject(clone, 2);
    }

    public Object revertObject(Object clone, int cascadeDepth) {
        if (clone == null) {
            return null;
        }
        this.logDebugMessage(clone, "revert");
        ClassDescriptor descriptor = this.getDescriptor(clone);
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(clone, this);
        MergeManager manager = new MergeManager(this);
        manager.mergeOriginalIntoWorkingCopy();
        manager.setForRefresh(true);
        manager.setCascadePolicy(cascadeDepth);
        try {
            manager.mergeChanges(implementation, null, this);
        }
        catch (RuntimeException exception) {
            return this.handleException(exception);
        }
        if (cascadeDepth != 1) {
            builder.instantiateEagerMappings(clone, this);
        }
        return clone;
    }

    @Override
    public void rollbackTransaction() throws DatabaseException {
        this.incrementProfile("Counter:UnitOfWorkRollbacks");
        this.parent.rollbackTransaction();
    }

    protected void rollbackTransaction(boolean intendedToCommitTransaction) throws DatabaseException {
        if (!intendedToCommitTransaction && this.parent.hasExternalTransactionController() && !this.parent.wasJTSTransactionInternallyStarted()) {
            this.parent.getExternalTransactionController().markTransactionForRollback();
        }
        this.rollbackTransaction();
    }

    public Map<Object, Object> scanForConformingInstances(Expression selectionCriteria, Class referenceClass, AbstractRecord arguments, ObjectLevelReadQuery query) {
        IdentityHashMap<Object, Object> indexedInterimResult;
        block6: {
            int policy = query.getInMemoryQueryIndirectionPolicyState();
            if (policy != 1) {
                policy = 3;
            }
            indexedInterimResult = new IdentityHashMap<Object, Object>();
            try {
                Vector fromCache = null;
                if (selectionCriteria != null) {
                    fromCache = this.getIdentityMapAccessor().getAllFromIdentityMap(selectionCriteria, referenceClass, (Record)arguments, policy);
                    for (Object object : fromCache) {
                        if (this.isObjectDeleted(object)) continue;
                        indexedInterimResult.put(object, object);
                    }
                }
                Vector newObjects = null;
                newObjects = this.getAllFromNewObjects(selectionCriteria, referenceClass, arguments, policy);
                for (Object object : newObjects) {
                    if (this.isObjectDeleted(object)) continue;
                    indexedInterimResult.put(object, object);
                }
            }
            catch (QueryException exception) {
                if (this.getShouldThrowConformExceptions() != 1) break block6;
                throw exception;
            }
        }
        return indexedInterimResult;
    }

    protected void setAllClonesCollection(Map objects) {
        this.allClones = objects;
    }

    protected void setCloneMapping(Map cloneMapping) {
        this.cloneMapping = cloneMapping;
    }

    protected void setContainerBeans(Map containerBeans) {
        this.containerBeans = containerBeans;
    }

    protected void setContainerUnitOfWork(UnitOfWorkImpl containerUnitOfWork) {
        this.containerUnitOfWork = containerUnitOfWork;
    }

    public void setDead() {
        this.setLifecycle(5);
    }

    protected void setDeletedObjects(Map deletedObjects) {
        this.deletedObjects = deletedObjects;
    }

    protected void setLifecycle(int lifecycle) {
        this.lifecycle = lifecycle;
    }

    public void setMergeManager(MergeManager mergeManager) {
        this.lastUsedMergeManager = mergeManager;
    }

    protected void setNewObjectsCloneToOriginal(Map newObjects) {
        this.newObjectsCloneToOriginal = newObjects;
    }

    protected void setNewObjectsOriginalToClone(Map newObjects) {
        this.newObjectsOriginalToClone = newObjects;
    }

    public void setObjectsDeletedDuringCommit(Map deletedObjects) {
        this.objectsDeletedDuringCommit = deletedObjects;
    }

    public void setParent(AbstractSession parent) {
        this.parent = parent;
    }

    public void setPendingMerge() {
        this.setLifecycle(4);
    }

    public void setPreDeleteComplete(boolean preDeleteComplete) {
        this.preDeleteComplete = preDeleteComplete;
    }

    public void setReadOnlyClasses(List<Class> classes) {
        if (classes.isEmpty()) {
            this.readOnlyClasses = null;
            return;
        }
        int size = classes.size();
        this.readOnlyClasses = new HashSet<Class>(size);
        int index = 0;
        while (index < size) {
            this.readOnlyClasses.add(classes.get(index));
            ++index;
        }
    }

    protected void setRemovedObjects(Map removedObjects) {
        this.removedObjects = removedObjects;
    }

    public void setResumeUnitOfWorkOnTransactionCompletion(boolean resumeUnitOfWork) {
        this.resumeOnTransactionCompletion = resumeUnitOfWork;
    }

    public boolean shouldDiscoverNewObjects() {
        return this.shouldDiscoverNewObjects;
    }

    public void setShouldDiscoverNewObjects(boolean shouldDiscoverNewObjects) {
        this.shouldDiscoverNewObjects = shouldDiscoverNewObjects;
    }

    public void setShouldCascadeCloneToJoinedRelationship(boolean shouldCascadeCloneToJoinedRelationship) {
        this.shouldCascadeCloneToJoinedRelationship = shouldCascadeCloneToJoinedRelationship;
    }

    public boolean shouldForceReadFromDB(ObjectBuildingQuery query, Object primaryKey) {
        return false;
    }

    @Override
    public void setShouldNewObjectsBeCached(boolean shouldNewObjectsBeCached) {
        this.shouldNewObjectsBeCached = shouldNewObjectsBeCached;
    }

    @Override
    public void setShouldPerformDeletesFirst(boolean shouldPerformDeletesFirst) {
        this.shouldPerformDeletesFirst = shouldPerformDeletesFirst;
    }

    @Override
    public void setShouldThrowConformExceptions(int shouldThrowExceptions) {
        this.shouldThrowConformExceptions = shouldThrowExceptions;
    }

    public static void setSmartMerge(boolean option) {
        SmartMerge = option;
    }

    @Override
    public void setSynchronized(boolean synched) {
        super.setSynchronized(synched);
        this.parent.setSynchronized(synched);
    }

    public void setUnitOfWorkChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet) {
        this.unitOfWorkChangeSet = unitOfWorkChangeSet;
    }

    protected void setUnregisteredExistingObjects(Map newUnregisteredExistingObjects) {
        this.unregisteredExistingObjects = newUnregisteredExistingObjects;
    }

    protected void setUnregisteredNewObjects(Map newObjects) {
        this.unregisteredNewObjects = newObjects;
    }

    protected void setUnregisteredNewObjectsInParent(Map newObjects) {
        this.unregisteredNewObjectsInParent = newObjects;
    }

    @Override
    public void setValidationLevel(int validationLevel) {
        this.validationLevel = validationLevel;
    }

    public void setWasTransactionBegunPrematurely(boolean wasTransactionBegunPrematurely) {
        if (this.isNestedUnitOfWork) {
            ((UnitOfWorkImpl)this.parent).setWasTransactionBegunPrematurely(wasTransactionBegunPrematurely);
        }
        this.wasTransactionBegunPrematurely = wasTransactionBegunPrematurely;
    }

    @Override
    public Object shallowMergeClone(Object rmiClone) {
        return this.mergeClone(rmiClone, 1, false);
    }

    @Override
    public Object shallowRevertObject(Object clone) {
        return this.revertObject(clone, 1);
    }

    @Override
    public void shallowUnregisterObject(Object clone) {
        this.unregisterObject(clone, 1);
    }

    public boolean shouldCascadeCloneToJoinedRelationship() {
        return this.shouldCascadeCloneToJoinedRelationship;
    }

    @Override
    public boolean shouldNewObjectsBeCached() {
        return this.shouldNewObjectsBeCached;
    }

    public boolean shouldValidateExistence() {
        return this.shouldValidateExistence;
    }

    public void setShouldValidateExistence(boolean shouldValidateExistence) {
        this.shouldValidateExistence = shouldValidateExistence;
    }

    @Override
    public boolean shouldPerformDeletesFirst() {
        return this.shouldPerformDeletesFirst;
    }

    @Override
    public boolean shouldPerformFullValidation() {
        return this.getValidationLevel() == 2;
    }

    @Override
    public boolean shouldPerformNoValidation() {
        return this.getValidationLevel() == 0;
    }

    @Override
    public boolean shouldPerformPartialValidation() {
        return this.getValidationLevel() == 1;
    }

    public boolean shouldResumeUnitOfWorkOnTransactionCompletion() {
        return this.resumeOnTransactionCompletion;
    }

    public boolean shouldStoreBypassCache() {
        return false;
    }

    public void storeModifyAllQuery(DatabaseQuery query) {
        if (this.modifyAllQueries == null) {
            this.modifyAllQueries = new ArrayList<ModifyAllQuery>();
        }
        this.modifyAllQueries.add((ModifyAllQuery)query);
    }

    public void storeDeferredModifyAllQuery(DatabaseQuery query, AbstractRecord translationRow) {
        if (this.deferredModifyAllQueries == null) {
            this.deferredModifyAllQueries = new ArrayList<Object[]>();
        }
        this.deferredModifyAllQueries.add(new Object[]{query, translationRow});
    }

    public void synchronizeAndResume() {
        this.pessimisticLockedObjects = null;
        if (this.hasProperties()) {
            this.getProperties().remove(LOCK_QUERIES_PROPERTY);
        }
        this.resumeUnitOfWork();
        this.allClones = null;
        this.removedObjects = null;
        this.lifecycle = 0;
        this.isSynchronized = false;
        this.unregisteredNewObjectsInParent = null;
        if (this.isNestedUnitOfWork) {
            this.discoverAllUnregisteredNewObjectsInParent();
        }
    }

    public void resumeUnitOfWork() {
        if (this.hasNewObjects() && !this.isNestedUnitOfWork) {
            Iterator<Map.Entry<Object, Object>> newEntries = this.newObjectsCloneToOriginal.entrySet().iterator();
            Map map = this.getCloneToOriginals();
            while (newEntries.hasNext()) {
                Map.Entry<Object, Object> entry = newEntries.next();
                Object clone = entry.getKey();
                Object original = entry.getValue();
                if (original == null) continue;
                map.put(clone, original);
            }
            this.newObjectsCloneToOriginal = null;
            this.newObjectsOriginalToClone = null;
        }
        this.unregisteredExistingObjects = null;
        this.unregisteredNewObjects = null;
        Map cloneMapping = this.getCloneMapping();
        if (this.unitOfWorkChangeSet != null) {
            for (Map map : this.unitOfWorkChangeSet.getObjectChanges().values()) {
                ClassDescriptor descriptor = null;
                for (ObjectChangeSet changeSet : map.values()) {
                    descriptor = changeSet.getDescriptor();
                    descriptor.getObjectChangePolicy().revertChanges(changeSet.getUnitOfWorkClone(), descriptor, this, cloneMapping, false);
                }
            }
        }
        this.deletedObjects = null;
        if (this.hasObjectsDeletedDuringCommit()) {
            if (this.unregisteredDeletedObjectsCloneToBackupAndOriginal == null) {
                this.unregisteredDeletedObjectsCloneToBackupAndOriginal = new IdentityHashMap<Object, Object>(this.objectsDeletedDuringCommit.size());
            }
            Iterator<Object> iterator = this.objectsDeletedDuringCommit.keySet().iterator();
            Map cloneToOriginals = this.getCloneToOriginals();
            while (iterator.hasNext()) {
                Object deletedObject = iterator.next();
                Object[] backupAndOriginal = new Object[]{cloneMapping.get(deletedObject), cloneToOriginals.get(deletedObject)};
                this.unregisteredDeletedObjectsCloneToBackupAndOriginal.put(deletedObject, backupAndOriginal);
                this.getIdentityMapAccessorInstance().removeFromIdentityMap(deletedObject);
                cloneMapping.remove(deletedObject);
            }
        }
        this.objectsDeletedDuringCommit = null;
        this.unitOfWorkChangeSet = null;
        this.changeTrackedHardList = null;
    }

    protected void undeleteObject(Object object) {
        this.getDeletedObjects().remove(object);
        if (this.parent.isUnitOfWork()) {
            ((UnitOfWorkImpl)this.parent).undeleteObject(object);
        }
    }

    @Override
    public void unregisterObject(Object clone) {
        this.unregisterObject(clone, 2);
    }

    public void unregisterObject(Object clone, int cascadeDepth) {
        this.unregisterObject(clone, cascadeDepth, false);
    }

    public void unregisterObject(Object clone, int cascadeDepth, boolean forDetach) {
        if (clone == null) {
            return;
        }
        this.logDebugMessage(clone, "unregister");
        Object implementation = this.getDescriptor(clone).getObjectBuilder().unwrapObject(clone, this);
        DescriptorIterator iterator = new DescriptorIterator(){

            public void iterate(Object object) {
                Object original;
                if (UnitOfWorkImpl.this.isClassReadOnly(object.getClass(), this.getCurrentDescriptor())) {
                    this.setShouldBreak(true);
                    return;
                }
                Object primaryKey = this.getCurrentDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, UnitOfWorkImpl.this, true);
                if (primaryKey != null) {
                    UnitOfWorkImpl.this.getIdentityMapAccessorInstance().removeFromIdentityMap(primaryKey, object.getClass(), this.getCurrentDescriptor(), object);
                }
                UnitOfWorkImpl.this.getCloneMapping().remove(object);
                UnitOfWorkImpl.this.getDeletedObjects().remove(object);
                if (UnitOfWorkImpl.this.hasNewObjects() && (original = UnitOfWorkImpl.this.getNewObjectsCloneToOriginal().remove(object)) != null) {
                    UnitOfWorkImpl.this.getNewObjectsOriginalToClone().remove(original);
                }
            }
        };
        iterator.setSession(this);
        iterator.setCascadeDepth(cascadeDepth);
        if (forDetach) {
            DescriptorIterator.CascadeCondition detached = new DescriptorIterator.CascadeCondition(iterator){

                public boolean shouldNotCascade(DatabaseMapping mapping) {
                    return !mapping.isForeignReferenceMapping() || !((ForeignReferenceMapping)mapping).isCascadeDetach();
                }
            };
            iterator.setCascadeCondition(detached);
            iterator.setShouldIterateOverUninstantiatedIndirectionObjects(false);
        }
        iterator.setShouldIterateOnFetchGroupAttributesOnly(true);
        iterator.startIterationOn(implementation);
    }

    public void updateChangeTrackersIfRequired(Object objectToWrite, ObjectChangeSet changeSetToWrite, UnitOfWorkImpl uow, ClassDescriptor descriptor) {
    }

    protected Object updateDerivedIds(Object clone, ClassDescriptor descriptor) {
        Object key = null;
        if (descriptor.hasDerivedId()) {
            for (DatabaseMapping derivesIdMapping : descriptor.getDerivesIdMappinps()) {
                DatabaseMapping derivedIdMapping = derivesIdMapping.getDerivedIdMapping();
                if (derivedIdMapping == null) continue;
                ClassDescriptor parentDescriptor = derivesIdMapping.getReferenceDescriptor();
                Object parentClone = derivesIdMapping.getRealAttributeValueFromObject(clone, this);
                if (parentClone == null) continue;
                key = parentDescriptor.hasDerivedId() ? this.updateDerivedIds(parentClone, parentDescriptor) : parentDescriptor.getCMPPolicy().createPrimaryKeyInstance(parentClone, this);
                if (derivesIdMapping.hasMapsIdValue()) {
                    Object aggregateClone = derivedIdMapping.getRealAttributeValueFromObject(clone, this);
                    if (aggregateClone == null) {
                        aggregateClone = derivedIdMapping.getReferenceDescriptor().getObjectBuilder().buildNewInstance();
                        derivedIdMapping.setRealAttributeValueInObject(clone, aggregateClone);
                    }
                    DatabaseMapping aggregateMapping = derivedIdMapping.getReferenceDescriptor().getObjectBuilder().getMappingForAttributeName(derivesIdMapping.getMapsIdValue());
                    aggregateMapping.setRealAttributeValueInObject(aggregateClone, key);
                    key = aggregateClone;
                    continue;
                }
                derivedIdMapping.setRealAttributeValueInObject(clone, key);
            }
        }
        return key;
    }

    @Override
    public void validateObjectSpace() {
        this.log(2, "transaction", "validate_object_space");
        DescriptorIterator iterator = new DescriptorIterator(){

            public void iterate(Object object) {
                try {
                    if (UnitOfWorkImpl.this.isClassReadOnly(object.getClass(), this.getCurrentDescriptor())) {
                        this.setShouldBreak(true);
                        return;
                    }
                    UnitOfWorkImpl.this.getBackupClone(object, this.getCurrentDescriptor());
                }
                catch (EclipseLinkException exception) {
                    UnitOfWorkImpl.this.log(1, "transaction", "stack_of_visited_objects_that_refer_to_the_corrupt_object", this.getVisitedStack());
                    UnitOfWorkImpl.this.log(2, "transaction", "corrupt_object_referenced_through_mapping", this.getCurrentMapping());
                    throw exception;
                }
            }
        };
        iterator.setSession(this);
        Iterator clonesEnum = this.getCloneMapping().keySet().iterator();
        while (clonesEnum.hasNext()) {
            iterator.startIterationOn(clonesEnum.next());
        }
    }

    public boolean wasTransactionBegunPrematurely() {
        if (this.isNestedUnitOfWork) {
            return ((UnitOfWorkImpl)this.parent).wasTransactionBegunPrematurely();
        }
        return this.wasTransactionBegunPrematurely;
    }

    @Override
    public Object retryQuery(DatabaseQuery query, AbstractRecord row, DatabaseException databaseException, int retryCount, AbstractSession executionSession) {
        return this.getParent().retryQuery(query, row, databaseException, retryCount, executionSession);
    }

    @Override
    public void writeChanges() {
        if (!this.isActive()) {
            throw ValidationException.inActiveUnitOfWork("writeChanges");
        }
        if (this.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.cannotWriteChangesTwice();
        }
        if (this.isNestedUnitOfWork) {
            throw ValidationException.writeChangesOnNestedUnitOfWork();
        }
        this.log(2, "transaction", "begin_unit_of_work_flush");
        this.mergeBmpAndWsEntities();
        if (this.eventManager != null) {
            this.eventManager.preCommitUnitOfWork();
        }
        this.setLifecycle(1);
        try {
            this.commitToDatabaseWithChangeSet(false);
            this.writesCompleted();
        }
        catch (RuntimeException exception) {
            this.setLifecycle(3);
            throw exception;
        }
        this.setLifecycle(2);
        this.log(2, "transaction", "end_unit_of_work_flush");
    }

    @Override
    public void writesCompleted() {
        this.parent.writesCompleted();
    }

    private void logDebugMessage(Object object, String debugMessage) {
        this.log(1, "transaction", debugMessage, object);
    }

    public Map<ReadQuery, ReadQuery> getBatchQueries() {
        if (this.batchQueries == null) {
            this.batchQueries = this.createMap();
        }
        return this.batchQueries;
    }

    public void setBatchQueries(Map<ReadQuery, ReadQuery> batchQueries) {
        this.batchQueries = batchQueries;
    }

    public Map getPessimisticLockedObjects() {
        if (this.pessimisticLockedObjects == null) {
            this.pessimisticLockedObjects = new IdentityHashMap<Object, Object>();
        }
        return this.pessimisticLockedObjects;
    }

    public void addToChangeTrackedHardList(Object obj) {
        if (this.referenceMode != ReferenceMode.HARD) {
            this.getChangeTrackedHardList().add(obj);
        }
    }

    public void addPessimisticLockedClone(Object clone) {
        this.log(1, "transaction", "tracking_pl_object", clone, this.hashCode());
        this.getPessimisticLockedObjects().put(clone, clone);
    }

    public void addPrivateOwnedObject(DatabaseMapping mapping, Object privateOwnedObject) {
        if (privateOwnedObject != null && this.getDescriptor(privateOwnedObject) != null) {
            Map<DatabaseMapping, Set> privateOwnedObjects = this.getPrivateOwnedObjects();
            Set objectsForMapping = privateOwnedObjects.get(mapping);
            if (objectsForMapping == null) {
                objectsForMapping = new IdentityHashSet();
                privateOwnedObjects.put(mapping, objectsForMapping);
            }
            objectsForMapping.add(privateOwnedObject);
        }
    }

    public boolean isPessimisticLocked(Object clone) {
        return this.pessimisticLockedObjects != null && this.pessimisticLockedObjects.containsKey(clone);
    }

    public boolean isPreDeleteComplete() {
        return this.preDeleteComplete;
    }

    public void setWasNonObjectLevelModifyQueryExecuted(boolean wasNonObjectLevelModifyQueryExecuted) {
        this.wasNonObjectLevelModifyQueryExecuted = wasNonObjectLevelModifyQueryExecuted;
    }

    public boolean wasNonObjectLevelModifyQueryExecuted() {
        return this.wasNonObjectLevelModifyQueryExecuted;
    }

    public boolean shouldReadFromDB() {
        return this.wasNonObjectLevelModifyQueryExecuted();
    }

    @Override
    public void releaseReadConnection(Accessor connection) {
        this.parent.releaseReadConnection(connection);
    }

    public void clear(boolean shouldClearCache) {
        this.cloneToOriginals = null;
        this.cloneMapping = null;
        this.newObjectsCloneToOriginal = null;
        this.newObjectsOriginalToClone = null;
        this.deletedObjects = null;
        this.allClones = null;
        this.objectsDeletedDuringCommit = null;
        this.removedObjects = null;
        this.unregisteredNewObjects = null;
        this.unregisteredExistingObjects = null;
        this.newAggregates = null;
        this.unitOfWorkChangeSet = null;
        this.pessimisticLockedObjects = null;
        this.optimisticReadLockObjects = null;
        this.batchQueries = null;
        this.privateOwnedObjects = null;
        if (shouldClearCache) {
            this.clearIdentityMapCache();
        }
    }

    private void clearIdentityMapCache() {
        this.getIdentityMapAccessor().initializeIdentityMaps();
        if (this.parent instanceof IsolatedClientSession) {
            this.parent.getIdentityMapAccessor().initializeIdentityMaps();
        }
    }

    public void clearForClose(boolean shouldClearCache) {
        this.clear(shouldClearCache);
        if (this.isActive()) {
            this.lifecycle = 0;
            this.isSynchronized = false;
        }
    }

    public boolean shouldClearForCloseOnRelease() {
        return false;
    }

    private void copyStatementsCountIntoProperties() {
        Accessor accessor = null;
        try {
            accessor = this.getAccessor();
        }
        catch (DatabaseException databaseException) {}
        if (accessor != null && accessor instanceof DatasourceAccessor) {
            this.getProperties().put("Read_Statements_Count_Property", ((DatasourceAccessor)accessor).getReadStatementsCount());
            this.getProperties().put("Write_Statements_Count_Property", ((DatasourceAccessor)accessor).getWriteStatementsCount());
            this.getProperties().put("StoredProcedure_Statements_Count_Property", ((DatasourceAccessor)accessor).getStoredProcedureStatementsCount());
        }
    }

    protected Map createMap() {
        if (this.referenceMode != null && this.referenceMode != ReferenceMode.HARD) {
            return new IdentityWeakHashMap();
        }
        return new IdentityHashMap();
    }

    protected Map createMap(int size) {
        if (this.referenceMode != null && this.referenceMode != ReferenceMode.HARD) {
            return new IdentityWeakHashMap(size);
        }
        return new IdentityHashMap(size);
    }

    protected Map cloneMap(Map map) {
        if (this.referenceMode != null && this.referenceMode != ReferenceMode.HARD) {
            return (IdentityWeakHashMap)((IdentityWeakHashMap)map).clone();
        }
        return (IdentityHashMap)((IdentityHashMap)map).clone();
    }

    public ReferenceMode getReferenceMode() {
        return this.referenceMode;
    }

    public Set<Object> getChangeTrackedHardList() {
        if (this.changeTrackedHardList == null) {
            this.changeTrackedHardList = new IdentityHashSet();
        }
        return this.changeTrackedHardList;
    }

    @Override
    public Object getReference(Class theClass, Object id) {
        Object reference;
        Object primaryKey;
        ClassDescriptor descriptor = this.getDescriptor(theClass);
        if (descriptor == null || descriptor.isDescriptorTypeAggregate()) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("unknown_bean_class", new Object[]{theClass}));
        }
        if (id == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_pk"));
        }
        if (id instanceof List) {
            primaryKey = descriptor.getCachePolicy().getCacheKeyType() == CacheKeyType.ID_VALUE ? (((List)id).isEmpty() ? null : ((List)id).get(0)) : new CacheId(((List)id).toArray());
        } else if (id instanceof CacheId) {
            primaryKey = id;
        } else if (descriptor.getCMPPolicy() != null) {
            if (descriptor.getCMPPolicy().getPKClass() != null && !descriptor.getCMPPolicy().getPKClass().isAssignableFrom(id.getClass())) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("invalid_pk_class", new Object[]{descriptor.getCMPPolicy().getPKClass(), id.getClass()}));
            }
            primaryKey = descriptor.getCMPPolicy().createPrimaryKeyFromId(id, this);
        } else {
            primaryKey = !id.getClass().equals(theClass) ? descriptor.getObjectBuilder().extractPrimaryKeyFromObject(id, this) : id;
        }
        if (descriptor.hasFetchGroupManager()) {
            reference = this.getIdentityMapAccessor().getFromIdentityMap(primaryKey, theClass);
            if (reference == null) {
                if (id instanceof List || id instanceof CacheId || descriptor.getCMPPolicy() == null) {
                    AbstractRecord row = descriptor.getObjectBuilder().buildRowFromPrimaryKeyValues(primaryKey, this);
                    reference = descriptor.getObjectBuilder().buildNewInstance();
                    descriptor.getObjectBuilder().buildPrimaryKeyAttributesIntoObject(reference, row, new ReadObjectQuery(), this);
                } else {
                    reference = descriptor.getCMPPolicy().createBeanUsingKey(id, this);
                }
                descriptor.getFetchGroupManager().getIdEntityFetchGroup().setOnEntity(reference, this);
                reference = this.registerExistingObject(reference);
            }
        } else {
            ReadObjectQuery query = new ReadObjectQuery(descriptor.getJavaClass());
            query.setSelectionId(primaryKey);
            query.conformResultsInUnitOfWork();
            query.setIsExecutionClone(true);
            reference = this.executeQuery(query);
        }
        return reference;
    }

    public boolean verifyMutexThreadIntegrityBeforeRelease() {
        if (this.lastUsedMergeManager != null) {
            Thread lockThread;
            Thread currentThread = Thread.currentThread();
            if (currentThread != (lockThread = this.lastUsedMergeManager.getLockThread())) {
                ArrayList<CacheKey> locks;
                if (ConcurrencyManager.getDeferredLockManager(lockThread) != null) {
                    ConcurrencyManager.deferredLockManagers.put(currentThread, ConcurrencyManager.deferredLockManagers.remove(lockThread));
                }
                if ((locks = this.getMergeManager().getAcquiredLocks()) != null) {
                    Iterator<CacheKey> locksIterator = locks.iterator();
                    this.log(2, "cache", "active_thread_is_different_from_current_thread", lockThread, this.getMergeManager(), currentThread);
                    while (locksIterator.hasNext()) {
                        Thread activeThread;
                        ConcurrencyManager lockMutex = locksIterator.next().getMutex();
                        if (lockMutex == null || currentThread == (activeThread = lockMutex.getActiveThread())) continue;
                        lockMutex.setActiveThread(currentThread);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldOrderUpdates() {
        return this.shouldOrderUpdates;
    }

    @Override
    public void setShouldOrderUpdates(boolean shouldOrderUpdates) {
        this.shouldOrderUpdates = shouldOrderUpdates;
    }

    @Override
    public DatabaseValueHolder createCloneQueryValueHolder(ValueHolderInterface attributeValue, Object clone, AbstractRecord row, ForeignReferenceMapping mapping) {
        return new UnitOfWorkQueryValueHolder(attributeValue, clone, mapping, row, this);
    }

    @Override
    public DatabaseValueHolder createCloneTransformationValueHolder(ValueHolderInterface attributeValue, Object original, Object clone, AbstractTransformationMapping mapping) {
        return new UnitOfWorkTransformerValueHolder(attributeValue, original, clone, mapping, this);
    }

    public Map<Object, Set<Object>> getDeletionDependencies() {
        if (this.deletionDependencies == null) {
            this.deletionDependencies = new HashMap<Object, Set<Object>>();
        }
        return this.deletionDependencies;
    }

    public void addDeletionDependency(Object target, Object source) {
        Set<Object> dependencies;
        if (this.deletionDependencies == null) {
            this.deletionDependencies = new HashMap<Object, Set<Object>>();
        }
        if ((dependencies = this.deletionDependencies.get(target)) == null) {
            dependencies = new HashSet<Object>();
            this.deletionDependencies.put(target, dependencies);
        }
        dependencies.add(source);
    }

    public Set<Object> getDeletionDependencies(Object deletedObject) {
        if (this.deletionDependencies == null) {
            return null;
        }
        return this.deletionDependencies.get(deletedObject);
    }
}

