/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.ExtendedContentHandler;
import org.eclipse.persistence.internal.oxm.record.XMLFragmentReader;
import org.eclipse.persistence.oxm.CharacterEscapeHandler;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class OutputStreamRecord
extends MarshalRecord {
    protected static byte[] OPEN_XML_PI_AND_VERSION_ATTRIBUTE;
    protected static byte[] OPEN_ENCODING_ATTRIBUTE;
    protected static byte[] CLOSE_PI;
    protected static byte SPACE;
    protected static byte[] CR;
    protected static byte CLOSE_ATTRIBUTE_VALUE;
    protected static byte[] OPEN_CDATA;
    protected static byte[] CLOSE_CDATA;
    protected static byte[] OPEN_COMMENT;
    protected static byte[] CLOSE_COMMENT;
    protected static byte OPEN_START_ELEMENT;
    protected static byte CLOSE_ELEMENT;
    protected static byte[] AMP;
    protected static byte[] LT;
    protected static byte[] QUOT;
    protected static byte[] ENCODING;
    protected OutputStream outputStream;
    protected boolean isStartElementOpen = false;
    protected boolean isProcessingCData = false;
    private static final int BUFFER_SIZE = 512;
    private byte[] buffer = new byte[512];
    private int bufferIndex = 0;

    static {
        SPACE = (byte)32;
        CLOSE_ATTRIBUTE_VALUE = (byte)34;
        OPEN_START_ELEMENT = (byte)60;
        CLOSE_ELEMENT = (byte)62;
        try {
            OPEN_XML_PI_AND_VERSION_ATTRIBUTE = "<?xml version=\"".getBytes("UTF-8");
            OPEN_ENCODING_ATTRIBUTE = " encoding=\"".getBytes("UTF-8");
            CLOSE_PI = "?>".getBytes("UTF-8");
            CR = Helper.cr().getBytes("UTF-8");
            OPEN_CDATA = "<![CDATA[".getBytes("UTF-8");
            CLOSE_CDATA = "]]>".getBytes("UTF-8");
            OPEN_COMMENT = "<!--".getBytes("UTF-8");
            CLOSE_COMMENT = "-->".getBytes("UTF-8");
            AMP = "&amp;".getBytes("UTF-8");
            LT = "&lt;".getBytes("UTF-8");
            QUOT = "&quot;".getBytes("UTF-8");
            ENCODING = "UTF-8".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
    }

    public void startDocument(String encoding, String version) {
        try {
            this.outputStreamWrite(OPEN_XML_PI_AND_VERSION_ATTRIBUTE);
            this.outputStreamWrite(version.getBytes("UTF-8"));
            this.outputStreamWrite(CLOSE_ATTRIBUTE_VALUE);
            if (encoding != null) {
                this.outputStreamWrite(OPEN_ENCODING_ATTRIBUTE);
                this.outputStreamWrite(ENCODING);
                this.outputStreamWrite(CLOSE_ATTRIBUTE_VALUE);
            }
            this.outputStreamWrite(CLOSE_PI);
            this.outputStreamWrite(CR);
        }
        catch (UnsupportedEncodingException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void writeHeader() {
        this.outputStreamWrite(this.getMarshaller().getXmlHeader().getBytes());
    }

    public void endDocument() {
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        super.openStartElement(xPathFragment, namespaceResolver);
        if (this.isStartElementOpen) {
            this.outputStreamWrite(CLOSE_ELEMENT);
        }
        this.isStartElementOpen = true;
        this.outputStreamWrite(OPEN_START_ELEMENT);
        this.outputStreamWrite(this.getNameForFragmentBytes(xPathFragment));
    }

    public void element(XPathFragment frag) {
        if (this.isStartElementOpen) {
            this.outputStreamWrite(CLOSE_ELEMENT);
            this.isStartElementOpen = false;
        }
        this.outputStreamWrite(OPEN_START_ELEMENT);
        try {
            this.outputStreamWrite(this.getNameForFragment(frag).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        this.outputStreamWrite((byte)47);
        this.outputStreamWrite((byte)62);
    }

    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String value) {
        this.attribute(null, xPathFragment.getLocalName(), this.getNameForFragment(xPathFragment), value);
    }

    public void attribute(String namespaceURI, String localName, String qName, String value) {
        try {
            this.outputStreamWrite(SPACE);
            this.outputStreamWrite(qName.getBytes("UTF-8"));
            this.outputStreamWrite((byte)61);
            this.outputStreamWrite((byte)34);
            this.writeValue(value, true, true, this.outputStream);
            this.outputStreamWrite(CLOSE_ATTRIBUTE_VALUE);
        }
        catch (UnsupportedEncodingException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void closeStartElement() {
    }

    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        if (this.isStartElementOpen) {
            this.outputStreamWrite((byte)47);
            this.outputStreamWrite((byte)62);
            this.isStartElementOpen = false;
        } else {
            this.outputStreamWrite((byte)60);
            this.outputStreamWrite((byte)47);
            this.outputStreamWrite(this.getNameForFragmentBytes(xPathFragment));
            this.outputStreamWrite(CLOSE_ELEMENT);
        }
        this.isStartElementOpen = false;
    }

    public void characters(String value) {
        if (this.isStartElementOpen) {
            this.isStartElementOpen = false;
            this.outputStreamWrite(CLOSE_ELEMENT);
        }
        this.writeValue(value, true);
    }

    public void cdata(String value) {
        try {
            if (this.isStartElementOpen) {
                this.isStartElementOpen = false;
                this.outputStreamWrite(CLOSE_ELEMENT);
            }
            this.outputStreamWrite(OPEN_CDATA);
            this.outputStreamWrite(value.getBytes("UTF-8"));
            this.outputStreamWrite(CLOSE_CDATA);
        }
        catch (UnsupportedEncodingException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    protected void writeValue(String value, boolean escapeChars) {
        this.writeValue(value, escapeChars, false, this.outputStream);
    }

    protected void writeValue(String value, boolean escapeChars, boolean isAttribute, OutputStream os) {
        CharacterEscapeHandler escapeHandler;
        if (escapeChars && (escapeHandler = this.marshaller.getCharacterEscapeHandler()) != null) {
            try {
                CharArrayWriter out = new CharArrayWriter();
                escapeHandler.escape(value.toCharArray(), 0, value.length(), isAttribute, out);
                byte[] bytes = out.toString().getBytes();
                this.outputStreamWrite(bytes);
                out.close();
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
            return;
        }
        int x = 0;
        int length = value.length();
        while (x < length) {
            block14: {
                char character;
                block11: {
                    block15: {
                        block12: {
                            block13: {
                                character = value.charAt(x);
                                if (character <= '\u007f') break block11;
                                if (character <= '\u07ff') break block12;
                                if (character < '\ud800' || character > '\udfff') break block13;
                                int uc = ((character & 0x3FF) << 10 | value.charAt(++x) & 0x3FF) + 65536;
                                this.outputStreamWrite((byte)(0xF0 | uc >> 18), os);
                                this.outputStreamWrite((byte)(0x80 | uc >> 12 & 0x3F), os);
                                this.outputStreamWrite((byte)(0x80 | uc >> 6 & 0x3F), os);
                                this.outputStreamWrite((byte)(128 + (uc & 0x3F)), os);
                                break block14;
                            }
                            this.outputStreamWrite((byte)(224 + (character >> 12)), os);
                            this.outputStreamWrite((byte)(128 + (character >> 6 & 0x3F)), os);
                            break block15;
                        }
                        this.outputStreamWrite((byte)(192 + (character >> 6)), os);
                    }
                    this.outputStreamWrite((byte)(128 + (character & 0x3F)), os);
                    break block14;
                }
                if (escapeChars) {
                    switch (character) {
                        case '&': {
                            this.outputStreamWrite(AMP, os);
                            break;
                        }
                        case '<': {
                            this.outputStreamWrite(LT, os);
                            break;
                        }
                        case '\"': {
                            this.outputStreamWrite(QUOT, os);
                            break;
                        }
                        default: {
                            this.outputStreamWrite((byte)character, os);
                            break;
                        }
                    }
                } else {
                    this.outputStreamWrite((byte)character, os);
                }
            }
            ++x;
        }
    }

    public void node(Node node, NamespaceResolver namespaceResolver) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String resolverPfx = null;
            if (this.getNamespaceResolver() != null) {
                resolverPfx = this.getNamespaceResolver().resolveNamespaceURI(attr.getNamespaceURI());
            }
            if (resolverPfx != null) {
                this.attribute(attr.getNamespaceURI(), "", String.valueOf(resolverPfx) + ':' + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(attr.getNamespaceURI(), "", attr.getName(), attr.getNodeValue());
                if (attr.getNamespaceURI() != null) {
                    this.namespaceDeclaration(attr.getPrefix(), attr.getNamespaceURI());
                    this.getNamespaceResolver().put(attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else if (node.getNodeType() == 3) {
            this.characters(node.getNodeValue());
        } else {
            try {
                OutputStreamRecordContentHandler handler = new OutputStreamRecordContentHandler();
                XMLFragmentReader xfragReader = new XMLFragmentReader(namespaceResolver);
                xfragReader.setContentHandler(handler);
                xfragReader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
                xfragReader.parse(node);
            }
            catch (SAXException sex) {
                throw XMLMarshalException.marshalException(sex);
            }
        }
    }

    public void flush() {
        try {
            this.outputStream.write(this.buffer, 0, this.bufferIndex);
            this.bufferIndex = 0;
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    protected void outputStreamWrite(byte[] bytes) {
        this.outputStreamWrite(bytes, this.outputStream);
    }

    protected void outputStreamWrite(byte[] bytes, OutputStream os) {
        if (os != this.outputStream) {
            try {
                os.write(bytes);
                return;
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }
        int bytesLength = bytes.length;
        if (this.bufferIndex + bytesLength >= 512) {
            try {
                os.write(this.buffer, 0, this.bufferIndex);
                this.bufferIndex = 0;
                if (bytesLength > 512) {
                    os.write(bytes);
                    return;
                }
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }
        System.arraycopy(bytes, 0, this.buffer, this.bufferIndex, bytes.length);
        this.bufferIndex += bytesLength;
    }

    protected void outputStreamWrite(byte aByte) {
        this.outputStreamWrite(aByte, this.outputStream);
    }

    protected void outputStreamWrite(byte aByte, OutputStream os) {
        if (os != this.outputStream) {
            try {
                os.write(aByte);
                return;
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }
        if (this.bufferIndex == 512) {
            try {
                os.write(this.buffer, 0, 512);
                this.bufferIndex = 0;
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }
        this.buffer[this.bufferIndex++] = aByte;
    }

    protected class OutputStreamRecordContentHandler
    implements ExtendedContentHandler,
    LexicalHandler {
        Map<String, String> prefixMappings = new HashMap<String, String>();

        OutputStreamRecordContentHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            try {
                if (OutputStreamRecord.this.isStartElementOpen) {
                    OutputStreamRecord.this.outputStreamWrite(CLOSE_ELEMENT);
                }
                OutputStreamRecord.this.outputStreamWrite(OPEN_START_ELEMENT);
                OutputStreamRecord.this.outputStreamWrite(qName.getBytes("UTF-8"));
                OutputStreamRecord.this.isStartElementOpen = true;
                this.handleAttributes(atts);
                this.writePrefixMappings();
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            try {
                if (OutputStreamRecord.this.isStartElementOpen) {
                    OutputStreamRecord.this.outputStreamWrite((byte)47);
                    OutputStreamRecord.this.outputStreamWrite((byte)62);
                } else {
                    OutputStreamRecord.this.outputStreamWrite((byte)60);
                    OutputStreamRecord.this.outputStreamWrite((byte)47);
                    OutputStreamRecord.this.outputStreamWrite(qName.getBytes("UTF-8"));
                    OutputStreamRecord.this.outputStreamWrite(CLOSE_ELEMENT);
                }
                OutputStreamRecord.this.isStartElementOpen = false;
            }
            catch (UnsupportedEncodingException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            String namespaceUri = OutputStreamRecord.this.getNamespaceResolver().resolveNamespacePrefix(prefix);
            if (namespaceUri == null || !namespaceUri.equals(uri)) {
                this.prefixMappings.put(prefix, uri);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            String characters = new String(ch, start, length);
            this.characters(characters);
        }

        public void characters(CharSequence characters) throws SAXException {
            if (OutputStreamRecord.this.isProcessingCData) {
                OutputStreamRecord.this.cdata(characters.toString());
                return;
            }
            if (OutputStreamRecord.this.isStartElementOpen) {
                OutputStreamRecord.this.outputStreamWrite(CLOSE_ELEMENT);
                OutputStreamRecord.this.isStartElementOpen = false;
            }
            OutputStreamRecord.this.writeValue(characters.toString(), true);
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            if (OutputStreamRecord.this.isStartElementOpen) {
                OutputStreamRecord.this.outputStreamWrite(CLOSE_ELEMENT);
                OutputStreamRecord.this.isStartElementOpen = false;
            }
            this.writeComment(ch, start, length);
        }

        public void startCDATA() throws SAXException {
            OutputStreamRecord.this.isProcessingCData = true;
        }

        public void endCDATA() throws SAXException {
            OutputStreamRecord.this.isProcessingCData = false;
        }

        protected void writePrefixMappings() {
            try {
                if (!this.prefixMappings.isEmpty()) {
                    for (String prefix : this.prefixMappings.keySet()) {
                        OutputStreamRecord.this.outputStreamWrite(SPACE);
                        OutputStreamRecord.this.outputStreamWrite("xmlns".getBytes("UTF-8"));
                        if (prefix != null && prefix.length() > 0) {
                            OutputStreamRecord.this.outputStreamWrite((byte)58);
                            OutputStreamRecord.this.outputStreamWrite(prefix.getBytes("UTF-8"));
                        }
                        OutputStreamRecord.this.outputStreamWrite((byte)61);
                        OutputStreamRecord.this.outputStreamWrite((byte)34);
                        String uri = this.prefixMappings.get(prefix);
                        if (uri != null) {
                            OutputStreamRecord.this.outputStreamWrite(this.prefixMappings.get(prefix).getBytes("UTF-8"));
                        }
                        OutputStreamRecord.this.outputStreamWrite(CLOSE_ATTRIBUTE_VALUE);
                    }
                    this.prefixMappings.clear();
                }
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        protected void handleAttributes(Attributes atts) {
            int i = 0;
            int attsLength = atts.getLength();
            while (i < attsLength) {
                String qName = atts.getQName(i);
                if (qName == null || !qName.startsWith("xmlns:") && !qName.equals("xmlns")) {
                    OutputStreamRecord.this.attribute(atts.getURI(i), atts.getLocalName(i), qName, atts.getValue(i));
                }
                ++i;
            }
        }

        protected void writeComment(char[] chars, int start, int length) {
            OutputStreamRecord.this.outputStreamWrite(OPEN_COMMENT);
            OutputStreamRecord.this.writeValue(new String(chars, start, length), false);
            OutputStreamRecord.this.outputStreamWrite(CLOSE_COMMENT);
        }

        protected void writeCharacters(char[] chars, int start, int length) {
            OutputStreamRecord.this.writeValue(new String(chars, start, length), true);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void startEntity(String name) throws SAXException {
        }

        public void endEntity(String name) throws SAXException {
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        public void endDTD() throws SAXException {
        }
    }
}

