/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.dcn;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.jdbc.OracleStatement;
import oracle.jdbc.dcn.DatabaseChangeEvent;
import oracle.jdbc.dcn.DatabaseChangeListener;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.jdbc.dcn.RowChangeDescription;
import oracle.jdbc.dcn.TableChangeDescription;
import oracle.jdbc.driver.OracleConnection;
import org.eclipse.persistence.annotations.DatabaseChangeNotificationType;
import org.eclipse.persistence.descriptors.CacheIndex;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventAdapter;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.platform.database.events.DatabaseEventListener;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sessions.Session;

public class OracleChangeNotificationListener
implements DatabaseEventListener {
    public static String ORA_TRANSACTION_ID = "oracle.dcn.transaction-id";
    public static String ROWID = "ROWID";
    protected DatabaseChangeRegistration register;
    protected Map<DatabaseTable, ClassDescriptor> descriptorsByTable;
    protected ValueReadQuery transactionIdQuery = new ValueReadQuery("SELECT DBMS_TRANSACTION.LOCAL_TRANSACTION_ID FROM DUAL");

    public OracleChangeNotificationListener() {
        this.transactionIdQuery.setName(ORA_TRANSACTION_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Session session) {
        final AbstractSession databaseSession = (AbstractSession)session;
        this.descriptorsByTable = new HashMap<DatabaseTable, ClassDescriptor>();
        for (ClassDescriptor descriptor : session.getDescriptors().values()) {
            if (descriptor.getTables().isEmpty() || descriptor.getCachePolicy().getDatabaseChangeNotificationType() == null || descriptor.getCachePolicy().getDatabaseChangeNotificationType() == DatabaseChangeNotificationType.NONE) continue;
            this.descriptorsByTable.put(descriptor.getTables().get(0), descriptor);
        }
        Accessor accessor = databaseSession.getAccessor();
        accessor.incrementCallCount(databaseSession);
        try {
            OracleConnection connection = (OracleConnection)databaseSession.getServerPlatform().unwrapConnection(accessor.getConnection());
            databaseSession.log(1, "connection", "dcn_registering");
            Properties properties = new Properties();
            properties.setProperty("DCN_NOTIFY_ROWIDS", "true");
            properties.setProperty("DCN_IGNORE_INSERTOP", "true");
            try {
                this.register = connection.registerDatabaseChangeNotification(properties);
                final ArrayList<DatabaseField> fields = new ArrayList<DatabaseField>();
                fields.add(new DatabaseField(ROWID));
                this.register.addListener(new DatabaseChangeListener(){

                    public void onDatabaseChangeNotification(DatabaseChangeEvent changeEvent) {
                        databaseSession.log(1, "connection", "dcn_change_event", changeEvent);
                        if (changeEvent.getTableChangeDescription() != null) {
                            for (TableChangeDescription tableChange : changeEvent.getTableChangeDescription()) {
                                ClassDescriptor descriptor = OracleChangeNotificationListener.this.descriptorsByTable.get(new DatabaseTable(tableChange.getTableName()));
                                if (descriptor == null) continue;
                                CacheIndex index = descriptor.getCachePolicy().getCacheIndex(fields);
                                for (RowChangeDescription rowChange : tableChange.getRowChangeDescription()) {
                                    CacheId id = new CacheId(new Object[]{rowChange.getRowid().stringValue()});
                                    CacheKey key = databaseSession.getIdentityMapAccessorInstance().getIdentityMapManager().getCacheKeyByIndex(index, id, true, descriptor);
                                    if (key == null || key.getTransactionId() != null && key.getTransactionId().equals(changeEvent.getTransactionId(true))) continue;
                                    databaseSession.log(1, "connection", "dcn_invalidate", key.getKey(), descriptor.getJavaClass().getName());
                                    key.setInvalidationState(-1);
                                }
                            }
                        }
                    }
                });
                for (DatabaseTable table : this.descriptorsByTable.keySet()) {
                    OracleStatement statement = (OracleStatement)connection.createStatement();
                    statement.setDatabaseChangeRegistration(this.register);
                    try {
                        statement.executeQuery("SELECT ROWID FROM " + table.getQualifiedName()).close();
                        databaseSession.log(1, "connection", "dcn_register_table", table.getQualifiedName());
                    }
                    catch (Exception failed) {
                        databaseSession.logThrowable(6, "sql", failed);
                    }
                    finally {
                        statement.close();
                    }
                }
            }
            catch (SQLException exception) {
                throw DatabaseException.sqlException(exception, databaseSession.getAccessor(), databaseSession, false);
            }
        }
        finally {
            accessor.decrementCallCount();
        }
    }

    @Override
    public void initialize(final ClassDescriptor descriptor, AbstractSession session) {
        if (descriptor.getOptimisticLockingPolicy() == null) {
            boolean requiresLocking = descriptor.hasMultipleTables();
            for (DatabaseMapping mapping : descriptor.getMappings()) {
                if (!mapping.isCollectionMapping()) continue;
                requiresLocking = true;
            }
            if (requiresLocking) {
                session.log(6, "metadata", "locking_required_for_database_change_notification", descriptor.getJavaClass());
            }
        }
        DatabaseField rowId = descriptor.buildField(new DatabaseField(ROWID));
        ArrayList<DatabaseField> fields = new ArrayList<DatabaseField>();
        fields.add(rowId);
        CacheIndex existingIndex = descriptor.getCachePolicy().getCacheIndex(fields);
        if (existingIndex == null) {
            if (descriptor.isChildDescriptor()) {
                existingIndex = descriptor.getInheritancePolicy().getRootParentDescriptor().getCachePolicy().getCacheIndex(fields);
            }
            if (existingIndex == null) {
                existingIndex = new CacheIndex(fields);
                existingIndex.setIsUpdatable(false);
                existingIndex.setIsInsertable(false);
            }
            descriptor.getCachePolicy().addCacheIndex(existingIndex);
        }
        final CacheIndex index = existingIndex;
        rowId.setInsertable(false);
        rowId.setUpdatable(false);
        rowId.setCreatable(false);
        descriptor.getFields().add(rowId);
        descriptor.getAllFields().add(rowId);
        final ValueReadQuery rowIdQuery = new ValueReadQuery();
        rowIdQuery.setName(ROWID);
        SQLSelectStatement sqlStatement = new SQLSelectStatement();
        sqlStatement.setWhereClause(descriptor.getObjectBuilder().getPrimaryKeyExpression());
        sqlStatement.addField(rowId);
        sqlStatement.addTable(descriptor.getTables().get(0));
        rowIdQuery.setSQLStatement(sqlStatement);
        sqlStatement.normalize(session, null);
        descriptor.getEventManager().addListener(new DescriptorEventAdapter(){

            @Override
            public void postMerge(DescriptorEvent event) {
                if (event.getChangeSet() != null && event.getChangeSet().hasChanges()) {
                    Object id = event.getChangeSet().getId();
                    CacheKey cacheKey = event.getChangeSet().getActiveCacheKey();
                    if (cacheKey == null) {
                        cacheKey = event.getSession().getParent().getIdentityMapAccessorInstance().getIdentityMapManager().getCacheKeyForObject(id, descriptor.getJavaClass(), descriptor, false);
                    }
                    cacheKey.setTransactionId(event.getSession().getProperty(ORA_TRANSACTION_ID));
                    if (event.getChangeSet().isNew()) {
                        AbstractRecord row = descriptor.getObjectBuilder().buildRowFromPrimaryKeyValues(id, event.getSession());
                        Object rowid = event.getSession().executeQuery((DatabaseQuery)rowIdQuery, row);
                        CacheId indexValue = new CacheId(new Object[]{rowid});
                        event.getSession().getParent().getIdentityMapAccessorInstance().getIdentityMapManager().putCacheKeyByIndex(index, indexValue, cacheKey, descriptor);
                    }
                }
            }

            @Override
            public void postUpdate(DescriptorEvent event) {
                Object txId = event.getSession().getProperty(ORA_TRANSACTION_ID);
                if (txId == null) {
                    txId = event.getSession().executeQuery(OracleChangeNotificationListener.this.transactionIdQuery);
                    event.getSession().setProperty(ORA_TRANSACTION_ID, txId);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Session session) {
        if (this.register == null) {
            return;
        }
        AbstractSession databaseSession = (AbstractSession)session;
        Accessor accessor = databaseSession.getAccessor();
        accessor.incrementCallCount(databaseSession);
        try {
            OracleConnection connection = (OracleConnection)databaseSession.getServerPlatform().unwrapConnection(accessor.getConnection());
            databaseSession.log(1, "connection", "dcn_unregister");
            try {
                connection.unregisterDatabaseChangeNotification(this.register);
            }
            catch (SQLException exception) {
                throw DatabaseException.sqlException(exception, databaseSession.getAccessor(), databaseSession, false);
            }
        }
        finally {
            accessor.decrementCallCount();
        }
    }

    public DatabaseChangeRegistration getRegister() {
        return this.register;
    }

    protected void setRegister(DatabaseChangeRegistration register) {
        this.register = register;
    }

    public Map<DatabaseTable, ClassDescriptor> getDescriptorsByTable() {
        return this.descriptorsByTable;
    }

    protected void setDescriptorsByTable(Map<DatabaseTable, ClassDescriptor> descriptorsByTable) {
        this.descriptorsByTable = descriptorsByTable;
    }
}

