/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkNodeManager;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;

final class SaveAllAction
extends AbstractFrameworkAction {
    private FrameworkNodeManager nodeManager;
    private ListValueModel projectNodesHolder;
    private ListChangeListener projectNodesListener;
    private WindowListener windowListener;

    SaveAllAction(WorkbenchContext context, FrameworkNodeManager nodeManager) {
        super(context);
        this.initialize(nodeManager);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.initializeTextAndMnemonic("file.saveAll");
        this.initializeIcon("file.saveAll");
        this.initializeToolTipText("file.saveAll.toolTipText");
        this.initializeAccelerator("file.saveAll.ACCELERATOR");
    }

    private void initialize(FrameworkNodeManager frameworkNodeManager) {
        this.nodeManager = frameworkNodeManager;
        this.projectNodesHolder = this.buildDirtyProjectNodesAdapter();
        this.projectNodesListener = this.buildProjectNodesListener();
        this.projectNodesHolder.addListChangeListener("value", this.projectNodesListener);
        this.windowListener = this.buildWorkbenchWindowListener();
        this.currentWindow().addWindowListener(this.windowListener);
        this.updateEnabledState();
    }

    private ListValueModel buildDirtyProjectNodesAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildProjectNodesAdapter(), "dirty");
    }

    private CollectionValueModel buildProjectNodesAdapter() {
        return new CollectionAspectAdapter("projectNodes", (Model)this.nodeManager){

            @Override
            protected Iterator getValueFromSubject() {
                return ((FrameworkNodeManager)this.subject).projectNodes();
            }

            @Override
            protected int sizeFromSubject() {
                return ((FrameworkNodeManager)this.subject).projectNodesSize();
            }
        };
    }

    private ListChangeListener buildProjectNodesListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent e) {
                SaveAllAction.this.updateEnabledState();
            }

            public void itemsRemoved(ListChangeEvent e) {
                SaveAllAction.this.updateEnabledState();
            }

            public void itemsReplaced(ListChangeEvent e) {
                SaveAllAction.this.updateEnabledState();
            }

            public void listChanged(ListChangeEvent e) {
                SaveAllAction.this.updateEnabledState();
            }
        };
    }

    private WindowListener buildWorkbenchWindowListener() {
        return new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                SaveAllAction.this.workbenchWindowClosed();
            }
        };
    }

    void updateEnabledState() {
        if (this.nodeManager.projectNodesSize() == 0) {
            this.setEnabled(false);
            return;
        }
        Iterator stream = this.nodeManager.projectNodes();
        while (stream.hasNext()) {
            if (!((ApplicationNode)stream.next()).isDirty()) continue;
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    @Override
    protected void execute() {
        this.nodeManager.saveAll(this.getWorkbenchContext());
    }

    void workbenchWindowClosed() {
        this.projectNodesHolder.removeListChangeListener("value", this.projectNodesListener);
        this.currentWindow().removeWindowListener(this.windowListener);
    }
}

