/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.FromSubSelectExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.querykeys.DirectQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.ReportQuery;

public class FromAliasExpression
extends QueryKeyExpression {
    protected ReportItem item;
    protected ClassDescriptor containingDescriptor;

    public FromAliasExpression() {
    }

    public FromAliasExpression(String name, Expression base) {
        super(name, base);
    }

    public String descriptionOfNodeType() {
        return "From Alias";
    }

    public QueryKey getQueryKeyOrNull() {
        if (!this.hasQueryKey) {
            return null;
        }
        if (this.getContainingDescriptor() == null) {
            DirectQueryKey alias = new DirectQueryKey();
            alias.setField(new DatabaseField(this.name));
            ReportQuery subQuery = ((FromSubSelectExpression)this.getBaseExpression()).getSubSelect().getSubQuery();
            alias.setDescriptor(subQuery.getDescriptor());
            this.queryKey = alias;
            return alias;
        }
        return super.getQueryKeyOrNull();
    }

    public ClassDescriptor getContainingDescriptor() {
        AbstractSession session = this.getBuilder().getSession();
        if (this.containingDescriptor == null) {
            Expression expression = this.getItem().getAttributeExpression();
            if (expression.isQueryKeyExpression()) {
                if (expression.getBuilder().getSession() == null) {
                    expression.getBuilder().setSession(session);
                }
                this.containingDescriptor = ((QueryKeyExpression)expression).getContainingDescriptor();
                return this.containingDescriptor;
            }
            return null;
        }
        return this.containingDescriptor;
    }

    public ReportItem getItem() {
        if (this.item == null) {
            ReportQuery subQuery = ((FromSubSelectExpression)this.getBaseExpression()).getSubSelect().getSubQuery();
            this.item = subQuery.getItem(this.name);
            if (this.item == null) {
                throw QueryException.invalidQueryKeyInExpression(this.name);
            }
        }
        return this.item;
    }
}

