/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.util;

import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.internal.weaving.RelationshipInfo;
import org.eclipse.persistence.jaxb.metadata.MetadataSource;
import org.eclipse.persistence.jaxb.xmlmodel.JavaType;
import org.eclipse.persistence.jaxb.xmlmodel.ObjectFactory;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter;
import org.eclipse.persistence.jaxb.xmlmodel.XmlRootElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlSchema;
import org.eclipse.persistence.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.jpa.rs.util.LinkAdapter;
import org.eclipse.persistence.jpa.rs.util.RelationshipLinkAdapter;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.sessions.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicXMLMetadataSource
implements MetadataSource {
    private static final String LINK_NAMESPACE_URI = "http://www.w3.org/2005/Atom";
    private static final String LINK_PREFIX = "atom";
    private static final String LINK_LOCAL_NAME = "link";
    private XmlBindings xmlBindings;

    public DynamicXMLMetadataSource(Server session, String packageName) {
        ObjectFactory objectFactory = new ObjectFactory();
        this.xmlBindings = new XmlBindings();
        this.xmlBindings.setPackageName(packageName);
        XmlBindings.JavaTypes javaTypes = new XmlBindings.JavaTypes();
        this.xmlBindings.setJavaTypes(javaTypes);
        XmlSchema xmlSchema = new XmlSchema();
        XmlSchema.XmlNs atomNs = new XmlSchema.XmlNs();
        atomNs.setPrefix(LINK_PREFIX);
        atomNs.setNamespaceUri(LINK_NAMESPACE_URI);
        xmlSchema.getXmlNs().add(atomNs);
        this.xmlBindings.setXmlSchema(xmlSchema);
        for (ClassDescriptor ormDescriptor : session.getProject().getOrderedDescriptors()) {
            String descriptorPackageName = "";
            if (ormDescriptor.getJavaClassName().lastIndexOf(46) > 0) {
                descriptorPackageName = ormDescriptor.getJavaClassName().substring(0, ormDescriptor.getJavaClassName().lastIndexOf(46));
            }
            if (!descriptorPackageName.equals(packageName)) continue;
            javaTypes.getJavaType().add(this.createJAXBType(ormDescriptor, objectFactory));
        }
    }

    private JavaType createJAXBType(ClassDescriptor classDescriptor, ObjectFactory objectFactory) {
        JavaType javaType = new JavaType();
        javaType.setName(classDescriptor.getAlias());
        javaType.setJavaAttributes(new JavaType.JavaAttributes());
        boolean isDynamic = DynamicEntity.class.isAssignableFrom(classDescriptor.getJavaClass());
        for (DatabaseMapping ormMapping : classDescriptor.getMappings()) {
            JAXBElement<XmlElement> element = this.createJAXBProperty(ormMapping, objectFactory, isDynamic);
            if (element == null) continue;
            javaType.getJavaAttributes().getJavaAttribute().add(element);
        }
        if (isDynamic) {
            javaType.getJavaAttributes().getJavaAttribute().add(DynamicXMLMetadataSource.createSelfProperty(classDescriptor.getJavaClassName(), objectFactory));
            javaType.getJavaAttributes().getJavaAttribute().add(DynamicXMLMetadataSource.createRelationshipsProperty(classDescriptor.getJavaClassName(), objectFactory));
        }
        javaType.setXmlRootElement(new XmlRootElement());
        return javaType;
    }

    private JAXBElement<XmlElement> createJAXBProperty(DatabaseMapping mapping, ObjectFactory objectFactory, boolean isDynamic) {
        if (!isDynamic && (mapping.isPrivateOwned() || !mapping.isObjectReferenceMapping() && !mapping.isCollectionMapping())) {
            return null;
        }
        XmlElement xmlElement = new XmlElement();
        xmlElement.setJavaAttribute(mapping.getAttributeName());
        if (mapping.isObjectReferenceMapping()) {
            xmlElement.setType(((ObjectReferenceMapping)mapping).getReferenceClassName());
            if (!mapping.isPrivateOwned()) {
                xmlElement.setReadOnly(Boolean.valueOf(true));
            }
        } else if (mapping.isCollectionMapping()) {
            xmlElement.setType(((CollectionMapping)mapping).getReferenceClassName());
            if (!mapping.isPrivateOwned()) {
                xmlElement.setReadOnly(Boolean.valueOf(true));
            }
        } else {
            xmlElement.setType(mapping.getAttributeClassification().getName());
        }
        return objectFactory.createXmlElement(xmlElement);
    }

    public static JAXBElement<XmlElement> createSelfProperty(String ownerClassName, ObjectFactory objectFactory) {
        XmlElement xmlElement = new XmlElement();
        xmlElement.setJavaAttribute("self");
        xmlElement.setType(ownerClassName);
        DynamicXMLMetadataSource.addXmlAdapter(xmlElement);
        return objectFactory.createXmlElement(xmlElement);
    }

    public static JAXBElement<XmlElement> createRelationshipsProperty(String ownerClassName, ObjectFactory objectFactory) {
        XmlElement xmlElement = new XmlElement();
        xmlElement.setJavaAttribute("_persistence_relationshipInfo");
        xmlElement.setName("relationships");
        xmlElement.setType(RelationshipInfo.class.getName());
        xmlElement.setContainerType(List.class.getName());
        xmlElement.setWriteOnly(Boolean.valueOf(true));
        XmlJavaTypeAdapter adapter = new XmlJavaTypeAdapter();
        adapter.setValue(RelationshipLinkAdapter.class.getName());
        adapter.setValueType(Link.class.getName());
        adapter.setType(xmlElement.getType());
        xmlElement.setXmlJavaTypeAdapter(adapter);
        return objectFactory.createXmlElement(xmlElement);
    }

    public static void addXmlAdapter(XmlElement xmlElement) {
        xmlElement.setXmlPath(String.valueOf(xmlElement.getJavaAttribute()) + "/" + LINK_PREFIX + ":" + LINK_LOCAL_NAME + "[@rel='" + xmlElement.getJavaAttribute() + "']/@href");
        XmlJavaTypeAdapter adapter = new XmlJavaTypeAdapter();
        adapter.setValue(LinkAdapter.class.getName());
        adapter.setValueType(String.class.getName());
        adapter.setType(xmlElement.getType());
        xmlElement.setXmlJavaTypeAdapter(adapter);
    }

    public XmlBindings getXmlBindings(Map<String, ?> properties, ClassLoader classLoader) {
        return this.xmlBindings;
    }
}

