/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.dynamic;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.dynamic.DynamicTypeBuilder;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.internal.dynamic.DynamicPropertiesManager;
import org.eclipse.persistence.internal.dynamic.DynamicTypeImpl;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.tools.schemaframework.DynamicSchemaManager;

public class DynamicHelper {
    protected DatabaseSession session;
    protected Map<String, ClassDescriptor> fqClassnameToDescriptor = new HashMap<String, ClassDescriptor>();

    public DynamicHelper(DatabaseSession session) {
        this.session = session;
        Collection<ClassDescriptor> descriptors = session.getDescriptors().values();
        for (ClassDescriptor desc : descriptors) {
            if (desc.getJavaClassName() == null) continue;
            this.fqClassnameToDescriptor.put(desc.getJavaClassName(), desc);
        }
    }

    public DatabaseSession getSession() {
        return this.session;
    }

    public DynamicType getType(String typeName) {
        ClassDescriptor cd = this.fqClassnameToDescriptor.get(typeName);
        if (cd == null) {
            cd = this.getSession().getClassDescriptorForAlias(typeName);
        }
        if (cd == null) {
            return null;
        }
        return DynamicHelper.getType(cd);
    }

    public static DynamicType getType(ClassDescriptor descriptor) {
        return (DynamicType)descriptor.getProperty("ENTITY_TYPE");
    }

    public static DynamicType getType(DynamicEntity entity) throws ClassCastException {
        return ((DynamicEntityImpl)entity).getType();
    }

    public void removeType(String typeName) {
        DynamicType type = this.getType(typeName);
        if (type != null) {
            this.getSession().getIdentityMapAccessor().initializeIdentityMap(type.getJavaClass());
            ClassDescriptor descriptor = type.getDescriptor();
            this.fqClassnameToDescriptor.remove(descriptor.getJavaClassName());
            this.getSession().getProject().getOrderedDescriptors().remove(descriptor);
            this.getSession().getProject().getDescriptors().remove(type.getJavaClass());
            ((AbstractSession)((Object)this.getSession())).getCommitManager().getCommitOrder().remove(type.getJavaClass());
        }
    }

    public DynamicEntity newDynamicEntity(String typeName) {
        DynamicType type = this.getType(typeName);
        if (type == null) {
            throw new IllegalArgumentException("DynamicHelper.createQuery: Dynamic type not found: " + typeName);
        }
        return type.newDynamicEntity();
    }

    public ReadAllQuery newReadAllQuery(String typeName) {
        DynamicType type = this.getType(typeName);
        if (type == null) {
            throw new IllegalArgumentException("DynamicHelper.createQuery: Dynamic type not found: " + typeName);
        }
        return new ReadAllQuery(type.getJavaClass());
    }

    public ReadObjectQuery newReadObjectQuery(String typeName) {
        DynamicType type = this.getType(typeName);
        if (type == null) {
            throw new IllegalArgumentException("DynamicHelper.createQuery: Dynamic type not found: " + typeName);
        }
        return new ReadObjectQuery(type.getJavaClass());
    }

    public ReportQuery newReportQuery(String typeName, ExpressionBuilder builder) {
        DynamicType type = this.getType(typeName);
        if (type == null) {
            throw new IllegalArgumentException("DynamicHelper.createQuery: Dynamic type not found: " + typeName);
        }
        return new ReportQuery(type.getJavaClass(), builder);
    }

    public DynamicClassLoader getDynamicClassLoader() {
        return DynamicClassLoader.lookup(this.getSession());
    }

    public void addTypes(boolean createMissingTables, boolean generateFKConstraints, DynamicType ... types) {
        if (types == null || types.length == 0) {
            throw new IllegalArgumentException("No types provided");
        }
        ArrayList<ClassDescriptor> descriptors = new ArrayList<ClassDescriptor>(types.length);
        int index = 0;
        while (index < types.length) {
            DynamicType typ = types[index];
            ClassDescriptor desc = typ.getDescriptor();
            DynamicTypeImpl typImpl = (DynamicTypeImpl)typ;
            typImpl.setDescriptor(desc);
            try {
                Field dpmField = desc.getJavaClass().getField("DPM");
                DynamicPropertiesManager dpm = (DynamicPropertiesManager)dpmField.get(null);
                dpm.setType(typImpl);
                typImpl.setDynamicPropertiesManager(dpm);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            descriptors.add(desc);
            if (!types[index].getDescriptor().requiresInitialization((AbstractSession)((Object)this.session))) {
                types[index].getDescriptor().getInstantiationPolicy().initialize((AbstractSession)((Object)this.session));
            }
            ++index;
        }
        this.session.addDescriptors(descriptors);
        for (ClassDescriptor desc : descriptors) {
            if (desc.getJavaClassName() == null) continue;
            this.fqClassnameToDescriptor.put(desc.getJavaClassName(), desc);
        }
        if (createMissingTables) {
            if (!this.getSession().isConnected()) {
                this.getSession().login();
            }
            new DynamicSchemaManager(this.session).createTables(generateFKConstraints, types);
        }
    }

    public static class SessionCustomizer
    implements org.eclipse.persistence.config.SessionCustomizer {
        public void customize(Session session) throws Exception {
            DynamicClassLoader dcl = DynamicClassLoader.lookup(session);
            Iterator<ClassDescriptor> i = session.getProject().getDescriptors().values().iterator();
            while (i.hasNext()) {
                new DynamicTypeBuilder(dcl, i.next(), null);
            }
        }
    }
}

