/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.Singleton;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.jpa.Archive;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.util.InMemoryArchive;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class PersistenceFactory {
    private Map<String, PersistenceContext> dynamicPersistenceContexts = new HashMap<String, PersistenceContext>();

    public PersistenceContext bootstrapPersistenceContext(String name, String persistenceXML, Map<String, ?> originalProperties, boolean replace) {
        ByteArrayInputStream stream = new ByteArrayInputStream(persistenceXML.getBytes());
        InMemoryArchive archive = new InMemoryArchive(stream);
        return this.bootstrapPersistenceContext(name, (Archive)archive, null, originalProperties, replace);
    }

    public PersistenceContext bootstrapPersistenceContext(String name, URL persistenceXMLURL, Map<String, ?> originalProperties, boolean replace) throws IOException {
        InMemoryArchive archive = new InMemoryArchive(persistenceXMLURL.openStream());
        return this.bootstrapPersistenceContext(name, (Archive)archive, persistenceXMLURL.toString(), originalProperties, replace);
    }

    public PersistenceContext bootstrapPersistenceContext(String name, InputStream persistenceXMLStream, Map<String, ?> originalProperties, boolean replace) {
        InMemoryArchive archive = new InMemoryArchive(persistenceXMLStream);
        return this.bootstrapPersistenceContext(name, (Archive)archive, null, originalProperties, replace);
    }

    public PersistenceContext bootstrapPersistenceContext(String name, Archive archive, String persistenceXMLLocation, Map<String, ?> originalProperties, boolean replace) {
        PersistenceContext persistenceContext = this.getDynamicPersistenceContext(name);
        if (persistenceContext == null || replace) {
            DynamicClassLoader dcl = new DynamicClassLoader(Thread.currentThread().getContextClassLoader());
            Map<String, Object> properties = PersistenceFactory.createProperties(dcl, originalProperties);
            properties.putAll(originalProperties);
            persistenceContext = new PersistenceContext(archive, properties, (ClassLoader)dcl);
            this.dynamicPersistenceContexts.put(name, persistenceContext);
        }
        return persistenceContext;
    }

    public PersistenceContext bootstrapPersistenceContext(String name, EntityManagerFactory emf, URI baseURI, boolean replace) {
        PersistenceContext persistenceContext = new PersistenceContext(name, (EntityManagerFactoryImpl)emf, baseURI);
        persistenceContext.setBaseURI(baseURI);
        return persistenceContext;
    }

    public void closePersistenceContext(String name) {
        PersistenceContext context = this.dynamicPersistenceContexts.get(name);
        if (context != null) {
            context.getEmf().close();
            this.dynamicPersistenceContexts.remove(name);
        }
    }

    public void close() {
        for (String key : this.dynamicPersistenceContexts.keySet()) {
            this.dynamicPersistenceContexts.get(key).stop();
        }
    }

    protected static Map<String, Object> createProperties(DynamicClassLoader dcl, Map<String, ?> originalProperties) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("eclipselink.classloader", dcl);
        properties.put("eclipselink.weaving", "static");
        for (Map.Entry<String, ?> entry : originalProperties.entrySet()) {
            if (!entry.getKey().startsWith("javax") && !entry.getKey().startsWith("eclipselink.log") && !entry.getKey().startsWith("eclipselink.target-server")) continue;
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    public PersistenceContext get(String persistenceUnit, URI defaultURI, Map<String, Object> initializationProperties) {
        PersistenceContext app = this.getDynamicPersistenceContext(persistenceUnit);
        if (app == null) {
            try {
                EntityManagerFactory factory;
                DynamicClassLoader dcl = new DynamicClassLoader(Thread.currentThread().getContextClassLoader());
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("eclipselink.classloader", dcl);
                if (initializationProperties != null) {
                    properties.putAll(initializationProperties);
                }
                if ((factory = Persistence.createEntityManagerFactory((String)persistenceUnit, properties)) != null) {
                    app = this.bootstrapPersistenceContext(persistenceUnit, factory, defaultURI, true);
                }
            }
            catch (Exception e) {
                JPARSLogger.fine("exception_creating_persistence_context", new Object[]{persistenceUnit, e.toString()});
            }
        } else if (app.getBaseURI() == null) {
            app.setBaseURI(defaultURI);
        }
        return app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistenceContext getDynamicPersistenceContext(String name) {
        PersistenceFactory persistenceFactory = this;
        synchronized (persistenceFactory) {
            return this.dynamicPersistenceContexts.get(name);
        }
    }

    public Set<String> getPersistenceContextNames() {
        HashSet<String> contextNames = new HashSet<String>();
        contextNames.addAll(this.dynamicPersistenceContexts.keySet());
        try {
            Set archives = PersistenceUnitProcessor.findPersistenceArchives();
            for (Archive archive : archives) {
                List infos = PersistenceUnitProcessor.processPersistenceArchive((Archive)archive, (ClassLoader)Thread.currentThread().getContextClassLoader());
                for (SEPersistenceUnitInfo info : infos) {
                    if (info.getPersistenceUnitName().equals("jpa-rs")) continue;
                    contextNames.add(info.getPersistenceUnitName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contextNames;
    }
}

