/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.TableCreator;

public class TogglingFastTableCreator
extends TableCreator {
    protected static Set fastTableCreators = new HashSet();
    protected static boolean useFastTableCreatorAfterInitialCreate = Boolean.getBoolean("eclipselink.test.toggle-fast-table-creator");

    public TogglingFastTableCreator() {
    }

    public TogglingFastTableCreator(Vector tableDefinitions) {
        super((List)tableDefinitions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceTables(DatabaseSession session) {
        session.getSessionLog().log(1, "TogglingFastTableCreator: useFastTableCreatorAfterInitialCreate: " + useFastTableCreatorAfterInitialCreate);
        boolean isFirstCreate = !this.isFastTableCreator();
        boolean orig_FAST_TABLE_CREATOR = SchemaManager.FAST_TABLE_CREATOR;
        session.getSessionLog().log(1, "TogglingFastTableCreator: " + this.getTableCreatorName() + " - isFirstCreate: " + isFirstCreate);
        session.getSessionLog().log(1, "TogglingFastTableCreator: Current fastTableCreators: " + fastTableCreators);
        if (useFastTableCreatorAfterInitialCreate && !isFirstCreate) {
            SchemaManager.FAST_TABLE_CREATOR = true;
            session.getSessionLog().log(1, "TogglingFastTableCreator: " + this.getTableCreatorName() + " - toggling true");
        }
        try {
            super.replaceTables(session);
        }
        finally {
            if (useFastTableCreatorAfterInitialCreate && !isFirstCreate) {
                SchemaManager.FAST_TABLE_CREATOR = orig_FAST_TABLE_CREATOR;
            }
        }
        if (useFastTableCreatorAfterInitialCreate) {
            this.setFastTableCreator();
            session.getSessionLog().log(1, "TogglingFastTableCreator: " + this.getTableCreatorName() + " added to fastTableCreators");
        }
    }

    public boolean resetFastTableCreator() {
        AbstractSessionLog.getLog().log(1, "TogglingFastTableCreator: removing table creator: " + this.getTableCreatorName());
        return fastTableCreators.remove(this.getTableCreatorName());
    }

    public boolean setFastTableCreator() {
        AbstractSessionLog.getLog().log(1, "TogglingFastTableCreator: adding table creator: " + this.getTableCreatorName());
        return fastTableCreators.add(this.getTableCreatorName());
    }

    public boolean isFastTableCreator() {
        return fastTableCreators.contains(this.getTableCreatorName());
    }

    public String getTableCreatorName() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

