/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.clientserver;

class FIFO {
    private int nTail;
    private int nHead;
    private int nCount;
    private int nSize;
    private Object[] objectArray;

    public FIFO(int nSize) {
        this.nSize = nSize;
        this.objectArray = new Object[nSize];
    }

    public boolean isFull() {
        return this.nCount == this.nSize;
    }

    public boolean isEmpty() {
        return this.nCount == 0;
    }

    public synchronized boolean insertTail(Object object) {
        if (!this.isFull() && object != null) {
            if (!this.isEmpty()) {
                this.nTail = this.next(this.nTail);
            } else if (this.nHead != this.nTail) {
                this.error();
            }
            if (this.objectArray[this.nTail] == null) {
                this.objectArray[this.nTail] = object;
                ++this.nCount;
                return true;
            }
            this.error();
            return false;
        }
        return false;
    }

    public synchronized Object removeHead() {
        Object head = null;
        if (!this.isEmpty()) {
            head = this.objectArray[this.nHead];
            if (head != null) {
                this.objectArray[this.nHead] = null;
                --this.nCount;
                if (!this.isEmpty()) {
                    this.nHead = this.next(this.nHead);
                }
            } else {
                this.error();
            }
        } else if (this.nHead != this.nTail) {
            this.error();
        }
        return head;
    }

    protected int next(int i) {
        return (i + 1) % this.nSize;
    }

    private void error() {
        System.out.println("FIFO error");
    }
}

