/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers;

import java.sql.Time;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.distributedservers.ComplexUpdateTest;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServer;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServersModel;

public class UpdateChangeObjectWithOptimisticLockTest
extends ComplexUpdateTest {
    public UpdateChangeObjectWithOptimisticLockTest() {
    }

    public UpdateChangeObjectWithOptimisticLockTest(Employee originalObject) {
        super(originalObject);
    }

    @Override
    protected void changeObject() {
        Employee employee = (Employee)this.workingCopy;
        employee.setNormalHours(new Time[2]);
        employee.setStartTime(Helper.timeFromHourMinuteSecond((int)1, (int)1, (int)1));
    }

    @Override
    protected void test() {
        this.changeObject();
        if (!this.getUnitOfWork().getParent().compareObjects(this.originalObject, this.objectToBeWritten)) {
            throw new TestErrorException("The original object was changed through changing the clone.");
        }
        this.getUnitOfWork().commit();
    }

    @Override
    protected void verify() {
        DatabaseSession remoteServer = ((DistributedServer)DistributedServersModel.getDistributedServers().get(0)).getDistributedSession();
        remoteServer.beginTransaction();
        UnitOfWork uow = remoteServer.acquireUnitOfWork();
        Employee remoteEmp = (Employee)uow.executeQuery((DatabaseQuery)this.query);
        remoteEmp.setLastName("newName" + System.currentTimeMillis());
        try {
            uow.commit();
        }
        catch (OptimisticLockException ex) {
            throw new TestErrorException("Failed to copy the version number to the remote system");
        }
        finally {
            remoteServer.rollbackTransaction();
        }
    }
}

