/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class CannotOverrideConnectedSequenceTest
extends AutoVerifyTestCase {
    Sequence originalSequence;
    Sequence newSequence;

    public CannotOverrideConnectedSequenceTest() {
        this.setDescription("Attempt to override connected sequence should fail - the old sequence should remain in place.");
    }

    public void setup() {
        if (!this.getSession().isConnected()) {
            throw new TestProblemException("This test requires the session to be connected.");
        }
        String seqName = this.getSession().getDescriptor(Employee.class).getSequenceNumberName();
        this.originalSequence = this.getSession().getPlatform().getSequence(seqName);
    }

    public void test() {
        this.newSequence = this.originalSequence.isTable() ? new NativeSequence(this.originalSequence.getName()) : new TableSequence(this.originalSequence.getName());
        this.getDatabaseSession().addSequence(this.newSequence);
    }

    public void verify() {
        Sequence sequence = this.getSession().getPlatform().getSequence(this.originalSequence.getName());
        if (sequence != this.originalSequence) {
            throw new TestErrorException("Connected sequence was overridden.");
        }
    }
}

