/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.feature.QueryTimeoutBatchTestCase;

public abstract class QueryTimeoutBatchDescriptorQueryManagerTest
extends QueryTimeoutBatchTestCase {
    @Override
    protected int getParentQueryTimeout() {
        return 2;
    }

    @Override
    protected int getChildQueryTimeout() {
        return -1;
    }

    @Override
    protected String getQuerySQLPostfix() {
        return ", SUM(e.address_id) as version from address e, address b, address b, address c, address c, address c, address b";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        UnitOfWork uow = null;
        try {
            uow = this.setupPlatform();
            this.initializeDatabase(uow);
            uow = this.getSession().acquireUnitOfWork();
            this.registerObjects(uow);
            this.verifyBefore(uow);
            uow.commit();
        }
        catch (Exception e) {
            if (e instanceof DatabaseException) {
                this.limitExceeded = true;
                this.vendorErrorCodeEncountered = ((DatabaseException)((Object)e)).getDatabaseErrorCode();
            }
        }
        finally {
            this.resetPlatform();
        }
    }

    @Override
    protected List<Employee> registerObjects(UnitOfWork uow) {
        ArrayList<Employee> objectListForEditing = new ArrayList<Employee>();
        Address address = null;
        Employee employee = null;
        for (int i = 0; i < this.getNumberOfInserts(); ++i) {
            address = new Address();
            address.setCity(new StringBuffer("city").append(i).toString());
            address.setProvince(new StringBuffer("province").append(i).toString());
            employee = new Employee();
            employee.setFirstName(new StringBuffer("first").append(i).toString());
            employee.setLastName(new StringBuffer("last").append(i).toString());
            employee.setAddress(address);
            uow.registerObject((Object)employee);
            objectListForEditing.add(employee);
            this.setDescriptorLevelQueryTimeout(uow.getDescriptor((Object)employee).getDescriptorQueryManager());
            this.setDescriptorLevelQueryTimeout(uow.getDescriptor((Object)address).getDescriptorQueryManager());
            this.setQueryLevelQueryTimeout(uow, employee);
            this.setQueryLevelQueryTimeout(uow, address);
            InsertObjectQuery query = new InsertObjectQuery();
            StringBuffer sBuffer = new StringBuffer(this.getQuerySQLPrefix());
            sBuffer.append(this.getCurrentIDSequence() + (long)i);
            sBuffer.append(this.getQuerySQLPostfix());
            query.setSQLString(sBuffer.toString());
            query.setQueryTimeout(this.getChildQueryTimeout());
            uow.getDescriptor((Object)employee).getDescriptorQueryManager().setInsertQuery(query);
        }
        return objectListForEditing;
    }

    @Override
    public void setDescriptorLevelQueryTimeout(DescriptorQueryManager queryManager) {
        queryManager.setQueryTimeout(this.getParentQueryTimeout());
    }

    @Override
    public void setQueryLevelQueryTimeout(UnitOfWork uow, Object object) {
    }
}

