/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps;

import java.math.BigDecimal;
import java.util.Vector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.WeakIdentityMap;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class CreateCacheKeyWeakIdentityMapTest
extends TestCase {
    protected Class originalIdentityMapClass;
    protected int originalIdentityMapSize;
    protected int querySize;

    public void reset() {
        this.getSession().getDescriptor(Employee.class).setIdentityMapClass(this.originalIdentityMapClass);
        this.getSession().getDescriptor(Employee.class).setIdentityMapSize(this.originalIdentityMapSize);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void setup() {
        this.originalIdentityMapClass = this.getSession().getDescriptor(Employee.class).getIdentityMapClass();
        this.originalIdentityMapSize = this.getSession().getDescriptor(Employee.class).getIdentityMapSize();
        this.getSession().getDescriptor(Employee.class).setIdentityMapClass(WeakIdentityMap.class);
        this.getSession().getDescriptor(Employee.class).setIdentityMapSize(10);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void test() {
        Vector<BigDecimal> primaryKeys = new Vector<BigDecimal>();
        primaryKeys.add(new BigDecimal(4));
        CacheKey cacheKey = this.getAbstractSession().getIdentityMapAccessorInstance().acquireDeferredLock(primaryKeys, Employee.class, this.getSession().getDescriptor(Employee.class));
        CacheKey cacheKey2 = this.getAbstractSession().getIdentityMapAccessorInstance().acquireDeferredLock(primaryKeys, Employee.class, this.getSession().getDescriptor(Employee.class));
        if (cacheKey != cacheKey2) {
            throw new TestErrorException("WeakIdentityMap failed to return same cachkey for successive calls for same primary key and class");
        }
        cacheKey.releaseDeferredLock();
        cacheKey2.releaseDeferredLock();
    }
}

