/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.mappings;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.annotations.CacheKeyType;
import org.eclipse.persistence.eis.mappings.EISMapping;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EISOneToOneMapping
extends ObjectReferenceMapping
implements EISMapping {
    protected Map sourceToTargetKeyFields;
    protected Map<DatabaseField, DatabaseField> targetToSourceKeyFields;
    protected boolean shouldVerifyDelete;
    protected transient Expression privateOwnedCriteria;

    public EISOneToOneMapping() {
        this.selectionQuery = new ReadObjectQuery();
        this.foreignKeyFields = NonSynchronizedVector.newInstance(1);
        this.sourceToTargetKeyFields = new HashMap(2);
        this.targetToSourceKeyFields = new HashMap<DatabaseField, DatabaseField>(2);
    }

    @Override
    public boolean isEISMapping() {
        return true;
    }

    @Override
    public boolean isOneToOneMapping() {
        return true;
    }

    public void addForeignKeyField(DatabaseField sourceForeignKeyField, DatabaseField targetKeyField) {
        this.getSourceToTargetKeyFields().put(sourceForeignKeyField, targetKeyField);
        this.getTargetToSourceKeyFields().put(targetKeyField, sourceForeignKeyField);
        this.getForeignKeyFields().add(sourceForeignKeyField);
        this.setIsForeignKeyRelationship(true);
    }

    public void addForeignKeyFieldName(String sourceForeignKeyFieldName, String targetKeyFieldName) {
        this.addForeignKeyField(new DatabaseField(sourceForeignKeyFieldName), new DatabaseField(targetKeyFieldName));
    }

    @Override
    public Object clone() {
        EISOneToOneMapping clone = (EISOneToOneMapping)super.clone();
        clone.setForeignKeyFields(NonSynchronizedVector.newInstance(this.getForeignKeyFields().size()));
        clone.setSourceToTargetKeyFields(new HashMap(this.getSourceToTargetKeyFields().size()));
        clone.setTargetToSourceKeyFields(new HashMap(this.getTargetToSourceKeyFields().size()));
        HashMap<DatabaseField, DatabaseField> setOfFields = new HashMap<DatabaseField, DatabaseField>(this.getTargetToSourceKeyFields().size());
        Enumeration<DatabaseField> enumtr = this.getForeignKeyFields().elements();
        while (enumtr.hasMoreElements()) {
            DatabaseField field = enumtr.nextElement();
            DatabaseField fieldClone = field.clone();
            setOfFields.put(field, fieldClone);
            clone.getForeignKeyFields().addElement(fieldClone);
        }
        for (DatabaseField sourceField : this.getSourceToTargetKeyFields().keySet()) {
            DatabaseField sourceClone;
            DatabaseField targetField = this.getSourceToTargetKeyFields().get(sourceField);
            DatabaseField targetClone = (DatabaseField)setOfFields.get(targetField);
            if (targetClone == null) {
                targetClone = targetField.clone();
                setOfFields.put(targetField, targetClone);
            }
            if ((sourceClone = sourceField.clone()) == null) {
                sourceClone = sourceField.clone();
                setOfFields.put(sourceField, sourceClone);
            }
            clone.getSourceToTargetKeyFields().put(sourceClone, targetClone);
        }
        for (DatabaseField targetField : this.getTargetToSourceKeyFields().keySet()) {
            DatabaseField sourceClone;
            DatabaseField sourceField = this.getTargetToSourceKeyFields().get(targetField);
            DatabaseField targetClone = (DatabaseField)setOfFields.get(targetField);
            if (targetClone == null) {
                targetClone = targetField.clone();
                setOfFields.put(targetField, targetClone);
            }
            if ((sourceClone = (DatabaseField)setOfFields.get(sourceField)) == null) {
                sourceClone = sourceField.clone();
                setOfFields.put(sourceField, sourceClone);
            }
            clone.getTargetToSourceKeyFields().put(targetClone, sourceClone);
        }
        return clone;
    }

    @Override
    public Object extractPrimaryKeysForReferenceObjectFromRow(AbstractRecord row) {
        List<DatabaseField> primaryKeyFields = this.getReferenceDescriptor().getPrimaryKeyFields();
        Object[] result = new Object[primaryKeyFields.size()];
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            DatabaseField targetKeyField = primaryKeyFields.get(index);
            DatabaseField sourceKeyField = this.getTargetToSourceKeyFields().get(targetKeyField);
            if (sourceKeyField == null) {
                return null;
            }
            result[index] = row.get(sourceKeyField);
            if (this.getReferenceDescriptor().getCachePolicy().getCacheKeyType() != CacheKeyType.ID_VALUE) continue;
            return result[index];
        }
        return new CacheId(result);
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        Vector<DatabaseField> foreignKeyFields = this.getForeignKeyFields();
        int size = foreignKeyFields.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField foreignKeyField = (DatabaseField)foreignKeyFields.get(index);
            foreignKeyField = this.getDescriptor().buildField(foreignKeyField);
            foreignKeyFields.set(index, foreignKeyField);
        }
        this.initializeForeignKeys(session);
        if (this.shouldInitializeSelectionCriteria()) {
            this.initializeSelectionCriteria(session);
        } else {
            this.setShouldVerifyDelete(false);
        }
        this.setFields(this.collectFields());
    }

    protected void initializeForeignKeys(AbstractSession session) {
        HashMap<DatabaseField, DatabaseField> newSourceToTargetKeyFields = new HashMap<DatabaseField, DatabaseField>(this.getSourceToTargetKeyFields().size());
        HashMap<DatabaseField, DatabaseField> newTargetToSourceKeyFields = new HashMap<DatabaseField, DatabaseField>(this.getTargetToSourceKeyFields().size());
        for (Map.Entry<DatabaseField, DatabaseField> entry : this.getSourceToTargetKeyFields().entrySet()) {
            DatabaseField sourceField = entry.getKey();
            DatabaseField targetField = entry.getValue();
            sourceField = this.getDescriptor().buildField(sourceField);
            targetField = this.getReferenceDescriptor().buildField(targetField);
            newSourceToTargetKeyFields.put(sourceField, targetField);
            newTargetToSourceKeyFields.put(targetField, sourceField);
        }
        this.setSourceToTargetKeyFields(newSourceToTargetKeyFields);
        this.setTargetToSourceKeyFields(newTargetToSourceKeyFields);
    }

    protected void initializeSelectionCriteria(AbstractSession session) {
        if (this.getSourceToTargetKeyFields().isEmpty()) {
            throw DescriptorException.noForeignKeysAreSpecified(this);
        }
        ExpressionBuilder builder = new ExpressionBuilder();
        for (DatabaseField foreignKey : this.getSourceToTargetKeyFields().keySet()) {
            DatabaseField targetKey = this.getSourceToTargetKeyFields().get(foreignKey);
            Expression expression = ((Expression)builder).getField(targetKey).equal(builder.getParameter(foreignKey));
            Expression criteria = expression.and(this.getSelectionCriteria());
            this.setSelectionCriteria(criteria);
        }
    }

    @Override
    protected Object readPrivateOwnedForObject(ObjectLevelModifyQuery modifyQuery) throws DatabaseException {
        if (modifyQuery.getSession().isUnitOfWork()) {
            return this.getRealAttributeValueFromObject(modifyQuery.getBackupClone(), modifyQuery.getSession());
        }
        if (!this.shouldVerifyDelete()) {
            return null;
        }
        ReadObjectQuery readQuery = (ReadObjectQuery)this.getSelectionQuery().clone();
        readQuery.setSelectionCriteria(this.getPrivateOwnedCriteria());
        return modifyQuery.getSession().executeQuery((DatabaseQuery)readQuery, modifyQuery.getTranslationRow());
    }

    protected void initializePrivateOwnedCriteria() {
        if (!this.isForeignKeyRelationship()) {
            this.setPrivateOwnedCriteria(this.getSelectionCriteria());
        } else {
            Expression pkCriteria = this.getDescriptor().getObjectBuilder().getPrimaryKeyExpression();
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression backRef = builder.getManualQueryKey(this.getAttributeName() + "-back-ref", this.getDescriptor());
            Expression newPKCriteria = pkCriteria.rebuildOn(backRef);
            Expression twistedSelection = backRef.twist(this.getSelectionCriteria(), builder);
            if (this.getDescriptor().getQueryManager().getAdditionalJoinExpression() != null) {
                Expression rebuiltAdditional = this.getDescriptor().getQueryManager().getAdditionalJoinExpression().rebuildOn(backRef);
                twistedSelection = twistedSelection == null ? rebuiltAdditional : twistedSelection.and(rebuiltAdditional);
            }
            this.setPrivateOwnedCriteria(newPKCriteria.and(twistedSelection));
        }
    }

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery query, CacheKey cacheKey, AbstractSession session, boolean isTargetProtected, Boolean[] wasCacheUsed) throws DatabaseException {
        ReadQuery targetQuery;
        if (this.descriptor.getCachePolicy().isProtectedIsolation()) {
            if (this.isCacheable && isTargetProtected && cacheKey != null) {
                Object result = null;
                Object cached = cacheKey.getObject();
                if (cached != null) {
                    if (wasCacheUsed != null) {
                        wasCacheUsed[0] = Boolean.TRUE;
                    }
                    return this.getAttributeValueFromObject(cached);
                }
                return result;
            }
            if (!this.isCacheable && !isTargetProtected && cacheKey != null) {
                return this.indirectionPolicy.buildIndirectObject(new ValueHolder(null));
            }
        }
        if (!query.hasPartialAttributeExpressions()) {
            Enumeration<DatabaseField> enumeration = this.getFields().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseField field = enumeration.nextElement();
                if (row.get(field) != null) continue;
                return this.getIndirectionPolicy().nullValueFromRow();
            }
        }
        if ((targetQuery = this.getSelectionQuery()).isObjectLevelReadQuery() && (query.shouldCascadeAllParts() || query.shouldCascadePrivateParts() && this.isPrivateOwned() || query.shouldCascadeByMapping() && this.cascadeRefresh)) {
            targetQuery = (ObjectLevelReadQuery)targetQuery.clone();
            ((ObjectLevelReadQuery)targetQuery).setShouldRefreshIdentityMapResult(query.shouldRefreshIdentityMapResult());
            targetQuery.setCascadePolicy(query.getCascadePolicy());
            targetQuery.setQueryId(query.getQueryId());
            if (targetQuery.shouldMaintainCache()) {
                targetQuery.setShouldMaintainCache(query.shouldMaintainCache());
            }
        }
        return this.getIndirectionPolicy().valueFromQuery(targetQuery, row, query.getSession());
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord Record2, AbstractSession session, DatabaseMapping.WriteType writeType) {
        if (this.isReadOnly() || !this.isForeignKeyRelationship()) {
            return;
        }
        AbstractRecord referenceRow = this.getIndirectionPolicy().extractReferenceRow(this.getAttributeValueFromObject(object));
        if (referenceRow == null) {
            Object referenceObject = this.getRealAttributeValueFromObject(object, session);
            for (int i = 0; i < this.getForeignKeyFields().size(); ++i) {
                DatabaseField sourceKey = this.getForeignKeyFields().get(i);
                DatabaseField targetKey = this.getSourceToTargetKeyFields().get(sourceKey);
                Object referenceValue = null;
                if (referenceObject != null) {
                    referenceValue = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(referenceObject, targetKey, session);
                }
                Record2.add(sourceKey, referenceValue);
            }
        } else {
            for (int i = 0; i < this.getForeignKeyFields().size(); ++i) {
                DatabaseField sourceKey = this.getForeignKeyFields().get(i);
                Record2.add(sourceKey, referenceRow.get(sourceKey));
            }
        }
    }

    @Override
    public Class getFieldClassification(DatabaseField fieldToClassify) throws DescriptorException {
        DatabaseField fieldInTarget = this.getSourceToTargetKeyFields().get(fieldToClassify);
        if (fieldInTarget == null) {
            return null;
        }
        DatabaseMapping mapping = this.getReferenceDescriptor().getObjectBuilder().getMappingForField(fieldInTarget);
        if (mapping == null) {
            return null;
        }
        return mapping.getFieldClassification(fieldInTarget);
    }

    public Expression getPrivateOwnedCriteria() {
        if (this.privateOwnedCriteria == null) {
            this.initializePrivateOwnedCriteria();
        }
        return this.privateOwnedCriteria;
    }

    protected void setPrivateOwnedCriteria(Expression expression) {
        this.privateOwnedCriteria = expression;
    }

    public void setShouldVerifyDelete(boolean shouldVerifyDelete) {
        this.shouldVerifyDelete = shouldVerifyDelete;
    }

    public boolean shouldVerifyDelete() {
        return this.shouldVerifyDelete;
    }

    public Map<DatabaseField, DatabaseField> getSourceToTargetKeyFields() {
        return this.sourceToTargetKeyFields;
    }

    public Map<DatabaseField, DatabaseField> getTargetToSourceKeyFields() {
        return this.targetToSourceKeyFields;
    }

    public void setSourceToTargetKeyFields(Map sourceToTargetKeyFields) {
        this.sourceToTargetKeyFields = sourceToTargetKeyFields;
    }

    public void setTargetToSourceKeyFields(Map targetToSourceKeyFields) {
        this.targetToSourceKeyFields = targetToSourceKeyFields;
    }

    @Override
    public void setSelectionSQLString(String sqlString) {
        throw DescriptorException.invalidMappingOperation(this, "setSelectionSQLString");
    }

    @Override
    public void setUsesBatchReading(boolean usesBatchReading) {
        if (usesBatchReading) {
            throw DescriptorException.invalidMappingOperation(this, "setUsesBatchReading");
        }
    }

    @Override
    public void useBatchReading() {
        throw DescriptorException.invalidMappingOperation(this, "useBatchReading");
    }
}

