/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.Serializable;
import java.util.Map;
import org.eclipse.persistence.internal.helper.DatabaseTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableAliasLookup
implements Serializable {
    protected DatabaseTable[] keys;
    protected DatabaseTable[] values;
    protected int lastUsed;
    protected boolean haveBeenAddedToStatement;

    public TableAliasLookup() {
        this.keys = new DatabaseTable[5];
        this.values = new DatabaseTable[5];
        this.lastUsed = 0;
    }

    public TableAliasLookup(int initialSize) {
        this.keys = new DatabaseTable[initialSize];
        this.values = new DatabaseTable[initialSize];
        this.lastUsed = 0;
    }

    public void addToMap(Map<DatabaseTable, DatabaseTable> map) {
        for (int i = 0; i < this.lastUsed; ++i) {
            map.put(this.keys[i], this.values[i]);
        }
    }

    public DatabaseTable get(DatabaseTable key) {
        int index = this.lookupIndexOf(key);
        if (index == -1) {
            return null;
        }
        return this.values[index];
    }

    private void grow() {
        DatabaseTable[] newKeys = new DatabaseTable[this.lastUsed * 2];
        DatabaseTable[] newValues = new DatabaseTable[this.lastUsed * 2];
        for (int i = 0; i < this.lastUsed; ++i) {
            newKeys[i] = this.keys[i];
            newValues[i] = this.values[i];
        }
        this.keys = newKeys;
        this.values = newValues;
    }

    public boolean haveBeenAddedToStatement() {
        return this.haveBeenAddedToStatement;
    }

    public boolean isEmpty() {
        return this.keys[0] == null;
    }

    public DatabaseTable keyAtValue(DatabaseTable value) {
        int index = this.lookupValueIndexOf(value);
        if (index == -1) {
            return null;
        }
        return this.keys[index];
    }

    public DatabaseTable[] keys() {
        return this.keys;
    }

    private int lookupIndexOf(DatabaseTable table) {
        for (int i = 0; i < this.lastUsed; ++i) {
            if (!this.keys[i].equals(table)) continue;
            return i;
        }
        return -1;
    }

    private int lookupValueIndexOf(DatabaseTable table) {
        for (int i = 0; i < this.lastUsed; ++i) {
            if (!this.values[i].equals(table)) continue;
            return i;
        }
        return -1;
    }

    public DatabaseTable put(DatabaseTable key, DatabaseTable value) {
        int index = this.lookupIndexOf(key);
        if (index == -1) {
            this.keys[this.lastUsed] = key;
            this.values[this.lastUsed++] = value;
            if (this.lastUsed >= this.keys.length) {
                this.grow();
            }
        } else {
            this.values[index] = value;
        }
        return value;
    }

    public void setHaveBeenAddedToStatement(boolean value) {
        this.haveBeenAddedToStatement = value;
    }

    public int size() {
        return this.lastUsed;
    }

    public String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        for (int i = 0; i <= max; ++i) {
            String s1 = this.keys[i].toString();
            String s2 = this.values[i].toString();
            buf.append(s1 + "=" + s2);
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    public DatabaseTable[] values() {
        return this.values;
    }
}

