/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;

public class XMLObjectReferenceMappingNodeValue
extends MappingNodeValue {
    private XMLObjectReferenceMapping xmlObjectReferenceMapping;
    private XMLField xmlField;

    public XMLObjectReferenceMappingNodeValue(XMLObjectReferenceMapping xmlObjectReferenceMapping) {
        this.xmlObjectReferenceMapping = xmlObjectReferenceMapping;
    }

    public XMLObjectReferenceMappingNodeValue(XMLObjectReferenceMapping xmlObjectReferenceMapping, XMLField xmlField) {
        this.xmlObjectReferenceMapping = xmlObjectReferenceMapping;
        this.xmlField = xmlField;
    }

    public void attribute(UnmarshalRecord unmarshalRecord, String namespaceURI, String localName, String value) {
        if (value != null) {
            Object realValue = this.xmlField.convertValueBasedOnSchemaType(value, (XMLConversionManager)unmarshalRecord.getSession().getDatasourcePlatform().getConversionManager(), unmarshalRecord);
            this.xmlObjectReferenceMapping.buildReference(unmarshalRecord, this.xmlField, realValue, unmarshalRecord.getSession());
        }
    }

    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        if (!this.xmlField.getLastXPathFragment().nameIsText()) {
            return;
        }
        Object value = ((Object)unmarshalRecord.getCharacters()).toString();
        unmarshalRecord.resetStringBuffer();
        XMLConversionManager xmlConversionManager = (XMLConversionManager)unmarshalRecord.getSession().getDatasourcePlatform().getConversionManager();
        if (unmarshalRecord.getTypeQName() != null) {
            Class typeClass = this.xmlField.getJavaClass(unmarshalRecord.getTypeQName());
            value = xmlConversionManager.convertObject(value, typeClass, unmarshalRecord.getTypeQName());
        } else {
            value = this.xmlField.convertValueBasedOnSchemaType(value, xmlConversionManager, unmarshalRecord);
        }
        this.xmlObjectReferenceMapping.buildReference(unmarshalRecord, this.xmlField, value, unmarshalRecord.getSession());
    }

    public boolean isOwningNode(XPathFragment xPathFragment) {
        return xPathFragment.isAttribute() || xPathFragment.nameIsText();
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
        return this.marshal(xPathFragment, marshalRecord, object, session, namespaceResolver, ObjectMarshalContext.getInstance());
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if (this.xmlObjectReferenceMapping.isReadOnly()) {
            return false;
        }
        Object targetObject = marshalContext.getAttributeValue(object, this.xmlObjectReferenceMapping);
        return this.marshalSingleValue(xPathFragment, marshalRecord, object, targetObject, session, namespaceResolver, marshalContext);
    }

    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object targetObject, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        Object fieldValue = this.xmlObjectReferenceMapping.buildFieldValue(targetObject, this.xmlField, session);
        if (fieldValue == null) {
            if (null != targetObject) {
                XMLField fkField = (XMLField)this.xmlObjectReferenceMapping.getSourceToTargetKeyFieldAssociations().get(this.xmlField);
                if (null == fkField) {
                    XMLDescriptor targetDescriptor = (XMLDescriptor)session.getDescriptor(targetObject);
                    fieldValue = marshalRecord.getMarshaller().getXMLContext().getValueByXPath(targetObject, targetDescriptor.getPrimaryKeyFields().get(0).getName(), targetDescriptor.getNamespaceResolver(), Object.class);
                } else {
                    fieldValue = marshalRecord.getMarshaller().getXMLContext().getValueByXPath(targetObject, fkField.getXPath(), fkField.getNamespaceResolver(), Object.class);
                }
            }
            if (null == fieldValue) {
                return false;
            }
        }
        QName schemaType = this.getSchemaType(this.xmlField, fieldValue, session);
        XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        if (xPathFragment.isAttribute()) {
            marshalRecord.attribute(xPathFragment, namespaceResolver, fieldValue, schemaType);
            marshalRecord.closeStartGroupingElements(groupingFragment);
        } else {
            marshalRecord.closeStartGroupingElements(groupingFragment);
            marshalRecord.characters(schemaType, fieldValue, false);
        }
        return true;
    }

    public XMLObjectReferenceMapping getMapping() {
        return this.xmlObjectReferenceMapping;
    }
}

