/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.persistence.internal.oxm.record.SAXUnmarshallerHandler;
import org.eclipse.persistence.internal.oxm.record.XMLReaderAdapter;
import org.eclipse.persistence.internal.oxm.record.XMLStreamReaderInputSource;
import org.eclipse.persistence.internal.oxm.record.namespaces.UnmarshalNamespaceContext;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLStreamReaderReader
extends XMLReaderAdapter {
    private int depth = 0;
    private UnmarshalNamespaceContext unmarshalNamespaceContext = new UnmarshalNamespaceContext();
    private XMLStreamReaderAttributes indexedAttributeList = new XMLStreamReaderAttributes();
    private boolean qNameAware;

    public XMLStreamReaderReader() {
    }

    public XMLStreamReaderReader(XMLUnmarshaller xmlUnmarshaller) {
        super(xmlUnmarshaller);
    }

    public void setContentHandler(ContentHandler handler) {
        super.setContentHandler(handler);
        Class<?> handlerClass = handler.getClass();
        if (handlerClass == UnmarshalRecord.class) {
            ((UnmarshalRecord)handler).setUnmarshalNamespaceResolver(this.unmarshalNamespaceContext);
            this.qNameAware = false;
        } else if (handlerClass == SAXUnmarshallerHandler.class) {
            ((SAXUnmarshallerHandler)handler).setUnmarshalNamespaceResolver(this.unmarshalNamespaceContext);
            this.qNameAware = true;
        } else {
            this.qNameAware = true;
        }
    }

    public void parse(InputSource input) throws SAXException {
        if (null == this.contentHandler) {
            return;
        }
        if (input instanceof XMLStreamReaderInputSource) {
            XMLStreamReader xmlStreamReader = ((XMLStreamReaderInputSource)input).getXmlStreamReader();
            this.unmarshalNamespaceContext.setXmlStreamReader(xmlStreamReader);
            this.indexedAttributeList.setXmlStreamReader(xmlStreamReader);
            this.parse(xmlStreamReader);
        }
    }

    private void parse(XMLStreamReader xmlStreamReader) throws SAXException {
        try {
            this.contentHandler.startDocument();
            this.parseEvent(xmlStreamReader);
            while (this.depth > 0) {
                xmlStreamReader.next();
                this.parseEvent(xmlStreamReader);
            }
            this.contentHandler.endDocument();
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    private void parseEvent(XMLStreamReader xmlStreamReader) throws SAXException {
        switch (xmlStreamReader.getEventType()) {
            case 1: {
                ++this.depth;
                String localName = xmlStreamReader.getLocalName();
                String namespaceURI = xmlStreamReader.getNamespaceURI();
                if ("".equals(namespaceURI)) {
                    namespaceURI = null;
                }
                if (this.qNameAware) {
                    String prefix = xmlStreamReader.getPrefix();
                    if (null == prefix || prefix.length() == 0) {
                        this.contentHandler.startElement(namespaceURI, localName, localName, this.indexedAttributeList.reset());
                        break;
                    }
                    this.contentHandler.startElement(namespaceURI, localName, prefix + ':' + localName, this.indexedAttributeList.reset());
                    break;
                }
                this.contentHandler.startElement(namespaceURI, localName, null, this.indexedAttributeList.reset());
                break;
            }
            case 2: {
                --this.depth;
                String localName = xmlStreamReader.getLocalName();
                String namespaceURI = xmlStreamReader.getNamespaceURI();
                if ("".equals(namespaceURI)) {
                    namespaceURI = null;
                }
                if (this.qNameAware) {
                    String prefix = xmlStreamReader.getPrefix();
                    if (null == prefix || prefix.length() == 0) {
                        this.contentHandler.endElement(namespaceURI, localName, localName);
                        break;
                    }
                    this.contentHandler.endElement(namespaceURI, localName, prefix + ':' + localName);
                    break;
                }
                this.contentHandler.endElement(namespaceURI, localName, null);
                break;
            }
            case 3: {
                this.contentHandler.processingInstruction(xmlStreamReader.getPITarget(), xmlStreamReader.getPIData());
                break;
            }
            case 4: {
                this.parseCharactersEvent(xmlStreamReader);
                break;
            }
            case 5: {
                if (null == this.lexicalHandler) break;
                this.lexicalHandler.comment(xmlStreamReader.getTextCharacters(), xmlStreamReader.getTextStart(), xmlStreamReader.getTextLength());
                break;
            }
            case 6: {
                this.contentHandler.characters(xmlStreamReader.getTextCharacters(), xmlStreamReader.getTextStart(), xmlStreamReader.getTextLength());
                break;
            }
            case 7: {
                ++this.depth;
                break;
            }
            case 8: {
                --this.depth;
                return;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                char[] characters = xmlStreamReader.getText().toCharArray();
                if (null == this.lexicalHandler) {
                    this.parseCharactersEvent(xmlStreamReader);
                    break;
                }
                this.lexicalHandler.startCDATA();
                this.parseCharactersEvent(xmlStreamReader);
                this.lexicalHandler.endCDATA();
                break;
            }
        }
    }

    protected void parseCharactersEvent(XMLStreamReader xmlStreamReader) throws SAXException {
        this.contentHandler.characters(xmlStreamReader.getTextCharacters(), xmlStreamReader.getTextStart(), xmlStreamReader.getTextLength());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XMLStreamReaderAttributes
    extends XMLReaderAdapter.IndexedAttributeList {
        private XMLStreamReader xmlStreamReader;

        private XMLStreamReaderAttributes() {
        }

        public void setXmlStreamReader(XMLStreamReader xmlStreamReader) {
            this.xmlStreamReader = xmlStreamReader;
        }

        @Override
        protected List<XMLReaderAdapter.Attribute> attributes() {
            if (null == this.attributes) {
                String localName;
                String uri;
                int x;
                int namespaceCount = this.xmlStreamReader.getNamespaceCount();
                int attributeCount = this.xmlStreamReader.getAttributeCount();
                this.attributes = new ArrayList(attributeCount + namespaceCount);
                for (x = 0; x < namespaceCount; ++x) {
                    String qName;
                    uri = "http://www.w3.org/2000/xmlns/";
                    localName = this.xmlStreamReader.getNamespacePrefix(x);
                    if (null == localName || localName.length() == 0) {
                        localName = "xmlns";
                        qName = "xmlns";
                    } else {
                        qName = "xmlns:" + localName;
                    }
                    String value = this.xmlStreamReader.getNamespaceURI(x);
                    this.attributes.add(new XMLReaderAdapter.Attribute(uri, localName, qName, value));
                }
                for (x = 0; x < attributeCount; ++x) {
                    uri = this.xmlStreamReader.getAttributeNamespace(x);
                    localName = this.xmlStreamReader.getAttributeLocalName(x);
                    String prefix = this.xmlStreamReader.getAttributePrefix(x);
                    String qName = null == prefix || prefix.length() == 0 ? localName : prefix + ':' + localName;
                    String value = this.xmlStreamReader.getAttributeValue(x);
                    this.attributes.add(new XMLReaderAdapter.Attribute(uri, localName, qName, value));
                }
            }
            return this.attributes;
        }
    }
}

