/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.cache;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.CacheIndex;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheIndexMetadata
extends ORMetadata {
    private List<String> m_columnNames = new ArrayList<String>();

    public CacheIndexMetadata() {
        super("<cache-index>");
    }

    public CacheIndexMetadata(MetadataAnnotation index, MetadataAccessor accessor) {
        super(index, accessor);
        if (index != null) {
            for (Object columnName : (Object[])index.getAttributeArray("columnNames")) {
                this.m_columnNames.add((String)columnName);
            }
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof CacheIndexMetadata) {
            CacheIndexMetadata index = (CacheIndexMetadata)objectToCompare;
            return ((Object)this.m_columnNames).equals(index.getColumnNames());
        }
        return false;
    }

    public List<String> getColumnNames() {
        return this.m_columnNames;
    }

    public void process(MetadataDescriptor descriptor, String defaultColumnName) {
        if (this.m_columnNames.isEmpty() && defaultColumnName != null) {
            descriptor.getClassDescriptor().getCachePolicy().addCacheIndex(new String[]{defaultColumnName});
        } else {
            CacheIndex index = new CacheIndex();
            for (String column : this.m_columnNames) {
                index.addFieldName(column);
            }
            descriptor.getClassDescriptor().getCachePolicy().addCacheIndex(index);
        }
    }

    public void setColumnNames(List<String> columnNames) {
        this.m_columnNames = columnNames;
    }
}

