/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import org.eclipse.persistence.internal.oxm.record.ExtendedContentHandler;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;

public abstract class XMLReaderAdapter
extends XMLReader {
    protected ExtendedContentHandler contentHandler;
    private DTDHandler dtdHandler;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;
    protected LexicalHandler lexicalHandler;

    public XMLReaderAdapter() {
    }

    public XMLReaderAdapter(XMLUnmarshaller xmlUnmarshaller) {
        if (null != xmlUnmarshaller) {
            Schema schema = xmlUnmarshaller.getSchema();
            if (null != schema) {
                this.validatorHandler = schema.newValidatorHandler();
                this.contentHandler = new ExtendedContentHandlerAdapter(this.validatorHandler);
            }
            this.setErrorHandler(xmlUnmarshaller.getErrorHandler());
        }
    }

    public ExtendedContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        if (null == this.validatorHandler) {
            this.contentHandler = contentHandler instanceof ExtendedContentHandler ? (ExtendedContentHandler)contentHandler : new ExtendedContentHandlerAdapter(contentHandler);
        } else {
            this.validatorHandler.setContentHandler(contentHandler);
        }
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setDTDHandler(DTDHandler dtdHandler) {
        this.dtdHandler = dtdHandler;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        if (null != this.validatorHandler) {
            this.validatorHandler.setErrorHandler(errorHandler);
        }
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            return this.getLexicalHandler();
        }
        return null;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            this.setLexicalHandler((LexicalHandler)value);
        }
    }

    public void parse(String systemId) {
    }

    protected static class Attribute {
        private QName qName;
        private String name;
        private String value;

        public Attribute(String uri, String localName, String name, String value) {
            this.qName = new QName(uri, localName);
            this.name = name;
            this.value = value;
        }

        public QName getQName() {
            return this.qName;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static class ExtendedContentHandlerAdapter
    implements ExtendedContentHandler {
        private ContentHandler contentHandler;

        public ExtendedContentHandlerAdapter(ContentHandler contentHandler) {
            this.contentHandler = contentHandler;
        }

        public void setDocumentLocator(Locator locator) {
            this.contentHandler.setDocumentLocator(locator);
        }

        public void startDocument() throws SAXException {
            this.contentHandler.startDocument();
        }

        public void endDocument() throws SAXException {
            this.contentHandler.endDocument();
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.contentHandler.startPrefixMapping(prefix, uri);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            this.contentHandler.endPrefixMapping(prefix);
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this.contentHandler.startElement(uri, localName, qName, atts);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.contentHandler.endElement(uri, localName, qName);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.contentHandler.characters(ch, start, length);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.contentHandler.ignorableWhitespace(ch, start, length);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this.contentHandler.processingInstruction(target, data);
        }

        public void skippedEntity(String name) throws SAXException {
            this.contentHandler.skippedEntity(name);
        }

        public void characters(CharSequence characters) throws SAXException {
            if (null == characters) {
                return;
            }
            this.contentHandler.characters(((Object)characters).toString().toCharArray(), 0, characters.length());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class IndexedAttributeList
    implements Attributes {
        protected List<Attribute> attributes;

        protected IndexedAttributeList() {
        }

        protected abstract List<Attribute> attributes();

        @Override
        public int getIndex(String qName) {
            if (null == qName) {
                return -1;
            }
            int index = 0;
            for (Attribute attribute : this.attributes()) {
                if (qName.equals(attribute.getName())) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        @Override
        public int getIndex(String uri, String localName) {
            if (null == localName) {
                return -1;
            }
            int index = 0;
            for (Attribute attribute : this.attributes()) {
                QName testQName = new QName(uri, localName);
                if (attribute.getQName().equals(testQName)) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        @Override
        public int getLength() {
            return this.attributes().size();
        }

        @Override
        public String getLocalName(int index) {
            return this.attributes().get(index).getQName().getLocalPart();
        }

        @Override
        public String getQName(int index) {
            return this.attributes().get(index).getName();
        }

        @Override
        public String getType(int index) {
            return "CDATA";
        }

        @Override
        public String getType(String name) {
            return "CDATA";
        }

        @Override
        public String getType(String uri, String localName) {
            return "CDATA";
        }

        @Override
        public String getURI(int index) {
            return this.attributes().get(index).getQName().getNamespaceURI();
        }

        @Override
        public String getValue(int index) {
            return this.attributes().get(index).getValue();
        }

        @Override
        public String getValue(String qName) {
            int index = this.getIndex(qName);
            if (-1 == index) {
                return null;
            }
            return this.attributes().get(index).getValue();
        }

        @Override
        public String getValue(String uri, String localName) {
            int index = this.getIndex(uri, localName);
            if (-1 == index) {
                return null;
            }
            return this.attributes().get(index).getValue();
        }

        public IndexedAttributeList reset() {
            this.attributes = null;
            return this;
        }
    }
}

