/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableCreator {
    protected List<TableDefinition> tableDefinitions;
    protected String name;
    protected boolean ignoreDatabaseException;

    public TableCreator() {
        this(new ArrayList<TableDefinition>());
    }

    public TableCreator(List<TableDefinition> tableDefinitions) {
        this.tableDefinitions = tableDefinitions;
    }

    public void addTableDefinition(TableDefinition tableDefinition) {
        this.tableDefinitions.add(tableDefinition);
    }

    public void addTableDefinitions(Collection<TableDefinition> tableDefs) {
        this.tableDefinitions.addAll(tableDefs);
    }

    public void createConstraints(DatabaseSession session) {
        this.createConstraints(session, new SchemaManager(session));
    }

    public void createConstraints(DatabaseSession session, SchemaManager schemaManager) {
        this.createConstraints(session, schemaManager, true);
    }

    public void createConstraints(DatabaseSession session, SchemaManager schemaManager, boolean build) {
        this.buildConstraints(schemaManager, build);
        for (TableDefinition table : this.getTableDefinitions()) {
            try {
                schemaManager.createUniqueConstraints(table);
            }
            catch (DatabaseException ex) {
                if (this.shouldIgnoreDatabaseException()) continue;
                throw ex;
            }
        }
        for (TableDefinition table : this.getTableDefinitions()) {
            try {
                schemaManager.createForeignConstraints(table);
            }
            catch (DatabaseException ex) {
                if (this.shouldIgnoreDatabaseException()) continue;
                throw ex;
            }
        }
    }

    public void createTables(DatabaseSession session) {
        this.createTables(session, new SchemaManager(session));
    }

    public void createTables(DatabaseSession session, SchemaManager schemaManager) {
        this.createTables(session, schemaManager, true);
    }

    public void createTables(DatabaseSession session, SchemaManager schemaManager, boolean build) {
        this.buildConstraints(schemaManager, build);
        String sequenceTableName = this.getSequenceTableName(session);
        for (TableDefinition table : this.getTableDefinitions()) {
            if (table.getName().equals(sequenceTableName)) continue;
            try {
                schemaManager.createObject(table);
                session.getSessionLog().log(1, "default_tables_created", table.getFullName());
            }
            catch (DatabaseException ex) {
                session.getSessionLog().log(1, "default_tables_already_existed", table.getFullName());
                if (this.shouldIgnoreDatabaseException()) continue;
                throw ex;
            }
        }
        this.createConstraints(session, schemaManager, false);
        schemaManager.createSequences();
    }

    public void dropConstraints(DatabaseSession session) {
        this.dropConstraints(session, new SchemaManager(session));
    }

    public void dropConstraints(DatabaseSession session, SchemaManager schemaManager) {
        this.dropConstraints(session, schemaManager, true);
    }

    public void dropConstraints(DatabaseSession session, SchemaManager schemaManager, boolean build) {
        this.buildConstraints(schemaManager, build);
        for (TableDefinition table : this.getTableDefinitions()) {
            try {
                schemaManager.dropConstraints(table);
            }
            catch (DatabaseException exception) {}
        }
    }

    public void dropTables(DatabaseSession session) {
        this.dropTables(session, new SchemaManager(session));
    }

    public void dropTables(DatabaseSession session, SchemaManager schemaManager) {
        this.dropTables(session, schemaManager, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTables(DatabaseSession session, SchemaManager schemaManager, boolean build) {
        this.buildConstraints(schemaManager, build);
        boolean shouldLogExceptionStackTrace = session.getSessionLog().shouldLogExceptionStackTrace();
        int level = session.getSessionLog().getLevel();
        if (shouldLogExceptionStackTrace) {
            session.getSessionLog().setShouldLogExceptionStackTrace(false);
        }
        if (level > 3) {
            session.getSessionLog().setLevel(7);
        }
        try {
            this.dropConstraints(session, schemaManager, false);
            String sequenceTableName = this.getSequenceTableName(session);
            List<TableDefinition> tables = this.getTableDefinitions();
            int trys = 1;
            if (SchemaManager.FORCE_DROP) {
                trys = 5;
            }
            while (trys > 0 && !tables.isEmpty()) {
                --trys;
                ArrayList<TableDefinition> failed = new ArrayList<TableDefinition>();
                for (TableDefinition table : tables) {
                    if (table.getName().equals(sequenceTableName)) continue;
                    try {
                        schemaManager.dropObject(table);
                    }
                    catch (DatabaseException exception) {
                        failed.add(table);
                        if (this.shouldIgnoreDatabaseException()) continue;
                        throw exception;
                    }
                }
                tables = failed;
            }
            Object var14_13 = null;
            if (shouldLogExceptionStackTrace) {
                session.getSessionLog().setShouldLogExceptionStackTrace(true);
            }
            if (level > 3) {
                session.getSessionLog().setLevel(level);
            }
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            if (shouldLogExceptionStackTrace) {
                session.getSessionLog().setShouldLogExceptionStackTrace(true);
            }
            if (level > 3) {
                session.getSessionLog().setLevel(level);
            }
            throw throwable;
        }
    }

    public String getName() {
        return this.name;
    }

    public List<TableDefinition> getTableDefinitions() {
        return this.tableDefinitions;
    }

    public void replaceTables(DatabaseSession session) {
        this.replaceTables(session, new SchemaManager(session));
    }

    public void replaceTables(DatabaseSession session, SchemaManager schemaManager) {
        this.replaceTablesAndConstraints(schemaManager, session);
        schemaManager.createSequences();
    }

    public void replaceTables(DatabaseSession session, SchemaManager schemaManager, boolean keepSequenceTable) {
        this.replaceTablesAndConstraints(schemaManager, session);
        schemaManager.createOrReplaceSequences(keepSequenceTable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceTablesAndConstraints(SchemaManager schemaManager, DatabaseSession session) {
        this.buildConstraints(schemaManager, true);
        boolean ignore = this.shouldIgnoreDatabaseException();
        this.setIgnoreDatabaseException(true);
        try {
            this.dropTables(session, schemaManager, false);
            Object var5_4 = null;
            this.setIgnoreDatabaseException(ignore);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.setIgnoreDatabaseException(ignore);
            throw throwable;
        }
        this.createTables(session, schemaManager, false);
    }

    protected void buildConstraints(SchemaManager schemaManager, boolean build) {
        if (build) {
            for (TableDefinition table : this.getTableDefinitions()) {
                schemaManager.buildFieldTypes(table);
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTableDefinitions(Vector tableDefinitions) {
        this.tableDefinitions = tableDefinitions;
    }

    protected boolean shouldIgnoreDatabaseException() {
        return this.ignoreDatabaseException;
    }

    protected void setIgnoreDatabaseException(boolean ignoreDatabaseException) {
        this.ignoreDatabaseException = ignoreDatabaseException;
    }

    protected String getSequenceTableName(Session session) {
        Sequence sequence;
        String sequenceTableName = null;
        if (session.getProject().usesSequencing() && (sequence = session.getLogin().getDefaultSequence()) instanceof TableSequence) {
            sequenceTableName = ((TableSequence)sequence).getTableName();
        }
        return sequenceTableName;
    }
}

