/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws.oracle;

import java.sql.Array;
import java.sql.Date;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.xr.Attachment;
import org.eclipse.persistence.internal.xr.CollectionResult;
import org.eclipse.persistence.internal.xr.NamedQueryHandler;
import org.eclipse.persistence.internal.xr.Parameter;
import org.eclipse.persistence.internal.xr.ProcedureArgument;
import org.eclipse.persistence.internal.xr.ProcedureOutputArgument;
import org.eclipse.persistence.internal.xr.QueryHandler;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.Result;
import org.eclipse.persistence.internal.xr.StoredFunctionQueryHandler;
import org.eclipse.persistence.internal.xr.StoredProcedureQueryHandler;
import org.eclipse.persistence.internal.xr.XRDynamicClassLoader;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormat;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormatProject;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.structures.ArrayMapping;
import org.eclipse.persistence.mappings.structures.ObjectArrayMapping;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.mappings.structures.StructureMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.oxm.schema.XMLSchemaURLReference;
import org.eclipse.persistence.platform.database.jdbc.JDBCTypes;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLCollection;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredFunctionCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredProcedureCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLrecord;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.StoredFunctionCall;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.tools.dbws.BaseDBWSBuilderHelper;
import org.eclipse.persistence.tools.dbws.DBWSBuilder;
import org.eclipse.persistence.tools.dbws.DBWSBuilderHelper;
import org.eclipse.persistence.tools.dbws.ProcedureOperationModel;
import org.eclipse.persistence.tools.dbws.Util;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentType;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentTypeDirection;
import org.eclipse.persistence.tools.oracleddl.metadata.FieldType;
import org.eclipse.persistence.tools.oracleddl.metadata.FunctionType;
import org.eclipse.persistence.tools.oracleddl.metadata.ObjectTableType;
import org.eclipse.persistence.tools.oracleddl.metadata.ObjectType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLCollectionType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLPackageType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLRecordType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLType;
import org.eclipse.persistence.tools.oracleddl.metadata.ProcedureType;
import org.eclipse.persistence.tools.oracleddl.metadata.TableType;
import org.eclipse.persistence.tools.oracleddl.metadata.VArrayType;
import org.eclipse.persistence.tools.oracleddl.parser.ParseException;
import org.eclipse.persistence.tools.oracleddl.util.DatabaseTypeBuilder;

public class OracleHelper
extends BaseDBWSBuilderHelper
implements DBWSBuilderHelper {
    protected DatabaseTypeBuilder dtBuilder = new DatabaseTypeBuilder();
    protected boolean hasComplexProcedureArgs = false;

    public OracleHelper(DBWSBuilder dbwsBuilder) {
        super(dbwsBuilder);
    }

    @Override
    public boolean hasTables() {
        return this.dbTables.size() != 0;
    }

    @Override
    public boolean hasComplexProcedureArgs() {
        return this.hasComplexProcedureArgs;
    }

    @Override
    public void buildProcedureOperation(ProcedureOperationModel procedureOperationModel) {
        List<ProcedureType> additionalProcs;
        String name = procedureOperationModel.getName();
        ArrayList<ProcedureType> procs = new ArrayList<ProcedureType>();
        for (Map.Entry me : this.dbStoredProcedure2QueryName.entrySet()) {
            ProcedureType key = (ProcedureType)me.getKey();
            BaseDBWSBuilderHelper.DbStoredProcedureNameAndModel value = (BaseDBWSBuilderHelper.DbStoredProcedureNameAndModel)me.getValue();
            if (!value.name.equals(procedureOperationModel.getName())) continue;
            procs.add(key);
        }
        if (procs.isEmpty() && (additionalProcs = this.loadProcedures(procedureOperationModel)) != null && !additionalProcs.isEmpty()) {
            procs.addAll(additionalProcs);
        }
        if (procedureOperationModel.isPLSQLProcedureOperation() && procedureOperationModel.hasComplexArguments()) {
            this.buildPLSQLProcedureOperation(procedureOperationModel, procs);
            return;
        }
        for (ProcedureType storedProcedure : procs) {
            QueryOperation qo = new QueryOperation();
            qo.setName(this.getNameForQueryOperation(name, storedProcedure));
            String qualifiedProcName = this.getQualifiedProcedureName(procedureOperationModel, storedProcedure);
            this.dbwsBuilder.logMessage(Level.FINEST, "Building QueryOperation for " + qualifiedProcName);
            Object qh = storedProcedure.isFunction() ? new StoredFunctionQueryHandler() : new StoredProcedureQueryHandler();
            ((StoredProcedureQueryHandler)qh).setName(qualifiedProcName);
            List queries = this.dbwsBuilder.getOrProject().getQueries();
            if (queries.size() > 0) {
                for (DatabaseQuery q : queries) {
                    if (!q.getName().equals(qo.getName())) continue;
                    qh = new NamedQueryHandler();
                    ((NamedQueryHandler)qh).setName(qo.getName());
                }
            }
            qo.setQueryHandler((QueryHandler)qh);
            String returnType = procedureOperationModel.getReturnType();
            boolean isCollection = procedureOperationModel.isCollection();
            boolean isSimpleXMLFormat = procedureOperationModel.isSimpleXMLFormat();
            Object result = null;
            if (storedProcedure.isFunction()) {
                result = this.buildResultForStoredFunction(storedProcedure, returnType);
            } else if (returnType != null) {
                result = new Result();
                result.setType(Util.buildCustomQName(returnType, this.dbwsBuilder));
            } else if (isCollection) {
                result = new CollectionResult();
                if (isSimpleXMLFormat) {
                    result.setType(Util.SXF_QNAME_CURSOR);
                }
            } else {
                result = new Result();
                result.setType(org.eclipse.persistence.internal.xr.Util.SXF_QNAME);
            }
            if (procedureOperationModel.getBinaryAttachment()) {
                Attachment attachment = new Attachment();
                attachment.setMimeType("application/octet-stream");
                result.setAttachment(attachment);
            }
            for (ArgumentType arg : storedProcedure.getArguments()) {
                String typeString;
                String argName = arg.getArgumentName();
                if (argName == null) continue;
                ProcedureOutputArgument pa = null;
                Parameter parm = null;
                ArgumentTypeDirection direction = arg.getDirection();
                QName xmlType = null;
                if (arg.getDataType() instanceof PLSQLType) {
                    this.hasComplexProcedureArgs = true;
                    typeString = storedProcedure.getCatalogName() + "_" + arg.getTypeName();
                    xmlType = Util.buildCustomQName(typeString, this.dbwsBuilder);
                } else if (arg.getDataType() instanceof VArrayType || arg.getDataType() instanceof ObjectTableType) {
                    this.hasComplexProcedureArgs = true;
                    typeString = arg.getTypeName().toLowerCase().concat("Type");
                    xmlType = Util.buildCustomQName(typeString, this.dbwsBuilder);
                } else {
                    switch (Util.getJDBCTypeFromTypeName(arg.getTypeName())) {
                        case 2002: 
                        case 2003: {
                            typeString = this.nct.generateSchemaAlias(arg.getTypeName());
                            xmlType = Util.buildCustomQName(typeString, this.dbwsBuilder);
                            break;
                        }
                        default: {
                            xmlType = Util.getXMLTypeFromJDBCType(Util.getJDBCTypeFromTypeName(arg.getTypeName()));
                        }
                    }
                }
                if (direction == ArgumentTypeDirection.IN) {
                    parm = new Parameter();
                    parm.setName(argName);
                    parm.setType(xmlType);
                    pa = new ProcedureArgument();
                    pa.setName(argName);
                    pa.setParameterName(argName);
                    if (qh instanceof StoredProcedureQueryHandler) {
                        ((StoredProcedureQueryHandler)qh).getInArguments().add(pa);
                    }
                } else {
                    ProcedureOutputArgument pao = pa = new ProcedureOutputArgument();
                    pao.setName(argName);
                    pao.setParameterName(argName);
                    boolean isCursor = arg.getTypeName().contains("CURSOR");
                    if (isCursor && returnType == null) {
                        pao.setResultType(Util.SXF_QNAME_CURSOR);
                        if (result == null) {
                            result = new CollectionResult();
                            result.setType(Util.SXF_QNAME_CURSOR);
                        }
                    } else {
                        if (returnType != null && !isSimpleXMLFormat) {
                            xmlType = Util.qNameFromString("{" + this.dbwsBuilder.getTargetNamespace() + "}" + returnType, this.dbwsBuilder.getSchema());
                        }
                        if (isCursor) {
                            pao.setResultType(new QName("", "cursor of " + returnType));
                            CollectionResult newResult = new CollectionResult();
                            newResult.setType(result.getType());
                            result = newResult;
                        } else {
                            pao.setResultType(xmlType);
                        }
                        if (result == null) {
                            result = isCollection ? new CollectionResult() : new Result();
                            result.setType(xmlType);
                        }
                    }
                    if (direction == ArgumentTypeDirection.INOUT) {
                        if (qh instanceof StoredProcedureQueryHandler) {
                            ((StoredProcedureQueryHandler)qh).getInOutArguments().add(pao);
                        }
                    } else if (qh instanceof StoredProcedureQueryHandler) {
                        ((StoredProcedureQueryHandler)qh).getOutArguments().add(pao);
                    }
                    if (arg.getDataType() instanceof PLSQLType) {
                        pa.setComplexTypeName(storedProcedure.getCatalogName() + "_" + arg.getTypeName());
                    }
                }
                if (parm == null) continue;
                qo.getParameters().add(parm);
            }
            this.handleSimpleXMLFormat(isSimpleXMLFormat, (Result)result, procedureOperationModel);
            qo.setResult(result);
            this.dbwsBuilder.getXrServiceModel().getOperations().put(qo.getName(), qo);
        }
        this.finishProcedureOperation();
    }

    public void buildPLSQLProcedureOperation(ProcedureOperationModel procedureOperationModel, List<ProcedureType> procs) {
        String name = procedureOperationModel.getName();
        for (ProcedureType storedProcedure : procs) {
            QueryOperation qo = new QueryOperation();
            qo.setName(this.getNameForQueryOperation(name, storedProcedure));
            this.dbwsBuilder.logMessage(Level.FINEST, "Building QueryOperation for " + this.getQualifiedProcedureName(procedureOperationModel, storedProcedure));
            String returnType = procedureOperationModel.getReturnType();
            boolean isCollection = procedureOperationModel.isCollection();
            boolean isSimpleXMLFormat = procedureOperationModel.isSimpleXMLFormat();
            Object result = null;
            if (storedProcedure.isFunction()) {
                result = this.buildResultForStoredFunction(storedProcedure, returnType);
            }
            if (procedureOperationModel.getBinaryAttachment()) {
                Attachment attachment = new Attachment();
                attachment.setMimeType("application/octet-stream");
                result.setAttachment(attachment);
            }
            for (ArgumentType arg : storedProcedure.getArguments()) {
                String typeString;
                String argName = arg.getArgumentName();
                if (argName == null) continue;
                ProcedureOutputArgument pa = null;
                ProcedureArgument paShadow = null;
                Parameter parm = null;
                ArgumentTypeDirection direction = arg.getDirection();
                QName xmlType = null;
                if (arg.getDataType() instanceof PLSQLType) {
                    this.hasComplexProcedureArgs = true;
                    typeString = storedProcedure.getCatalogName() + "_" + arg.getTypeName();
                    xmlType = Util.buildCustomQName(typeString, this.dbwsBuilder);
                } else if (arg.getDataType() instanceof VArrayType || arg.getDataType() instanceof ObjectType) {
                    this.hasComplexProcedureArgs = true;
                    typeString = arg.getTypeName().toLowerCase().concat("Type");
                    xmlType = Util.buildCustomQName(typeString, this.dbwsBuilder);
                } else {
                    switch (Util.getJDBCTypeFromTypeName(arg.getTypeName())) {
                        case 2002: 
                        case 2003: {
                            typeString = this.nct.generateSchemaAlias(arg.getTypeName());
                            xmlType = Util.buildCustomQName(typeString, this.dbwsBuilder);
                            break;
                        }
                        default: {
                            xmlType = Util.getXMLTypeFromJDBCType(Util.getJDBCTypeFromTypeName(arg.getTypeName()));
                        }
                    }
                }
                if (direction == ArgumentTypeDirection.IN) {
                    parm = new Parameter();
                    parm.setName(argName);
                    parm.setType(xmlType);
                    pa = new ProcedureArgument();
                    pa.setName(argName);
                    pa.setParameterName(argName);
                } else {
                    ProcedureOutputArgument pao = pa = new ProcedureOutputArgument();
                    pao.setName(argName);
                    pao.setParameterName(argName);
                    boolean isCursor = arg.getTypeName().contains("CURSOR");
                    if (isCursor && returnType == null) {
                        pao.setResultType(Util.SXF_QNAME_CURSOR);
                        if (result == null) {
                            result = new CollectionResult();
                            result.setType(Util.SXF_QNAME_CURSOR);
                        }
                    } else {
                        if (returnType != null && !isSimpleXMLFormat) {
                            xmlType = Util.qNameFromString("{" + this.dbwsBuilder.getTargetNamespace() + "}" + returnType, this.dbwsBuilder.getSchema());
                        }
                        if (isCursor) {
                            pao.setResultType(new QName("", "cursor of " + returnType));
                            CollectionResult newResult = new CollectionResult();
                            newResult.setType(result.getType());
                            result = newResult;
                        } else {
                            pao.setResultType(xmlType);
                        }
                        if (result == null) {
                            result = isCollection ? new CollectionResult() : new Result();
                            result.setType(xmlType);
                        }
                    }
                    if (direction == ArgumentTypeDirection.INOUT) {
                        parm = new Parameter();
                        parm.setName(argName);
                        parm.setType(Util.getXMLTypeFromJDBCType(Util.getJDBCTypeFromTypeName(arg.getTypeName())));
                        result.setType(parm.getType());
                        isSimpleXMLFormat = false;
                        paShadow = new ProcedureArgument();
                        paShadow.setName(argName);
                        paShadow.setParameterName(argName);
                    }
                }
                if (arg.getDataType() instanceof PLSQLType) {
                    pa.setComplexTypeName(storedProcedure.getCatalogName() + "_" + arg.getTypeName());
                    if (paShadow != null) {
                        paShadow.setComplexTypeName(pa.getComplexTypeName());
                    }
                }
                if (parm == null) continue;
                qo.getParameters().add(parm);
            }
            this.handleSimpleXMLFormat(isSimpleXMLFormat, (Result)result, procedureOperationModel);
            qo.setResult(result);
            this.dbwsBuilder.getXrServiceModel().getOperations().put(qo.getName(), qo);
        }
        this.finishProcedureOperation();
    }

    protected Result buildResultForStoredFunction(ProcedureType storedProcedure, String returnType) {
        CollectionResult result = null;
        FunctionType storedFunction = (FunctionType)storedProcedure;
        ArgumentType rarg = storedFunction.getReturnArgument();
        if (rarg.getTypeName().contains("CURSOR")) {
            result = new CollectionResult();
            result.setType(Util.SXF_QNAME_CURSOR);
        } else {
            result = new Result();
            int rargJdbcType = Util.getJDBCTypeFromTypeName(rarg.getTypeName());
            switch (rargJdbcType) {
                case 1111: {
                    String packageName;
                    if (returnType == null) {
                        returnType = rarg.getTypeName();
                    }
                    String returnTypeName = (packageName = storedProcedure.getCatalogName()) != null && packageName.length() > 0 ? packageName + "_" + returnType : returnType;
                    result.setType(Util.buildCustomQName(returnTypeName, this.dbwsBuilder));
                    break;
                }
                case 2002: 
                case 2003: {
                    if (returnType != null) {
                        result.setType(Util.buildCustomQName(returnType, this.dbwsBuilder));
                        break;
                    }
                    result.setType(XMLConstants.ANY_QNAME);
                    break;
                }
                default: {
                    result.setType(Util.getXMLTypeFromJDBCType(rargJdbcType));
                }
            }
        }
        return result;
    }

    protected String getNameForQueryOperation(String modelName, ProcedureType storedProcedure) {
        if (modelName != null && modelName.length() > 0) {
            return modelName;
        }
        StringBuilder sb = new StringBuilder();
        if (storedProcedure.getOverload() > 0) {
            sb.append(storedProcedure.getOverload());
            sb.append('_');
        }
        if (storedProcedure.getCatalogName() != null && storedProcedure.getCatalogName().length() > 0) {
            sb.append(storedProcedure.getCatalogName());
            sb.append('_');
        }
        if (storedProcedure.getSchema() != null && storedProcedure.getSchema().length() > 0) {
            sb.append(storedProcedure.getSchema());
            sb.append('_');
        }
        sb.append(storedProcedure.getProcedureName());
        return sb.toString();
    }

    protected String getQualifiedProcedureName(ProcedureOperationModel procedureOperationModel, ProcedureType storedProcedure) {
        StringBuilder sb = new StringBuilder();
        if (storedProcedure.getCatalogName() != null && storedProcedure.getCatalogName().length() > 0) {
            sb.append(storedProcedure.getCatalogName());
            sb.append('.');
        }
        if (procedureOperationModel.getSchemaPattern() != null && procedureOperationModel.getSchemaPattern().length() > 0 && storedProcedure.getSchema() != null && storedProcedure.getSchema().length() > 0) {
            sb.append(storedProcedure.getSchema());
            sb.append('.');
        }
        sb.append(storedProcedure.getProcedureName());
        return sb.toString();
    }

    protected void handleSimpleXMLFormat(boolean isSimpleXMLFormat, Result result, ProcedureOperationModel procedureOperationModel) {
        if (isSimpleXMLFormat) {
            String xmlTag;
            SimpleXMLFormat sxf = new SimpleXMLFormat();
            String simpleXMLFormatTag = procedureOperationModel.getSimpleXMLFormatTag();
            if (simpleXMLFormatTag != null && simpleXMLFormatTag.length() > 0) {
                sxf.setSimpleXMLFormatTag(simpleXMLFormatTag);
            }
            if ((xmlTag = procedureOperationModel.getXmlTag()) != null && xmlTag.length() > 0) {
                sxf.setXMLTag(xmlTag);
            }
            result.setSimpleXMLFormat(sxf);
            if (this.dbwsBuilder.getOxProject().getDescriptorForAlias("simple-xml-format") == null) {
                SimpleXMLFormatProject sxfProject = new SimpleXMLFormatProject();
                this.dbwsBuilder.getOxProject().addDescriptor(sxfProject.buildXRRowSetModelDescriptor());
            }
        }
    }

    protected void finishProcedureOperation() {
        if (Util.requiresSimpleXMLFormat(this.dbwsBuilder.getXrServiceModel()) && this.dbwsBuilder.getSchema().getTopLevelElements().get("simple-xml-format") == null) {
            Util.addSimpleXMLFormat(this.dbwsBuilder.getSchema());
        }
    }

    @Override
    protected List<TableType> loadTables(String originalCatalogPattern, String schemaPattern, String tableNamePattern) {
        try {
            return this.dtBuilder.buildTables(this.dbwsBuilder.getConnection(), schemaPattern, tableNamePattern);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected List<ProcedureType> loadProcedures(ProcedureOperationModel procedureModel) {
        ArrayList<ProcedureType> allProcsAndFuncs = new ArrayList<ProcedureType>();
        try {
            if (procedureModel.isPLSQLProcedureOperation()) {
                List foundPackages = this.dtBuilder.buildPackages(this.dbwsBuilder.getConnection(), procedureModel.getSchemaPattern(), procedureModel.getCatalogPattern());
                if (foundPackages != null) {
                    for (PLSQLPackageType plsqlpkg : foundPackages) {
                        for (ProcedureType pType : plsqlpkg.getProcedures()) {
                            if (!Util.sqlMatch(procedureModel.getProcedurePattern(), pType.getProcedureName())) continue;
                            allProcsAndFuncs.add(pType);
                        }
                    }
                }
            } else {
                List foundProcedures = this.dtBuilder.buildProcedures(this.dbwsBuilder.getConnection(), procedureModel.getSchemaPattern(), procedureModel.getProcedurePattern());
                List foundFunctions = this.dtBuilder.buildFunctions(this.dbwsBuilder.getConnection(), procedureModel.getSchemaPattern(), procedureModel.getProcedurePattern());
                if (foundProcedures != null) {
                    allProcsAndFuncs.addAll(foundProcedures);
                }
                if (foundFunctions != null) {
                    allProcsAndFuncs.addAll(foundFunctions);
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return allProcsAndFuncs.isEmpty() ? null : allProcsAndFuncs;
    }

    @Override
    protected void addToOROXProjectsForComplexArgs(List<ArgumentType> arguments, Project orProject, Project oxProject, ProcedureOperationModel opModel) {
        for (ArgumentType arg : arguments) {
            String alias;
            String name;
            org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dbType = arg.getDataType();
            if (dbType instanceof PLSQLType) {
                name = opModel.getCatalogPattern() + "." + dbType.getTypeName();
                String targetTypeName = opModel.getCatalogPattern() + "_" + dbType.getTypeName();
                alias = targetTypeName.toLowerCase();
                if (dbType instanceof PLSQLRecordType) {
                    this.addToOXProjectForPLSQLRecordArg(dbType, oxProject, name, alias, targetTypeName, opModel.getCatalogPattern());
                    this.addToORProjectForPLSQLRecordArg(dbType, orProject, name, alias, targetTypeName, opModel.getCatalogPattern());
                    continue;
                }
                this.addToOXProjectForPLSQLTableArg(dbType, oxProject, name, alias, targetTypeName, opModel.getCatalogPattern());
                this.addToORProjectForPLSQLTableArg(dbType, orProject, name, alias, targetTypeName, opModel.getCatalogPattern());
                continue;
            }
            name = dbType.getTypeName();
            alias = name.toLowerCase();
            if (dbType instanceof VArrayType) {
                this.addToOXProjectForVArrayArg(dbType, oxProject, name, alias);
                this.addToORProjectForVArrayArg(dbType, orProject, name, alias);
                continue;
            }
            if (dbType instanceof ObjectType) {
                this.addToOXProjectForObjectTypeArg(dbType, oxProject, name, alias);
                this.addToORProjectForObjectTypeArg(dbType, orProject, alias);
                continue;
            }
            if (!(dbType instanceof ObjectTableType)) continue;
            this.addToOXProjectForObjectTableTypeArg(dbType, oxProject, name, alias);
            this.addToORProjectForObjectTableTypeArg(dbType, orProject, name, alias);
        }
    }

    protected void addToOXProjectForPLSQLRecordArg(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dbType, Project oxProject, String recordName, String recordAlias, String targetTypeName, String catalogPattern) {
        QName xmlType = Util.buildCustomQName(targetTypeName, this.dbwsBuilder);
        String targetNamespace = xmlType.getNamespaceURI();
        XMLDescriptor xdesc = (XMLDescriptor)oxProject.getDescriptorForAlias(recordAlias);
        if (xdesc == null) {
            xdesc = new XMLDescriptor();
            xdesc.setAlias(recordAlias);
            xdesc.setJavaClassName(recordName.toLowerCase());
            xdesc.setDefaultRootElement(targetTypeName);
            xdesc.getQueryManager();
            XMLSchemaURLReference schemaReference = new XMLSchemaURLReference();
            schemaReference.setSchemaContext("/" + targetTypeName);
            schemaReference.setType(1);
            xdesc.setSchemaReference((XMLSchemaReference)schemaReference);
            NamespaceResolver nr = new NamespaceResolver();
            nr.setDefaultNamespaceURI(targetNamespace);
            xdesc.setNamespaceResolver(nr);
            oxProject.addDescriptor((ClassDescriptor)xdesc);
        }
        PLSQLRecordType plsqlRecType = (PLSQLRecordType)dbType;
        for (FieldType fType : plsqlRecType.getFields()) {
            String fieldName = fType.getFieldName();
            String lFieldName = fieldName.toLowerCase();
            if (xdesc.getMappingForAttributeName(lFieldName) != null) continue;
            if (fType.isComposite()) {
                XMLCompositeObjectMapping fieldMapping;
                if (fType.getDataType() instanceof PLSQLRecordType) {
                    XMLCompositeObjectMapping fieldMapping2 = new XMLCompositeObjectMapping();
                    fieldMapping2.setAttributeName(lFieldName);
                    fieldMapping2.setXPath(lFieldName);
                    XMLField xField = (XMLField)fieldMapping2.getField();
                    xField.setRequired(true);
                    fieldMapping2.setReferenceClassName((catalogPattern + "." + fType.getDataType()).toLowerCase());
                    xdesc.addMapping((DatabaseMapping)fieldMapping2);
                    continue;
                }
                if (!(fType.getDataType() instanceof PLSQLCollectionType)) continue;
                PLSQLCollectionType tableType = (PLSQLCollectionType)fType.getDataType();
                if (tableType.getNestedType().isComposite()) {
                    fieldMapping = new XMLCompositeObjectMapping();
                    fieldMapping.setAttributeName(lFieldName);
                    fieldMapping.setXPath(lFieldName);
                    XMLField xField = (XMLField)fieldMapping.getField();
                    xField.setRequired(true);
                    fieldMapping.setReferenceClassName((catalogPattern + "." + tableType.getTypeName()).toLowerCase() + "_CollectionWrapper");
                    xdesc.addMapping((DatabaseMapping)fieldMapping);
                    continue;
                }
                fieldMapping = new XMLCompositeDirectCollectionMapping();
                XMLDescriptor refDesc = (XMLDescriptor)oxProject.getDescriptorForAlias((catalogPattern + "_" + tableType.getTypeName()).toLowerCase());
                if (refDesc != null) {
                    XMLCompositeDirectCollectionMapping itemsMapping = (XMLCompositeDirectCollectionMapping)refDesc.getMappingForAttributeName("items");
                    Class attributeElementClass = itemsMapping.getAttributeElementClass();
                    fieldMapping.setAttributeElementClass(attributeElementClass);
                } else {
                    fieldMapping.setAttributeElementClass(String.class);
                }
                fieldMapping.setAttributeName(lFieldName);
                fieldMapping.setUsesSingleNode(true);
                fieldMapping.setXPath(lFieldName + "/item/text()");
                XMLField xField = (XMLField)fieldMapping.getField();
                xField.setRequired(true);
                fieldMapping.useCollectionClassName("java.util.ArrayList");
                AbstractNullPolicy nullPolicy = fieldMapping.getNullPolicy();
                nullPolicy.setNullRepresentedByEmptyNode(false);
                nullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
                nullPolicy.setNullRepresentedByXsiNil(true);
                fieldMapping.setNullPolicy(nullPolicy);
                xdesc.getNamespaceResolver().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                xdesc.addMapping((DatabaseMapping)fieldMapping);
                continue;
            }
            this.addDirectMappingForFieldType(xdesc, lFieldName, fType);
        }
    }

    protected void addToORProjectForPLSQLRecordArg(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dbType, Project orProject, String recordName, String recordAlias, String targetTypeName, String catalogPattern) {
        ObjectRelationalDataTypeDescriptor ordtDesc = (ObjectRelationalDataTypeDescriptor)orProject.getDescriptorForAlias(recordAlias);
        if (ordtDesc == null) {
            ordtDesc = new ObjectRelationalDataTypeDescriptor();
            ordtDesc.descriptorIsAggregate();
            ordtDesc.setAlias(recordAlias);
            ordtDesc.setJavaClassName(recordName.toLowerCase());
            ordtDesc.getQueryManager();
            ordtDesc.setStructureName(targetTypeName);
            orProject.addDescriptor((ClassDescriptor)ordtDesc);
        }
        PLSQLRecordType plsqlRecType = (PLSQLRecordType)dbType;
        for (FieldType fType : plsqlRecType.getFields()) {
            String fieldName = fType.getFieldName();
            String lFieldName = fieldName.toLowerCase();
            boolean found = false;
            Vector orderedFields = ordtDesc.getOrderedFields();
            for (Object o : orderedFields) {
                DatabaseField field;
                if (!(o instanceof DatabaseField) || !(field = (DatabaseField)o).getName().equals(lFieldName)) continue;
                found = true;
                break;
            }
            if (!found) {
                ordtDesc.addFieldOrdering(lFieldName);
            }
            if (ordtDesc.getMappingForAttributeName(lFieldName) != null) continue;
            if (fType.isComposite()) {
                if (fType.getDataType() instanceof PLSQLRecordType) {
                    StructureMapping structureMapping = new StructureMapping();
                    structureMapping.setAttributeName(lFieldName);
                    structureMapping.setFieldName(lFieldName);
                    structureMapping.setReferenceClassName(recordName.toLowerCase());
                    ordtDesc.addMapping((DatabaseMapping)structureMapping);
                    continue;
                }
                if (!(fType.getDataType() instanceof PLSQLCollectionType)) continue;
                PLSQLCollectionType tableType = (PLSQLCollectionType)fType.getDataType();
                if (tableType.getNestedType().isComposite()) {
                    ObjectArrayMapping objectArrayMapping = new ObjectArrayMapping();
                    objectArrayMapping.setAttributeName(lFieldName);
                    objectArrayMapping.setFieldName(lFieldName);
                    objectArrayMapping.setStructureName(targetTypeName);
                    objectArrayMapping.setReferenceClassName((catalogPattern + "." + tableType.getTypeName()).toLowerCase() + "_CollectionWrapper");
                    ordtDesc.addMapping((DatabaseMapping)objectArrayMapping);
                    continue;
                }
                ArrayMapping arrayMapping = new ArrayMapping();
                arrayMapping.setAttributeName(lFieldName);
                arrayMapping.setFieldName(lFieldName);
                arrayMapping.setStructureName(targetTypeName);
                ordtDesc.addMapping((DatabaseMapping)arrayMapping);
                continue;
            }
            ordtDesc.addDirectMapping(lFieldName, lFieldName);
        }
    }

    protected void addToOXProjectForPLSQLTableArg(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dbType, Project oxProject, String tableName, String tableAlias, String targetTypeName, String catalogPattern) {
        boolean itemsMappingFound;
        QName xmlType = Util.buildCustomQName(targetTypeName, this.dbwsBuilder);
        String targetNamespace = xmlType.getNamespaceURI();
        XMLDescriptor xdesc = (XMLDescriptor)oxProject.getDescriptorForAlias(tableAlias);
        if (xdesc == null) {
            xdesc = new XMLDescriptor();
            xdesc.setAlias(tableAlias);
            xdesc.setJavaClassName(tableName.toLowerCase() + "_CollectionWrapper");
            xdesc.getQueryManager();
            xdesc.setDefaultRootElement(targetTypeName);
            XMLSchemaURLReference schemaReference = new XMLSchemaURLReference("");
            schemaReference.setSchemaContext("/" + targetTypeName);
            schemaReference.setType(1);
            xdesc.setSchemaReference((XMLSchemaReference)schemaReference);
            NamespaceResolver nr = new NamespaceResolver();
            nr.setDefaultNamespaceURI(targetNamespace);
            xdesc.setNamespaceResolver(nr);
            oxProject.addDescriptor((ClassDescriptor)xdesc);
        }
        boolean bl = itemsMappingFound = xdesc.getMappingForAttributeName("items") != null;
        if (!itemsMappingFound) {
            org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType nestedType = ((PLSQLCollectionType)dbType).getNestedType();
            if (nestedType instanceof PLSQLRecordType) {
                XMLCompositeCollectionMapping itemsMapping = new XMLCompositeCollectionMapping();
                itemsMapping.setAttributeName("items");
                itemsMapping.setXPath("item");
                XMLField xField = (XMLField)itemsMapping.getField();
                xField.setRequired(true);
                itemsMapping.useCollectionClassName("java.util.ArrayList");
                itemsMapping.setReferenceClassName((catalogPattern + "." + ((PLSQLRecordType)nestedType).getTypeName()).toLowerCase());
                xdesc.addMapping((DatabaseMapping)itemsMapping);
            } else if (nestedType.isComposite()) {
                XMLCompositeCollectionMapping itemsMapping = new XMLCompositeCollectionMapping();
                itemsMapping.setAttributeName("items");
                itemsMapping.setXPath("item");
                XMLField xField = (XMLField)itemsMapping.getField();
                xField.setRequired(true);
                itemsMapping.useCollectionClassName("java.util.ArrayList");
                itemsMapping.setReferenceClassName(tableName.toLowerCase() + "_CollectionWrapper");
                xdesc.addMapping((DatabaseMapping)itemsMapping);
            } else {
                XMLCompositeDirectCollectionMapping itemsMapping = new XMLCompositeDirectCollectionMapping();
                itemsMapping.setAttributeElementClass(OracleHelper.getAttributeClassForDatabaseType(nestedType));
                itemsMapping.setAttributeName("items");
                itemsMapping.setUsesSingleNode(true);
                itemsMapping.setXPath("item/text()");
                XMLField xField = (XMLField)itemsMapping.getField();
                xField.setRequired(true);
                itemsMapping.useCollectionClassName("java.util.ArrayList");
                AbstractNullPolicy nullPolicy = itemsMapping.getNullPolicy();
                nullPolicy.setNullRepresentedByEmptyNode(false);
                nullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
                nullPolicy.setNullRepresentedByXsiNil(true);
                itemsMapping.setNullPolicy(nullPolicy);
                xdesc.getNamespaceResolver().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                xdesc.addMapping((DatabaseMapping)itemsMapping);
            }
        }
    }

    protected void addToORProjectForPLSQLTableArg(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dbType, Project orProject, String tableName, String tableAlias, String targetTypeName, String catalogPattern) {
        boolean itemsMappingFound;
        ObjectRelationalDataTypeDescriptor ordt = (ObjectRelationalDataTypeDescriptor)orProject.getDescriptorForAlias(tableAlias);
        if (ordt == null) {
            ordt = new ObjectRelationalDataTypeDescriptor();
            ordt.descriptorIsAggregate();
            ordt.setAlias(tableAlias);
            ordt.setJavaClassName(tableName.toLowerCase() + "_CollectionWrapper");
            ordt.getQueryManager();
            orProject.addDescriptor((ClassDescriptor)ordt);
        }
        boolean bl = itemsMappingFound = ordt.getMappingForAttributeName("items") != null;
        if (!itemsMappingFound) {
            org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType nestedType = ((PLSQLCollectionType)dbType).getNestedType();
            if (nestedType instanceof PLSQLRecordType) {
                ObjectArrayMapping itemsMapping = new ObjectArrayMapping();
                itemsMapping.setAttributeName("items");
                itemsMapping.setFieldName("ITEMS");
                itemsMapping.setStructureName(targetTypeName);
                itemsMapping.setReferenceClassName((catalogPattern + "." + ((PLSQLRecordType)nestedType).getTypeName()).toLowerCase());
                ordt.addMapping((DatabaseMapping)itemsMapping);
            } else {
                ArrayMapping itemsMapping = new ArrayMapping();
                itemsMapping.setAttributeName("items");
                itemsMapping.setFieldName("ITEMS");
                itemsMapping.useCollectionClass(ArrayList.class);
                itemsMapping.setStructureName(targetTypeName);
                ordt.addMapping((DatabaseMapping)itemsMapping);
            }
        }
    }

    protected void addToOXProjectForVArrayArg(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dbType, Project oxProject, String arrayName, String arrayAlias) {
        boolean itemsMappingFound;
        QName xmlType = Util.buildCustomQName(arrayName, this.dbwsBuilder);
        String targetNamespace = xmlType.getNamespaceURI();
        String userType = this.nct.generateSchemaAlias(arrayAlias);
        XMLDescriptor xdesc = (XMLDescriptor)oxProject.getDescriptorForAlias(arrayAlias);
        if (xdesc == null) {
            xdesc = new XMLDescriptor();
            xdesc.setAlias(arrayAlias);
            xdesc.setJavaClassName(arrayAlias + "_CollectionWrapper");
            xdesc.getQueryManager();
            XMLSchemaURLReference schemaReference = new XMLSchemaURLReference();
            schemaReference.setSchemaContext("/" + userType);
            schemaReference.setType(1);
            xdesc.setSchemaReference((XMLSchemaReference)schemaReference);
            NamespaceResolver nr = new NamespaceResolver();
            nr.setDefaultNamespaceURI(targetNamespace);
            xdesc.setNamespaceResolver(nr);
            xdesc.setDefaultRootElement(userType);
            oxProject.addDescriptor((ClassDescriptor)xdesc);
        }
        boolean bl = itemsMappingFound = xdesc.getMappingForAttributeName("items") != null;
        if (!itemsMappingFound) {
            org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType nestedType = ((VArrayType)dbType).getEnclosedType();
            if (nestedType.isComposite()) {
                XMLCompositeCollectionMapping itemsMapping = new XMLCompositeCollectionMapping();
                itemsMapping.setAttributeName("items");
                itemsMapping.setXPath("item");
                ((XMLField)itemsMapping.getField()).setRequired(true);
                itemsMapping.useCollectionClass(ArrayList.class);
                itemsMapping.setReferenceClassName(nestedType.getTypeName().toLowerCase());
                xdesc.addMapping((DatabaseMapping)itemsMapping);
            } else {
                XMLCompositeDirectCollectionMapping itemsMapping = new XMLCompositeDirectCollectionMapping();
                itemsMapping.setAttributeElementClass(OracleHelper.getAttributeClassForDatabaseType(nestedType));
                itemsMapping.setAttributeName("items");
                itemsMapping.setUsesSingleNode(true);
                itemsMapping.setXPath("item/text()");
                ((XMLField)itemsMapping.getField()).setRequired(true);
                itemsMapping.useCollectionClass(ArrayList.class);
                AbstractNullPolicy nullPolicy = itemsMapping.getNullPolicy();
                nullPolicy.setNullRepresentedByEmptyNode(false);
                nullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
                nullPolicy.setNullRepresentedByXsiNil(true);
                itemsMapping.setNullPolicy(nullPolicy);
                xdesc.getNamespaceResolver().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                xdesc.addMapping((DatabaseMapping)itemsMapping);
            }
        }
    }

    protected void addToORProjectForVArrayArg(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dbType, Project orProject, String arrayName, String arrayAlias) {
        boolean itemsMappingFound;
        ObjectRelationalDataTypeDescriptor ordt = (ObjectRelationalDataTypeDescriptor)orProject.getDescriptorForAlias(arrayAlias);
        if (ordt == null) {
            ordt = new ObjectRelationalDataTypeDescriptor();
            ordt.descriptorIsAggregate();
            ordt.setAlias(arrayAlias);
            ordt.setJavaClassName(arrayAlias + "_CollectionWrapper");
            ordt.getQueryManager();
            orProject.addDescriptor((ClassDescriptor)ordt);
        }
        boolean bl = itemsMappingFound = ordt.getMappingForAttributeName("items") != null;
        if (!itemsMappingFound) {
            org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType nestedType = ((VArrayType)dbType).getEnclosedType();
            if (nestedType.isComposite()) {
                ObjectArrayMapping itemsMapping = new ObjectArrayMapping();
                itemsMapping.setAttributeName("items");
                itemsMapping.setFieldName("ITEMS");
                itemsMapping.setStructureName(arrayName);
                itemsMapping.setReferenceClassName(nestedType.getTypeName().toLowerCase());
                ordt.addMapping((DatabaseMapping)itemsMapping);
            } else {
                ArrayMapping itemsMapping = new ArrayMapping();
                itemsMapping.setAttributeName("items");
                itemsMapping.setFieldName("ITEMS");
                itemsMapping.useCollectionClass(ArrayList.class);
                itemsMapping.setStructureName(arrayName);
                ordt.addMapping((DatabaseMapping)itemsMapping);
            }
        }
    }

    protected void addToOXProjectForObjectTypeArg(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dbType, Project oxProject, String objectName, String objectAlias) {
        QName xmlType = Util.buildCustomQName(objectName, this.dbwsBuilder);
        String targetNamespace = xmlType.getNamespaceURI();
        String userType = this.nct.generateSchemaAlias(objectAlias);
        XMLDescriptor xdesc = (XMLDescriptor)oxProject.getDescriptorForAlias(objectAlias);
        if (xdesc == null) {
            xdesc = this.buildNewXMLDescriptor(objectAlias, userType, targetNamespace);
            oxProject.addDescriptor((ClassDescriptor)xdesc);
        }
        ObjectType oType = (ObjectType)dbType;
        for (FieldType field : oType.getFields()) {
            String fieldName = field.getFieldName();
            String lFieldName = fieldName.toLowerCase();
            if (xdesc.getMappingForAttributeName(lFieldName) != null) continue;
            if (field.isComposite()) {
                if (!(field.getDataType() instanceof ObjectType)) continue;
                String alias = field.getDataType().getTypeName().toLowerCase();
                XMLDescriptor xdesc2 = (XMLDescriptor)oxProject.getDescriptorForAlias(alias);
                if (xdesc2 == null) {
                    String targetTypeName2 = field.getDataType().getTypeName();
                    QName xmlType2 = Util.buildCustomQName(targetTypeName2, this.dbwsBuilder);
                    String targetNamespace2 = xmlType2.getNamespaceURI();
                    String userType2 = this.nct.generateSchemaAlias(alias);
                    xdesc2 = this.buildNewXMLDescriptor(alias, userType2, targetNamespace2);
                    oxProject.addDescriptor((ClassDescriptor)xdesc2);
                    this.addToOXProjectForObjectTypeArg(field.getDataType(), oxProject, targetTypeName2, alias);
                }
                XMLCompositeObjectMapping compMapping = new XMLCompositeObjectMapping();
                compMapping.setAttributeName(lFieldName);
                compMapping.setReferenceClassName(xdesc2.getJavaClassName());
                compMapping.setXPath(lFieldName);
                XMLField xField = (XMLField)compMapping.getField();
                xField.setRequired(true);
                xdesc.addMapping((DatabaseMapping)compMapping);
                continue;
            }
            this.addDirectMappingForFieldType(xdesc, lFieldName, field);
        }
    }

    protected void addToORProjectForObjectTypeArg(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dbType, Project orProject, String objectAlias) {
        ObjectRelationalDataTypeDescriptor ordt = (ObjectRelationalDataTypeDescriptor)orProject.getDescriptorForAlias(objectAlias);
        if (ordt == null) {
            ordt = this.buildNewObjectRelationalDataTypeDescriptor(objectAlias);
            orProject.addDescriptor((ClassDescriptor)ordt);
        }
        ObjectType oType = (ObjectType)dbType;
        for (FieldType fType : oType.getFields()) {
            String fieldName = fType.getFieldName();
            String lFieldName = fieldName.toLowerCase();
            boolean found = false;
            Vector orderedFields = ordt.getOrderedFields();
            for (Object o : orderedFields) {
                DatabaseField field;
                if (!(o instanceof DatabaseField) || !(field = (DatabaseField)o).getName().equals(lFieldName)) continue;
                found = true;
                break;
            }
            if (!found) {
                ordt.addFieldOrdering(lFieldName);
            }
            if (ordt.getMappingForAttributeName(lFieldName) != null) continue;
            if (fType.isComposite()) {
                if (!(fType.getDataType() instanceof ObjectType)) continue;
                String targetTypeName2 = fType.getDataType().getTypeName();
                String alias = targetTypeName2.toLowerCase();
                ObjectRelationalDataTypeDescriptor ordt2 = (ObjectRelationalDataTypeDescriptor)orProject.getDescriptorForAlias(alias);
                if (ordt2 == null) {
                    ordt2 = this.buildNewObjectRelationalDataTypeDescriptor(alias);
                    orProject.addDescriptor((ClassDescriptor)ordt2);
                    this.addToORProjectForObjectTypeArg(fType.getDataType(), orProject, alias);
                }
                StructureMapping structMapping = new StructureMapping();
                structMapping.setFieldName(lFieldName);
                structMapping.setAttributeName(lFieldName);
                structMapping.setReferenceClassName(ordt2.getJavaClassName());
                ordt.addMapping((DatabaseMapping)structMapping);
                continue;
            }
            DirectToFieldMapping dfm = new DirectToFieldMapping();
            dfm.setFieldName(lFieldName);
            dfm.setAttributeName(lFieldName);
            ordt.addMapping((DatabaseMapping)dfm);
        }
    }

    protected void addToOXProjectForObjectTableTypeArg(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dbType, Project oxProject, String objectTableName, String objectTableAlias) {
        boolean itemsMappingFound;
        QName xmlType = Util.buildCustomQName(objectTableName, this.dbwsBuilder);
        String targetNamespace = xmlType.getNamespaceURI();
        String userType = this.nct.generateSchemaAlias(objectTableAlias);
        XMLDescriptor xdesc = (XMLDescriptor)oxProject.getDescriptorForAlias(objectTableAlias);
        if (xdesc == null) {
            xdesc = new XMLDescriptor();
            xdesc.setAlias(objectTableAlias);
            xdesc.setJavaClassName(objectTableAlias + "_CollectionWrapper");
            xdesc.getQueryManager();
            XMLSchemaURLReference schemaReference = new XMLSchemaURLReference();
            schemaReference.setSchemaContext("/" + userType);
            schemaReference.setType(1);
            xdesc.setSchemaReference((XMLSchemaReference)schemaReference);
            NamespaceResolver nr = new NamespaceResolver();
            nr.setDefaultNamespaceURI(targetNamespace);
            xdesc.setNamespaceResolver(nr);
            xdesc.setDefaultRootElement(userType);
            oxProject.addDescriptor((ClassDescriptor)xdesc);
        }
        boolean bl = itemsMappingFound = xdesc.getMappingForAttributeName("items") != null;
        if (!itemsMappingFound) {
            ObjectType nestedType = (ObjectType)((ObjectTableType)dbType).getEnclosedType();
            String nestedTypeAlias = nestedType.getTypeName().toLowerCase();
            this.addToOXProjectForObjectTypeArg((org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType)nestedType, oxProject, nestedType.getTypeName(), nestedTypeAlias);
            XMLDescriptor nestedTypeDesc = (XMLDescriptor)oxProject.getDescriptorForAlias(nestedTypeAlias);
            XMLCompositeCollectionMapping itemsMapping = new XMLCompositeCollectionMapping();
            itemsMapping.setAttributeName("items");
            itemsMapping.setXPath("item");
            ((XMLField)itemsMapping.getField()).setRequired(true);
            itemsMapping.setReferenceClassName(nestedTypeDesc.getJavaClassName());
            itemsMapping.useCollectionClass(ArrayList.class);
            xdesc.addMapping((DatabaseMapping)itemsMapping);
        }
    }

    protected void addToORProjectForObjectTableTypeArg(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dbType, Project orProject, String objectTableName, String objectTableAlias) {
        boolean itemsMappingFound;
        ObjectRelationalDataTypeDescriptor ordt = (ObjectRelationalDataTypeDescriptor)orProject.getDescriptorForAlias(objectTableAlias);
        if (ordt == null) {
            ordt = this.buildNewObjectRelationalDataTypeDescriptor(objectTableAlias, objectTableAlias + "_CollectionWrapper");
            orProject.addDescriptor((ClassDescriptor)ordt);
        }
        boolean bl = itemsMappingFound = ordt.getMappingForAttributeName("items") != null;
        if (!itemsMappingFound) {
            ObjectType nestedType = (ObjectType)((ObjectTableType)dbType).getEnclosedType();
            String nestedTypeAlias = nestedType.getTypeName().toLowerCase();
            this.addToORProjectForObjectTypeArg((org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType)nestedType, orProject, nestedTypeAlias);
            ObjectRelationalDataTypeDescriptor nestedTypeDesc = (ObjectRelationalDataTypeDescriptor)orProject.getDescriptorForAlias(nestedTypeAlias);
            ObjectArrayMapping itemsMapping = new ObjectArrayMapping();
            itemsMapping.setAttributeName("items");
            itemsMapping.setFieldName("ITEMS");
            itemsMapping.setStructureName(objectTableName);
            itemsMapping.setReferenceClassName(nestedTypeDesc.getJavaClassName());
            itemsMapping.useCollectionClass(ArrayList.class);
            ordt.addMapping((DatabaseMapping)itemsMapping);
        }
    }

    @Override
    protected void buildQueryForProcedureType(ProcedureType procType, Project orProject, Project oxProject, ProcedureOperationModel opModel, String queryName) {
        if (opModel.isPLSQLProcedureOperation()) {
            this.buildQueryForPLSQLProcedureType(procType, orProject, oxProject, opModel, queryName);
        } else {
            this.buildQueryForAdvancedJDBCProcedureType(procType, orProject, oxProject, opModel, queryName);
        }
    }

    protected void buildQueryForPLSQLProcedureType(ProcedureType procType, Project orProject, Project oxProject, ProcedureOperationModel opModel, String queryName) {
        PLSQLStoredProcedureCall call;
        if (procType.isFunction()) {
            DatabaseType returnDatabaseType = opModel.getDbStoredFunctionReturnType();
            if (returnDatabaseType == null) {
                returnDatabaseType = this.buildDatabaseTypeFromMetadataType((org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType)((FunctionType)procType).getReturnArgument(), procType.getCatalogName());
            }
            call = new PLSQLStoredFunctionCall(returnDatabaseType);
        } else {
            call = new PLSQLStoredProcedureCall();
        }
        String cat = procType.getCatalogName();
        String catalogPrefix = cat == null || cat.length() == 0 ? "" : cat + ".";
        call.setProcedureName(catalogPrefix + procType.getProcedureName());
        String returnType = opModel.getReturnType();
        boolean hasResponse = returnType != null;
        String typ = null;
        XMLDescriptor xdesc = null;
        if (hasResponse) {
            int idx = returnType.indexOf(":");
            if (idx == -1) {
                idx = returnType.indexOf("}");
            }
            if (idx > 0) {
                typ = returnType.substring(idx + 1);
                for (XMLDescriptor xd : oxProject.getOrderedDescriptors()) {
                    String context;
                    if (xd.getSchemaReference() == null || !(context = xd.getSchemaReference().getSchemaContext()).substring(1).equals(typ)) continue;
                    xdesc = xd;
                    break;
                }
            }
        }
        Object dq = null;
        dq = hasResponse && opModel.isCollection() ? new DataReadQuery() : new ValueReadQuery();
        dq.bindAllParameters();
        dq.setName(queryName);
        dq.setCall((Call)call);
        for (ArgumentType arg : procType.getArguments()) {
            org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType argType = arg.getDataType();
            DatabaseType databaseType = this.buildDatabaseTypeFromMetadataType(argType, cat);
            ArgumentTypeDirection direction = arg.getDirection();
            if (direction == ArgumentTypeDirection.OUT) {
                call.addNamedOutputArgument(arg.getArgumentName(), databaseType);
            } else if (direction == ArgumentTypeDirection.IN) {
                call.addNamedArgument(arg.getArgumentName(), databaseType);
            } else {
                call.addNamedInOutputArgument(arg.getArgumentName(), databaseType);
            }
            if (direction != ArgumentTypeDirection.IN && direction != ArgumentTypeDirection.INOUT) continue;
            if (xdesc != null) {
                dq.addArgumentByTypeName(arg.getArgumentName(), xdesc.getJavaClassName());
                continue;
            }
            if (databaseType instanceof PLSQLCollection) {
                dq.addArgument(arg.getArgumentName(), Array.class);
                continue;
            }
            if (databaseType instanceof PLSQLrecord) {
                dq.addArgument(arg.getArgumentName(), Struct.class);
                continue;
            }
            dq.addArgument(arg.getArgumentName(), JDBCTypes.getClassForCode((int)databaseType.getConversionCode()));
        }
        orProject.getQueries().add(dq);
    }

    protected void buildQueryForAdvancedJDBCProcedureType(ProcedureType procType, Project orProject, Project oxProject, ProcedureOperationModel opModel, String queryName) {
        StoredProcedureCall call;
        if (procType.isFunction()) {
            ArgumentType returnArg = ((FunctionType)procType).getReturnArgument();
            String javaTypeName = returnArg.getTypeName();
            ClassDescriptor desc = oxProject.getDescriptorForAlias(javaTypeName.toLowerCase());
            if (desc != null) {
                javaTypeName = desc.getJavaClassName();
            }
            if (returnArg.isComposite()) {
                org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dataType = returnArg.getDataType();
                call = dataType instanceof VArrayType || dataType instanceof ObjectTableType ? new StoredFunctionCall(2003, returnArg.getTypeName(), javaTypeName, (DatabaseField)this.buildFieldForNestedType(dataType)) : new StoredFunctionCall(2002, returnArg.getTypeName(), javaTypeName);
            } else {
                call = new StoredFunctionCall();
                ((StoredFunctionCall)call).setResult(null, ClassConstants.OBJECT);
            }
        } else {
            call = new StoredProcedureCall();
        }
        String cat = procType.getCatalogName();
        String catalogPrefix = cat == null || cat.length() == 0 ? "" : cat + ".";
        call.setProcedureName(catalogPrefix + procType.getProcedureName());
        String returnType = opModel.getReturnType();
        boolean hasResponse = returnType != null;
        Object dq = null;
        dq = hasResponse && opModel.isCollection() ? new DataReadQuery() : new ValueReadQuery();
        dq.bindAllParameters();
        dq.setName(queryName);
        dq.setCall((Call)call);
        for (ArgumentType arg : procType.getArguments()) {
            org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType argType = arg.getDataType();
            ArgumentTypeDirection direction = arg.getDirection();
            String javaTypeName = argType.getTypeName();
            ClassDescriptor desc = oxProject.getDescriptorForAlias(javaTypeName.toLowerCase());
            if (desc != null) {
                javaTypeName = desc.getJavaClassName();
            }
            if (direction == ArgumentTypeDirection.IN) {
                if (argType instanceof VArrayType) {
                    dq.addArgument(arg.getArgumentName());
                    call.addNamedArgument(arg.getArgumentName(), arg.getArgumentName(), 2003, argType.getTypeName(), javaTypeName);
                    continue;
                }
                if (argType instanceof ObjectType) {
                    dq.addArgument(arg.getArgumentName());
                    call.addNamedArgument(arg.getArgumentName(), arg.getArgumentName(), 2002, argType.getTypeName(), javaTypeName);
                    continue;
                }
                if (argType instanceof ObjectTableType) {
                    dq.addArgument(arg.getArgumentName(), Array.class);
                    call.addNamedArgument(arg.getArgumentName(), arg.getArgumentName(), 2003, argType.getTypeName(), (DatabaseField)this.buildFieldForNestedType(argType));
                    continue;
                }
                dq.addArgument(arg.getArgumentName());
                call.addNamedArgument(arg.getArgumentName(), arg.getArgumentName(), Util.getJDBCTypeFromTypeName(argType.getTypeName()));
                continue;
            }
            if (direction == ArgumentTypeDirection.OUT) {
                if (argType.isComposite()) {
                    DatabaseField dbf;
                    if (argType instanceof VArrayType || argType instanceof ObjectTableType) {
                        try {
                            call.addNamedOutputArgument(arg.getArgumentName(), arg.getArgumentName(), 2003, argType.getTypeName(), new XRDynamicClassLoader(this.getClass().getClassLoader()).loadClass(javaTypeName), (DatabaseField)this.buildFieldForNestedType(argType));
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            call.addNamedOutputArgument(arg.getArgumentName(), arg.getArgumentName(), 2003, argType.getTypeName(), (Class)null, (DatabaseField)this.buildFieldForNestedType(argType));
                            for (Object param : call.getParameters()) {
                                dbf = (DatabaseField)param;
                                if (!dbf.getName().equals(arg.getArgumentName())) continue;
                                dbf.setTypeName(javaTypeName);
                            }
                            continue;
                        }
                    }
                    try {
                        call.addNamedOutputArgument(arg.getArgumentName(), arg.getArgumentName(), 2002, argType.getTypeName(), new XRDynamicClassLoader(this.getClass().getClassLoader()).loadClass(javaTypeName));
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        call.addNamedOutputArgument(arg.getArgumentName(), arg.getArgumentName(), 2002, argType.getTypeName(), (Class)null);
                        for (Object param : call.getParameters()) {
                            dbf = (DatabaseField)param;
                            if (!dbf.getName().equals(arg.getArgumentName())) continue;
                            dbf.setTypeName(javaTypeName);
                        }
                        continue;
                    }
                }
                call.addNamedOutputArgument(arg.getArgumentName(), arg.getArgumentName(), Util.getJDBCTypeFromTypeName(argType.getTypeName()));
                continue;
            }
            if (direction != ArgumentTypeDirection.INOUT) continue;
            dq.addArgument(arg.getArgumentName());
            call.addNamedInOutputArgument(arg.getArgumentName());
        }
        orProject.getQueries().add(dq);
    }

    protected ObjectRelationalDatabaseField buildFieldForNestedType(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType owningType) {
        org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType nestedType;
        ObjectRelationalDatabaseField nestedField = new ObjectRelationalDatabaseField("");
        if (owningType instanceof VArrayType) {
            nestedType = ((VArrayType)owningType).getEnclosedType();
            nestedField.setSqlTypeName(Util.getJDBCTypeNameFromType(2003));
            nestedField.setSqlType(2003);
        } else {
            nestedType = ((ObjectTableType)owningType).getEnclosedType();
            nestedField.setSqlTypeName(Util.getJDBCTypeNameFromType(2002));
            nestedField.setSqlType(2002);
        }
        nestedField.setTypeName(nestedType.getTypeName().toLowerCase());
        return nestedField;
    }

    protected void addDirectMappingForFieldType(XMLDescriptor xdesc, String attributeName, FieldType fType) {
        XMLDirectMapping fieldMapping = new XMLDirectMapping();
        fieldMapping.setAttributeName(attributeName);
        XMLField xField = new XMLField(attributeName + "/text()");
        xField.setRequired(true);
        QName qnameFromDatabaseType = Util.getXMLTypeFromJDBCType(Util.getJDBCTypeFromTypeName(fType.getTypeName()));
        xField.setSchemaType(qnameFromDatabaseType);
        if (qnameFromDatabaseType == XMLConstants.DATE_QNAME) {
            fieldMapping.setAttributeClassification(Date.class);
            xField.addXMLConversion(XMLConstants.DATE_QNAME, Date.class);
            xField.addJavaConversion(Date.class, XMLConstants.DATE_QNAME);
            xdesc.getNamespaceResolver().put("xsd", "http://www.w3.org/2001/XMLSchema");
        } else {
            Class attributeClass = (Class)XMLConversionManager.getDefaultXMLTypes().get(qnameFromDatabaseType);
            if (attributeClass == null) {
                attributeClass = ClassConstants.Object_Class;
            }
            fieldMapping.setAttributeClassification(attributeClass);
        }
        fieldMapping.setField((DatabaseField)xField);
        AbstractNullPolicy nullPolicy = fieldMapping.getNullPolicy();
        nullPolicy.setNullRepresentedByEmptyNode(false);
        nullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
        nullPolicy.setNullRepresentedByXsiNil(true);
        fieldMapping.setNullPolicy(nullPolicy);
        xdesc.getNamespaceResolver().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        xdesc.addMapping((DatabaseMapping)fieldMapping);
    }

    protected XMLDescriptor buildNewXMLDescriptor(String objectAlias, String userType, String targetNamespace) {
        XMLDescriptor xdesc = new XMLDescriptor();
        xdesc.setAlias(objectAlias);
        xdesc.setJavaClassName(objectAlias);
        xdesc.getQueryManager();
        XMLSchemaURLReference schemaReference = new XMLSchemaURLReference();
        schemaReference.setSchemaContext("/" + userType);
        schemaReference.setType(1);
        xdesc.setSchemaReference((XMLSchemaReference)schemaReference);
        NamespaceResolver nr = new NamespaceResolver();
        nr.setDefaultNamespaceURI(targetNamespace);
        xdesc.setNamespaceResolver(nr);
        xdesc.setDefaultRootElement(userType);
        return xdesc;
    }

    protected ObjectRelationalDataTypeDescriptor buildNewObjectRelationalDataTypeDescriptor(String alias) {
        return this.buildNewObjectRelationalDataTypeDescriptor(alias, alias);
    }

    protected ObjectRelationalDataTypeDescriptor buildNewObjectRelationalDataTypeDescriptor(String alias, String javaClassName) {
        ObjectRelationalDataTypeDescriptor ordt = new ObjectRelationalDataTypeDescriptor();
        ordt.setStructureName(alias.toUpperCase());
        ordt.descriptorIsAggregate();
        ordt.setAlias(alias);
        ordt.setJavaClassName(javaClassName);
        ordt.getQueryManager();
        return ordt;
    }
}

