/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.ExpressionIterator;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.FromAliasExpression;
import org.eclipse.persistence.internal.expressions.SubSelectDatabaseTable;
import org.eclipse.persistence.internal.expressions.SubSelectExpression;
import org.eclipse.persistence.internal.expressions.TableExpression;
import org.eclipse.persistence.internal.helper.DatabaseTable;

public class FromSubSelectExpression
extends TableExpression {
    protected SubSelectExpression subSelect;

    public FromSubSelectExpression() {
    }

    public FromSubSelectExpression(SubSelectExpression subSelect) {
        this.subSelect = subSelect;
        this.table = new SubSelectDatabaseTable(subSelect);
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int computeHashCode() {
        return System.identityHashCode(this);
    }

    public String descriptionOfNodeType() {
        return "FromSubSelect";
    }

    public Expression get(String alias) {
        FromAliasExpression aliasExpression = new FromAliasExpression(alias, this);
        return aliasExpression;
    }

    public Expression normalize(ExpressionNormalizer normalizer) {
        if (this.subSelect != null) {
            this.subSelect.normalizeSubSelect(normalizer, normalizer.getClonedExpressions());
        }
        return super.normalize(normalizer);
    }

    public void iterateOn(ExpressionIterator iterator) {
        super.iterateOn(iterator);
        if (this.subSelect != null) {
            this.subSelect.iterateOn(iterator);
        }
    }

    protected void postCopyIn(Map alreadyDone) {
        super.postCopyIn(alreadyDone);
        if (this.subSelect != null) {
            this.subSelect = (SubSelectExpression)this.subSelect.copiedVersionFrom(alreadyDone);
            this.table = new SubSelectDatabaseTable(this.subSelect);
        }
    }

    public Expression rebuildOn(Expression newBase) {
        Expression newLocalBase = this.getBaseExpression().rebuildOn(newBase);
        return newLocalBase.getTable(this.subSelect.rebuildOn(newBase));
    }

    public Expression twistedForBaseAndContext(Expression newBase, Expression context, Expression oldBase) {
        Expression twistedBase = this.getBaseExpression().twistedForBaseAndContext(newBase, context, oldBase);
        return twistedBase.getTable(this.subSelect.twistedForBaseAndContext(newBase, context, oldBase));
    }

    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        this.subSelect.writeDescriptionOn(writer);
        writer.write(this.tableAliasesDescription());
    }

    public DatabaseTable aliasForTable(DatabaseTable table) {
        return super.aliasForTable(this.getTable());
    }

    public SubSelectExpression getSubSelect() {
        return this.subSelect;
    }

    public void setSubSelect(SubSelectExpression subSelect) {
        this.subSelect = subSelect;
        this.table = new SubSelectDatabaseTable(subSelect);
    }
}

