/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.jpa.jpql.DefaultJPQLQueryContext;
import org.eclipse.persistence.jpa.internal.jpql.LiteralType;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractFromClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractSelectClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractSelectStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.AnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.AvgFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.internal.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CountFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.internal.jpql.parser.Join;
import org.eclipse.persistence.jpa.internal.jpql.parser.KeyExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.MaxFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.MinFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.ObjectExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.internal.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleFromClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SumFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.ValueExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.WhereClause;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.MappingTypeHelper;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractObjectLevelReadQueryVisitor<T extends ObjectLevelReadQuery>
extends AbstractExpressionVisitor {
    private CountFunctionVisitor countFunctionVisitor;
    private JoinExpressionVisitor joinExpressionVisitor;
    private OneToOneSelectedVisitor oneToOneSelectedVisitor;
    private OrderByVisitor orderByVisitor;
    final DefaultJPQLQueryContext queryContext;

    AbstractObjectLevelReadQueryVisitor(DefaultJPQLQueryContext queryContext) {
        this.queryContext = queryContext;
    }

    private CountFunctionVisitor countFunctionVisitor() {
        if (this.countFunctionVisitor == null) {
            this.countFunctionVisitor = new CountFunctionVisitor();
        }
        return this.countFunctionVisitor;
    }

    T getDatabaseQuery() {
        return (T)((ObjectLevelReadQuery)this.queryContext.getDatabaseQuery());
    }

    private boolean hasNotCountFunction(AbstractSelectClause expression) {
        CountFunctionVisitor visitor = this.countFunctionVisitor();
        expression.accept((ExpressionVisitor)visitor);
        return visitor.hasCountFunction;
    }

    private boolean hasOneToOneSelected(AbstractSelectClause expression) {
        OneToOneSelectedVisitor visitor = this.oneToOneSelectedVisitor();
        expression.accept((ExpressionVisitor)visitor);
        return visitor.oneToOneSelected;
    }

    private JoinExpressionVisitor joinExpressionVisitor() {
        if (this.joinExpressionVisitor == null) {
            this.joinExpressionVisitor = new JoinExpressionVisitor();
        }
        return this.joinExpressionVisitor;
    }

    private OneToOneSelectedVisitor oneToOneSelectedVisitor() {
        if (this.oneToOneSelectedVisitor == null) {
            this.oneToOneSelectedVisitor = new OneToOneSelectedVisitor();
        }
        return this.oneToOneSelectedVisitor;
    }

    private OrderByVisitor orderyByVisitor() {
        if (this.orderByVisitor == null) {
            this.orderByVisitor = new OrderByVisitor();
        }
        return this.orderByVisitor;
    }

    public void visit(FromClause expression) {
        this.visitAbstractFromClause((AbstractFromClause)expression);
    }

    public void visit(OrderByClause expression) {
        expression.accept((ExpressionVisitor)this.orderyByVisitor());
    }

    public void visit(SelectClause expression) {
        this.visitAbstractSelectClause((AbstractSelectClause)expression);
    }

    public void visit(SelectStatement expression) {
        this.visitAbstractSelectStatement((AbstractSelectStatement)expression);
        expression.getOrderByClause().accept((ExpressionVisitor)this);
        expression.getFromClause().accept((ExpressionVisitor)this.joinExpressionVisitor());
    }

    public void visit(SimpleFromClause expression) {
        this.visitAbstractFromClause((AbstractFromClause)expression);
    }

    public void visit(SimpleSelectClause expression) {
        this.visitAbstractSelectClause((AbstractSelectClause)expression);
    }

    public void visit(SimpleSelectStatement expression) {
        this.visitAbstractSelectStatement((AbstractSelectStatement)expression);
        expression.getFromClause().accept((ExpressionVisitor)this.joinExpressionVisitor());
    }

    public void visit(WhereClause expression) {
        Expression queryExpression = this.queryContext.buildQueryExpression((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
        ((ObjectLevelReadQuery)this.getDatabaseQuery()).setSelectionCriteria(queryExpression);
    }

    private void visitAbstractFromClause(AbstractFromClause expression) {
        ObjectLevelReadQuery query = (ObjectLevelReadQuery)this.queryContext.getDatabaseQuery();
        Expression baseExpression = this.queryContext.getBaseExpression();
        ExpressionBuilder expressionBuilder = baseExpression.getBuilder();
        query.setExpressionBuilder(expressionBuilder);
        if (query.getReferenceClass() == null) {
            query.setReferenceClass(expressionBuilder.getQueryClass());
            query.changeDescriptor(this.queryContext.getSession());
        }
    }

    private void visitAbstractSelectClause(AbstractSelectClause expression) {
        ObjectLevelReadQuery query = (ObjectLevelReadQuery)this.queryContext.getDatabaseQuery();
        if (expression.hasDistinct() && !this.hasNotCountFunction(expression)) {
            query.useDistinct();
        }
        boolean buildNullForNullPK = this.hasOneToOneSelected(expression);
        query.setShouldBuildNullForNullPk(buildNullForNullPK);
    }

    private void visitAbstractSelectStatement(AbstractSelectStatement expression) {
        expression.getFromClause().accept((ExpressionVisitor)this);
        expression.getSelectClause().accept((ExpressionVisitor)this);
        expression.getWhereClause().accept((ExpressionVisitor)this);
        expression.getGroupByClause().accept((ExpressionVisitor)this);
        expression.getHavingClause().accept((ExpressionVisitor)this);
    }

    private class CountFunctionVisitor
    extends AnonymousExpressionVisitor {
        boolean hasCountFunction;

        private CountFunctionVisitor() {
        }

        public void visit(CountFunction expression) {
            this.hasCountFunction = true;
        }

        protected void visit(org.eclipse.persistence.jpa.internal.jpql.parser.Expression expression) {
            this.hasCountFunction = false;
        }

        public void visit(SelectClause expression) {
            expression.getSelectExpression().accept((ExpressionVisitor)this);
        }

        public void visit(SimpleSelectClause expression) {
            expression.getSelectExpression().accept((ExpressionVisitor)this);
        }
    }

    private class JoinExpressionVisitor
    extends AbstractExpressionVisitor {
        private JoinExpressionVisitor() {
        }

        public void visit(CollectionExpression expression) {
            expression.acceptChildren((ExpressionVisitor)this);
        }

        public void visit(CollectionMemberDeclaration expression) {
            String variableName = AbstractObjectLevelReadQueryVisitor.this.queryContext.literal(expression.getIdentificationVariable(), LiteralType.IDENTIFICATION_VARIABLE);
            if (!AbstractObjectLevelReadQueryVisitor.this.queryContext.isIdentificationVariableUsed(variableName)) {
                ObjectLevelReadQuery query = (ObjectLevelReadQuery)AbstractObjectLevelReadQueryVisitor.this.queryContext.getDatabaseQuery();
                Expression queryExpression = AbstractObjectLevelReadQueryVisitor.this.queryContext.getQueryExpression(variableName);
                if (queryExpression == null) {
                    queryExpression = AbstractObjectLevelReadQueryVisitor.this.queryContext.buildQueryExpression(expression.getCollectionValuedPathExpression());
                }
                query.addNonFetchJoinedAttribute(queryExpression);
            }
        }

        public void visit(FromClause expression) {
            expression.getDeclaration().accept((ExpressionVisitor)this);
        }

        public void visit(IdentificationVariableDeclaration expression) {
            expression.getJoins().accept((ExpressionVisitor)this);
        }

        public void visit(Join expression) {
            String variableName = AbstractObjectLevelReadQueryVisitor.this.queryContext.literal(expression.getIdentificationVariable(), LiteralType.IDENTIFICATION_VARIABLE);
            if (!AbstractObjectLevelReadQueryVisitor.this.queryContext.isIdentificationVariableUsed(variableName)) {
                Expression queryExpression = AbstractObjectLevelReadQueryVisitor.this.queryContext.getQueryExpression(variableName);
                if (queryExpression == null) {
                    queryExpression = AbstractObjectLevelReadQueryVisitor.this.queryContext.buildQueryExpression((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
                    AbstractObjectLevelReadQueryVisitor.this.queryContext.addQueryExpression(variableName, queryExpression);
                }
                ((ObjectLevelReadQuery)AbstractObjectLevelReadQueryVisitor.this.getDatabaseQuery()).addNonFetchJoinedAttribute(queryExpression);
            }
        }

        public void visit(SimpleFromClause expression) {
            expression.getDeclaration().accept((ExpressionVisitor)this);
        }
    }

    private class OneToOneSelectedVisitor
    extends AnonymousExpressionVisitor {
        boolean oneToOneSelected;

        private OneToOneSelectedVisitor() {
        }

        public void visit(AvgFunction expression) {
            expression.getExpression().accept((ExpressionVisitor)this);
        }

        public void visit(CollectionExpression expression) {
            org.eclipse.persistence.jpa.internal.jpql.parser.Expression[] expressionArray = expression.getChildren();
            int n = expressionArray.length;
            int n2 = 0;
            while (n2 < n) {
                org.eclipse.persistence.jpa.internal.jpql.parser.Expression child = expressionArray[n2];
                child.accept((ExpressionVisitor)this);
                if (this.oneToOneSelected) break;
                ++n2;
            }
        }

        public void visit(ConstructorExpression expression) {
            expression.getConstructorItems().accept((ExpressionVisitor)this);
        }

        public void visit(CountFunction expression) {
            this.oneToOneSelected = false;
        }

        public void visit(IdentificationVariable expression) {
            this.oneToOneSelected = !AbstractObjectLevelReadQueryVisitor.this.queryContext.isRangeIdentificationVariable(expression.getText());
        }

        public void visit(KeyExpression expression) {
            this.oneToOneSelected = true;
        }

        public void visit(MaxFunction expression) {
            expression.getExpression().accept((ExpressionVisitor)this);
        }

        public void visit(MinFunction expression) {
            expression.getExpression().accept((ExpressionVisitor)this);
        }

        public void visit(ObjectExpression expression) {
            expression.getExpression().accept((ExpressionVisitor)this);
        }

        protected void visit(org.eclipse.persistence.jpa.internal.jpql.parser.Expression expression) {
            this.oneToOneSelected = true;
        }

        public void visit(ResultVariable expression) {
            expression.getSelectExpression().accept((ExpressionVisitor)this);
        }

        public void visit(SelectClause expression) {
            expression.getSelectExpression().accept((ExpressionVisitor)this);
        }

        public void visit(SimpleSelectClause expression) {
            expression.getSelectExpression().accept((ExpressionVisitor)this);
        }

        public void visit(StateFieldPathExpression expression) {
            IMapping mapping = AbstractObjectLevelReadQueryVisitor.this.queryContext.getMapping((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
            this.oneToOneSelected = !MappingTypeHelper.isPropertyMapping((IMapping)mapping);
        }

        public void visit(SumFunction expression) {
            expression.getExpression().accept((ExpressionVisitor)this);
        }

        public void visit(ValueExpression expression) {
            this.oneToOneSelected = true;
        }
    }

    private class OrderByVisitor
    extends AbstractExpressionVisitor {
        private OrderByVisitor() {
        }

        public void visit(CollectionExpression expression) {
            expression.acceptChildren((ExpressionVisitor)this);
        }

        public void visit(OrderByClause expression) {
            expression.getOrderByItems().accept((ExpressionVisitor)this);
        }

        public void visit(OrderByItem expression) {
            Expression queryExpression = null;
            String variableName = AbstractObjectLevelReadQueryVisitor.this.queryContext.literal(expression.getExpression(), LiteralType.IDENTIFICATION_VARIABLE);
            if (ExpressionTools.stringIsNotEmpty((CharSequence)variableName)) {
                queryExpression = AbstractObjectLevelReadQueryVisitor.this.queryContext.getQueryExpression(variableName);
            }
            if (queryExpression == null) {
                queryExpression = AbstractObjectLevelReadQueryVisitor.this.queryContext.buildQueryExpression(expression.getExpression());
            }
            if (expression.getOrdering() == OrderByItem.Ordering.DESC) {
                ((ObjectLevelReadQuery)AbstractObjectLevelReadQueryVisitor.this.getDatabaseQuery()).addOrdering(queryExpression.descending());
            } else {
                ((ObjectLevelReadQuery)AbstractObjectLevelReadQueryVisitor.this.getDatabaseQuery()).addOrdering(queryExpression.ascending());
            }
        }
    }
}

