/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.DateConstantExpression;
import org.eclipse.persistence.internal.expressions.MapEntryExpression;
import org.eclipse.persistence.internal.jpa.jpql.DefaultJPQLQueryContext;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.jpa.internal.jpql.CollectionValuedFieldResolver;
import org.eclipse.persistence.jpa.internal.jpql.EntityResolver;
import org.eclipse.persistence.jpa.internal.jpql.IdentificationVariableResolver;
import org.eclipse.persistence.jpa.internal.jpql.KeyResolver;
import org.eclipse.persistence.jpa.internal.jpql.LiteralType;
import org.eclipse.persistence.jpa.internal.jpql.Resolver;
import org.eclipse.persistence.jpa.internal.jpql.ResolverVisitor;
import org.eclipse.persistence.jpa.internal.jpql.SingleValuedObjectFieldResolver;
import org.eclipse.persistence.jpa.internal.jpql.StateFieldResolver;
import org.eclipse.persistence.jpa.internal.jpql.TreatResolver;
import org.eclipse.persistence.jpa.internal.jpql.ValueResolver;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbsExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractTraverseChildrenVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.AdditionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AllOrAnyExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AndExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.ArithmeticFactor;
import org.eclipse.persistence.jpa.internal.jpql.parser.AvgFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.BadExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.BetweenExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CaseExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CoalesceExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionMemberExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ComparisonExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ConcatExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CountFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.DateTime;
import org.eclipse.persistence.jpa.internal.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.DivisionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.EmptyCollectionComparisonExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.EntityTypeLiteral;
import org.eclipse.persistence.jpa.internal.jpql.parser.EntryExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExistsExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.FuncExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.GroupByClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.HavingClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.internal.jpql.parser.InExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.IndexExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Join;
import org.eclipse.persistence.jpa.internal.jpql.parser.JoinFetch;
import org.eclipse.persistence.jpa.internal.jpql.parser.KeyExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.KeywordExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.LengthExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.LikeExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.LocateExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.LowerExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.MaxFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.MinFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.ModExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.MultiplicationExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NotExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NullComparisonExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NullIfExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NumericLiteral;
import org.eclipse.persistence.jpa.internal.jpql.parser.ObjectExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.OrExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.internal.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.internal.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleFromClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.SizeExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SqrtExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringLiteral;
import org.eclipse.persistence.jpa.internal.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SubstringExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SubtractionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SumFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.TreatExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.TrimExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.TypeExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.UnknownExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateItem;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpperExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ValueExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.WhenClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.WhereClause;
import org.eclipse.persistence.jpa.jpql.MappingTypeHelper;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.queries.ReportQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExpressionBuilderVisitor
implements ExpressionVisitor {
    private ChildrenExpressionVisitor childrenExpressionVisitor;
    private EmptyCollectionComparisonExpressionVisitor emptyCollectionComparisonExpressionVisitor;
    private ExpressionResolverVisitor expressionResolverVisitor;
    private InExpressionBuilder inExpressionBuilder;
    private final DefaultJPQLQueryContext queryContext;
    private Expression queryExpression;
    private boolean typeExpression;
    private WhenClauseExpressionVisitor whenClauseExpressionVisitor;

    ExpressionBuilderVisitor(DefaultJPQLQueryContext queryContext) {
        this.queryContext = queryContext;
    }

    private void appendJoinVariables(org.eclipse.persistence.jpa.internal.jpql.parser.Expression expression, ReportQuery subquery) {
        this.queryExpression = null;
        JoinVariableNameVisitor visitor2 = new JoinVariableNameVisitor();
        expression.accept((ExpressionVisitor)visitor2);
        for (String variableName : visitor2.outerVariablesNames()) {
            Expression innerExpression = this.queryContext.getQueryExpression(variableName);
            Expression outerExpression = this.queryContext.getParentQueryExpression(variableName);
            Expression equalExpression = innerExpression.equal(outerExpression);
            this.queryExpression = this.queryExpression == null ? equalExpression : this.queryExpression.and(equalExpression);
        }
        if (this.queryExpression != null) {
            Expression whereClause = subquery.getSelectionCriteria();
            whereClause = whereClause != null ? whereClause.and(this.queryExpression) : this.queryExpression;
            subquery.setSelectionCriteria(whereClause);
        }
    }

    private Expression buildExpression(org.eclipse.persistence.jpa.internal.jpql.parser.Expression expression) {
        return this.resolve(this.queryContext.getResolver(expression));
    }

    private ReportQuery buildSubquery(org.eclipse.persistence.jpa.internal.jpql.parser.Expression expression) {
        ReportQuery subquery = new ReportQuery();
        this.queryContext.newSubQueryContext(expression, subquery);
        try {
            expression.accept((ExpressionVisitor)this.queryContext.reportQueryVisitor());
            this.appendJoinVariables(expression, subquery);
            ReportQuery reportQuery = subquery;
            return reportQuery;
        }
        finally {
            this.queryContext.disposeSubqueryContext();
        }
    }

    private List<org.eclipse.persistence.jpa.internal.jpql.parser.Expression> children(org.eclipse.persistence.jpa.internal.jpql.parser.Expression expression) {
        ChildrenExpressionVisitor visitor = this.childrenExpressionVisitor();
        try {
            expression.accept((ExpressionVisitor)visitor);
            ArrayList<org.eclipse.persistence.jpa.internal.jpql.parser.Expression> arrayList = new ArrayList<org.eclipse.persistence.jpa.internal.jpql.parser.Expression>(visitor.expressions);
            return arrayList;
        }
        finally {
            visitor.expressions.clear();
        }
    }

    private ChildrenExpressionVisitor childrenExpressionVisitor() {
        if (this.childrenExpressionVisitor == null) {
            this.childrenExpressionVisitor = new ChildrenExpressionVisitor();
        }
        return this.childrenExpressionVisitor;
    }

    void dispose() {
        this.queryExpression = null;
        this.typeExpression = false;
    }

    private EmptyCollectionComparisonExpressionVisitor emptyCollectionComparisonExpressionVisitor() {
        if (this.emptyCollectionComparisonExpressionVisitor == null) {
            this.emptyCollectionComparisonExpressionVisitor = new EmptyCollectionComparisonExpressionVisitor();
        }
        return this.emptyCollectionComparisonExpressionVisitor;
    }

    private ExpressionResolverVisitor expressionResolverVisitor() {
        if (this.expressionResolverVisitor == null) {
            this.expressionResolverVisitor = new ExpressionResolverVisitor();
        }
        return this.expressionResolverVisitor;
    }

    Expression getQueryExpression() {
        return this.queryExpression;
    }

    private InExpressionBuilder inExpressionBuilder() {
        if (this.inExpressionBuilder == null) {
            this.inExpressionBuilder = new InExpressionBuilder();
        }
        return this.inExpressionBuilder;
    }

    private String literal(org.eclipse.persistence.jpa.internal.jpql.parser.Expression expression, LiteralType type) {
        return this.queryContext.literal(expression, type);
    }

    Expression resolve(Resolver resolver) {
        ExpressionResolverVisitor visitor = this.expressionResolverVisitor();
        try {
            resolver.accept((ResolverVisitor)visitor);
            Expression expression = visitor.expression;
            return expression;
        }
        finally {
            visitor.expression = null;
        }
    }

    public void visit(AbsExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = ExpressionMath.abs(this.queryExpression);
    }

    public void visit(AbstractSchemaName expression) {
    }

    public void visit(AdditionExpression expression) {
        expression.getLeftExpression().accept((ExpressionVisitor)this);
        Expression leftExpression = this.queryExpression;
        expression.getRightExpression().accept((ExpressionVisitor)this);
        Expression rightExpression = this.queryExpression;
        this.queryExpression = ExpressionMath.add(leftExpression, rightExpression);
    }

    public void visit(AllOrAnyExpression expression) {
        ReportQuery subquery = this.buildSubquery(expression.getExpression());
        String identifier = expression.getIdentifier();
        this.queryExpression = this.queryContext.getBaseExpression();
        if (identifier == "ALL") {
            this.queryExpression = this.queryExpression.all(subquery);
        } else if (identifier == "SOME") {
            this.queryExpression = this.queryExpression.some(subquery);
        } else if (identifier == "ANY") {
            this.queryExpression = this.queryExpression.any(subquery);
        }
    }

    public void visit(AndExpression expression) {
        expression.getLeftExpression().accept((ExpressionVisitor)this);
        Expression leftExpression = this.queryExpression;
        expression.getRightExpression().accept((ExpressionVisitor)this);
        Expression rightExpression = this.queryExpression;
        this.queryExpression = leftExpression.and(rightExpression);
    }

    public void visit(ArithmeticFactor expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        Expression arithmeticFactor = this.queryExpression;
        this.queryExpression = new ConstantExpression(0, new ExpressionBuilder());
        this.queryExpression = ExpressionMath.subtract(this.queryExpression, arithmeticFactor);
    }

    public void visit(AvgFunction expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        if (expression.hasDistinct()) {
            this.queryExpression = this.queryExpression.distinct();
        }
        this.queryExpression = this.queryExpression.average();
    }

    public void visit(BadExpression expression) {
    }

    public void visit(BetweenExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        Expression resultExpression = this.queryExpression;
        expression.getLowerBoundExpression().accept((ExpressionVisitor)this);
        Expression lowerBoundExpression = this.queryExpression;
        expression.getUpperBoundExpression().accept((ExpressionVisitor)this);
        Expression upperBoundExpression = this.queryExpression;
        this.queryExpression = expression.hasNot() ? resultExpression.notBetween(lowerBoundExpression, upperBoundExpression) : resultExpression.between(lowerBoundExpression, upperBoundExpression);
    }

    public void visit(CaseExpression expression) {
        expression.getCaseOperand().accept((ExpressionVisitor)this);
        Expression caseOperandExpression = this.queryExpression;
        WhenClauseExpressionVisitor visitor = this.whenClauseExpressionVisitor();
        try {
            expression.getWhenClauses().accept((ExpressionVisitor)visitor);
            expression.getElseExpression().accept((ExpressionVisitor)this);
            Expression elseExpression = this.queryExpression;
            this.queryExpression = caseOperandExpression != null ? caseOperandExpression.caseStatement(visitor.whenClauses, elseExpression) : this.queryContext.getBaseExpression().caseStatement(visitor.whenClauses, elseExpression);
        }
        finally {
            visitor.dispose();
        }
    }

    public void visit(CoalesceExpression expression) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        org.eclipse.persistence.jpa.internal.jpql.parser.Expression[] expressionArray = expression.getExpression().getChildren();
        int n = expressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            org.eclipse.persistence.jpa.internal.jpql.parser.Expression child = expressionArray[n2];
            child.accept((ExpressionVisitor)this);
            expressions.add(this.queryExpression);
            ++n2;
        }
        this.queryExpression = this.queryContext.getBaseExpression();
        this.queryExpression = this.queryExpression.coalesce(expressions);
    }

    public void visit(CollectionExpression expression) {
    }

    public void visit(CollectionMemberDeclaration expression) {
    }

    public void visit(CollectionMemberExpression expression) {
        expression.getEntityExpression().accept((ExpressionVisitor)this);
        Expression entityExpression = this.queryExpression;
        if (expression.hasNot()) {
            String variableName = this.literal(expression.getCollectionValuedPathExpression(), LiteralType.PATH_EXPRESSION_IDENTIFICATION_VARIABLE);
            Expression parentExpression = this.queryContext.getQueryExpression(variableName);
            variableName = this.literal(expression.getCollectionValuedPathExpression(), LiteralType.PATH_EXPRESSION_LAST_PATH);
            this.queryExpression = new ExpressionBuilder().equal(entityExpression);
            this.queryExpression = parentExpression.noneOf(variableName, this.queryExpression);
        } else {
            expression.getCollectionValuedPathExpression().accept((ExpressionVisitor)this);
            this.queryExpression = this.queryExpression.equal(entityExpression);
        }
    }

    public void visit(CollectionValuedPathExpression expression) {
        this.queryExpression = this.buildExpression((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
    }

    public void visit(ComparisonExpression expression) {
        expression.getLeftExpression().accept((ExpressionVisitor)this);
        Expression leftExpression = this.queryExpression;
        expression.getRightExpression().accept((ExpressionVisitor)this);
        Expression rightExpression = this.queryExpression;
        this.typeExpression = false;
        String comparaison = expression.getComparisonOperator();
        if (comparaison == "=") {
            this.queryExpression = leftExpression.equal(rightExpression);
        } else if (comparaison == "<>") {
            this.queryExpression = leftExpression.notEqual(rightExpression);
        } else if (comparaison == "<") {
            this.queryExpression = leftExpression.lessThan(rightExpression);
        } else if (comparaison == "<=") {
            this.queryExpression = leftExpression.lessThanEqual(rightExpression);
        } else if (comparaison == ">") {
            this.queryExpression = leftExpression.greaterThan(rightExpression);
        } else if (comparaison == ">=") {
            this.queryExpression = leftExpression.greaterThanEqual(rightExpression);
        }
    }

    public void visit(ConcatExpression expression) {
        List<org.eclipse.persistence.jpa.internal.jpql.parser.Expression> expressions = this.children(expression.getExpression());
        Expression newExpression = null;
        for (org.eclipse.persistence.jpa.internal.jpql.parser.Expression child : expressions) {
            child.accept((ExpressionVisitor)this);
            newExpression = newExpression == null ? this.queryExpression : newExpression.concat(this.queryExpression);
        }
        this.queryExpression = newExpression;
    }

    public void visit(ConstructorExpression expression) {
    }

    public void visit(CountFunction expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        if (expression.hasDistinct()) {
            this.queryExpression = this.queryExpression.distinct();
        }
        this.queryExpression = this.queryExpression.count();
    }

    public void visit(DateTime expression) {
        if (expression.isJDBCDate()) {
            this.queryExpression = this.queryContext.getBaseExpression();
            this.queryExpression = new DateConstantExpression(expression.getText(), this.queryExpression);
        } else {
            this.queryExpression = this.queryContext.getBaseExpression();
            if (expression.isCurrentDate()) {
                this.queryExpression = this.queryExpression.currentDateDate();
            } else if (expression.isCurrentTime()) {
                this.queryExpression = this.queryExpression.currentTime();
            } else if (expression.isCurrentTimestamp()) {
                this.queryExpression = this.queryExpression.currentTimeStamp();
            }
        }
    }

    public void visit(DeleteClause expression) {
    }

    public void visit(DeleteStatement expression) {
    }

    public void visit(DivisionExpression expression) {
        expression.getLeftExpression().accept((ExpressionVisitor)this);
        Expression leftExpression = this.queryExpression;
        expression.getRightExpression().accept((ExpressionVisitor)this);
        Expression rightExpression = this.queryExpression;
        this.queryExpression = ExpressionMath.divide(leftExpression, rightExpression);
    }

    public void visit(EmptyCollectionComparisonExpression expression) {
        String name = this.literal(expression.getExpression(), LiteralType.PATH_EXPRESSION_LAST_PATH);
        expression.getExpression().accept((ExpressionVisitor)this.emptyCollectionComparisonExpressionVisitor());
        this.queryExpression = expression.hasNot() ? this.queryExpression.notEmpty(name) : this.queryExpression.isEmpty(name);
    }

    public void visit(EntityTypeLiteral expression) {
        ClassDescriptor descriptor = this.queryContext.getSession().getClassDescriptorForAlias(expression.getEntityTypeName());
        this.queryExpression = new ConstantExpression(descriptor.getJavaClass(), this.queryContext.getBaseExpression());
    }

    public void visit(EntryExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        MapEntryExpression entryExpression = new MapEntryExpression(this.queryExpression);
        entryExpression.returnMapEntry();
        this.queryExpression = entryExpression;
    }

    public void visit(ExistsExpression expression) {
        ReportQuery subquery = this.buildSubquery(expression.getExpression());
        for (ReportItem item : subquery.getItems()) {
            Expression expr = item.getAttributeExpression();
            subquery.addNonFetchJoinedAttribute(expr);
        }
        subquery.clearItems();
        ConstantExpression one = new ConstantExpression(1, new ExpressionBuilder());
        subquery.addItem("one", one);
        subquery.dontUseDistinct();
        this.queryExpression = this.queryContext.getBaseExpression();
        this.queryExpression = expression.hasNot() ? this.queryExpression.notExists(subquery) : this.queryExpression.exists(subquery);
    }

    public void visit(FromClause expression) {
    }

    public void visit(FuncExpression expression) {
        List<org.eclipse.persistence.jpa.internal.jpql.parser.Expression> expressions = this.children(expression.getExpression());
        String functionName = expression.getUnquotedFunctionName();
        if (expressions.isEmpty()) {
            this.queryExpression = this.queryContext.getBaseExpression();
            this.queryExpression = this.queryExpression.getFunction(functionName);
        } else {
            Vector<Expression> queryExpressions = new Vector<Expression>(expressions.size());
            for (org.eclipse.persistence.jpa.internal.jpql.parser.Expression child : expressions) {
                child.accept((ExpressionVisitor)this);
                queryExpressions.add(this.queryExpression);
            }
            this.queryExpression = (Expression)queryExpressions.remove(0);
            this.queryExpression = this.queryExpression.getFunctionWithArguments(functionName, queryExpressions);
        }
    }

    public void visit(GroupByClause expression) {
    }

    public void visit(HavingClause expression) {
        expression.getConditionalExpression().accept((ExpressionVisitor)this);
    }

    public void visit(IdentificationVariable expression) {
        if (expression.isVirtual()) {
            StateFieldPathExpression stateFieldPathExpression = expression.getStateFieldPathExpression();
            if (stateFieldPathExpression != null) {
                stateFieldPathExpression.accept((ExpressionVisitor)this);
            }
        } else if (this.typeExpression) {
            this.typeExpression = false;
            ClassDescriptor descriptor = this.queryContext.getSession().getClassDescriptorForAlias(expression.getText());
            this.queryExpression = new ConstantExpression(descriptor.getJavaClass(), this.queryContext.getBaseExpression());
        } else {
            this.queryExpression = this.buildExpression((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
        }
    }

    public void visit(IdentificationVariableDeclaration expression) {
    }

    public void visit(IndexExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = this.queryExpression.index();
    }

    public void visit(InExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        Expression stateFieldPathExpression = this.queryExpression;
        this.visitInExpression(expression, stateFieldPathExpression);
    }

    public void visit(InputParameter expression) {
        String parameterName = expression.getParameter();
        IType type = this.queryContext.getParameterType(expression);
        Class<?> javaType = this.queryContext.getJavaType(type);
        this.queryExpression = this.queryContext.getBaseExpression();
        this.queryExpression = this.queryExpression.getParameter(parameterName.substring(1), javaType);
        this.queryContext.addInputParameter(parameterName, javaType);
    }

    public void visit(Join expression) {
        ExpressionResolverVisitor visitor = this.expressionResolverVisitor();
        Resolver resolver = this.queryContext.getResolver(expression.getJoinAssociationPath());
        boolean oldNullAllowed = resolver.isNullAllowed();
        try {
            resolver.setNullAllowed(expression.isLeftJoin());
            resolver.accept((ResolverVisitor)visitor);
            this.queryExpression = visitor.expression;
        }
        finally {
            visitor.expression = null;
            resolver.setNullAllowed(oldNullAllowed);
        }
    }

    public void visit(JoinFetch expression) {
        ExpressionResolverVisitor visitor = this.expressionResolverVisitor();
        Resolver resolver = this.queryContext.getResolver(expression.getJoinAssociationPath());
        boolean oldNullAllowed = resolver.isNullAllowed();
        try {
            resolver.setNullAllowed(expression.isLeftJoinFetch());
            resolver.accept((ResolverVisitor)visitor);
            this.queryExpression = visitor.expression;
        }
        finally {
            visitor.expression = null;
            resolver.setNullAllowed(oldNullAllowed);
        }
    }

    public void visit(JPQLExpression expression) {
    }

    public void visit(KeyExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = new MapEntryExpression(this.queryExpression);
    }

    public void visit(KeywordExpression expression) {
        String keyword = expression.getText();
        Boolean value = keyword == "NULL" ? null : (keyword == "TRUE" ? Boolean.TRUE : Boolean.FALSE);
        this.queryExpression = this.queryContext.getBaseExpression();
        this.queryExpression = new ConstantExpression(value, this.queryExpression);
    }

    public void visit(LengthExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = this.queryExpression.length();
    }

    public void visit(LikeExpression expression) {
        expression.getStringExpression().accept((ExpressionVisitor)this);
        Expression firstExpression = this.queryExpression;
        expression.getPatternValue().accept((ExpressionVisitor)this);
        Expression patternValue = this.queryExpression;
        if (expression.hasEscapeCharacter()) {
            expression.getEscapeCharacter().accept((ExpressionVisitor)this);
            this.queryExpression = firstExpression.like(patternValue, this.queryExpression);
        } else {
            this.queryExpression = firstExpression.like(patternValue);
        }
        if (expression.hasNot()) {
            this.queryExpression = this.queryExpression.not();
        }
    }

    public void visit(LocateExpression expression) {
        expression.getFirstExpression().accept((ExpressionVisitor)this);
        Expression findExpression = this.queryExpression;
        expression.getSecondExpression().accept((ExpressionVisitor)this);
        Expression findInExpression = this.queryExpression;
        expression.getThirdExpression().accept((ExpressionVisitor)this);
        Expression startPositionExpression = this.queryExpression;
        this.queryExpression = startPositionExpression != null ? findInExpression.locate(findExpression, startPositionExpression) : findInExpression.locate(findExpression);
    }

    public void visit(LowerExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = this.queryExpression.toLowerCase();
    }

    public void visit(MaxFunction expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        if (expression.hasDistinct()) {
            this.queryExpression = this.queryExpression.distinct();
        }
        this.queryExpression = this.queryExpression.maximum();
    }

    public void visit(MinFunction expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        if (expression.hasDistinct()) {
            this.queryExpression = this.queryExpression.distinct();
        }
        this.queryExpression = this.queryExpression.minimum();
    }

    public void visit(ModExpression expression) {
        expression.getFirstExpression().accept((ExpressionVisitor)this);
        Expression leftExpression = this.queryExpression;
        expression.getSecondExpression().accept((ExpressionVisitor)this);
        Expression rightExpression = this.queryExpression;
        this.queryExpression = ExpressionMath.mod(leftExpression, rightExpression);
    }

    public void visit(MultiplicationExpression expression) {
        expression.getLeftExpression().accept((ExpressionVisitor)this);
        Expression leftExpression = this.queryExpression;
        expression.getRightExpression().accept((ExpressionVisitor)this);
        Expression rightExpression = this.queryExpression;
        this.queryExpression = ExpressionMath.multiply(leftExpression, rightExpression);
    }

    public void visit(NotExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = this.queryExpression.not();
    }

    public void visit(NullComparisonExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = this.queryExpression.isNull();
        if (expression.hasNot()) {
            this.queryExpression = this.queryExpression.not();
        }
    }

    public void visit(NullExpression expression) {
        this.queryExpression = null;
    }

    public void visit(NullIfExpression expression) {
        expression.getFirstExpression().accept((ExpressionVisitor)this);
        Expression firstExpression = this.queryExpression;
        expression.getSecondExpression().accept((ExpressionVisitor)this);
        Expression secondExpression = this.queryExpression;
        this.queryExpression = firstExpression.nullIf(secondExpression);
    }

    public void visit(NumericLiteral expression) {
        Class<?> type = this.queryContext.getJavaType((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
        Number number = (Number)this.queryContext.newInstance(type, String.class, expression.getText());
        this.queryExpression = new ConstantExpression(number, this.queryContext.getBaseExpression());
    }

    public void visit(ObjectExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
    }

    public void visit(OrderByClause expression) {
    }

    public void visit(OrderByItem expression) {
    }

    public void visit(OrExpression expression) {
        expression.getLeftExpression().accept((ExpressionVisitor)this);
        Expression leftExpression = this.queryExpression;
        expression.getRightExpression().accept((ExpressionVisitor)this);
        Expression rightExpression = this.queryExpression;
        this.queryExpression = leftExpression.or(rightExpression);
    }

    public void visit(RangeVariableDeclaration expression) {
    }

    public void visit(ResultVariable expression) {
        expression.getSelectExpression().accept((ExpressionVisitor)this);
    }

    public void visit(SelectClause expression) {
    }

    public void visit(SelectStatement expression) {
    }

    public void visit(SimpleFromClause expression) {
    }

    public void visit(SimpleSelectClause expression) {
    }

    public void visit(SimpleSelectStatement expression) {
        ReportQuery subquery = this.buildSubquery((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
        this.queryExpression = this.queryContext.getBaseExpression();
        this.queryExpression = this.queryExpression.subQuery(subquery);
    }

    public void visit(SizeExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        String name = this.literal(expression.getExpression(), LiteralType.PATH_EXPRESSION_LAST_PATH);
        this.queryExpression = this.queryExpression.size(name);
    }

    public void visit(SqrtExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = ExpressionMath.sqrt(this.queryExpression);
    }

    public void visit(StateFieldPathExpression expression) {
        this.queryExpression = this.buildExpression((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
    }

    public void visit(StringLiteral expression) {
        this.queryExpression = this.queryContext.getBaseExpression();
        this.queryExpression = new ConstantExpression(expression.getUnquotedText(), this.queryExpression);
    }

    public void visit(SubExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
    }

    public void visit(SubstringExpression expression) {
        expression.getFirstExpression().accept((ExpressionVisitor)this);
        Expression firstExpression = this.queryExpression;
        expression.getSecondExpression().accept((ExpressionVisitor)this);
        Expression secondExpression = this.queryExpression;
        expression.getThirdExpression().accept((ExpressionVisitor)this);
        Expression thirdExpression = this.queryExpression;
        this.queryExpression = thirdExpression != null ? firstExpression.substring(secondExpression, thirdExpression) : firstExpression.substring(secondExpression);
    }

    public void visit(SubtractionExpression expression) {
        expression.getLeftExpression().accept((ExpressionVisitor)this);
        Expression leftExpression = this.queryExpression;
        expression.getRightExpression().accept((ExpressionVisitor)this);
        Expression rightExpression = this.queryExpression;
        this.queryExpression = ExpressionMath.subtract(leftExpression, rightExpression);
    }

    public void visit(SumFunction expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        if (expression.hasDistinct()) {
            this.queryExpression = this.queryExpression.distinct();
        }
        this.queryExpression = this.queryExpression.sum();
    }

    public void visit(TreatExpression expression) {
    }

    public void visit(TrimExpression expression) {
        expression.getTrimCharacter().accept((ExpressionVisitor)this);
        Expression trimCharacter = this.queryExpression;
        expression.getExpression().accept((ExpressionVisitor)this);
        Expression stringExpression = this.queryExpression;
        switch (expression.getSpecification()) {
            case LEADING: {
                if (trimCharacter != null) {
                    this.queryExpression = stringExpression.leftTrim(trimCharacter);
                    break;
                }
                this.queryExpression = stringExpression.leftTrim();
                break;
            }
            case TRAILING: {
                if (trimCharacter != null) {
                    this.queryExpression = stringExpression.rightTrim(trimCharacter);
                    break;
                }
                this.queryExpression = stringExpression.rightTrim();
                break;
            }
            default: {
                this.queryExpression = trimCharacter != null ? stringExpression.trim(trimCharacter) : stringExpression.trim();
            }
        }
    }

    public void visit(TypeExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = this.queryExpression.type();
        this.typeExpression = true;
    }

    public void visit(UnknownExpression expression) {
        this.queryExpression = null;
    }

    public void visit(UpdateClause expression) {
    }

    public void visit(UpdateItem expression) {
    }

    public void visit(UpdateStatement expression) {
    }

    public void visit(UpperExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = this.queryExpression.toUpperCase();
    }

    public void visit(ValueExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
    }

    public void visit(WhenClause expression) {
    }

    public void visit(WhereClause expression) {
        expression.getConditionalExpression().accept((ExpressionVisitor)this);
    }

    private void visitInExpression(InExpression expression, Expression stateFieldPathExpression) {
        InExpressionBuilder visitor = this.inExpressionBuilder();
        try {
            visitor.stateFieldPathExpression = stateFieldPathExpression;
            visitor.singleInputParameter = !expression.hasLeftParenthesis();
            visitor.hasNot = expression.hasNot();
            expression.getInItems().accept((ExpressionVisitor)visitor);
        }
        finally {
            visitor.singleInputParameter = false;
            visitor.hasNot = false;
            visitor.stateFieldPathExpression = null;
        }
    }

    private WhenClauseExpressionVisitor whenClauseExpressionVisitor() {
        if (this.whenClauseExpressionVisitor == null) {
            this.whenClauseExpressionVisitor = new WhenClauseExpressionVisitor();
        }
        return this.whenClauseExpressionVisitor;
    }

    private class ChildrenExpressionVisitor
    extends AnonymousExpressionVisitor {
        List<org.eclipse.persistence.jpa.internal.jpql.parser.Expression> expressions = new ArrayList<org.eclipse.persistence.jpa.internal.jpql.parser.Expression>();

        ChildrenExpressionVisitor() {
        }

        public void visit(CollectionExpression expression) {
            org.eclipse.persistence.jpa.internal.jpql.parser.Expression[] expressionArray = expression.getChildren();
            int n = expressionArray.length;
            int n2 = 0;
            while (n2 < n) {
                org.eclipse.persistence.jpa.internal.jpql.parser.Expression child = expressionArray[n2];
                this.expressions.add(child);
                ++n2;
            }
        }

        public void visit(NullExpression expression) {
        }

        protected void visit(org.eclipse.persistence.jpa.internal.jpql.parser.Expression expression) {
            this.expressions.add(expression);
        }
    }

    private class EmptyCollectionComparisonExpressionVisitor
    extends AbstractExpressionVisitor {
        private EmptyCollectionComparisonExpressionVisitor() {
        }

        public void visit(CollectionValuedPathExpression expression) {
            int index = 0;
            int count = expression.pathSize();
            while (index < count) {
                if (index == 0) {
                    expression.getIdentificationVariable().accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
                } else {
                    if (index + 1 >= count) break;
                    ExpressionBuilderVisitor.this.queryExpression.get(expression.getPath(index));
                }
                ++index;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExpressionResolverVisitor
    implements ResolverVisitor {
        Expression expression;

        private ExpressionResolverVisitor() {
        }

        private Enum<?> buildEnumConstant(Class<?> type, String constant) {
            ?[] constants = type.getEnumConstants();
            int index = constants.length;
            while (--index >= 0) {
                Enum enumConstant = (Enum)constants[index];
                if (!constant.equals(enumConstant.name())) continue;
                return enumConstant;
            }
            return null;
        }

        private void buildEnumExpression(Resolver resolver, IType type, String constant) {
            Class<?> javaType = ExpressionBuilderVisitor.this.queryContext.getJavaType(type);
            Enum<?> enumConstant = this.buildEnumConstant(javaType, constant);
            this.expression = new ConstantExpression(enumConstant, new ExpressionBuilder());
        }

        public void visit(CollectionValuedFieldResolver resolver) {
            String path = resolver.getPath();
            resolver.getType();
            if (resolver.isEnumType()) {
                this.buildEnumExpression((Resolver)resolver, resolver.getType(), path);
            } else {
                resolver.getParent().accept((ResolverVisitor)this);
                this.expression = MappingTypeHelper.isCollectionMapping((IMapping)resolver.getMapping()) ? (resolver.isNullAllowed() ? this.expression.anyOfAllowingNone(path) : this.expression.anyOf(path)) : (resolver.isNullAllowed() ? this.expression.getAllowingNull(path) : this.expression.get(path));
            }
        }

        public void visit(EntityResolver resolver) {
            String abstractSchemaName = resolver.getAbstractSchemaName();
            ClassDescriptor descriptor = ExpressionBuilderVisitor.this.queryContext.getDescriptor(abstractSchemaName);
            this.expression = new ExpressionBuilder(descriptor.getJavaClass());
        }

        public void visit(IdentificationVariableResolver resolver) {
            String variableName = resolver.getVariableName();
            this.expression = ExpressionBuilderVisitor.this.queryContext.getQueryExpression(variableName);
            if (this.expression == null) {
                resolver.getParent().accept((ResolverVisitor)this);
                ExpressionBuilderVisitor.this.queryContext.addUsedIdentificationVariable(variableName);
                ExpressionBuilderVisitor.this.queryContext.addQueryExpression(variableName, this.expression);
            }
        }

        public void visit(KeyResolver resolver) {
            resolver.getParent().accept((ResolverVisitor)this);
            this.expression = new MapEntryExpression(this.expression);
        }

        public void visit(SingleValuedObjectFieldResolver resolver) {
            resolver.getParent().accept((ResolverVisitor)this);
            this.expression = this.expression.get(resolver.getPath());
        }

        public void visit(StateFieldResolver resolver) {
            String path = resolver.getPath();
            resolver.getType();
            if (resolver.isEnumType()) {
                this.buildEnumExpression((Resolver)resolver, resolver.getType(), path);
            } else {
                resolver.getParent().accept((ResolverVisitor)this);
                this.expression = MappingTypeHelper.isCollectionMapping((IMapping)resolver.getMapping()) ? (resolver.isNullAllowed() ? this.expression.anyOfAllowingNone(path) : this.expression.anyOf(path)) : ((resolver.isNullAllowed() || resolver.getParent().isNullAllowed()) && MappingTypeHelper.isRelationshipMapping((IMapping)resolver.getMapping()) ? this.expression.getAllowingNull(path) : this.expression.get(path));
            }
        }

        public void visit(TreatResolver resolver) {
            resolver.getParent().accept((ResolverVisitor)this);
            ClassDescriptor entityType = ExpressionBuilderVisitor.this.queryContext.getDescriptor(resolver.getEntityTypeName());
            this.expression = this.expression.as(entityType.getJavaClass());
        }

        public void visit(ValueResolver resolver) {
            resolver.getParent().accept((ResolverVisitor)this);
        }
    }

    private class InExpressionBuilder
    extends AnonymousExpressionVisitor {
        private boolean hasNot;
        private boolean singleInputParameter;
        private Expression stateFieldPathExpression;
        private ExpressionVisitor visitor = new InItemExpressionVisitor();

        InExpressionBuilder() {
        }

        public void visit(CollectionExpression expression) {
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            org.eclipse.persistence.jpa.internal.jpql.parser.Expression[] expressionArray = expression.getChildren();
            int n = expressionArray.length;
            int n2 = 0;
            while (n2 < n) {
                org.eclipse.persistence.jpa.internal.jpql.parser.Expression child = expressionArray[n2];
                child.accept(this.visitor);
                expressions.add(ExpressionBuilderVisitor.this.queryExpression);
                ++n2;
            }
            if (this.hasNot) {
                ExpressionBuilderVisitor.this.queryExpression = this.stateFieldPathExpression.notIn(expressions);
            } else {
                ExpressionBuilderVisitor.this.queryExpression = this.stateFieldPathExpression.in(expressions);
            }
        }

        public void visit(InputParameter expression) {
            if (this.singleInputParameter) {
                expression.accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
                if (this.hasNot) {
                    ExpressionBuilderVisitor.this.queryExpression = this.stateFieldPathExpression.notIn(ExpressionBuilderVisitor.this.queryExpression);
                } else {
                    ExpressionBuilderVisitor.this.queryExpression = this.stateFieldPathExpression.in(ExpressionBuilderVisitor.this.queryExpression);
                }
            } else {
                this.visit((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
            }
        }

        protected void visit(org.eclipse.persistence.jpa.internal.jpql.parser.Expression expression) {
            expression.accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            expressions.add(ExpressionBuilderVisitor.this.queryExpression);
            if (this.hasNot) {
                ExpressionBuilderVisitor.this.queryExpression = this.stateFieldPathExpression.notIn(expressions);
            } else {
                ExpressionBuilderVisitor.this.queryExpression = this.stateFieldPathExpression.in(expressions);
            }
        }

        public void visit(SimpleSelectStatement expression) {
            ReportQuery subquery = ExpressionBuilderVisitor.this.buildSubquery((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
            if (this.hasNot) {
                ExpressionBuilderVisitor.this.queryExpression = this.stateFieldPathExpression.notIn(subquery);
            } else {
                ExpressionBuilderVisitor.this.queryExpression = this.stateFieldPathExpression.in(subquery);
            }
        }

        private class InItemExpressionVisitor
        extends AnonymousExpressionVisitor {
            private InItemExpressionVisitor() {
            }

            public void visit(IdentificationVariable expression) {
                ClassDescriptor descriptor = ExpressionBuilderVisitor.this.queryContext.getDescriptor(expression.getText());
                ExpressionBuilderVisitor.this.queryExpression = ExpressionBuilderVisitor.this.queryContext.getBaseExpression();
                ExpressionBuilderVisitor.this.queryExpression = new ConstantExpression(descriptor.getJavaClass(), ExpressionBuilderVisitor.this.queryExpression);
            }

            protected void visit(org.eclipse.persistence.jpa.internal.jpql.parser.Expression expression) {
                expression.accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JoinVariableNameVisitor
    extends AbstractTraverseChildrenVisitor {
        private boolean gatheringInnerVariable;
        private Set<String> innerVariables = new HashSet<String>();
        private Set<String> outerVariableNames = new HashSet<String>();

        JoinVariableNameVisitor() {
        }

        Set<String> outerVariablesNames() {
            this.outerVariableNames.removeAll(this.innerVariables);
            return this.outerVariableNames;
        }

        public void visit(AbstractSchemaName expression) {
        }

        public void visit(CollectionMemberDeclaration expression) {
            expression.getCollectionValuedPathExpression().accept((ExpressionVisitor)this);
            this.gatheringInnerVariable = true;
            expression.getIdentificationVariable().accept((ExpressionVisitor)this);
            this.gatheringInnerVariable = false;
        }

        public void visit(CollectionValuedPathExpression expression) {
            expression.getIdentificationVariable().accept((ExpressionVisitor)this);
        }

        public void visit(IdentificationVariable expression) {
            if (this.gatheringInnerVariable && !expression.isVirtual()) {
                this.innerVariables.add(expression.getText().toLowerCase());
            } else if (!this.gatheringInnerVariable) {
                this.outerVariableNames.add(expression.getText().toLowerCase());
            }
        }

        public void visit(IdentificationVariableDeclaration expression) {
            expression.getRangeVariableDeclaration().accept((ExpressionVisitor)this);
            expression.getJoins().accept((ExpressionVisitor)this);
        }

        public void visit(Join expression) {
            expression.getJoinAssociationPath().accept((ExpressionVisitor)this);
            this.gatheringInnerVariable = true;
            expression.getIdentificationVariable().accept((ExpressionVisitor)this);
            this.gatheringInnerVariable = false;
        }

        public void visit(RangeVariableDeclaration expression) {
            expression.getAbstractSchemaName().accept((ExpressionVisitor)this);
            this.gatheringInnerVariable = true;
            expression.getIdentificationVariable().accept((ExpressionVisitor)this);
            this.gatheringInnerVariable = false;
        }

        public void visit(SimpleFromClause expression) {
            expression.getDeclaration().accept((ExpressionVisitor)this);
        }

        public void visit(SimpleSelectStatement expression) {
            expression.getFromClause().accept((ExpressionVisitor)this);
            expression.getWhereClause().accept((ExpressionVisitor)this);
        }

        public void visit(StateFieldPathExpression expression) {
            expression.getIdentificationVariable().accept((ExpressionVisitor)this);
        }

        public void visit(WhereClause expression) {
            expression.getConditionalExpression().accept((ExpressionVisitor)this);
        }
    }

    private class WhenClauseExpressionVisitor
    extends AbstractExpressionVisitor {
        Map<Expression, Expression> whenClauses = new LinkedHashMap<Expression, Expression>();

        WhenClauseExpressionVisitor() {
        }

        void dispose() {
            this.whenClauses.clear();
        }

        public void visit(CollectionExpression expression) {
            expression.acceptChildren((ExpressionVisitor)this);
        }

        public void visit(WhenClause expression) {
            expression.getWhenExpression().accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
            Expression whenExpression = ExpressionBuilderVisitor.this.queryExpression;
            expression.getThenExpression().accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
            Expression thenExpression = ExpressionBuilderVisitor.this.queryExpression;
            this.whenClauses.put(whenExpression, thenExpression);
        }
    }
}

