/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.persistence.internal.jpa.jpql.DefaultJPQLQueryContext;
import org.eclipse.persistence.internal.jpa.jpql.DeleteQueryVisitor;
import org.eclipse.persistence.internal.jpa.jpql.ReadQueryBuilder;
import org.eclipse.persistence.internal.jpa.jpql.UpdateQueryVisitor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.internal.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.internal.jpql.JPQLQueryProblemResourceBundle;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.jpql.JPQLQueryHelper;
import org.eclipse.persistence.jpa.jpql.JPQLQueryProblem;
import org.eclipse.persistence.jpa.jpql.spi.IJPAVersion;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.ModifyAllQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.UpdateAllQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HermesParser {
    private DeleteQueryVisitor deleteQueryVisitor;
    private ExistingQueryBuilderVisitor existingQueryBuilderVisitor;
    private NewQueryBuilderVisitor newQueryBuilderVisitor;
    private DefaultJPQLQueryContext queryContext;
    private JPQLQueryHelper queryHelper;
    private UpdateQueryVisitor updateQueryVisitor;
    private boolean validateQueries;

    public HermesParser(boolean validateQueries) {
        this.initialize(validateQueries);
    }

    private void addArguments(DatabaseQuery databaseQuery) {
        for (Map.Entry<String, Class<?>> inputParameters : this.queryContext.inputParameters()) {
            databaseQuery.addArgument(inputParameters.getKey().substring(1), inputParameters.getValue());
        }
    }

    private void addArguments(Map<String, Class<?>> arguments) {
        for (Map.Entry<String, Class<?>> inputParameters : this.queryContext.inputParameters()) {
            arguments.put(inputParameters.getKey().substring(1), inputParameters.getValue());
        }
    }

    private JPQLExpression buildExpression(String query) {
        return new JPQLExpression((CharSequence)query, IJPAVersion.DEFAULT_VERSION, this.validateQueries);
    }

    private DatabaseQuery buildQuery(JPQLExpression jpqlExpression) {
        NewQueryBuilderVisitor visitor = this.newQueryVisitor();
        try {
            jpqlExpression.accept((ExpressionVisitor)visitor);
            this.queryContext.setQuery(visitor.query);
            DatabaseQuery databaseQuery = visitor.query;
            return databaseQuery;
        }
        finally {
            visitor.query = null;
        }
    }

    public DatabaseQuery buildQuery(String jpqlQuery, AbstractSession session) {
        JPQLExpression jpqlExpression = this.buildExpression(jpqlQuery);
        this.queryContext.setJPQLExpression(jpqlExpression);
        this.queryContext.setQuery(session, jpqlQuery);
        this.validate((Expression)jpqlExpression);
        DatabaseQuery query = this.buildQuery(jpqlExpression);
        query.setEJBQLString(jpqlQuery);
        try {
            jpqlExpression.accept((ExpressionVisitor)this.existingQueryVisitor());
            this.addArguments(query);
        }
        finally {
            this.dispose();
        }
        return query;
    }

    public org.eclipse.persistence.expressions.Expression buildSelectionCriteria(String abstractSchemaName, String selectionCriteria, AbstractSession session, Map<String, Class<?>> arguments) {
        try {
            Expression expression = JPQLExpression.parseConditionalExpression((String)abstractSchemaName, (CharSequence)selectionCriteria, (IJPAVersion)IJPAVersion.DEFAULT_VERSION, (boolean)this.validateQueries);
            this.queryContext.setJPQLExpression(expression.getRoot());
            this.queryContext.setQuery(session, selectionCriteria);
            this.validate(expression);
            org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildQueryExpression(expression);
            this.addArguments(arguments);
            org.eclipse.persistence.expressions.Expression expression2 = queryExpression;
            return expression2;
        }
        finally {
            this.dispose();
        }
    }

    private DeleteQueryVisitor deleteQueryVisitor() {
        if (this.deleteQueryVisitor == null) {
            this.deleteQueryVisitor = new DeleteQueryVisitor(this.queryContext);
        }
        return this.deleteQueryVisitor;
    }

    private void dispose() {
        this.queryContext.dispose();
    }

    private ExistingQueryBuilderVisitor existingQueryVisitor() {
        if (this.existingQueryBuilderVisitor == null) {
            this.existingQueryBuilderVisitor = new ExistingQueryBuilderVisitor();
        }
        return this.existingQueryBuilderVisitor;
    }

    private void initialize(boolean validateQueries) {
        this.validateQueries = validateQueries;
        this.queryContext = new DefaultJPQLQueryContext();
        this.queryHelper = new JPQLQueryHelper((JPQLQueryContext)this.queryContext);
    }

    private void logProblems(List<JPQLQueryProblem> problems, String messageKey) {
        ResourceBundle bundle = ResourceBundle.getBundle(JPQLQueryProblemResourceBundle.class.getName());
        StringBuilder sb = new StringBuilder();
        int index = 0;
        int count = problems.size();
        while (index < count) {
            JPQLQueryProblem problem = problems.get(index);
            String message = bundle.getString(problem.getMessageKey());
            message = MessageFormat.format(message, problem.getMessageArguments());
            sb.append("\n");
            sb.append("[");
            sb.append(problem.getStartPosition());
            sb.append(", ");
            sb.append(problem.getEndPosition());
            sb.append("] ");
            sb.append(message);
            ++index;
        }
        String errorMessage = bundle.getString(messageKey);
        errorMessage = MessageFormat.format(errorMessage, this.queryContext.getJPQLQuery(), sb);
    }

    private NewQueryBuilderVisitor newQueryVisitor() {
        if (this.newQueryBuilderVisitor == null) {
            this.newQueryBuilderVisitor = new NewQueryBuilderVisitor();
        }
        return this.newQueryBuilderVisitor;
    }

    public void populateQuery(String jpqlQuery, DatabaseQuery query, AbstractSession session) {
        try {
            JPQLExpression jpqlExpression = this.buildExpression(jpqlQuery);
            this.queryContext.setJPQLExpression(jpqlExpression);
            this.queryContext.setQuery(query);
            this.queryContext.setQuery(session, jpqlQuery);
            this.validate((Expression)jpqlExpression);
            jpqlExpression.accept((ExpressionVisitor)this.existingQueryVisitor());
        }
        finally {
            this.dispose();
        }
    }

    private UpdateQueryVisitor updateQueryVisitor() {
        if (this.updateQueryVisitor == null) {
            this.updateQueryVisitor = new UpdateQueryVisitor(this.queryContext);
        }
        return this.updateQueryVisitor;
    }

    private void validate(Expression expression) {
        if (this.validateQueries) {
            ArrayList<JPQLQueryProblem> problems = new ArrayList<JPQLQueryProblem>();
            this.queryHelper.validateGrammar(expression, problems);
            if (!problems.isEmpty()) {
                this.logProblems(problems, "HERMES_PARSER_GRAMMAR_VALIDATOR_ERROR_MESSAGE");
                problems.clear();
            }
            this.queryHelper.validateSemantic(expression, problems);
            if (!problems.isEmpty()) {
                this.logProblems(problems, "HERMES_PARSER_SEMANTIC_VALIDATOR_ERROR_MESSAGE");
            }
        }
    }

    private class ExistingQueryBuilderVisitor
    extends AbstractExpressionVisitor {
        private ExistingQueryBuilderVisitor() {
        }

        private void updateQuery(ModifyAllQuery query) {
            query.setJPQLString(HermesParser.this.queryContext.getJPQLQuery());
            query.setSession(HermesParser.this.queryContext.getSession());
            query.setShouldDeferExecutionInUOW(false);
        }

        private void updateQuery(ObjectLevelReadQuery query) {
            query.setJPQLString(HermesParser.this.queryContext.getJPQLQuery());
        }

        public void visit(DeleteStatement expression) {
            this.updateQuery((ModifyAllQuery)HermesParser.this.queryContext.getDatabaseQuery());
            expression.accept((ExpressionVisitor)HermesParser.this.deleteQueryVisitor());
        }

        public void visit(JPQLExpression expression) {
            expression.getQueryStatement().accept((ExpressionVisitor)this);
        }

        public void visit(SelectStatement expression) {
            this.updateQuery((ObjectLevelReadQuery)HermesParser.this.queryContext.getDatabaseQuery());
            expression.accept(HermesParser.this.queryContext.readQueryVisitor());
        }

        public void visit(UpdateStatement expression) {
            this.updateQuery((ModifyAllQuery)HermesParser.this.queryContext.getDatabaseQuery());
            expression.accept((ExpressionVisitor)HermesParser.this.updateQueryVisitor());
        }
    }

    private class NewQueryBuilderVisitor
    extends AbstractExpressionVisitor {
        DatabaseQuery query;

        private NewQueryBuilderVisitor() {
        }

        public void visit(DeleteStatement expression) {
            this.query = new DeleteAllQuery();
        }

        public void visit(JPQLExpression expression) {
            expression.getQueryStatement().accept((ExpressionVisitor)this);
        }

        public void visit(SelectStatement expression) {
            ReadQueryBuilder visitor = HermesParser.this.queryContext.readQueryBuilder();
            try {
                expression.accept((ExpressionVisitor)visitor);
                this.query = visitor.query;
            }
            finally {
                visitor.query = null;
            }
        }

        public void visit(UpdateStatement expression) {
            this.query = new UpdateAllQuery();
        }
    }
}

