/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import org.eclipse.persistence.internal.jpa.jpql.JavaType;
import org.eclipse.persistence.internal.jpa.jpql.JavaTypeDeclaration;
import org.eclipse.persistence.jpa.jpql.spi.IConstructor;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JavaConstructor
implements IConstructor {
    private Constructor<?> constructor;
    private ITypeDeclaration[] parameterTypes;
    private JavaType type;

    JavaConstructor(JavaType type, Constructor<?> constructor) {
        this.type = type;
        this.constructor = constructor;
    }

    private ITypeDeclaration[] buildParameterTypes() {
        Class<?>[] types = this.constructor.getParameterTypes();
        Type[] genericTypes = this.constructor.getGenericParameterTypes();
        ITypeDeclaration[] typeDeclarations = new ITypeDeclaration[types.length];
        int index = 0;
        int count = types.length;
        while (index < count) {
            typeDeclarations[index] = this.buildTypeDeclaration(types[index], genericTypes[index]);
            ++index;
        }
        return typeDeclarations;
    }

    private ITypeDeclaration buildTypeDeclaration(Class<?> javaType, Type genericType) {
        ITypeRepository typeRepository = this.getTypeRepository();
        IType type = typeRepository.getType(javaType);
        return new JavaTypeDeclaration(typeRepository, type, genericType, javaType.isArray());
    }

    public ITypeDeclaration[] getParameterTypes() {
        if (this.parameterTypes == null) {
            this.parameterTypes = this.buildParameterTypes();
        }
        return this.parameterTypes;
    }

    private ITypeRepository getTypeRepository() {
        return this.type.getTypeRepository();
    }

    public String toString() {
        return this.constructor.toGenericString();
    }
}

