/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.internal.jpa.jpql.JavaType;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.jpa.jpql.TypeHelper;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JavaTypeRepository
implements ITypeRepository {
    private final ClassLoader classLoader;
    private TypeHelper typeHelper;
    private final Map<String, IType> types;

    JavaTypeRepository(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.types = new HashMap<String, IType>();
    }

    private Class<?> attemptLoadType(String typeName) {
        block5: {
            try {
                if (!PrivilegedAccessHelper.shouldUsePrivilegedAccess()) break block5;
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedClassForName(typeName, true, this.classLoader));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    return null;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getClassForName(typeName, true, this.classLoader);
    }

    private IType buildType(Class<?> javaType) {
        JavaType type = new JavaType((ITypeRepository)this, javaType);
        this.types.put(javaType.getName(), type);
        return type;
    }

    private IType buildType(String typeName) {
        return new JavaType((ITypeRepository)this, typeName);
    }

    public IType getEnumType(String enumTypeName) {
        int lastDotIndex = enumTypeName.lastIndexOf(".");
        if (lastDotIndex == -1) {
            return null;
        }
        String typeName = enumTypeName.substring(0, lastDotIndex);
        IType type = this.getType(typeName);
        return type.isEnum() ? type : null;
    }

    public IType getType(Class<?> javaClass) {
        return this.getType(javaClass.getName());
    }

    public IType getType(String typeName) {
        return this.loadTypeImp(typeName);
    }

    public TypeHelper getTypeHelper() {
        if (this.typeHelper == null) {
            this.typeHelper = new TypeHelper((ITypeRepository)this);
        }
        return this.typeHelper;
    }

    private IType loadInnerType(String typeName) {
        int index = typeName.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(typeName.substring(0, index));
        sb.append("$");
        sb.append(typeName.substring(index + 1, typeName.length()));
        typeName = sb.toString();
        return this.loadTypeImp(typeName);
    }

    private IType loadTypeImp(String typeName) {
        IType type = this.types.get(typeName);
        if (type != null) {
            return type;
        }
        Class<?> javaType = this.attemptLoadType(typeName);
        if (javaType != null) {
            return this.buildType(javaType);
        }
        type = this.loadInnerType(typeName);
        if (type == null) {
            type = this.buildType(typeName);
        }
        return type;
    }
}

