/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.jpql.DefaultJPQLQueryContext;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.jpa.internal.jpql.LiteralType;
import org.eclipse.persistence.jpa.internal.jpql.Resolver;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbsExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractSelectClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.AdditionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.AvgFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.CaseExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CoalesceExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ConcatExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CountFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.DateTime;
import org.eclipse.persistence.jpa.internal.jpql.parser.DivisionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.EntryExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.FuncExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.internal.jpql.parser.IndexExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.JoinFetch;
import org.eclipse.persistence.jpa.internal.jpql.parser.KeyExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.KeywordExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.LengthExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.LocateExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.LowerExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.MaxFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.MinFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.ModExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.MultiplicationExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NullIfExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NumericLiteral;
import org.eclipse.persistence.jpa.internal.jpql.parser.ObjectExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SizeExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SqrtExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringLiteral;
import org.eclipse.persistence.jpa.internal.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SubstringExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SubtractionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SumFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.TrimExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.TypeExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpperExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ValueExpression;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.MappingTypeHelper;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.queries.ReportQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ReportItemExpressionBuilder
extends AnonymousExpressionVisitor {
    private ConstructorExpressionVisitor constructorExpressionVisitor;
    private boolean multipleSelects;
    private final DefaultJPQLQueryContext queryContext;
    private SizeGroupByExpressionVisitor sizeGroupByExpressionVisitor;

    ReportItemExpressionBuilder(DefaultJPQLQueryContext queryContext) {
        this.queryContext = queryContext;
    }

    private void addAttribute(org.eclipse.persistence.jpa.internal.jpql.parser.Expression expression) {
        this.addAttribute("", expression);
    }

    private void addAttribute(org.eclipse.persistence.jpa.internal.jpql.parser.Expression expression, Class<?> type) {
        this.addAttribute("", expression, type);
    }

    private void addAttribute(String name, org.eclipse.persistence.jpa.internal.jpql.parser.Expression expression) {
        this.addAttribute(name, expression, null);
    }

    private void addAttribute(String name, org.eclipse.persistence.jpa.internal.jpql.parser.Expression expression, Class<?> type) {
        this.addAttribute(name, this.queryContext.buildQueryExpression(expression), type);
    }

    private void addAttribute(String name, Expression expression) {
        this.addAttribute(name, expression, null);
    }

    private void addAttribute(String name, Expression expression, Class<?> type) {
        this.getDatabaseQuery().addAttribute(name, expression, type);
    }

    private void addAttributeWithType(org.eclipse.persistence.jpa.internal.jpql.parser.Expression expression) {
        this.addAttributeWithType("", expression);
    }

    private void addAttributeWithType(String name, org.eclipse.persistence.jpa.internal.jpql.parser.Expression expression) {
        this.addAttribute(name, expression, this.queryContext.getJavaType(expression));
    }

    private ConstructorExpressionVisitor constructorExpressionVisitor() {
        if (this.constructorExpressionVisitor == null) {
            this.constructorExpressionVisitor = new ConstructorExpressionVisitor();
        }
        return this.constructorExpressionVisitor;
    }

    private ReportQuery getDatabaseQuery() {
        return (ReportQuery)this.queryContext.getDatabaseQuery();
    }

    private String literal(org.eclipse.persistence.jpa.internal.jpql.parser.Expression expression, LiteralType type) {
        return this.queryContext.literal(expression, type);
    }

    private SizeGroupByExpressionVisitor sizeGroupByExpressionVisitor() {
        if (this.sizeGroupByExpressionVisitor == null) {
            this.sizeGroupByExpressionVisitor = new SizeGroupByExpressionVisitor();
        }
        return this.sizeGroupByExpressionVisitor;
    }

    public void visit(AbsExpression expression) {
        this.addAttributeWithType((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
    }

    public void visit(AdditionExpression expression) {
        Class<?> type = this.queryContext.getJavaType((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
        if (type == Object.class) {
            type = null;
        }
        this.addAttribute("plus", (org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression, type);
    }

    public void visit(AvgFunction expression) {
        String name = this.literal(expression.getExpression(), LiteralType.PATH_EXPRESSION_LAST_PATH);
        this.addAttribute(name, (org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression, Double.class);
    }

    public void visit(CaseExpression expression) {
        this.addAttributeWithType("Case", (org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
    }

    public void visit(CoalesceExpression expression) {
        this.addAttribute("Coalesce", (org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
    }

    public void visit(CollectionExpression expression) {
        this.multipleSelects = true;
        expression.acceptChildren((ExpressionVisitor)this);
    }

    public void visit(ConcatExpression expression) {
        this.addAttribute((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression, String.class);
    }

    public void visit(ConstructorExpression expression) {
        ReportQuery query = this.getDatabaseQuery();
        Class<?> type = this.queryContext.getJavaType(expression.getClassName());
        query.beginAddingConstructorArguments(type);
        expression.accept((ExpressionVisitor)this.constructorExpressionVisitor());
        query.endAddingToConstructorItem();
    }

    public void visit(CountFunction expression) {
        String name = this.literal(expression.getExpression(), LiteralType.PATH_EXPRESSION_LAST_PATH);
        if (ExpressionTools.stringIsEmpty((CharSequence)name)) {
            name = "COUNT";
        }
        this.addAttribute(name, (org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression, Long.class);
    }

    public void visit(DateTime expression) {
        if (expression.isJDBCDate()) {
            this.addAttribute("CONSTANT", (org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
        } else {
            this.addAttributeWithType("date", (org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
        }
    }

    public void visit(DivisionExpression expression) {
        Class<?> type = this.queryContext.getJavaType((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
        if (type == Object.class) {
            type = null;
        }
        this.addAttribute("divide", (org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression, type);
    }

    public void visit(EntryExpression expression) {
        this.addAttribute(" MapEntry", (org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
    }

    public void visit(FuncExpression expression) {
        this.addAttribute((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
    }

    public void visit(IdentificationVariable expression) {
        String variableName = expression.getText();
        ArrayList<Expression> joinFetches = new ArrayList<Expression>();
        for (JoinFetch joinFetch : this.queryContext.getJoinFetches(variableName)) {
            String joinFetchVariableName = this.literal((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)joinFetch, LiteralType.PATH_EXPRESSION_IDENTIFICATION_VARIABLE);
            if (!variableName.equalsIgnoreCase(joinFetchVariableName)) continue;
            joinFetches.add(this.queryContext.buildQueryExpression((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)joinFetch));
        }
        if (joinFetches.isEmpty()) {
            this.addAttribute(variableName, this.queryContext.buildQueryExpression((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression));
        } else {
            this.getDatabaseQuery().addItem(variableName, this.queryContext.buildQueryExpression((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression), joinFetches);
        }
    }

    public void visit(IndexExpression expression) {
        this.addAttribute("Index", (org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression, Integer.class);
    }

    public void visit(KeyExpression expression) {
        this.addAttribute("MapKey", (org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
    }

    public void visit(KeywordExpression expression) {
        this.addAttribute("CONSTANT", (org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
    }

    public void visit(LengthExpression expression) {
        this.addAttribute((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression, Integer.class);
    }

    public void visit(LocateExpression expression) {
        this.addAttribute((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression, Integer.class);
    }

    public void visit(LowerExpression expression) {
        this.addAttribute((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression, String.class);
    }

    public void visit(MaxFunction expression) {
        String name = this.literal(expression.getExpression(), LiteralType.PATH_EXPRESSION_LAST_PATH);
        this.addAttribute(name, (org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
    }

    public void visit(MinFunction expression) {
        String name = this.literal(expression.getExpression(), LiteralType.PATH_EXPRESSION_LAST_PATH);
        this.addAttribute(name, (org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
    }

    public void visit(ModExpression expression) {
        this.addAttribute((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression, Integer.class);
    }

    public void visit(MultiplicationExpression expression) {
        Class<?> type = this.queryContext.getJavaType((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
        if (type == Object.class) {
            type = null;
        }
        this.addAttribute("multiply", (org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression, type);
    }

    public void visit(NullIfExpression expression) {
        this.addAttribute("NULLIF", (org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
    }

    public void visit(NumericLiteral expression) {
        this.addAttribute("CONSTANT", (org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
    }

    public void visit(ObjectExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
    }

    protected void visit(org.eclipse.persistence.jpa.internal.jpql.parser.Expression expression) {
        this.addAttribute(expression);
    }

    public void visit(ResultVariable expression) {
        expression.getSelectExpression().accept((ExpressionVisitor)this);
        String variableName = expression.getResultVariable().toParsedText();
        List<ReportItem> items = this.getDatabaseQuery().getItems();
        ReportItem lastItem = items.get(items.size() - 1);
        this.queryContext.addQueryExpression(variableName, lastItem.getAttributeExpression());
    }

    public void visit(SelectClause expression) {
        this.visitAbstractSelectClause((AbstractSelectClause)expression);
    }

    public void visit(SimpleSelectClause expression) {
        this.visitAbstractSelectClause((AbstractSelectClause)expression);
    }

    public void visit(SizeExpression expression) {
        Expression queryExpression = this.queryContext.buildQueryExpression(expression.getExpression());
        this.addAttribute("size", queryExpression.count(), Integer.class);
        SizeGroupByExpressionVisitor visitor = this.sizeGroupByExpressionVisitor();
        try {
            expression.accept((ExpressionVisitor)visitor);
            this.getDatabaseQuery().addGrouping(this.queryContext.resolve(visitor.resolver));
        }
        finally {
            visitor.resolver = null;
        }
    }

    public void visit(SqrtExpression expression) {
        this.addAttribute((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression, Double.class);
    }

    public void visit(StateFieldPathExpression expression) {
        Expression queryExpression;
        Resolver resolver = this.queryContext.getResolver((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
        IMapping mapping = resolver.getMapping();
        if (MappingTypeHelper.isRelationshipMapping((IMapping)mapping)) {
            boolean oldNullAllowed = resolver.isNullAllowed();
            resolver.setNullAllowed(true);
            queryExpression = this.queryContext.buildQueryExpression((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
            resolver.setNullAllowed(oldNullAllowed);
        } else {
            queryExpression = this.queryContext.buildQueryExpression((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
        }
        String name = expression.getPath(expression.pathSize() - 1);
        this.addAttribute(name, queryExpression);
        this.getDatabaseQuery().dontRetrievePrimaryKeys();
    }

    public void visit(StringLiteral expression) {
        this.addAttribute("CONSTANT", (org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
    }

    public void visit(SubExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
    }

    public void visit(SubstringExpression expression) {
        this.addAttribute((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression, String.class);
    }

    public void visit(SubtractionExpression expression) {
        Class<?> type = this.queryContext.getJavaType((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
        if (type == Object.class) {
            type = null;
        }
        this.addAttribute("minus", (org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression, type);
    }

    public void visit(SumFunction expression) {
        String name = this.literal(expression.getExpression(), LiteralType.PATH_EXPRESSION_LAST_PATH);
        this.addAttributeWithType(name, (org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
    }

    public void visit(TrimExpression expression) {
        this.addAttribute((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression, String.class);
    }

    public void visit(TypeExpression expression) {
        super.visit(expression);
    }

    public void visit(UpperExpression expression) {
        this.addAttribute((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression, String.class);
    }

    public void visit(ValueExpression expression) {
        String name = this.literal(expression.getExpression(), LiteralType.IDENTIFICATION_VARIABLE);
        this.addAttribute(name, (org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
    }

    private void visitAbstractSelectClause(AbstractSelectClause expression) {
        this.multipleSelects = false;
        expression.getSelectExpression().accept((ExpressionVisitor)this);
        if (this.multipleSelects) {
            this.getDatabaseQuery().returnWithoutReportQueryResult();
        } else {
            this.getDatabaseQuery().returnSingleAttribute();
        }
    }

    private class ConstructorExpressionVisitor
    extends AnonymousExpressionVisitor {
        private ConstructorExpressionVisitor() {
        }

        public void visit(CollectionExpression expression) {
            expression.acceptChildren((ExpressionVisitor)this);
        }

        public void visit(ConstructorExpression expression) {
            expression.getConstructorItems().accept((ExpressionVisitor)this);
        }

        protected void visit(org.eclipse.persistence.jpa.internal.jpql.parser.Expression expression) {
            expression.accept((ExpressionVisitor)ReportItemExpressionBuilder.this);
        }
    }

    private class SizeGroupByExpressionVisitor
    extends AnonymousExpressionVisitor {
        Resolver resolver;

        private SizeGroupByExpressionVisitor() {
        }

        public void visit(CollectionValuedPathExpression expression) {
            this.resolver = ReportItemExpressionBuilder.this.queryContext.getResolver((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
            this.resolver = this.resolver.getParent();
        }

        public void visit(IdentificationVariable expression) {
            this.resolver = ReportItemExpressionBuilder.this.queryContext.getResolver((org.eclipse.persistence.jpa.internal.jpql.parser.Expression)expression);
        }

        public void visit(SizeExpression expression) {
            expression.getExpression().accept((ExpressionVisitor)this);
        }
    }
}

