/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.XPathPredicate;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshalListener;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MarshalRecord
extends XMLRecord {
    private ArrayList<XPathNode> groupingElements;
    private HashMap positionalNodes;
    protected XPathFragment textWrapperFragment;
    protected static final String COLON_W_SCHEMA_NIL_ATTRIBUTE = ":nil";
    protected static final String TRUE = "true";

    public HashMap getPositionalNodes() {
        if (this.positionalNodes == null) {
            this.positionalNodes = new HashMap();
        }
        return this.positionalNodes;
    }

    @Override
    public String getLocalName() {
        throw XMLMarshalException.operationNotSupported("getLocalName");
    }

    @Override
    public String getNamespaceURI() {
        throw XMLMarshalException.operationNotSupported("getNamespaceURI");
    }

    @Override
    public void clear() {
        throw XMLMarshalException.operationNotSupported("clear");
    }

    @Override
    public Document getDocument() {
        throw XMLMarshalException.operationNotSupported("getDocument");
    }

    @Override
    public Element getDOM() {
        throw XMLMarshalException.operationNotSupported("getDOM");
    }

    public void addGroupingElement(XPathNode xPathNode) {
        if (this.groupingElements == null) {
            this.groupingElements = new ArrayList();
        }
        this.groupingElements.add(xPathNode);
    }

    public void removeGroupingElement(XPathNode xPathNode) {
        if (this.groupingElements != null) {
            this.groupingElements.remove(xPathNode);
        }
    }

    @Override
    public String transformToXML() {
        return null;
    }

    @Override
    public void add(DatabaseField key, Object value) {
        if (value == null) {
            return;
        }
        XMLField xmlField = this.convertToXMLField(key);
        XPathFragment lastFragment = xmlField.getLastXPathFragment();
        if (lastFragment.nameIsText()) {
            this.characters(xmlField.getSchemaType(), value, xmlField.isCDATA());
        } else if (lastFragment.isAttribute()) {
            this.attribute(lastFragment, xmlField.getNamespaceResolver(), value, xmlField.getSchemaType());
        } else {
            this.element(lastFragment);
        }
    }

    @Override
    public Object put(DatabaseField key, Object value) {
        this.add(key, value);
        return null;
    }

    public void namespaceDeclarations(NamespaceResolver namespaceResolver) {
        if (namespaceResolver == null) {
            return;
        }
        String namespaceURI = namespaceResolver.getDefaultNamespaceURI();
        if (namespaceURI != null) {
            this.attribute("http://www.w3.org/2000/xmlns/", "xmlns", "xmlns", namespaceURI);
        }
        for (Map.Entry<String, String> entry : namespaceResolver.getPrefixesToNamespaces().entrySet()) {
            String namespacePrefix = entry.getKey();
            this.attribute("http://www.w3.org/2000/xmlns/", namespacePrefix, "xmlns:" + namespacePrefix, entry.getValue());
        }
    }

    public abstract void startDocument(String var1, String var2);

    public abstract void endDocument();

    public void startPrefixMapping(String prefix, String namespaceURI) {
    }

    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
        if (namespaceResolver != null) {
            for (Map.Entry<String, String> entry : namespaceResolver.getPrefixesToNamespaces().entrySet()) {
                this.startPrefixMapping(entry.getKey(), entry.getValue());
            }
        }
    }

    public void endPrefixMapping(String prefix) {
    }

    public void endPrefixMappings(NamespaceResolver namespaceResolver) {
        if (namespaceResolver != null) {
            for (Map.Entry<String, String> entry : namespaceResolver.getPrefixesToNamespaces().entrySet()) {
                this.endPrefixMapping(entry.getKey());
            }
        }
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.addPositionalNodes(xPathFragment, namespaceResolver);
    }

    public abstract void element(XPathFragment var1);

    public abstract void attribute(XPathFragment var1, NamespaceResolver var2, String var3);

    public abstract void attribute(String var1, String var2, String var3, String var4);

    public abstract void closeStartElement();

    public abstract void endElement(XPathFragment var1, NamespaceResolver var2);

    public abstract void characters(String var1);

    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, Object value, QName schemaType) {
        if (schemaType != null && XMLConstants.QNAME_QNAME.equals(schemaType)) {
            String convertedValue = this.getStringForQName((QName)value);
            this.attribute(xPathFragment, namespaceResolver, convertedValue);
        } else {
            String convertedValue = (String)((XMLConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(value, ClassConstants.STRING, schemaType);
            this.attribute(xPathFragment, namespaceResolver, convertedValue);
        }
    }

    public void characters(QName schemaType, Object value, boolean isCDATA) {
        if (schemaType != null && XMLConstants.QNAME_QNAME.equals(schemaType)) {
            String convertedValue = this.getStringForQName((QName)value);
            this.characters(convertedValue);
        } else {
            String convertedValue = (String)((XMLConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(value, ClassConstants.STRING, schemaType);
            if (isCDATA) {
                this.cdata(convertedValue);
            } else {
                this.characters(convertedValue);
            }
        }
    }

    public String getValueToWrite(QName schemaType, Object value, XMLConversionManager xmlConversionManager) {
        if (schemaType != null && XMLConstants.QNAME_QNAME.equals(schemaType)) {
            return this.getStringForQName((QName)value);
        }
        if (value.getClass() == String.class) {
            return (String)value;
        }
        return (String)xmlConversionManager.convertObject(value, ClassConstants.STRING, schemaType);
    }

    protected String getStringForQName(QName qName) {
        if (qName == null) {
            return null;
        }
        String namespaceURI = qName.getNamespaceURI();
        if (namespaceURI == null || namespaceURI.length() == 0) {
            if (this.getNamespaceResolver() != null && this.getNamespaceResolver().getDefaultNamespaceURI() != null) {
                this.attribute("http://www.w3.org/2000/xmlns/", "xmlns", "xmlns", namespaceURI);
            }
            return qName.getLocalPart();
        }
        NamespaceResolver namespaceResolver = this.getNamespaceResolver();
        if (namespaceResolver == null) {
            throw XMLMarshalException.namespaceResolverNotSpecified(namespaceURI);
        }
        if (namespaceURI.equals(namespaceResolver.getDefaultNamespaceURI())) {
            return qName.getLocalPart();
        }
        String prefix = namespaceResolver.resolveNamespaceURI(namespaceURI);
        if (prefix == null) {
            prefix = namespaceResolver.generatePrefix();
            this.attribute("http://www.w3.org/2000/xmlns/", prefix, "xmlns:" + prefix, namespaceURI);
        }
        return String.valueOf(prefix) + ':' + qName.getLocalPart();
    }

    public abstract void cdata(String var1);

    public abstract void node(Node var1, NamespaceResolver var2);

    public XPathFragment openStartGroupingElements(NamespaceResolver namespaceResolver) {
        if (this.groupingElements == null) {
            return null;
        }
        XPathFragment xPathFragment = null;
        int x = 0;
        int groupingElementsSize = this.groupingElements.size();
        while (x < groupingElementsSize) {
            XPathNode xPathNode = this.groupingElements.get(x);
            xPathFragment = xPathNode.getXPathFragment();
            this.openStartElement(xPathFragment, namespaceResolver);
            this.predicateAttribute(xPathFragment, namespaceResolver);
            if (x != groupingElementsSize - 1) {
                this.closeStartElement();
            }
            ++x;
        }
        this.groupingElements = null;
        return xPathFragment;
    }

    public void closeStartGroupingElements(XPathFragment groupingFragment) {
        if (groupingFragment != null) {
            this.closeStartElement();
        }
    }

    protected void addPositionalNodes(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        if (xPathFragment.containsIndex()) {
            String shortName = xPathFragment.getShortName();
            Integer index = (Integer)this.getPositionalNodes().get(shortName);
            int start = index == null ? 1 : index;
            int x = start;
            while (x < xPathFragment.getIndexValue()) {
                this.element(xPathFragment);
                ++x;
            }
            this.getPositionalNodes().put(shortName, xPathFragment.getIndexValue() + 1);
        }
    }

    public void beforeContainmentMarshal(Object child) {
        XMLMarshalListener marshalListener;
        if (this.marshaller != null && (marshalListener = this.marshaller.getMarshalListener()) != null) {
            marshalListener.beforeMarshal(child);
        }
        this.setOwningObject(child);
    }

    public void afterContainmentMarshal(Object parent, Object child) {
        XMLMarshalListener marshalListener;
        if (this.marshaller != null && (marshalListener = this.marshaller.getMarshalListener()) != null) {
            marshalListener.afterMarshal(child);
        }
        this.setOwningObject(parent);
    }

    public ArrayList<XPathNode> getGroupingElements() {
        return this.groupingElements;
    }

    public void setGroupingElement(ArrayList<XPathNode> elements) {
        this.groupingElements = elements;
    }

    public void predicateAttribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment predicateXPathFragment;
        XPathPredicate predicate;
        if (xPathFragment != null && (predicate = xPathFragment.getPredicate()) != null && (predicateXPathFragment = predicate.getXPathFragment()).isAttribute()) {
            this.attribute(predicateXPathFragment, namespaceResolver, predicate.getValue());
        }
    }

    public void startCollection() {
    }

    public void emptyAttribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.attribute(xPathFragment, namespaceResolver, "");
        this.closeStartGroupingElements(groupingFragment);
    }

    public void emptyComplex(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.closeStartGroupingElements(groupingFragment);
        this.openStartElement(xPathFragment, namespaceResolver);
        this.closeStartElement();
        this.endElement(xPathFragment, namespaceResolver);
    }

    public void emptySimple(NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.closeStartGroupingElements(groupingFragment);
    }

    public void nilSimple(NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        String xsiPrefix = this.processNamespaceResolverForXSIPrefix(namespaceResolver);
        StringBuilder qName = new StringBuilder(XMLConstants.ATTRIBUTE.charValue());
        qName.append(xsiPrefix).append(COLON_W_SCHEMA_NIL_ATTRIBUTE);
        XPathFragment nilFragment = new XPathFragment(qName.toString());
        nilFragment.setNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        this.attribute(nilFragment, namespaceResolver, TRUE);
        this.closeStartGroupingElements(groupingFragment);
    }

    public void nilComplex(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.closeStartGroupingElements(groupingFragment);
        this.openStartElement(xPathFragment, namespaceResolver);
        String xsiPrefix = this.processNamespaceResolverForXSIPrefix(namespaceResolver);
        XPathFragment nilFragment = new XPathFragment(XMLConstants.ATTRIBUTE + xsiPrefix + COLON_W_SCHEMA_NIL_ATTRIBUTE);
        nilFragment.setNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        this.attribute(nilFragment, namespaceResolver, TRUE);
        this.closeStartElement();
        this.endElement(xPathFragment, namespaceResolver);
    }

    public void endCollection() {
    }

    protected String processNamespaceResolverForXSIPrefix(NamespaceResolver namespaceResolver) {
        String xsiPrefix;
        if (namespaceResolver == null) {
            xsiPrefix = "xsi";
            namespaceResolver = new NamespaceResolver();
            namespaceResolver.put(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
            this.attribute("http://www.w3.org/2000/xmlns/", xsiPrefix, "xmlns:" + xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
        } else {
            xsiPrefix = namespaceResolver.resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
            if (xsiPrefix == null) {
                xsiPrefix = namespaceResolver.generatePrefix("xsi");
                this.attribute("http://www.w3.org/2000/xmlns/", xsiPrefix, "xmlns:" + xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
            }
        }
        return xsiPrefix;
    }

    public XPathFragment getTextWrapperFragment() {
        return null;
    }

    @Override
    public void setMarshaller(XMLMarshaller marshaller) {
        super.setMarshaller(marshaller);
        if (marshaller.getValueWrapper() != null) {
            this.textWrapperFragment = new XPathFragment(marshaller.getValueWrapper());
        }
    }
}

