/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.jpa.jpql.AbstractObjectLevelReadQueryVisitor;
import org.eclipse.persistence.internal.jpa.jpql.ExpressionBuilderVisitor;
import org.eclipse.persistence.internal.jpa.jpql.JavaManagedTypeProvider;
import org.eclipse.persistence.internal.jpa.jpql.JavaQuery;
import org.eclipse.persistence.internal.jpa.jpql.JavaType;
import org.eclipse.persistence.internal.jpa.jpql.ObjectLevelReadQueryVisitor;
import org.eclipse.persistence.internal.jpa.jpql.ReadQueryBuilder;
import org.eclipse.persistence.internal.jpa.jpql.ReportQueryVisitor;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.internal.jpql.DeclarationResolver;
import org.eclipse.persistence.jpa.internal.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.internal.jpql.Resolver;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DefaultJPQLQueryContext
extends JPQLQueryContext {
    private org.eclipse.persistence.expressions.Expression baseExpression;
    private Map<String, org.eclipse.persistence.expressions.Expression> entityExpressions;
    private ExpressionBuilderVisitor expressionBuilder;
    private Map<String, org.eclipse.persistence.expressions.Expression> expressions;
    private Map<String, Class<?>> inputParameters;
    private ObjectLevelReadQueryVisitor objectLevelReadQueryVisitor;
    private DatabaseQuery query;
    private ReadQueryBuilder readQueryBuilder;
    private ReportQueryVisitor reportQueryVisitor;
    private Set<String> usedIdentificationVariables;

    DefaultJPQLQueryContext() {
        this.inputParameters = new LinkedHashMap();
    }

    private DefaultJPQLQueryContext(DefaultJPQLQueryContext parent, Expression currentQuery, ReportQuery query) {
        super((JPQLQueryContext)parent, currentQuery);
        this.store(parent, query);
    }

    void addInputParameter(String parameterName, Class<?> type) {
        this.inputParameters.put(parameterName, type);
    }

    void addQueryExpression(String variableName, org.eclipse.persistence.expressions.Expression expression) {
        this.getCurrentContext().addQueryExpressionImp(variableName, expression);
    }

    private void addQueryExpressionImp(String variableName, org.eclipse.persistence.expressions.Expression expression) {
        this.expressions.put(variableName.toUpperCase(), expression);
    }

    void addUsedIdentificationVariable(String variableName) {
        this.usedIdentificationVariables.add(variableName.toUpperCase());
    }

    org.eclipse.persistence.expressions.Expression buildBaseExpression(DeclarationResolver.Declaration declaration) {
        ClassDescriptor descriptor = this.getDescriptor(declaration.getAbstractSchemaName());
        if (descriptor == null) {
            this.convertUnqualifiedDeclaration(declaration);
            return this.buildQueryExpression(declaration.getBaseExpression());
        }
        return new ExpressionBuilder(descriptor.getJavaClass());
    }

    private JavaManagedTypeProvider buildProvider(AbstractSession session) {
        return new JavaManagedTypeProvider(session);
    }

    org.eclipse.persistence.expressions.Expression buildQueryExpression(Expression expression) {
        ExpressionBuilderVisitor expressionBuilder = this.expressionBuilder();
        try {
            expression.accept((ExpressionVisitor)expressionBuilder);
            org.eclipse.persistence.expressions.Expression expression2 = expressionBuilder.getQueryExpression();
            return expression2;
        }
        finally {
            expressionBuilder.dispose();
        }
    }

    public void dispose() {
        super.dispose();
        this.query = null;
        this.baseExpression = null;
        this.expressions.clear();
        this.inputParameters.clear();
        this.entityExpressions.clear();
        this.usedIdentificationVariables.clear();
    }

    private ExpressionBuilderVisitor expressionBuilder() {
        if (this.expressionBuilder == null) {
            this.expressionBuilder = new ExpressionBuilderVisitor(this);
        }
        return this.expressionBuilder;
    }

    org.eclipse.persistence.expressions.Expression getBaseExpression() {
        return this.getCurrentContext().getBaseExpressionImp();
    }

    private org.eclipse.persistence.expressions.Expression getBaseExpressionImp() {
        if (this.baseExpression == null) {
            DeclarationResolver.Declaration declaration = (DeclarationResolver.Declaration)this.getDeclarations().get(0);
            this.baseExpression = declaration.isRange() ? this.buildBaseExpression(declaration) : this.buildQueryExpression(declaration.getBaseExpression());
            this.addQueryExpressionImp(declaration.getVariableName(), this.baseExpression);
        }
        return this.baseExpression;
    }

    Constructor<?> getConstructor(Class<?> type) {
        return this.getConstructor(type, new Class[0]);
    }

    <T> Constructor<T> getConstructor(Class<?> type, Class<?>[] parameterTypes) {
        block5: {
            try {
                if (!PrivilegedAccessHelper.shouldUsePrivilegedAccess()) break block5;
                try {
                    return (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(type, (Class[])parameterTypes, true));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    return null;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getConstructorFor(type, (Class[])parameterTypes, (boolean)true);
    }

    protected DefaultJPQLQueryContext getCurrentContext() {
        return (DefaultJPQLQueryContext)super.getCurrentContext();
    }

    <T extends DatabaseQuery> T getDatabaseQuery() {
        return (T)this.getCurrentContext().query;
    }

    protected DeclarationResolver getDeclarationResolver(Expression expression) {
        return this.getDeclarationResolver();
    }

    ClassDescriptor getDescriptor(String abstractSchemaName) {
        return this.getSession().getDescriptorForAlias(abstractSchemaName);
    }

    Class<?> getJavaType(IType type) {
        Class<Object> javaType;
        Class<?> clazz = javaType = type == null ? null : ((JavaType)type).getType();
        if (javaType == null) {
            javaType = Object.class;
        }
        return javaType;
    }

    Class<?> getJavaType(Expression expression) {
        return this.getJavaType(this.getType(expression));
    }

    Class<?> getJavaType(String typeName) {
        return this.getJavaType(this.getType(typeName));
    }

    public DefaultJPQLQueryContext getParent() {
        return (DefaultJPQLQueryContext)this.parent;
    }

    org.eclipse.persistence.expressions.Expression getParentQueryExpression(String variableName) {
        return this.getCurrentContext().getParent().getQueryExpressionImp(variableName);
    }

    public JavaManagedTypeProvider getProvider() {
        return (JavaManagedTypeProvider)super.getProvider();
    }

    org.eclipse.persistence.expressions.Expression getQueryExpression(String variableName) {
        return this.getCurrentContext().getQueryExpressionImp(variableName);
    }

    private org.eclipse.persistence.expressions.Expression getQueryExpressionImp(String variableName) {
        return this.expressions.get(variableName.toUpperCase());
    }

    AbstractSession getSession() {
        return this.getProvider().getSession();
    }

    protected void initialize() {
        super.initialize();
        this.expressions = new HashMap<String, org.eclipse.persistence.expressions.Expression>();
        this.entityExpressions = new HashMap<String, org.eclipse.persistence.expressions.Expression>();
        this.usedIdentificationVariables = new HashSet<String>();
    }

    Set<Map.Entry<String, Class<?>>> inputParameters() {
        return this.inputParameters.entrySet();
    }

    boolean isIdentificationVariableUsed(String variableName) {
        return this.getCurrentContext().isIdentificationVariableUsedImp(variableName.toUpperCase());
    }

    private boolean isIdentificationVariableUsedImp(String variableName) {
        boolean result = this.usedIdentificationVariables.contains(variableName);
        if (!result && this.parent != null) {
            result = this.getParent().isIdentificationVariableUsedImp(variableName);
        }
        return result;
    }

    <T> T newInstance(Class<?> type, Class<?> parameterType, Object parameter) {
        return this.newInstance(type, new Class[]{parameterType}, new Object[]{parameter});
    }

    <T> T newInstance(Class<?> type, Class<?>[] parameterTypes, Object[] parameters) {
        Constructor<T> constructor = this.getConstructor(type, parameterTypes);
        if (constructor != null) {
            return this.newInstance(constructor, parameters);
        }
        return null;
    }

    <T> T newInstance(Constructor<T> constructor, Object[] parameters) {
        block7: {
            if (!PrivilegedAccessHelper.shouldUsePrivilegedAccess()) break block7;
            try {
                return AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, parameters));
            }
            catch (PrivilegedActionException privilegedActionException) {
                return null;
            }
        }
        try {
            return (T)PrivilegedAccessHelper.invokeConstructor(constructor, (Object[])parameters);
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    void newSubQueryContext(Expression currentQuery, ReportQuery query) {
        this.currentContext = new DefaultJPQLQueryContext(this.getCurrentContext(), currentQuery, query);
    }

    ObjectLevelReadQueryVisitor objectLevelReadQueryVisitor() {
        if (this.objectLevelReadQueryVisitor == null) {
            this.objectLevelReadQueryVisitor = new ObjectLevelReadQueryVisitor(this);
        }
        return this.objectLevelReadQueryVisitor;
    }

    ReadQueryBuilder readQueryBuilder() {
        if (this.readQueryBuilder == null) {
            this.readQueryBuilder = new ReadQueryBuilder(this);
        }
        return this.readQueryBuilder;
    }

    AbstractObjectLevelReadQueryVisitor<? extends ObjectLevelReadQuery> readQueryVisitor() {
        return this.query.isReportQuery() ? this.reportQueryVisitor() : this.objectLevelReadQueryVisitor();
    }

    ReportQueryVisitor reportQueryVisitor() {
        if (this.reportQueryVisitor == null) {
            this.reportQueryVisitor = new ReportQueryVisitor(this);
        }
        return this.reportQueryVisitor;
    }

    org.eclipse.persistence.expressions.Expression resolve(Resolver resolver) {
        return this.expressionBuilder().resolve(resolver);
    }

    void setQuery(AbstractSession session, String jpqlQuery) {
        this.setQuery(new JavaQuery(this.buildProvider(session), jpqlQuery));
    }

    void setQuery(DatabaseQuery query) {
        this.getCurrentContext().query = query;
    }

    private void store(DefaultJPQLQueryContext parent, ReportQuery query) {
        this.query = query;
        this.inputParameters = parent.inputParameters;
        this.readQueryBuilder = parent.readQueryBuilder;
        this.expressionBuilder = parent.expressionBuilder;
        this.reportQueryVisitor = parent.reportQueryVisitor;
        this.objectLevelReadQueryVisitor = parent.objectLevelReadQueryVisitor;
    }
}

