/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.jpql.JavaManagedTypeProvider;
import org.eclipse.persistence.internal.jpa.jpql.JavaMapping;
import org.eclipse.persistence.internal.jpa.jpql.JavaQueryKey;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.querykeys.QueryKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JavaManagedType
implements IManagedType {
    private ClassDescriptor descriptor;
    private Map<String, IMapping> mappings;
    private JavaManagedTypeProvider provider;
    private IType type;

    JavaManagedType(JavaManagedTypeProvider provider, ClassDescriptor descriptor) {
        this.provider = provider;
        this.descriptor = descriptor;
    }

    private IMapping buildMapping(DatabaseMapping mapping) {
        return new JavaMapping(this, mapping);
    }

    private IMapping buildMapping(QueryKey queryKey) {
        return new JavaQueryKey(this, queryKey);
    }

    private Map<String, IMapping> buildMappings() {
        HashMap<String, IMapping> mappings = new HashMap<String, IMapping>();
        for (DatabaseMapping databaseMapping : this.descriptor.getMappings()) {
            mappings.put(databaseMapping.getAttributeName(), this.buildMapping(databaseMapping));
        }
        for (QueryKey queryKey : this.descriptor.getQueryKeys().values()) {
            mappings.put(queryKey.getName(), this.buildMapping(queryKey));
        }
        return mappings;
    }

    private IType buildType() {
        return this.provider.getTypeRepository().getType(this.descriptor.getJavaClass());
    }

    public final int compareTo(IManagedType managedType) {
        return this.getType().getName().compareTo(managedType.getType().getName());
    }

    final ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final IMapping getMappingNamed(String name) {
        this.initializeMappings();
        return this.mappings.get(name);
    }

    public final JavaManagedTypeProvider getProvider() {
        return this.provider;
    }

    public final IType getType() {
        if (this.type == null) {
            this.type = this.buildType();
        }
        return this.type;
    }

    private void initializeMappings() {
        if (this.mappings == null) {
            this.mappings = this.buildMappings();
        }
    }

    public Iterable<IMapping> mappings() {
        this.initializeMappings();
        return Collections.unmodifiableCollection(this.mappings.values());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("type=");
        sb.append(this.descriptor.getJavaClassName());
        return sb.toString();
    }
}

