/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.jpql.JavaEmbeddable;
import org.eclipse.persistence.internal.jpa.jpql.JavaEntity;
import org.eclipse.persistence.internal.jpa.jpql.JavaType;
import org.eclipse.persistence.internal.jpa.jpql.JavaTypeRepository;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.spi.IEmbeddable;
import org.eclipse.persistence.jpa.jpql.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.spi.IJPAVersion;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeVisitor;
import org.eclipse.persistence.jpa.jpql.spi.IMappedSuperclass;
import org.eclipse.persistence.jpa.jpql.spi.IPlatform;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaManagedTypeProvider
implements IManagedTypeProvider {
    private Collection<IEntity> abstractSchemaTypes;
    private Map<String, IManagedType> managedTypes;
    private AbstractSession session;
    private JavaTypeRepository typeRepository;

    JavaManagedTypeProvider(AbstractSession session) {
        this.session = session;
    }

    public Iterable<IEntity> abstractSchemaTypes() {
        if (this.abstractSchemaTypes == null) {
            this.initializeManagedTypes();
            EntityCollector visitor = new EntityCollector();
            for (IManagedType managedType : this.managedTypes.values()) {
                managedType.accept((IManagedTypeVisitor)visitor);
            }
            this.abstractSchemaTypes = visitor.entities;
        }
        return Collections.unmodifiableCollection(this.abstractSchemaTypes);
    }

    private IManagedType buildManagedType(ClassDescriptor descriptor) {
        if (descriptor.isAggregateDescriptor()) {
            return new JavaEmbeddable(this, descriptor);
        }
        return new JavaEntity(this, descriptor);
    }

    ClassLoader getClassLoader() {
        return this.getSession().getDatasourcePlatform().getConversionManager().getLoader();
    }

    public IManagedType getManagedType(IType type) {
        JavaType eclipseLinkType = (JavaType)type;
        ClassDescriptor descriptor = eclipseLinkType.getDescriptor();
        if (descriptor == null) {
            descriptor = this.getSession().getClassDescriptor(eclipseLinkType.getType());
        }
        if (descriptor == null) {
            return null;
        }
        String abstractSchemaName = descriptor.getAlias();
        if (ExpressionTools.stringIsEmpty((CharSequence)abstractSchemaName)) {
            for (Map.Entry value : this.getSession().getAliasDescriptors().entrySet()) {
                Map.Entry entry = value;
                if (descriptor != entry.getValue()) continue;
                abstractSchemaName = (String)entry.getKey();
                break;
            }
            if (ExpressionTools.stringIsEmpty((CharSequence)abstractSchemaName)) {
                abstractSchemaName = descriptor.getJavaClass().getSimpleName();
            }
        }
        return this.getManagedType(abstractSchemaName);
    }

    public IManagedType getManagedType(String abstractSchemaName) {
        this.initializeManagedTypes();
        return this.managedTypes.get(abstractSchemaName);
    }

    public IPlatform getPlatform() {
        return IPlatform.ECLIPSE_LINK;
    }

    AbstractSession getSession() {
        return this.session;
    }

    public ITypeRepository getTypeRepository() {
        if (this.typeRepository == null) {
            this.typeRepository = new JavaTypeRepository(this.getClassLoader());
        }
        return this.typeRepository;
    }

    public IJPAVersion getVersion() {
        return IJPAVersion.DEFAULT_VERSION;
    }

    private void initializeManagedTypes() {
        if (this.managedTypes == null) {
            this.managedTypes = new HashMap<String, IManagedType>();
            for (ClassDescriptor classDescriptor : this.getSession().getDescriptors().values()) {
                String abstractSchemaName = classDescriptor.getAlias();
                if (ExpressionTools.stringIsEmpty((CharSequence)abstractSchemaName)) {
                    abstractSchemaName = classDescriptor.getJavaClass().getSimpleName();
                }
                this.managedTypes.put(abstractSchemaName, this.buildManagedType(classDescriptor));
            }
            for (Object object : this.getSession().getAliasDescriptors().entrySet()) {
                Map.Entry entry = (Map.Entry)object;
                this.managedTypes.put((String)entry.getKey(), this.buildManagedType((ClassDescriptor)entry.getValue()));
            }
        }
    }

    public Iterable<IManagedType> managedTypes() {
        this.initializeManagedTypes();
        return Collections.unmodifiableCollection(this.managedTypes.values());
    }

    private static class EntityCollector
    implements IManagedTypeVisitor {
        private final Collection<IEntity> entities = new ArrayList<IEntity>();

        EntityCollector() {
        }

        public void visit(IEmbeddable embeddable) {
        }

        public void visit(IEntity entity) {
            this.entities.add(entity);
        }

        public void visit(IMappedSuperclass mappedSuperclass) {
        }
    }
}

