/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.jpql.JavaConstructor;
import org.eclipse.persistence.internal.jpa.jpql.JavaTypeDeclaration;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.spi.IConstructor;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JavaType
implements IType {
    private Collection<IConstructor> constructors;
    private ClassDescriptor descriptor;
    private String[] enumConstants;
    private Class<?> type;
    private ITypeDeclaration typeDeclaration;
    private String typeName;
    private ITypeRepository typeRepository;

    JavaType(ITypeRepository typeRepository, Class<?> type) {
        this.type = type;
        this.typeName = type.getName();
        this.typeRepository = typeRepository;
    }

    JavaType(ITypeRepository typeRepository, ClassDescriptor descriptor) {
        this(typeRepository, descriptor.getJavaClass());
        this.descriptor = descriptor;
    }

    JavaType(ITypeRepository typeRepository, String typeName) {
        this.typeName = typeName;
        this.typeRepository = typeRepository;
    }

    private IConstructor buildConstructor(Constructor<?> constructor) {
        return new JavaConstructor(this, constructor);
    }

    private Collection<IConstructor> buildConstructors() {
        if (this.type == null) {
            return Collections.emptyList();
        }
        Constructor<?>[] javaConstructors = this.type.getDeclaredConstructors();
        ArrayList<IConstructor> constructors = new ArrayList<IConstructor>(javaConstructors.length);
        Constructor<?>[] constructorArray = javaConstructors;
        int n = javaConstructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> javaConstructor = constructorArray[n2];
            constructors.add(this.buildConstructor(javaConstructor));
            ++n2;
        }
        return constructors;
    }

    private String[] buildEnumConstants() {
        if (this.type == null || !this.type.isEnum()) {
            return ExpressionTools.EMPTY_STRING_ARRAY;
        }
        ?[] enumConstants = this.type.getEnumConstants();
        String[] names = new String[enumConstants.length];
        int index = enumConstants.length;
        while (--index >= 0) {
            names[index] = ((Enum)enumConstants[index]).name();
        }
        return names;
    }

    public Iterable<IConstructor> constructors() {
        if (this.constructors == null) {
            this.constructors = this.buildConstructors();
        }
        return Collections.unmodifiableCollection(this.constructors);
    }

    public boolean equals(IType type) {
        return this == type ? true : this.typeName.equals(type.getName());
    }

    public boolean equals(Object object) {
        return this == object || this.equals((IType)object);
    }

    ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String[] getEnumConstants() {
        if (this.enumConstants == null) {
            this.enumConstants = this.buildEnumConstants();
        }
        return this.enumConstants;
    }

    public String getName() {
        return this.typeName;
    }

    Class<?> getType() {
        return this.type;
    }

    public ITypeDeclaration getTypeDeclaration() {
        if (this.typeDeclaration == null) {
            this.typeDeclaration = new JavaTypeDeclaration(this.typeRepository, this, null, this.type != null ? this.type.isArray() : false);
        }
        return this.typeDeclaration;
    }

    ITypeRepository getTypeRepository() {
        return this.typeRepository;
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        return this.type == null ? false : this.type.isAnnotationPresent(annotationType);
    }

    public int hashCode() {
        return this.typeName.hashCode();
    }

    public boolean isAssignableTo(IType type) {
        if (this.type == null) {
            return false;
        }
        Class<?> otherType = ((JavaType)type).type;
        if (otherType == null) {
            return false;
        }
        return otherType.isAssignableFrom(this.type);
    }

    public boolean isEnum() {
        return this.type != null && this.type.isEnum();
    }

    public boolean isResolvable() {
        return this.type != null;
    }

    public String toString() {
        return this.typeName;
    }
}

